/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.proj.jstartup.impl;

import com.sap.bc.proj.jstartup.impl.JStartupMessageHeader;
import com.sap.bc.proj.jstartup.impl.JStartupRawConnection;
import com.sap.bc.proj.jstartup.impl.JStartupReplyListener;
import java.util.HashMap;

class JStartupSocketListener
implements Runnable {
    private JStartupRawConnection msConnection;
    private HashMap replyListenerMap;
    private int msgIndex;
    private boolean msAvailable;

    JStartupSocketListener(JStartupRawConnection jStartupRawConnection) {
        this.msConnection = jStartupRawConnection;
        this.msAvailable = false;
        this.msgIndex = 0;
        this.replyListenerMap = new HashMap();
    }

    public void run() {
        Thread.currentThread().setName("Socket Listener");
        while (!Thread.interrupted()) {
            JStartupMessageHeader jStartupMessageHeader = this.msConnection.receiveRawMessage();
            if (jStartupMessageHeader == null) {
                return;
            }
            this.processReplyDirectly(jStartupMessageHeader);
        }
    }

    void close() {
    }

    void processReplyDirectly(JStartupMessageHeader jStartupMessageHeader) {
        JStartupReplyListener jStartupReplyListener = this.searchReplyListener(jStartupMessageHeader);
        if (jStartupReplyListener == null) {
            return;
        }
        jStartupReplyListener.process(jStartupMessageHeader);
    }

    synchronized JStartupReplyListener searchReplyListener(JStartupMessageHeader jStartupMessageHeader) {
        return (JStartupReplyListener)this.replyListenerMap.get(new Integer(jStartupMessageHeader.msKey.getInt()));
    }

    synchronized boolean registerReplyListener(int n, JStartupReplyListener jStartupReplyListener) {
        Integer n2 = new Integer(n);
        if (this.replyListenerMap.containsKey(n2)) {
            return false;
        }
        this.replyListenerMap.put(n2, jStartupReplyListener);
        return true;
    }

    synchronized void unregisterReplyListener(int n) {
        Integer n2 = new Integer(n);
        if (this.replyListenerMap.containsKey(n2)) {
            this.replyListenerMap.remove(n2);
        }
    }
}

