/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.proj.jstartup.impl;

class JStartupSemaphore {
    protected long permitsCount;

    JStartupSemaphore(long l) {
        this.permitsCount = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        JStartupSemaphore jStartupSemaphore = this;
        synchronized (jStartupSemaphore) {
            try {
                while (this.permitsCount <= 0L) {
                    this.wait();
                }
                --this.permitsCount;
            }
            catch (InterruptedException interruptedException) {
                this.notify();
                throw interruptedException;
            }
        }
    }

    boolean attempt(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        JStartupSemaphore jStartupSemaphore = this;
        synchronized (jStartupSemaphore) {
            if (this.permitsCount > 0L) {
                --this.permitsCount;
                return true;
            }
            if (l <= 0L) {
                return false;
            }
            try {
                long l2 = System.currentTimeMillis();
                long l3 = l;
                do {
                    this.wait(l3);
                    if (this.permitsCount <= 0L) continue;
                    --this.permitsCount;
                    return true;
                } while ((l3 = l - (System.currentTimeMillis() - l2)) > 0L);
                return false;
            }
            catch (InterruptedException interruptedException) {
                this.notify();
                throw interruptedException;
            }
        }
    }

    synchronized void release() {
        ++this.permitsCount;
        this.notify();
    }

    synchronized void release(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative argument");
        }
        this.permitsCount += l;
        for (long i = 0L; i < l; ++i) {
            this.notify();
        }
    }

    synchronized long permits() {
        return this.permitsCount;
    }
}

