/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.proj.jstartup.impl;

import com.sap.bc.proj.jstartup.impl.JStartupMessageHeader;
import com.sap.bc.proj.jstartup.impl.JStartupRawConnection;

class JStartupReplyListener {
    private JStartupMessageHeader receiveMessage = null;
    private JStartupRawConnection msConnection;
    private byte errorCode = 0;
    private long receivedTimestamp = 0L;
    private int listenerKey;
    private int errorKey;
    private boolean hasErrorKey = false;
    protected long statReplyTS = 0L;
    protected long timeToProcessUSec = 0L;

    JStartupReplyListener(JStartupRawConnection jStartupRawConnection) {
        this.msConnection = jStartupRawConnection;
    }

    boolean init(JStartupMessageHeader jStartupMessageHeader) {
        this.listenerKey = jStartupMessageHeader.msKey.getInt();
        this.msConnection.socketListener.registerReplyListener(this.listenerKey, this);
        return true;
    }

    synchronized JStartupMessageHeader WaitForReply(long l) throws InterruptedException {
        long l2 = l;
        long l3 = System.currentTimeMillis() + l;
        while ((System.currentTimeMillis() <= l3 || l == 0L) && this.receiveMessage == null) {
            if (l > 0L && (l2 = l3 - System.currentTimeMillis()) < 1L) {
                l2 = 1L;
            }
            try {
                if (this.receiveMessage != null) break;
                this.wait(l2);
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this.msConnection.socketListener.unregisterReplyListener(this.listenerKey);
        if (this.receiveMessage == null) {
            throw new InterruptedException();
        }
        return this.receiveMessage;
    }

    void process(JStartupMessageHeader jStartupMessageHeader) {
        this.CheckAndNotify(jStartupMessageHeader);
    }

    byte getErrorCode() {
        return this.errorCode;
    }

    private synchronized void CheckAndNotify(JStartupMessageHeader jStartupMessageHeader) {
        this.receiveMessage = jStartupMessageHeader;
        this.errorCode = jStartupMessageHeader.getErrorCode();
        this.notify();
    }
}

