/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.proj.jstartup.impl;

import com.sap.bc.proj.jstartup.api.JStartupClusterControlException;
import com.sap.bc.proj.jstartup.api.JStartupClusterInstance;
import com.sap.bc.proj.jstartup.impl.JStartupClusterControlExceptionImpl;
import com.sap.bc.proj.jstartup.impl.JStartupClusterControllerImpl;
import com.sap.bc.proj.jstartup.impl.JStartupClusterInstanceImpl;
import com.sap.bc.proj.jstartup.impl.JStartupConnectionUtil;
import com.sap.bc.proj.jstartup.impl.JStartupMessageHeader;
import com.sap.bc.proj.jstartup.impl.JStartupReplyListener;
import com.sap.bc.proj.jstartup.impl.JStartupSemaphore;
import com.sap.bc.proj.jstartup.impl.JStartupSocketListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

class JStartupRawConnection {
    private JStartupClusterControllerImpl clusterController;
    protected boolean isTestMode = false;
    private Socket socket = null;
    private OutputStream outStream = null;
    private InputStream inStream = null;
    private InetAddress msAddress = null;
    private int socketTimeout = 0;
    protected long defaultTimeout = 0L;
    private final int INITIAL = 0;
    private final int CONNECTING = 1;
    private final int CONNECTED = 2;
    private final int DISCONNECTING = 3;
    private final int DISCONNECTED = 4;
    private final int BROKEN = -1;
    private volatile int connectionState = 0;
    private JStartupSemaphore connectionSemaphore;
    private String msHost = null;
    private int msPort = 0;
    private String msEyeCatcher2 = null;
    protected String ownElementClientName = null;
    protected JStartupSocketListener socketListener = null;
    protected Thread socketListenerThread = null;
    private volatile boolean inReconnect = false;
    private JStartupSemaphore reconnectSemaphore;
    private volatile boolean shouldRun = true;
    protected int[] write_lock = new int[0];

    JStartupRawConnection(String string, int n, JStartupClusterControllerImpl jStartupClusterControllerImpl) throws IOException, UnknownHostException {
        this.clusterController = jStartupClusterControllerImpl;
        this.msEyeCatcher2 = System.getProperty("jstartup.ownHardwareId") != null ? new String("HWID:" + System.getProperty("jstartup.ownHardwareId")) : new String(JStartupMessageHeader.JCONTROL_EYECATCHER);
        this.open(string, n);
    }

    synchronized void open(String string, int n) throws IOException, UnknownHostException {
        this.connectionSemaphore = new JStartupSemaphore(0L);
        this.reconnectSemaphore = new JStartupSemaphore(1L);
        this.msHost = string;
        this.msPort = n;
        this.msAddress = InetAddress.getByName(this.msHost);
        String string2 = System.getProperty("startup.ownProcessId");
        if (string2 != null) {
            this.ownElementClientName = new String("JM_P" + string2 + "_" + InetAddress.getLocalHost().getHostName());
        } else {
            Long l = new Long(System.currentTimeMillis());
            this.ownElementClientName = new String("JM_T" + l.toString() + "_" + InetAddress.getLocalHost().getHostName());
        }
        this.setConnectionState(1);
        this.socket = new Socket(this.msAddress, this.msPort);
        this.socket.setTcpNoDelay(true);
        this.outStream = new BufferedOutputStream(this.socket.getOutputStream());
        this.inStream = new BufferedInputStream(this.socket.getInputStream());
        this.socketTimeout = this.socket.getSoTimeout();
        this.startListener();
        this.setConnectionState(2);
        this.attachToMessageServer();
    }

    synchronized void close() throws IOException {
        this.detachFromMessageServer();
        this.stopListener();
        this.socket.close();
    }

    synchronized void attachToMessageServer() throws IOException {
        JStartupMessageHeader jStartupMessageHeader = new JStartupMessageHeader();
        jStartupMessageHeader.init("MSG_SERVER", 2, 8, 2, JStartupMessageHeader.getKey(), 0);
        jStartupMessageHeader.msgDomain.setByte((byte)2);
        this.sendRawMessage(jStartupMessageHeader, 0, 0);
    }

    synchronized void detachFromMessageServer() throws IOException {
        this.shouldRun = false;
        JStartupMessageHeader jStartupMessageHeader = new JStartupMessageHeader();
        jStartupMessageHeader.init("MSG_SERVER", 1, 4, 2, JStartupMessageHeader.getKey(), 0);
        jStartupMessageHeader.msgDomain.setByte((byte)2);
        this.socketListenerThread.interrupt();
        this.sendRawMessage(jStartupMessageHeader, 0, 0);
    }

    JStartupClusterInstance[] getClusterList() throws JStartupClusterControlException {
        byte[] byArray = new byte[]{5, 0, 102, 1};
        JStartupMessageHeader jStartupMessageHeader = new JStartupMessageHeader();
        jStartupMessageHeader.initRequest("MSG_SERVER", 4);
        jStartupMessageHeader.msgDomain.setByte((byte)2);
        JStartupClusterInstance[] jStartupClusterInstanceArray = null;
        JStartupMessageHeader jStartupMessageHeader2 = null;
        try {
            jStartupMessageHeader2 = this.sendRawRequest(jStartupMessageHeader, byArray, 0, 4, 60000L);
        }
        catch (IOException iOException) {
            throw new JStartupClusterControlExceptionImpl("There was an IOException while getting the cluster instance list", iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new JStartupClusterControlExceptionImpl("The message server did not respond within 60 sec. Please check if the message server is running and if the socket connection has been established.", interruptedException);
        }
        byte[] byArray2 = jStartupMessageHeader2.msgBody;
        if ((byArray2.length - 4) % 115 != 0) {
            return null;
        }
        jStartupClusterInstanceArray = new JStartupClusterInstance[(byArray2.length - 4) / 115];
        if (byArray2 != null) {
            int n = 4;
            int n2 = 0;
            while (n < byArray2.length) {
                jStartupClusterInstanceArray[n2] = new JStartupClusterInstanceImpl(byArray2, n, this.clusterController);
                n += 115;
                ++n2;
            }
        }
        return jStartupClusterInstanceArray;
    }

    void sendCommandToCluster(byte by) throws JStartupClusterControlException {
        this.sendCommandToCluster(by, -1);
    }

    void sendCommandToCluster(byte by, int n) throws JStartupClusterControlException {
        int n2 = 58;
        int n3 = 0;
        byte[] byArray = new byte[n2];
        JStartupConnectionUtil.ComInt comInt = null;
        JStartupConnectionUtil.ComString comString = new JStartupConnectionUtil.ComString(24, byArray, n3);
        byArray[n3 += comString.getMaxLength()] = by;
        ++n3;
        if (n >= 0) {
            comInt = new JStartupConnectionUtil.ComInt(byArray, n3);
            n3 += comInt.getMaxLength();
        }
        JStartupConnectionUtil.ComString comString2 = new JStartupConnectionUtil.ComString(24, byArray, n3);
        n3 += comString.getMaxLength();
        comString.setString(JStartupMessageHeader.JCONTROL_EYECATCHER);
        comString2.setString(this.msEyeCatcher2);
        if (n >= 0) {
            comInt.setInt(n);
        }
        JStartupMessageHeader jStartupMessageHeader = new JStartupMessageHeader();
        jStartupMessageHeader.initBroadcast((byte)1, n3);
        jStartupMessageHeader.msgDomain.setByte((byte)2);
        try {
            this.sendRawMessage(jStartupMessageHeader, byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new JStartupClusterControlExceptionImpl("There was an IOException while sending a command to the cluster", iOException);
        }
    }

    void sendCommandToInstance(String string, byte by) throws JStartupClusterControlException {
        this.sendCommandToInstance(string, by, -1);
    }

    void sendCommandToInstance(String string, byte by, int n) throws JStartupClusterControlException {
        int n2 = 58;
        int n3 = 0;
        byte[] byArray = new byte[n2];
        JStartupConnectionUtil.ComString comString = null;
        JStartupConnectionUtil.ComString comString2 = null;
        JStartupConnectionUtil.ComInt comInt = null;
        comString = new JStartupConnectionUtil.ComString(24, byArray, n3);
        byArray[n3 += comString.getMaxLength()] = by;
        ++n3;
        if (n >= 0) {
            comInt = new JStartupConnectionUtil.ComInt(byArray, n3);
            n3 += comInt.getMaxLength();
        }
        comString2 = new JStartupConnectionUtil.ComString(24, byArray, n3);
        n3 += comString.getMaxLength();
        comString.setString(JStartupMessageHeader.JCONTROL_EYECATCHER);
        comString2.setString(this.msEyeCatcher2);
        if (n >= 0) {
            comInt.setInt(n);
        }
        JStartupMessageHeader jStartupMessageHeader = new JStartupMessageHeader();
        jStartupMessageHeader.initMessage(string, n3);
        jStartupMessageHeader.msgDomain.setByte((byte)2);
        try {
            this.sendRawMessage(jStartupMessageHeader, byArray, 0, n3);
        }
        catch (IOException iOException) {
            throw new JStartupClusterControlExceptionImpl("There was an IOException while sending a command to the cluster instance", iOException);
        }
    }

    JStartupMessageHeader sendRequestToInstance(String string, byte by, long l) throws JStartupClusterControlException {
        return this.sendRequestToInstance(string, by, -1, l);
    }

    JStartupMessageHeader sendRequestToInstance(String string, byte by, int n, long l) throws JStartupClusterControlException {
        JStartupMessageHeader jStartupMessageHeader;
        int n2 = 58;
        int n3 = 0;
        byte[] byArray = new byte[n2];
        JStartupConnectionUtil.ComString comString = null;
        JStartupConnectionUtil.ComString comString2 = null;
        JStartupConnectionUtil.ComInt comInt = null;
        comString = new JStartupConnectionUtil.ComString(24, byArray, n3);
        byArray[n3 += comString.getMaxLength()] = by;
        ++n3;
        if (n >= 0) {
            comInt = new JStartupConnectionUtil.ComInt(byArray, n3);
            n3 += comInt.getMaxLength();
        }
        comString2 = new JStartupConnectionUtil.ComString(24, byArray, n3);
        n3 += comString.getMaxLength();
        comString.setString(JStartupMessageHeader.JCONTROL_EYECATCHER);
        comString2.setString(this.msEyeCatcher2);
        if (n >= 0) {
            comInt.setInt(n);
        }
        JStartupMessageHeader jStartupMessageHeader2 = new JStartupMessageHeader();
        jStartupMessageHeader2.initRequest(string, n3);
        jStartupMessageHeader2.msgDomain.setByte((byte)2);
        try {
            jStartupMessageHeader = this.sendRawRequest(jStartupMessageHeader2, byArray, 0, n3, l);
        }
        catch (IOException iOException) {
            throw new JStartupClusterControlExceptionImpl("There was an IOException while sending a command to the cluster instance", iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new JStartupClusterControlExceptionImpl("The instance with instance name '" + string + "' did not respond within " + l / 1000L + " s.", interruptedException);
        }
        return jStartupMessageHeader;
    }

    synchronized void sendState(byte by) throws JStartupClusterControlException {
        JStartupMessageHeader jStartupMessageHeader = new JStartupMessageHeader();
        jStartupMessageHeader.init("MSG_SERVER", 1, 9, by, JStartupMessageHeader.getKey(), 0);
        try {
            this.sendRawMessage(jStartupMessageHeader, null, 0, 0);
        }
        catch (IOException iOException) {
            throw new JStartupClusterControlExceptionImpl("There was an IOException while sending a command to the cluster instance", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRawMessage(JStartupMessageHeader jStartupMessageHeader, int n, int n2) throws IOException {
        int[] nArray = this.write_lock;
        synchronized (this.write_lock) {
            jStartupMessageHeader.write(this.outStream, this.ownElementClientName, null, n, n2);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRawMessage(JStartupMessageHeader jStartupMessageHeader, byte[] byArray, int n, int n2) throws IOException {
        if (this.connectionState != 2) {
            this.reconnectAcquire();
            if (!this.inReconnect && this.connectionState != 2) {
                boolean bl = this.reconnectSync();
                if (!bl) {
                    throw new IOException("Cannot reconnect to the message server. Check if the message server is up and running.");
                }
            } else {
                this.reconnectRelease();
            }
        }
        int[] nArray = this.write_lock;
        synchronized (this.write_lock) {
            jStartupMessageHeader.write(this.outStream, this.ownElementClientName, byArray, n, n2);
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return;
        }
    }

    JStartupMessageHeader sendRawRequest(JStartupMessageHeader jStartupMessageHeader, byte[] byArray, int n, int n2, long l) throws IOException, InterruptedException {
        JStartupReplyListener jStartupReplyListener = new JStartupReplyListener(this);
        jStartupReplyListener.init(jStartupMessageHeader);
        this.sendRawMessage(jStartupMessageHeader, byArray, n, n2);
        JStartupMessageHeader jStartupMessageHeader2 = jStartupReplyListener.WaitForReply(l);
        return jStartupMessageHeader2;
    }

    JStartupMessageHeader receiveRawMessage() {
        JStartupMessageHeader jStartupMessageHeader = new JStartupMessageHeader();
        while (true) {
            try {
                while (true) {
                    if (this.connectionState != 2) {
                        boolean bl = this.connectedAcquire();
                        if (!bl) {
                            return null;
                        }
                        this.connectedRelease();
                        continue;
                    }
                    int n = jStartupMessageHeader.read(this.inStream);
                    if (n != -1) break;
                    this.SendNiPong();
                }
                return jStartupMessageHeader;
            }
            catch (IOException iOException) {
                if (this.doReconnect(iOException)) {
                    this.reconnectAsync(iOException);
                    continue;
                }
                return null;
            }
            break;
        }
    }

    private void reconnectAsync(IOException iOException) {
        this.reconnectAcquire();
        this.inReconnect = true;
        this.connectedAcquire();
        this.setConnectionState(-1);
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
                this.socket.shutdownOutput();
                this.socket.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        MSReconnectThread mSReconnectThread = new MSReconnectThread();
        Thread thread = new Thread(mSReconnectThread);
        thread.setDaemon(true);
        thread.start();
    }

    private boolean reconnectSync() {
        boolean bl = false;
        this.inReconnect = true;
        this.setConnectionState(-1);
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
                this.socket.shutdownOutput();
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bl = this.executeReconnect(30)) {
            System.out.println("Successfully reconnected to message server synchronously.");
        } else {
            System.out.println("Synchronous reconnect to message server failed.");
        }
        return bl;
    }

    private boolean doReconnect(Exception exception) {
        if (this.connectionState == 2 && this.shouldRun) {
            System.out.println("Disconnected from message server. Trying to reconnect ...");
            exception.printStackTrace();
            return true;
        }
        this.connectionState = -1;
        return false;
    }

    void setConnectionState(int n) {
        this.connectionState = n;
        if (n == 2) {
            this.connectedRelease();
        }
    }

    void waitForInstanceState(String string, long l, byte by) throws JStartupClusterControlException {
        int n = 1000;
        long l2 = System.currentTimeMillis();
        long l3 = l;
        try {
            boolean bl;
            do {
                bl = true;
                JStartupClusterInstance[] jStartupClusterInstanceArray = this.getClusterList();
                if (jStartupClusterInstanceArray == null) {
                    return;
                }
                for (int i = 0; i < jStartupClusterInstanceArray.length; ++i) {
                    if (jStartupClusterInstanceArray[i].getName() != string || jStartupClusterInstanceArray[i].getState() == by) continue;
                    bl = false;
                }
                long l4 = System.currentTimeMillis();
                l3 = l - (l4 - l2);
                if (l3 <= (long)n) {
                    throw new JStartupClusterControlExceptionImpl("Timeout reached");
                }
                Thread.sleep(n);
            } while (!bl);
        }
        catch (InterruptedException interruptedException) {
            throw new JStartupClusterControlExceptionImpl("Timeout was unconditionally interrupted while waiting for reaching the instance state: " + by, interruptedException);
        }
    }

    void waitForClusterState(long l, byte by, byte by2) throws JStartupClusterControlException {
        int n = 1000;
        long l2 = System.currentTimeMillis();
        long l3 = l;
        try {
            boolean bl;
            do {
                bl = true;
                JStartupClusterInstance[] jStartupClusterInstanceArray = this.getClusterList();
                if (jStartupClusterInstanceArray == null) {
                    return;
                }
                for (int i = 0; i < jStartupClusterInstanceArray.length; ++i) {
                    if (jStartupClusterInstanceArray[i].getMessageType() != 1 || jStartupClusterInstanceArray[i].getState() == by || jStartupClusterInstanceArray[i].getState() == by2) continue;
                    bl = false;
                }
                long l4 = System.currentTimeMillis();
                l3 = l - (l4 - l2);
                if (l3 <= (long)n) {
                    throw new JStartupClusterControlExceptionImpl("Timeout reached");
                }
                Thread.sleep(n);
            } while (!bl);
        }
        catch (InterruptedException interruptedException) {
            throw new JStartupClusterControlExceptionImpl("Timeout was unconditionally interrupted while waiting for reaching the cluster state: " + by + "/" + by2, interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SendNiPong() {
        byte[] byArray = new byte[12];
        JStartupConnectionUtil.ComInt comInt = new JStartupConnectionUtil.ComInt(byArray, 0);
        JStartupConnectionUtil.ComString comString = new JStartupConnectionUtil.ComString(8, byArray, 4);
        try {
            comInt.setInt(8);
            comString.setString("NI_PONG");
            int[] nArray = this.write_lock;
            synchronized (this.write_lock) {
                this.outStream.write(comInt.getArray());
                this.outStream.write(comString.getArray());
                this.outStream.flush();
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        {
            return;
        }
    }

    private void startListener() {
        this.stopListener();
        this.socketListener = new JStartupSocketListener(this);
        this.socketListenerThread = new Thread(this.socketListener);
        this.socketListenerThread.setDaemon(true);
        this.socketListenerThread.start();
    }

    private void stopListener() {
        if (this.socketListener != null) {
            this.socketListener.close();
        }
    }

    private boolean connectedAcquire() {
        try {
            this.connectionSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean reconnectAcquire() {
        try {
            this.reconnectSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private void connectedRelease() {
        this.connectionSemaphore.release();
    }

    private void reconnectRelease() {
        this.reconnectSemaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean executeReconnect(int var1_1) {
        block20: {
            var2_2 = 0;
            try {
                while (true) {
                    try {
                        this.setConnectionState(1);
                        this.msAddress = InetAddress.getByName(this.msHost);
                        this.socket = new Socket(this.msAddress, this.msPort);
                        this.socket.setTcpNoDelay(true);
                        this.outStream = new BufferedOutputStream(this.socket.getOutputStream());
                        this.inStream = new BufferedInputStream(this.socket.getInputStream());
                        this.attachToMessageServer();
                        this.setConnectionState(2);
                        this.inReconnect = false;
                        this.reconnectRelease();
                        var3_4 = true;
                        var5_7 = null;
                        if (++var2_2 != var1_1) break block20;
                    }
                    catch (IOException var3_5) {
                        this.setConnectionState(-1);
                        var5_7 = null;
                        if (++var2_2 == var1_1) {
                            try {
                                this.inReconnect = false;
                                this.reconnectRelease();
                                System.out.println("JStartupRawConnection: Cannot reconnect to message server.");
                                return false;
                            }
                            catch (Exception var6_9) {
                                var6_9.printStackTrace();
                            }
                            return false;
                        }
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException var6_9) {
                            continue;
                        }
                    }
                    catch (Exception var3_6) {
                        this.setConnectionState(-1);
                        var5_7 = null;
                        if (++var2_2 == var1_1) {
                            ** try [egrp 2[TRYBLOCK] [6 : 148->168)] { 
lbl44:
                            // 1 sources

                            this.inReconnect = false;
                            this.reconnectRelease();
                            System.out.println("JStartupRawConnection: Cannot reconnect to message server.");
                            return false;
lbl48:
                            // 1 sources

                            catch (Exception var6_9) {
                                var6_9.printStackTrace();
                            }
                            return false;
                        }
                        try {}
                        catch (InterruptedException var6_9) {
                            continue;
                        }
                        Thread.sleep(1000L);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable var4_12) {
                var5_8 = null;
                if (++var2_2 == var1_1) {
                    ** try [egrp 2[TRYBLOCK] [6 : 148->168)] { 
lbl61:
                    // 1 sources

                    this.inReconnect = false;
                    this.reconnectRelease();
                    System.out.println("JStartupRawConnection: Cannot reconnect to message server.");
                    return false;
lbl65:
                    // 1 sources

                    catch (Exception var6_10) {
                        var6_10.printStackTrace();
                    }
                    return false;
                }
                try {}
                catch (InterruptedException var6_11) {
                    throw var4_12;
                }
                Thread.sleep(1000L);
                throw var4_12;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 148->168)] { 
lbl75:
            // 1 sources

            this.inReconnect = false;
            this.reconnectRelease();
            System.out.println("JStartupRawConnection: Cannot reconnect to message server.");
            return false;
lbl79:
            // 1 sources

            catch (Exception var6_9) {
                var6_9.printStackTrace();
            }
            return false;
        }
        try {}
        catch (InterruptedException var6_9) {
            // empty catch block
            return var3_4;
        }
        Thread.sleep(1000L);
        return var3_4;
    }

    class MSReconnectThread
    implements Runnable {
        MSReconnectThread() {
        }

        public void run() {
            boolean bl = JStartupRawConnection.this.executeReconnect(60);
            if (bl) {
                System.out.println("Successfully reconnected to message server asynchronously.");
            } else {
                System.out.println("asynchronous reconnected to message server failed.");
            }
        }
    }
}

