/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.proj.jstartup.impl;

import com.sap.bc.proj.jstartup.api.JStartupClusterControlException;
import com.sap.bc.proj.jstartup.api.JStartupClusterInstance;
import com.sap.bc.proj.jstartup.api.JStartupControlProcess;
import com.sap.bc.proj.jstartup.api.JStartupMonitor;
import com.sap.bc.proj.jstartup.impl.JStartupClusterControllerFactoryImpl;
import com.sap.bc.proj.jstartup.impl.JStartupClusterControllerImpl;
import com.sap.bc.proj.jstartup.impl.JStartupControlInstanceImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;

class JStartupMonitorImpl
extends JStartupMonitor {
    private static long DEFAULT_TIMEOUT = 60000L;
    private static JStartupClusterControllerImpl clusterController = null;

    JStartupMonitorImpl() {
    }

    public void executeMain(String[] stringArray) {
        String string = System.getProperty("SAPMSHOST");
        String string2 = System.getProperty("SAPMSPORT");
        if (string == null || string2 == null) {
            System.out.println("============================================================");
            System.out.println("JControl Monitor Program");
            System.out.println("============================================================");
            if (string == null) {
                System.out.print("Message Server Host : ");
                string = this.readStringFromStdin();
                System.setProperty("SAPMSHOST", string);
            }
            if (string2 == null) {
                System.out.print("Message Server Port : ");
                string2 = this.readStringFromStdin();
                System.setProperty("SAPMSPORT", string2);
            }
        }
        try {
            clusterController = JStartupClusterControllerFactoryImpl.getInstance().createClusterControllerImpl();
        }
        catch (Exception exception) {
            System.out.println("Could not create JStartupClusterController.");
            this.printErrorMessage();
            return;
        }
        int n = 0;
        do {
            try {
                this.printMenue();
                n = this.readIntegerFromStdin();
                switch (n) {
                    case 1: {
                        JStartupClusterInstance[] jStartupClusterInstanceArray = clusterController.getInstances();
                        if (jStartupClusterInstanceArray == null) break;
                        for (int i = 0; i < jStartupClusterInstanceArray.length; ++i) {
                            System.out.println(jStartupClusterInstanceArray[i]);
                        }
                        break;
                    }
                    case 2: {
                        clusterController.shutdownCluster(false, DEFAULT_TIMEOUT);
                        break;
                    }
                    case 3: {
                        clusterController.shutdownClusterAsync(false);
                        break;
                    }
                    case 4: {
                        clusterController.shutdownCluster(true, DEFAULT_TIMEOUT);
                        break;
                    }
                    case 5: {
                        clusterController.shutdownClusterAsync(true);
                        break;
                    }
                    case 6: {
                        clusterController.restartCluster(DEFAULT_TIMEOUT);
                        break;
                    }
                    case 7: {
                        clusterController.freeCluster();
                        break;
                    }
                    case 8: {
                        clusterController.shutdownClusterWithoutSDM(DEFAULT_TIMEOUT);
                        break;
                    }
                    case 9: {
                        clusterController.shutdownClusterWithoutSDMAsync();
                        break;
                    }
                    case 10: {
                        String string3 = this.getInstanceNameFromStdIn();
                        clusterController.shutdownInstance(string3, false, DEFAULT_TIMEOUT);
                        break;
                    }
                    case 11: {
                        String string4 = this.getInstanceNameFromStdIn();
                        clusterController.shutdownInstanceAsync(string4, false);
                        break;
                    }
                    case 12: {
                        String string5 = this.getInstanceNameFromStdIn();
                        clusterController.shutdownInstance(string5, true, DEFAULT_TIMEOUT);
                        break;
                    }
                    case 13: {
                        String string6 = this.getInstanceNameFromStdIn();
                        clusterController.shutdownInstanceAsync(string6, true);
                        break;
                    }
                    case 14: {
                        String string7 = this.getInstanceNameFromStdIn();
                        clusterController.restartInstance(string7, DEFAULT_TIMEOUT);
                        break;
                    }
                    case 20: {
                        String string8 = this.getInstanceNameFromStdIn();
                        this.instanceMenue(string8);
                        break;
                    }
                    case 30: {
                        System.out.print("Process Type: ");
                        int n2 = this.readIntegerFromStdin();
                        clusterController.enableProcesses(n2);
                        break;
                    }
                    case 31: {
                        System.out.print("Process Type: ");
                        int n3 = this.readIntegerFromStdin();
                        clusterController.disableProcesses(n3);
                        break;
                    }
                    case 32: {
                        System.out.print("Process Type: ");
                        int n4 = this.readIntegerFromStdin();
                        clusterController.enableProcessesExclude(n4);
                        break;
                    }
                    case 33: {
                        System.out.print("Process Type: ");
                        int n5 = this.readIntegerFromStdin();
                        clusterController.disableProcessesExclude(n5);
                        break;
                    }
                    case 98: {
                        Properties properties = System.getProperties();
                        Enumeration<Object> enumeration = properties.keys();
                        System.out.println("############# System properties ##############");
                        while (enumeration.hasMoreElements()) {
                            String string9 = (String)enumeration.nextElement();
                            System.out.println(string9 + " : " + properties.getProperty(string9));
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } while (n != 0);
        clusterController.exit();
        System.exit(0);
    }

    private void instanceMenue(String string) {
        JStartupControlInstanceImpl jStartupControlInstanceImpl;
        try {
            jStartupControlInstanceImpl = new JStartupControlInstanceImpl(clusterController, string);
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            System.out.println(jStartupClusterControlException.getMessage() + "\n");
            return;
        }
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        do {
            try {
                this.printInstanceMenue(jStartupControlInstanceImpl);
                n2 = this.readIntegerFromStdin();
                switch (n2) {
                    case 1: {
                        jStartupControlInstanceImpl.refresh();
                        break;
                    }
                    case 2: {
                        jStartupControlInstanceImpl.shutdown();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        System.out.print("Process Index : ");
                        n = this.readIntegerFromStdin();
                        if (n < 0 || n >= jStartupControlInstanceImpl.getProcesses().length) break;
                        jStartupControlInstanceImpl.getProcesses()[n].enableProcess();
                        break;
                    }
                    case 5: {
                        System.out.print("Process Index : ");
                        n = this.readIntegerFromStdin();
                        if (n < 0 || n >= jStartupControlInstanceImpl.getProcesses().length) break;
                        jStartupControlInstanceImpl.getProcesses()[n].disableProcess();
                        break;
                    }
                    case 6: {
                        System.out.print("Process Index : ");
                        n = this.readIntegerFromStdin();
                        if (n < 0 || n >= jStartupControlInstanceImpl.getProcesses().length) break;
                        jStartupControlInstanceImpl.getProcesses()[n].restartProcess();
                        break;
                    }
                    case 8: {
                        System.out.print("Process Index : ");
                        n = this.readIntegerFromStdin();
                        if (n < 0 || n >= jStartupControlInstanceImpl.getProcesses().length) break;
                        jStartupControlInstanceImpl.getProcesses()[n].enableDebugging();
                        break;
                    }
                    case 9: {
                        System.out.print("Process Index : ");
                        n = this.readIntegerFromStdin();
                        if (n < 0 || n >= jStartupControlInstanceImpl.getProcesses().length) break;
                        jStartupControlInstanceImpl.getProcesses()[n].disableDebugging();
                        break;
                    }
                    case 10: {
                        System.out.print("Process Index : ");
                        n = this.readIntegerFromStdin();
                        if (n < 0 || n >= jStartupControlInstanceImpl.getProcesses().length) break;
                        jStartupControlInstanceImpl.getProcesses()[n].dumpStackTrace();
                        break;
                    }
                    case 12: {
                        System.out.print("Process Index : ");
                        n = this.readIntegerFromStdin();
                        if (n < 0 || n >= jStartupControlInstanceImpl.getProcesses().length) break;
                        jStartupControlInstanceImpl.getProcesses()[n].enableDebugSession();
                        break;
                    }
                    case 13: {
                        System.out.print("Process Index : ");
                        n = this.readIntegerFromStdin();
                        if (n < 0 || n >= jStartupControlInstanceImpl.getProcesses().length) break;
                        jStartupControlInstanceImpl.getProcesses()[n].disableDebugSession();
                        break;
                    }
                    case 14: {
                        System.out.print("Process Index : ");
                        n = this.readIntegerFromStdin();
                        if (n < 0 || n >= jStartupControlInstanceImpl.getProcesses().length) break;
                        jStartupControlInstanceImpl.getProcesses()[n].traceIncrement();
                        break;
                    }
                    case 15: {
                        System.out.print("Process Index : ");
                        n = this.readIntegerFromStdin();
                        if (n < 0 || n >= jStartupControlInstanceImpl.getProcesses().length) break;
                        jStartupControlInstanceImpl.getProcesses()[n].traceDecrement();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } while (n2 != 0);
    }

    private void printMenue() {
        System.out.println("");
        System.out.println("============================================================");
        System.out.println("JControl Monitor Program - Main Menue");
        System.out.println("============================================================");
        System.out.println("0  : exit");
        System.out.println("1  : Display Instance List");
        System.out.println("2  : Shutdown Cluster");
        System.out.println("3  : Shutdown Cluster (Async)");
        System.out.println("4  : Shutdown Cluster with Restart");
        System.out.println("5  : Shutdown Cluster with Restart (Async)");
        System.out.println("6  : Restart Cluster");
        System.out.println("7  : Free Cluster");
        System.out.println("8  : Shutdown Cluster with Restart without SDM");
        System.out.println("9  : Shutdown Cluster with Restart without SDM (Async)");
        System.out.println("-----------------------------------------------------------");
        System.out.println("10 : Shutdown Instance");
        System.out.println("11 : Shutdown Instance (Async)");
        System.out.println("12 : Shutdown Instance with Restart");
        System.out.println("13 : Shutdown Instance with Restart (Async)");
        System.out.println("14 : Restart Instance");
        System.out.println("-----------------------------------------------------------");
        System.out.println("20 : Instance Menue");
        System.out.println("-----------------------------------------------------------");
        System.out.println("30 : Enable all processes with specified process type");
        System.out.println("31 : Disable all processes with specified process type");
        System.out.println("32 : Enable all processes excluding specified process type");
        System.out.println("33 : Disable all processes excluding specified process type");
        System.out.println("-----------------------------------------------------------");
        System.out.println("98 : Print system properties");
        System.out.println("-----------------------------------------------------------");
        System.out.print("command => ");
    }

    private void printInstanceMenue(JStartupControlInstanceImpl jStartupControlInstanceImpl) {
        JStartupControlProcess[] jStartupControlProcessArray = jStartupControlInstanceImpl.getProcesses();
        System.out.println("");
        System.out.println("============================================================");
        System.out.println("JControl Monitor Program - Instance Menue");
        System.out.println("============================================================");
        System.out.println("Instance Name   : " + jStartupControlInstanceImpl.getName());
        System.out.println("SAP System Name : " + jStartupControlInstanceImpl.getSAPSystemName());
        System.out.println("SAP System Nr.  : " + jStartupControlInstanceImpl.getSAPSystem());
        System.out.println("State           : " + jStartupControlInstanceImpl.getStateString());
        System.out.println("PID             : " + jStartupControlInstanceImpl.getPID());
        System.out.println("Process Count   : " + jStartupControlProcessArray.length);
        System.out.println("-----------------------------------------------------------");
        for (int i = 0; i < jStartupControlProcessArray.length; ++i) {
            System.out.println(jStartupControlProcessArray[i]);
        }
        System.out.println("-----------------------------------------------------------");
        System.out.println("0  : Exit");
        System.out.println("1  : Refresh");
        System.out.println("2  : Shutdown instance");
        System.out.println("3  : ");
        System.out.println("4  : Enable process");
        System.out.println("5  : Disable process");
        System.out.println("6  : Restart process");
        System.out.println("7  : Process list");
        System.out.println("8  : Enable debugging");
        System.out.println("9  : Disable debugging");
        System.out.println("10 : Dump stacktrace");
        System.out.println("12 : Activate debug session");
        System.out.println("13 : Deactivate debug session");
        System.out.println("14 : Increment trace level");
        System.out.println("15 : Decrement trace level");
        System.out.println("-----------------------------------------------------------");
        System.out.print("command => ");
    }

    private int readIntegerFromStdin() {
        return Integer.valueOf(this.readStringFromStdin().trim());
    }

    private String getInstanceNameFromStdIn() {
        System.out.print("InstanceName: ");
        return this.readInstanceNameFromStdin().trim();
    }

    private String readInstanceNameFromStdin() {
        String string = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    private String readStringFromStdin() {
        try {
            String string = new String();
            byte[] byArray = new byte[100];
            do {
                string = "";
                int n = System.in.read(byArray);
                for (int i = 0; i < n && (Character.isLetterOrDigit((char)byArray[i]) || byArray[i] == 45 || byArray[i] == 32); ++i) {
                    string = string + (char)byArray[i];
                }
            } while (string.length() == 0);
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void printErrorMessage() {
        System.out.println("\nPlease try again and make sure that you start JStartupMonitor\nfrom within the directory where its class file is located.\n OR \nSpecify the properties as start parameter in the following form: \njava -cp ... -DSAPSYSTEM=<..> -DSAPSYSTEMNAME=<..> -DSAPMSHOST=<..> -DSAPMSPORT=<..> JStartupMonitor \n");
    }
}

