/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.proj.jstartup.impl;

import com.sap.bc.proj.jstartup.impl.JStartupConnectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class JStartupMessageHeader {
    private JStartupConnectionUtil.ComString eyeCatcher;
    JStartupConnectionUtil.ComByte version;
    JStartupConnectionUtil.ComByte msErrno;
    JStartupConnectionUtil.ComString toName;
    JStartupConnectionUtil.ComByte msgTypes;
    JStartupConnectionUtil.ComByte msgTypes2;
    JStartupConnectionUtil.ComByte msgDomain;
    JStartupConnectionUtil.ComInt msKey;
    JStartupConnectionUtil.ComByte msSubKey;
    JStartupConnectionUtil.ComByte msFlag;
    JStartupConnectionUtil.ComByte msiFlag;
    JStartupConnectionUtil.ComInt msgLen;
    JStartupConnectionUtil.ComString fromName;
    JStartupConnectionUtil.ComShort fromServno;
    JStartupConnectionUtil.ComInt senderClusterId;
    JStartupConnectionUtil.ComInt clusterId;
    JStartupConnectionUtil.ComInt serviceId;
    JStartupConnectionUtil.ComInt groupId;
    JStartupConnectionUtil.ComByte nodeType;
    JStartupConnectionUtil.ComInt totalLength;
    JStartupConnectionUtil.ComInt currentLength;
    JStartupConnectionUtil.ComInt currentOffset;
    JStartupConnectionUtil.ComByte totalBlocks;
    JStartupConnectionUtil.ComByte currentBlock;
    JStartupConnectionUtil.ComInt messageType;
    JStartupConnectionUtil.ComInt broadcastHeaderLength;
    int maxBodyLength;
    int receivedLength = 0;
    boolean isExtendedHeader;
    protected byte[] buf;
    byte[] msgBody;
    public static final byte MS_VERSION = 4;
    public static final byte MS_SEND_NAME = 1;
    public static final byte MS_SEND_TYPE = 2;
    public static final byte MS_LOGIN = 3;
    public static final byte MS_LOGOUT = 4;
    public static final byte MS_ADM_OPCODES = 5;
    public static final byte MS_MOD_MSGTYPES = 6;
    public static final byte MS_SEND_TYPE_ONCE = 7;
    public static final byte MS_LOGIN_2 = 8;
    public static final byte MS_MOD_STATE = 9;
    public static final byte MS_J2EE_LOGIN = 10;
    public static final byte MS_J2EE_LOGOUT = 11;
    public static final byte MS_J2EE_SEND_TO_CLUSTERID = 12;
    public static final byte MS_J2EE_SEND_BROADCAST = 13;
    private static final int MS_EYECLN = 12;
    public static final int MS_NAME_SIZ = 40;
    private static final int MS_RESERVE_SIZ = 1;
    private static final int MS_KEY_SIZ = 8;
    private static final int MS_TEXT_SIZ = 32000;
    public static final int MS_J2EE_SIZ = 31950;
    public static final int MS_HEADER_SIZ = 110;
    public static final int MS_J2EE_HEADER_LN = 40;
    public static final int MS_PING_SIZ = 8;
    public static final String MS_NIPING = "NI_PING";
    public static final int MS_PONG_SIZ = 8;
    public static final String MS_NIPONG = "NI_PONG";
    public static final String MS_MSGNAME = "MSG_SERVER";
    public static final String MS_EYECATCHER = "**MESSAGE**";
    public static final String MS_J2EE_PREFIX = "J2EE";
    public static final byte MS_DOMAIN_WAS = 0;
    public static final byte MS_DOMAIN_J2EE = 1;
    public static final byte MS_DEFAULT = 0;
    public static final byte MS_ONE_WAY = 1;
    public static final byte MS_REQUEST = 2;
    public static final byte MS_REPLY = 3;
    public static final byte MS_ADMIN = 4;
    public static final String[] MS_FLAG_TEXT = new String[]{"Default", "One-Way", "Request", "Reply", "Admin"};
    public static final int MS_NO_TYPES = 0;
    public static final byte MSEINTERN = -1;
    public static final byte MSENOMSG = -2;
    public static final byte MSEINVAL = -3;
    public static final byte MSENOTFOUND = -4;
    public static final byte MSEWAKEUP = -5;
    public static final byte MSEWRONGNAME = -6;
    public static final byte MSEWRONGTYPE = -7;
    public static final byte MSEPARTNERDIED = -8;
    public static final byte MSEPARTNERUNKNOWN = -9;
    public static final byte MSENOTUNIQUE = -10;
    public static final byte MSEMSGDESTROYED = -11;
    public static final byte MSEWRONGVERSION = -12;
    public static final byte MSEREPLYTOOLARGE = -13;
    public static final byte MSESHUTDOWN = -14;
    public static final byte MSENOSLOTFREE = -15;
    public static final byte MSESOCKTOOLARGE = -16;
    public static final byte MSEADMIN = -17;
    public static final byte MSEREADINCOMPLETE = -18;
    public static final byte MSEWRITEINCOMPLETE = -19;
    public static final byte MSEACCESSDENIED = -20;
    public static final byte MSETYPESNOTALLOWED = -21;
    public static final byte MSEHEADERINCOMPLETE = -22;
    public static final byte MSENOMEM = -23;
    public static final byte MSEVARBUF = -24;
    public static final byte MSESOFTSHUTDOWN = -25;
    public static final byte MSEDUPKEY = -26;
    public static final byte MSENILAYER = -100;
    public static final byte MSENIQUEUE = -101;
    public static final byte MSSTOPLISTENERQUEUE = -125;
    public static final byte MSNOLISTENERREGISTERED = -126;
    public static final byte MSATTACHCONFIRMATION = -127;
    public static final byte MS_SERVER_LST = 5;
    public static final byte MS_SERVER_LST_OFFSET = 100;
    public static final byte MS_SERVER_LST_VERSION = 2;
    public static final byte MS_JCONTROL_TYPE = 1;
    public static final byte MS_JMONITOR_TYPE = 2;
    public static final byte SHUTDOWN_WITHOUT_RESTART = 0;
    public static final byte SHUTDOWN_AND_WAIT = 1;
    public static final byte RESTART = 2;
    public static final byte SYNCHRONIZE_PROPERTIES = 3;
    public static final byte ENABLE_PROCESS = 4;
    public static final byte DISABLE_PROCESS = 5;
    public static final byte GET_PROCESS_LIST = 6;
    public static final byte ENABLE_DEBUGGING = 7;
    public static final byte DISABLE_DEBUGGING = 8;
    public static final byte RESTART_PROCESS = 9;
    public static final byte DUMP_STACKTRACE = 10;
    public static final byte ENABLE_PROCESSES = 11;
    public static final byte DISABLE_PROCESSES = 12;
    public static final byte ENABLE_PROCESSES_EXCLUDE = 13;
    public static final byte DISABLE_PROCESSES_EXCLUDE = 14;
    public static final byte ENABLE_DEBUG_SESSION = 15;
    public static final byte DISABLE_DEBUG_SESSION = 16;
    public static final byte TERMINATE_PROCESS = 18;
    public static final byte TRACE_INCREMENT = 19;
    public static final byte TRACE_DECREMENT = 20;
    public static final byte SHUTDOWN_AND_WAIT_WS = 21;
    public static final byte BOOTSTRAP_PROCESSES = 30;
    public static final byte BOOTSTRAP_PROCESSES_EXCLUDE = 31;
    public static final byte STATE_SHUTDOWN = 100;
    public static final byte STATE_SHUTDOWN_RESTART = 101;
    public static final int JCONTROL_EYECATCHER_LEN = 24;
    public static final String JCONTROL_EYECATCHER = new String("***JCONTRL_EYECATCHER***");
    public static final int MS_HOST_CHARSET = 1;
    private static int messageId = 1;

    static String getErrorString(byte by) {
        String string = null;
        switch (by) {
            case -1: {
                string = "MSEINTERN";
                break;
            }
            case -2: {
                string = "MSEINTERN";
                break;
            }
            case -3: {
                string = "MSEINVAL";
                break;
            }
            case -4: {
                string = "MSENOTFOUND";
                break;
            }
            case -5: {
                string = "MSEWAKEUP";
                break;
            }
            case -6: {
                string = "MSEWRONGNAME";
                break;
            }
            case -7: {
                string = "MSEWRONGTYPE";
                break;
            }
            case -8: {
                string = "MSEPARTNERDIED";
                break;
            }
            case -9: {
                string = "MSEPARTNERUNKNOWN";
                break;
            }
            case -10: {
                string = "MSENOTUNIQUE";
                break;
            }
            case -11: {
                string = "MSEMSGDESTROYED";
                break;
            }
            case -12: {
                string = "MSEWRONGVERSION";
                break;
            }
            case -13: {
                string = "MSEREPLYTOOLARGE";
                break;
            }
            case -14: {
                string = "MSESHUTDOWN";
                break;
            }
            case -15: {
                string = "MSENOSLOTFREE";
                break;
            }
            case -16: {
                string = "MSESOCKTOOLARGE";
                break;
            }
            case -17: {
                string = "MSEADMIN";
                break;
            }
            case -18: {
                string = "MSEREADINCOMPLETE";
                break;
            }
            case -19: {
                string = "MSEWRITEINCOMPLETE";
                break;
            }
            case -20: {
                string = "MSEACCESSDENIED";
                break;
            }
            case -21: {
                string = "MSETYPESNOTALLOWED";
                break;
            }
            case -22: {
                string = "MSEHEADERINCOMPLETE";
                break;
            }
            case -23: {
                string = "MSENOMEM";
                break;
            }
            case -24: {
                string = "MSEVARBUF";
                break;
            }
            case -25: {
                string = "MSESOFTSHUTDOWN";
                break;
            }
            case -26: {
                string = "MSEDUPKEY";
                break;
            }
            case -100: {
                string = "MSENILAYER";
                break;
            }
            case -101: {
                string = "MSENIQUEUE";
                break;
            }
            default: {
                string = new String("Unknown Error");
            }
        }
        return string;
    }

    static synchronized int getKey() {
        int n = messageId++;
        if (messageId >= Integer.MAX_VALUE) {
            messageId = 1;
        }
        return n;
    }

    JStartupMessageHeader() {
        int n = 0;
        if (this.buf == null) {
            this.buf = new byte[154];
        }
        this.msgLen = new JStartupConnectionUtil.ComInt(this.buf, n);
        this.eyeCatcher = new JStartupConnectionUtil.ComString(12, this.buf, n += this.msgLen.getMaxLength());
        this.version = new JStartupConnectionUtil.ComByte(this.buf, n += this.eyeCatcher.getMaxLength());
        this.msErrno = new JStartupConnectionUtil.ComByte(this.buf, n += this.version.getMaxLength());
        this.toName = new JStartupConnectionUtil.ComString(40, this.buf, n += this.msErrno.getMaxLength());
        this.msgTypes = new JStartupConnectionUtil.ComByte(this.buf, n += this.toName.getMaxLength());
        this.msgTypes2 = new JStartupConnectionUtil.ComByte(this.buf, n += this.msgTypes.getMaxLength());
        this.msgDomain = new JStartupConnectionUtil.ComByte(this.buf, n += this.msgTypes2.getMaxLength());
        n += this.msgDomain.getMaxLength();
        this.msKey = new JStartupConnectionUtil.ComInt(this.buf, ++n);
        this.msSubKey = new JStartupConnectionUtil.ComByte(this.buf, n += 7);
        this.msFlag = new JStartupConnectionUtil.ComByte(this.buf, n += this.msSubKey.getMaxLength());
        this.msiFlag = new JStartupConnectionUtil.ComByte(this.buf, n += this.msFlag.getMaxLength());
        this.fromName = new JStartupConnectionUtil.ComString(40, this.buf, n += this.msiFlag.getMaxLength());
        this.fromServno = new JStartupConnectionUtil.ComShort(this.buf, n += this.fromName.getMaxLength());
        n += this.fromServno.getMaxLength();
        n = 114;
        this.senderClusterId = new JStartupConnectionUtil.ComInt(this.buf, n);
        this.clusterId = new JStartupConnectionUtil.ComInt(this.buf, n += this.senderClusterId.getMaxLength());
        this.serviceId = new JStartupConnectionUtil.ComInt(this.buf, n += this.clusterId.getMaxLength());
        this.groupId = new JStartupConnectionUtil.ComInt(this.buf, n += this.serviceId.getMaxLength());
        this.nodeType = new JStartupConnectionUtil.ComByte(this.buf, n += this.groupId.getMaxLength());
        this.totalLength = new JStartupConnectionUtil.ComInt(this.buf, n += this.nodeType.getMaxLength());
        this.currentLength = new JStartupConnectionUtil.ComInt(this.buf, n += this.totalLength.getMaxLength());
        this.currentOffset = new JStartupConnectionUtil.ComInt(this.buf, n += this.currentLength.getMaxLength());
        this.totalBlocks = new JStartupConnectionUtil.ComByte(this.buf, n += this.currentOffset.getMaxLength());
        this.currentBlock = new JStartupConnectionUtil.ComByte(this.buf, n += this.totalBlocks.getMaxLength());
        this.messageType = new JStartupConnectionUtil.ComInt(this.buf, n += this.currentBlock.getMaxLength());
        this.broadcastHeaderLength = new JStartupConnectionUtil.ComInt(this.buf, n += this.messageType.getMaxLength());
        n += this.broadcastHeaderLength.getMaxLength();
        this.version.setByte((byte)4);
        this.eyeCatcher.setString(MS_EYECATCHER);
        this.msgDomain.setByte((byte)1);
        this.isExtendedHeader = false;
    }

    void Deseralize() {
        this.msgLen.Deserialize();
        this.eyeCatcher.Deserialize();
        this.toName.Deserialize();
        this.msKey.Deserialize();
        this.fromName.Deserialize();
        this.fromServno.Deserialize();
        this.senderClusterId.Deserialize();
        this.clusterId.Deserialize();
        this.serviceId.Deserialize();
        this.groupId.Deserialize();
        this.totalLength.Deserialize();
        this.currentLength.Deserialize();
        this.currentOffset.Deserialize();
        this.messageType.Deserialize();
        this.broadcastHeaderLength.Deserialize();
    }

    void write(OutputStream outputStream, String string, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        this.fromName.setString(string);
        this.msgLen.setInt(110 + n2);
        int n4 = 114;
        if (this.msgLen.getInt() > 32110) {
            throw new IllegalArgumentException("Invalid message length of " + this.msgLen.getInt() + " bytes");
        }
        outputStream.write(this.buf, 0, n4);
        n3 += n4;
        if (n2 > 0) {
            outputStream.write(byArray, n, n2);
            n3 += n2;
        }
        outputStream.flush();
        if (this.msgLen.getInt() + 4 != n3) {
            throw new IllegalArgumentException("Message inconsistency (" + this.msgLen.getInt() + " != " + (n3 - 4) + ")");
        }
    }

    int read(InputStream inputStream) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 4;
        int n4 = 0;
        do {
            if ((n = inputStream.read(this.buf, n4, n3)) == -1) {
                throw new IOException("Error reading length field of message. EOF has been reached.");
            }
            n4 += n;
        } while ((n3 -= n) > 0);
        this.msgLen.Deserialize();
        if (this.msgLen.getInt() == 8) {
            byte[] byArray = new byte[8];
            n = inputStream.read(byArray);
            if (n == -1) {
                throw new IOException("Error reading niping. EOF has been reached.");
            }
            return -1;
        }
        n3 = 110;
        n4 = 4;
        do {
            if ((n = inputStream.read(this.buf, n4, n3)) == -1) {
                throw new IOException("Error reading header data. EOF has been reached.");
            }
            n4 += n;
        } while ((n3 -= n) > 0);
        this.eyeCatcher.DeserializeDelBlanks();
        if (this.eyeCatcher.getString().compareTo(MS_EYECATCHER) != 0) {
            return n2;
        }
        this.toName.DeserializeDelBlanks();
        this.msKey.Deserialize();
        this.fromName.DeserializeDelBlanks();
        this.fromServno.Deserialize();
        n2 = this.msgLen.getInt() - 110;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 32000) {
            n2 = 32000;
        }
        if (n2 > 0) {
            n3 = n2;
            n4 = 0;
            this.msgBody = new byte[n3];
            do {
                if ((n = inputStream.read(this.msgBody, n4, n3)) == -1) {
                    throw new IOException("Error reading body data. EOF has been reached.");
                }
                n4 += n;
            } while ((n3 -= n) > 0);
        }
        return n2;
    }

    void out() {
        System.out.println("##################################################");
        System.out.println("Message Type : " + MS_FLAG_TEXT[this.msFlag.getByte()]);
        System.out.println("Internal Type: " + this.msiFlag.getByte());
        System.out.println("Client Type  : " + this.msgTypes.getByte());
        System.out.println("Key          : " + this.msKey.getInt());
        System.out.println("SubKey       : " + this.msSubKey.getByte());
        System.out.println("From         : " + this.fromName.getString());
        System.out.println("To           : " + this.toName.getString());
        System.out.println("error code   : " + this.msErrno.getByte());
        System.out.println("##################################################");
    }

    void init(String string, int n, int n2, int n3, int n4, int n5) {
        this.msiFlag.setByte((byte)n2);
        this.msFlag.setByte((byte)n);
        this.msgTypes.setByte((byte)n3);
        this.msKey.setInt(n4);
        this.toName.setString(string);
        this.msgLen.setInt(110 + n5);
    }

    void initToName(String string, int n, int n2, int n3) {
        this.init(string, n, 1, 0, n2, n3);
    }

    void initMessage(String string, int n) {
        this.init(string, 1, 1, 0, JStartupMessageHeader.getKey(), n);
    }

    void initBroadcast(byte by, int n) {
        this.init("", 1, 2, by, JStartupMessageHeader.getKey(), n);
    }

    void initRequest(String string, int n) {
        this.init(string, 2, 1, 0, JStartupMessageHeader.getKey(), n);
    }

    void initReply(JStartupMessageHeader jStartupMessageHeader) {
        this.toName.setString(jStartupMessageHeader.fromName.getString());
        this.fromName.setString(jStartupMessageHeader.toName.getString());
        this.msKey.setInt(jStartupMessageHeader.msKey.getInt());
        this.msSubKey.setByte(jStartupMessageHeader.msSubKey.getByte());
        this.msiFlag.setByte(jStartupMessageHeader.msiFlag.getByte());
        this.msFlag.setByte((byte)3);
        this.msgTypes.setByte(jStartupMessageHeader.msgTypes.getByte());
        this.isExtendedHeader = jStartupMessageHeader.isExtendedHeader;
    }

    byte getErrorCode() {
        return this.msErrno.getByte();
    }

    String getErrorString() {
        return JStartupMessageHeader.getErrorString(this.msErrno.getByte());
    }
}

