/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.proj.jstartup.impl;

import com.sap.bc.proj.jstartup.api.JStartupClusterControlException;
import com.sap.bc.proj.jstartup.api.JStartupControlProcess;
import com.sap.bc.proj.jstartup.impl.JStartupConnectionUtil;
import com.sap.bc.proj.jstartup.impl.JStartupControlInstanceImpl;

class JStartupControlProcessImpl
extends JStartupControlProcess {
    private JStartupControlInstanceImpl clusterInstance = null;
    private JStartupConnectionUtil.ComString name = null;
    private int procNdx = -1;
    private int type = 0;
    private long PID = 0L;
    private int restartFlag = 0;
    private int state = 0;
    private int httpPort = 0;
    private int httpsPort = 0;
    private int telnetPort = 0;
    private int p4Port = 0;
    private int restartCount = 0;
    private int errorCount = 0;
    private int debuggable = 0;
    private int debugMode = 0;
    private int debugPort = 0;
    private int clusterId = 0;
    private int sdmPort = 0;
    private int lbRestricted = 0;

    JStartupControlProcessImpl(JStartupControlInstanceImpl jStartupControlInstanceImpl, int n) {
        this.clusterInstance = jStartupControlInstanceImpl;
        this.procNdx = n;
    }

    public String getName() {
        return this.name.getString();
    }

    public int getType() {
        return this.type;
    }

    public long getPID() {
        return this.PID;
    }

    public int getRestartFlag() {
        return this.restartFlag;
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        switch (this.state) {
            case 0: {
                return "Initial";
            }
            case 1: {
                return "Waiting for start";
            }
            case 2: {
                return "Starting";
            }
            case 3: {
                return "Running";
            }
            case 4: {
                return "Waiting for stop";
            }
            case 5: {
                return "Stopping";
            }
            case 6: {
                return "Stopped";
            }
            case 7: {
                return "Debugging";
            }
            case 10: {
                return "Starting applications";
            }
        }
        return "Unknown";
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public int getP4Port() {
        return this.p4Port;
    }

    public int getTelnetPort() {
        return this.telnetPort;
    }

    public int getRestartCount() {
        return this.restartCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getDebuggable() {
        return this.debuggable;
    }

    public int getDebugMode() {
        return this.debugMode;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public int getLoadBalanceRestricted() {
        return this.lbRestricted;
    }

    public int getSDMPort() {
        return this.sdmPort;
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public boolean disableProcess() {
        try {
            this.clusterInstance.getClusterController().getConnection().sendCommandToInstance(this.clusterInstance.getName(), (byte)5, this.procNdx);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public boolean enableProcess() {
        try {
            this.clusterInstance.getClusterController().getConnection().sendCommandToInstance(this.clusterInstance.getName(), (byte)4, this.procNdx);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public boolean enableDebugging() {
        try {
            this.clusterInstance.getClusterController().getConnection().sendCommandToInstance(this.clusterInstance.getName(), (byte)7, this.procNdx);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public boolean disableDebugging() {
        try {
            this.clusterInstance.getClusterController().getConnection().sendCommandToInstance(this.clusterInstance.getName(), (byte)8, this.procNdx);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public boolean restartProcess() {
        try {
            this.clusterInstance.getClusterController().getConnection().sendCommandToInstance(this.clusterInstance.getName(), (byte)9, this.procNdx);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public boolean dumpStackTrace() {
        try {
            this.clusterInstance.getClusterController().getConnection().sendCommandToInstance(this.clusterInstance.getName(), (byte)10, this.procNdx);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public boolean enableDebugSession() {
        try {
            this.clusterInstance.getClusterController().getConnection().sendCommandToInstance(this.clusterInstance.getName(), (byte)15, this.procNdx);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public boolean disableDebugSession() {
        try {
            this.clusterInstance.getClusterController().getConnection().sendCommandToInstance(this.clusterInstance.getName(), (byte)16, this.procNdx);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public boolean traceIncrement() {
        try {
            this.clusterInstance.getClusterController().getConnection().sendCommandToInstance(this.clusterInstance.getName(), (byte)19, this.procNdx);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public boolean traceDecrement() {
        try {
            this.clusterInstance.getClusterController().getConnection().sendCommandToInstance(this.clusterInstance.getName(), (byte)20, this.procNdx);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("|Name:" + this.getName());
        stringBuffer.append("|PID:" + this.getPID());
        stringBuffer.append("|State:" + this.getStateString());
        stringBuffer.append("|Restart:" + this.getRestartFlag());
        stringBuffer.append("|Http:" + this.getHttpPort());
        stringBuffer.append("|DbgPort:" + this.getDebugPort());
        stringBuffer.append("|DbgMode:" + this.getDebugMode());
        stringBuffer.append("|LBRestricted:" + this.getLoadBalanceRestricted());
        stringBuffer.append("|");
        return stringBuffer.toString();
    }

    void deserialize(byte[] byArray, int n) {
        this.name = new JStartupConnectionUtil.ComString(50, byArray, n);
        this.name.DeserializeDelBlanks();
        JStartupConnectionUtil.ComString comString = new JStartupConnectionUtil.ComString(10, byArray, n += 50);
        comString.Deserialize();
        this.PID = Long.parseLong(comString.getString());
        this.state = JStartupConnectionUtil.ComInt.get(byArray, n += 10);
        this.restartFlag = JStartupConnectionUtil.ComInt.get(byArray, n += 4);
        this.restartCount = JStartupConnectionUtil.ComInt.get(byArray, n += 4);
        this.errorCount = JStartupConnectionUtil.ComInt.get(byArray, n += 4);
        this.type = JStartupConnectionUtil.ComInt.get(byArray, n += 4);
        this.debuggable = JStartupConnectionUtil.ComInt.get(byArray, n += 4);
        this.debugMode = JStartupConnectionUtil.ComInt.get(byArray, n += 4);
        this.debugPort = JStartupConnectionUtil.ComInt.get(byArray, n += 4);
        this.telnetPort = JStartupConnectionUtil.ComInt.get(byArray, n += 4);
        this.httpPort = JStartupConnectionUtil.ComInt.get(byArray, n += 4);
        this.httpsPort = JStartupConnectionUtil.ComInt.get(byArray, n += 4);
        this.p4Port = JStartupConnectionUtil.ComInt.get(byArray, n += 4);
        this.clusterId = JStartupConnectionUtil.ComInt.get(byArray, n += 4);
        this.sdmPort = JStartupConnectionUtil.ComInt.get(byArray, n += 4);
        this.lbRestricted = byArray[n += 4];
        ++n;
    }
}

