/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.proj.jstartup.impl;

import com.sap.bc.proj.jstartup.api.JStartupClusterControlException;
import com.sap.bc.proj.jstartup.api.JStartupControlInstance;
import com.sap.bc.proj.jstartup.api.JStartupControlProcess;
import com.sap.bc.proj.jstartup.impl.JStartupClusterControlExceptionImpl;
import com.sap.bc.proj.jstartup.impl.JStartupClusterControllerImpl;
import com.sap.bc.proj.jstartup.impl.JStartupConnectionUtil;
import com.sap.bc.proj.jstartup.impl.JStartupControlProcessImpl;
import com.sap.bc.proj.jstartup.impl.JStartupMessageHeader;

class JStartupControlInstanceImpl
extends JStartupControlInstance {
    private JStartupClusterControllerImpl clusterController;
    private int version = 0;
    private String name = null;
    private JStartupConnectionUtil.ComString SAPSystemName = null;
    private JStartupConnectionUtil.ComString SAPSystem = null;
    private JStartupConnectionUtil.ComString msHost = null;
    private JStartupConnectionUtil.ComString msPort = null;
    private JStartupConnectionUtil.ComString adminURL = null;
    private long PID = 0L;
    private int state = 0;
    private int procCount = 0;
    private JStartupControlProcess[] processes = null;
    private long lastRefresh = 0L;

    JStartupControlInstanceImpl(JStartupClusterControllerImpl jStartupClusterControllerImpl, String string) throws JStartupClusterControlException {
        this.clusterController = jStartupClusterControllerImpl;
        this.name = string;
        this.refresh();
    }

    public String getName() {
        return this.name;
    }

    public String getSAPSystemName() {
        return this.SAPSystemName.getString();
    }

    public String getSAPSystem() {
        return this.SAPSystem.getString();
    }

    public String getMSHost() {
        return this.msHost.getString();
    }

    public String getMSPort() {
        return this.msPort.getString();
    }

    public long getPID() {
        return this.PID;
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        switch (this.state) {
            case 0: {
                return "Initial";
            }
            case 1: {
                return "Synchronizing binaries";
            }
            case 2: {
                return "Connecting to message server";
            }
            case 3: {
                return "Starting the processes";
            }
            case 4: {
                return "Some processes running";
            }
            case 5: {
                return "All processes running";
            }
            case 6: {
                return "Stopping the processes";
            }
            case 7: {
                return "All processes stopped";
            }
            case 8: {
                return "Waiting for restart";
            }
        }
        return "Unknown";
    }

    public JStartupControlProcess[] getProcesses() {
        return this.processes;
    }

    public void refresh() throws JStartupClusterControlException {
        long l = System.currentTimeMillis();
        if (l < this.lastRefresh + 2000L) {
            return;
        }
        this.lastRefresh = l;
        JStartupMessageHeader jStartupMessageHeader = null;
        jStartupMessageHeader = this.clusterController.getConnection().sendRequestToInstance(this.name, (byte)6, JStartupClusterControllerImpl.DEFAULT_TIMEOUT);
        if (jStartupMessageHeader.msgLen.getInt() < 400) {
            throw new JStartupClusterControlExceptionImpl("Instance [" + this.name + "] not available");
        }
        int n = 0;
        this.version = jStartupMessageHeader.msgBody[n];
        this.SAPSystemName = new JStartupConnectionUtil.ComString(10, jStartupMessageHeader.msgBody, ++n);
        this.SAPSystemName.DeserializeDelBlanks();
        this.SAPSystem = new JStartupConnectionUtil.ComString(5, jStartupMessageHeader.msgBody, n += 10);
        this.SAPSystem.DeserializeDelBlanks();
        this.msHost = new JStartupConnectionUtil.ComString(40, jStartupMessageHeader.msgBody, n += 5);
        this.msHost.DeserializeDelBlanks();
        this.msPort = new JStartupConnectionUtil.ComString(10, jStartupMessageHeader.msgBody, n += 40);
        this.msPort.DeserializeDelBlanks();
        n += 10;
        int n2 = JStartupConnectionUtil.ComInt.get(jStartupMessageHeader.msgBody, n += 4);
        this.state = JStartupConnectionUtil.ComInt.get(jStartupMessageHeader.msgBody, n += 4);
        n += 4;
        JStartupConnectionUtil.ComString comString = new JStartupConnectionUtil.ComString(10, jStartupMessageHeader.msgBody, n += 4);
        comString.Deserialize();
        this.PID = Long.parseLong(comString.getString());
        this.adminURL = new JStartupConnectionUtil.ComString(400 - (n += 10), jStartupMessageHeader.msgBody, n);
        this.adminURL.DeserializeDelBlanks();
        n = 400;
        if (n2 != this.procCount) {
            JStartupControlProcess[] jStartupControlProcessArray = new JStartupControlProcess[n2];
            int n3 = n2;
            for (int i = 0; i < n2 && i < this.procCount; ++i) {
                jStartupControlProcessArray[i] = this.processes[i];
            }
            this.processes = jStartupControlProcessArray;
            this.procCount = n2;
        }
        int n4 = 0;
        for (n = 400; n < jStartupMessageHeader.msgLen.getInt() && n4 < this.procCount; ++n4, n += 150) {
            if (this.processes[n4] == null) {
                this.processes[n4] = new JStartupControlProcessImpl(this, n4);
            }
            JStartupControlProcessImpl jStartupControlProcessImpl = (JStartupControlProcessImpl)this.processes[n4];
            jStartupControlProcessImpl.deserialize(jStartupMessageHeader.msgBody, n);
        }
    }

    public void shutdown() throws JStartupClusterControlException {
        this.clusterController.getConnection().sendCommandToInstance(this.getName(), (byte)0, 0);
    }

    public boolean enableProcesses(int n) {
        try {
            this.clusterController.getConnection().sendCommandToInstance(this.getName(), (byte)11, n);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public boolean disableProcesses(int n) {
        try {
            this.clusterController.getConnection().sendCommandToInstance(this.getName(), (byte)12, n);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public boolean enableProcessesExclude(int n) {
        try {
            this.clusterController.getConnection().sendCommandToInstance(this.getName(), (byte)13, n);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public boolean disableProcessesExclude(int n) {
        try {
            this.clusterController.getConnection().sendCommandToInstance(this.getName(), (byte)14, n);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    JStartupClusterControllerImpl getClusterController() {
        return this.clusterController;
    }
}

