/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.proj.jstartup.impl;

import java.io.UnsupportedEncodingException;

final class JStartupConnectionUtil {
    private JStartupConnectionUtil() {
    }

    static class ComBitMask {
        private byte[] comBuffer;
        private int comBufferOffset = 0;
        private int maxLength = 0;
        private final byte[] bitMask = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};

        public ComBitMask(int n, byte[] byArray, int n2) {
            this.comBuffer = byArray;
            this.comBufferOffset = n2;
            this.maxLength = n;
        }

        public void setBit(int n) {
            int n2 = this.comBufferOffset + n / 8;
            int n3 = n % 8;
            int n4 = n2;
            this.comBuffer[n4] = (byte)(this.comBuffer[n4] | this.bitMask[n3]);
        }

        public void clearBit(int n) {
            int n2 = this.comBufferOffset + n / 8;
            int n3 = n % 8;
            int n4 = n2;
            this.comBuffer[n4] = (byte)(this.comBuffer[n4] & ~this.bitMask[n3]);
        }

        public byte testBit(int n) {
            int n2 = this.comBufferOffset + n / 8;
            int n3 = n % 8;
            return (byte)(this.comBuffer[n2] & this.bitMask[n3]);
        }

        public int getMaxLength() {
            return this.maxLength;
        }
    }

    static class ComByteArray {
        private byte[] comBuffer;
        private int maxLength = 0;
        private int comBufferOffset = 0;

        public ComByteArray(int n, byte[] byArray, int n2) {
            this.comBuffer = byArray;
            this.comBufferOffset = n2;
            this.maxLength = n;
        }

        public void setByteArray(byte[] byArray) {
            System.arraycopy(byArray, 0, this.comBuffer, this.comBufferOffset, this.maxLength);
        }

        public byte[] getByteArray() {
            byte[] byArray = new byte[this.maxLength];
            System.arraycopy(this.comBuffer, this.comBufferOffset, byArray, 0, this.maxLength);
            return byArray;
        }

        public int getMaxLength() {
            return this.maxLength;
        }
    }

    static class ComByte {
        private byte[] comBuffer;
        private int comBufferOffset = 0;
        private int maxLength = 1;

        public ComByte(byte[] byArray, int n) {
            this.comBuffer = byArray;
            this.comBufferOffset = n;
        }

        public void setByte(byte by) {
            this.comBuffer[this.comBufferOffset] = by;
        }

        public byte getByte() {
            return this.comBuffer[this.comBufferOffset];
        }

        public byte[] getArray() {
            return this.comBuffer;
        }

        public int getMaxLength() {
            return this.maxLength;
        }
    }

    static class ComShort {
        private byte[] comBuffer;
        private int comBufferOffset = 0;
        private short shortVal = 0;
        private int maxLength = 2;

        public ComShort(byte[] byArray, int n) {
            this.comBuffer = byArray;
            this.comBufferOffset = n;
        }

        public void setShort(short s) {
            this.shortVal = s;
            this.Serialize();
        }

        public short getShort() {
            return this.shortVal;
        }

        public byte[] getArray() {
            return this.comBuffer;
        }

        public void Deserialize(byte[] byArray, int n) {
            this.comBuffer = byArray;
            this.comBufferOffset = n;
            this.shortVal = 0;
            this.shortVal = (short)(this.shortVal + ((this.comBuffer[this.comBufferOffset] & 0xFF) << 8));
            this.shortVal = (short)(this.shortVal + ((this.comBuffer[this.comBufferOffset + 1] & 0xFF) << 0));
        }

        public void Deserialize() {
            this.shortVal = 0;
            this.shortVal = (short)(this.shortVal + ((this.comBuffer[this.comBufferOffset] & 0xFF) << 8));
            this.shortVal = (short)(this.shortVal + ((this.comBuffer[this.comBufferOffset + 1] & 0xFF) << 0));
        }

        public void Serialize() {
            this.comBuffer[this.comBufferOffset] = (byte)(this.shortVal >> 8 & 0xFF);
            this.comBuffer[this.comBufferOffset + 1] = (byte)(this.shortVal & 0xFF);
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public static short get(byte[] byArray, int n) {
            short s = 0;
            s = (short)(s + ((byArray[n] & 0xFF) << 8));
            s = (short)(s + ((byArray[n + 1] & 0xFF) << 0));
            return s;
        }

        public static void put(short s, byte[] byArray, int n) {
            byArray[n] = (byte)(s >> 8 & 0xFF);
            byArray[n + 1] = (byte)(s & 0xFF);
        }
    }

    static class ComInt {
        private byte[] comBuffer;
        private int maxLength = 4;
        private int intValue = 0;
        private int comBufferOffset = 0;

        public ComInt(byte[] byArray, int n) {
            this.comBuffer = byArray;
            this.comBufferOffset = n;
        }

        public void setInt(int n) {
            this.intValue = n;
            this.Serialize();
        }

        public int getInt() {
            return this.intValue;
        }

        public byte[] getArray() {
            return this.comBuffer;
        }

        public void Deserialize(byte[] byArray, int n) {
            this.comBuffer = byArray;
            this.comBufferOffset = n;
            this.intValue = 0;
            this.intValue += (this.comBuffer[this.comBufferOffset] & 0xFF) << 24;
            this.intValue += (this.comBuffer[this.comBufferOffset + 1] & 0xFF) << 16;
            this.intValue += (this.comBuffer[this.comBufferOffset + 2] & 0xFF) << 8;
            this.intValue += (this.comBuffer[this.comBufferOffset + 3] & 0xFF) << 0;
        }

        public void Deserialize() {
            this.intValue = 0;
            this.intValue += (this.comBuffer[this.comBufferOffset] & 0xFF) << 24;
            this.intValue += (this.comBuffer[this.comBufferOffset + 1] & 0xFF) << 16;
            this.intValue += (this.comBuffer[this.comBufferOffset + 2] & 0xFF) << 8;
            this.intValue += (this.comBuffer[this.comBufferOffset + 3] & 0xFF) << 0;
        }

        public void Serialize() {
            this.comBuffer[this.comBufferOffset] = (byte)(this.intValue >> 24 & 0xFF);
            this.comBuffer[this.comBufferOffset + 1] = (byte)(this.intValue >> 16 & 0xFF);
            this.comBuffer[this.comBufferOffset + 2] = (byte)(this.intValue >> 8 & 0xFF);
            this.comBuffer[this.comBufferOffset + 3] = (byte)(this.intValue & 0xFF);
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public static int get(byte[] byArray, int n) {
            int n2 = 0;
            n2 += (byArray[n] & 0xFF) << 24;
            n2 += (byArray[n + 1] & 0xFF) << 16;
            n2 += (byArray[n + 2] & 0xFF) << 8;
            return n2 += (byArray[n + 3] & 0xFF) << 0;
        }

        public static void put(int n, byte[] byArray, int n2) {
            byArray[n2] = (byte)(n >> 24 & 0xFF);
            byArray[n2 + 1] = (byte)(n >> 16 & 0xFF);
            byArray[n2 + 2] = (byte)(n >> 8 & 0xFF);
            byArray[n2 + 3] = (byte)(n & 0xFF);
        }
    }

    static class ComLong {
        private byte[] comBuffer;
        private int maxLength = 8;
        private long longValue = 0L;
        private int comBufferOffset = 0;

        public ComLong(byte[] byArray, int n) {
            this.comBuffer = byArray;
            this.comBufferOffset = n;
        }

        public void setLong(long l) {
            this.longValue = l;
            this.Serialize();
        }

        public long getLong() {
            return this.longValue;
        }

        public byte[] getArray() {
            return this.comBuffer;
        }

        public void Deserialize(byte[] byArray, int n) {
            this.comBuffer = byArray;
            this.comBufferOffset = n;
            this.longValue = 0L;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset] & 0xFFL) << 56;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 1] & 0xFFL) << 48;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 2] & 0xFFL) << 40;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 3] & 0xFFL) << 32;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 4] & 0xFFL) << 24;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 5] & 0xFFL) << 16;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 6] & 0xFFL) << 8;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 7] & 0xFFL) << 0;
        }

        public void Deserialize() {
            this.longValue = 0L;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset] & 0xFFL) << 56;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 1] & 0xFFL) << 48;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 2] & 0xFFL) << 40;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 3] & 0xFFL) << 32;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 4] & 0xFFL) << 24;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 5] & 0xFFL) << 16;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 6] & 0xFFL) << 8;
            this.longValue += ((long)this.comBuffer[this.comBufferOffset + 7] & 0xFFL) << 0;
        }

        public void Serialize() {
            this.comBuffer[this.comBufferOffset] = (byte)(this.longValue >> 56 & 0xFFL);
            this.comBuffer[this.comBufferOffset + 1] = (byte)(this.longValue >> 48 & 0xFFL);
            this.comBuffer[this.comBufferOffset + 2] = (byte)(this.longValue >> 40 & 0xFFL);
            this.comBuffer[this.comBufferOffset + 3] = (byte)(this.longValue >> 32 & 0xFFL);
            this.comBuffer[this.comBufferOffset + 4] = (byte)(this.longValue >> 24 & 0xFFL);
            this.comBuffer[this.comBufferOffset + 5] = (byte)(this.longValue >> 16 & 0xFFL);
            this.comBuffer[this.comBufferOffset + 6] = (byte)(this.longValue >> 8 & 0xFFL);
            this.comBuffer[this.comBufferOffset + 7] = (byte)(this.longValue & 0xFFL);
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public static long get(byte[] byArray, int n) {
            long l = 0L;
            l += ((long)byArray[n] & 0xFFL) << 56;
            l += ((long)byArray[n + 1] & 0xFFL) << 48;
            l += ((long)byArray[n + 2] & 0xFFL) << 40;
            l += ((long)byArray[n + 3] & 0xFFL) << 32;
            l += ((long)byArray[n + 4] & 0xFFL) << 24;
            l += ((long)byArray[n + 5] & 0xFFL) << 16;
            l += ((long)byArray[n + 6] & 0xFFL) << 8;
            return l += ((long)byArray[n + 7] & 0xFFL) << 0;
        }

        public static void put(long l, byte[] byArray, int n) {
            byArray[n] = (byte)(l >> 56 & 0xFFL);
            byArray[n + 1] = (byte)(l >> 48 & 0xFFL);
            byArray[n + 2] = (byte)(l >> 40 & 0xFFL);
            byArray[n + 3] = (byte)(l >> 32 & 0xFFL);
            byArray[n + 4] = (byte)(l >> 24 & 0xFFL);
            byArray[n + 5] = (byte)(l >> 16 & 0xFFL);
            byArray[n + 6] = (byte)(l >> 8 & 0xFFL);
            byArray[n + 7] = (byte)(l & 0xFFL);
        }
    }

    static class ComString {
        private byte[] comBuffer;
        private int comBufferOffset = 0;
        private int maxLength = 0;
        private String string = "";
        private static byte[] blankBuf;

        public ComString(int n, byte[] byArray, int n2) {
            if (blankBuf == null) {
                blankBuf = new byte[1024];
            }
            this.comBuffer = byArray;
            this.maxLength = n;
            this.comBufferOffset = n2;
        }

        public void setString(String string) {
            this.string = string;
            this.Serialize();
        }

        public String getString() {
            return this.string;
        }

        public byte[] getArray() {
            return this.comBuffer;
        }

        public void Serialize() {
            int n = 0;
            try {
                byte[] byArray = this.string.getBytes("UTF8");
                n = byArray.length;
                if (n > this.maxLength) {
                    n = this.maxLength;
                }
                System.arraycopy(byArray, 0, this.comBuffer, this.comBufferOffset, n);
                if (this.maxLength > n && n >= 0) {
                    int n2 = this.comBufferOffset + n;
                    int n3 = this.maxLength - n;
                    System.arraycopy(blankBuf, 0, this.comBuffer, n2, n3);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
        }

        public void DeserializeDelBlanks() {
            int n;
            for (n = 0; n < this.maxLength && this.comBuffer[this.comBufferOffset + n] != 32 && this.comBuffer[this.comBufferOffset + n] != 0; ++n) {
            }
            this.string = new String(this.comBuffer, this.comBufferOffset, n);
        }

        public void Deserialize() {
            int n;
            for (n = 0; n < this.maxLength && this.comBuffer[this.comBufferOffset + n] != 0; ++n) {
            }
            this.string = new String(this.comBuffer, this.comBufferOffset, n);
        }

        public int getMaxLength() {
            return this.maxLength;
        }
    }
}

