/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.proj.jstartup.impl;

import com.sap.bc.proj.jstartup.api.JStartupClusterControlException;
import com.sap.bc.proj.jstartup.api.JStartupClusterController;
import com.sap.bc.proj.jstartup.api.JStartupClusterInstance;
import com.sap.bc.proj.jstartup.api.JStartupControlInstance;
import com.sap.bc.proj.jstartup.impl.JStartupClusterControllerImpl;
import com.sap.bc.proj.jstartup.impl.JStartupConnectionUtil;
import com.sap.bc.proj.jstartup.impl.JStartupControlInstanceImpl;
import java.net.InetAddress;
import java.net.UnknownHostException;

class JStartupClusterInstanceImpl
extends JStartupClusterInstance {
    private JStartupClusterControllerImpl clusterController;
    private JStartupControlInstance ctrlInstance;
    private JStartupConnectionUtil.ComString name;
    private JStartupConnectionUtil.ComString host;
    private JStartupConnectionUtil.ComString service;
    private JStartupConnectionUtil.ComByte messageType;
    private JStartupConnectionUtil.ComByteArray hostAddress;
    private JStartupConnectionUtil.ComShort serverNumber;
    private JStartupConnectionUtil.ComByte state;
    private byte[] buf;

    JStartupClusterInstanceImpl(JStartupClusterControllerImpl jStartupClusterControllerImpl) {
        this.clusterController = jStartupClusterControllerImpl;
        int n = 0;
        this.buf = new byte[115];
        this.name = new JStartupConnectionUtil.ComString(40, this.buf, n);
        this.host = new JStartupConnectionUtil.ComString(32, this.buf, n += this.name.getMaxLength());
        this.service = new JStartupConnectionUtil.ComString(20, this.buf, n += this.host.getMaxLength());
        this.messageType = new JStartupConnectionUtil.ComByte(this.buf, n += this.service.getMaxLength());
        this.hostAddress = new JStartupConnectionUtil.ComByteArray(4, this.buf, n += this.messageType.getMaxLength());
        this.serverNumber = new JStartupConnectionUtil.ComShort(this.buf, n += this.hostAddress.getMaxLength());
        this.state = new JStartupConnectionUtil.ComByte(this.buf, n += this.serverNumber.getMaxLength());
        n += this.state.getMaxLength();
    }

    JStartupClusterInstanceImpl(byte[] byArray, int n, JStartupClusterControllerImpl jStartupClusterControllerImpl) {
        this(jStartupClusterControllerImpl);
        this.deserialize(byArray, n);
    }

    public String getHost() {
        return this.host.getString();
    }

    public String getName() {
        return this.name.getString();
    }

    public byte getState() {
        return this.state.getByte();
    }

    public byte getMessageType() {
        return this.messageType.getByte();
    }

    public JStartupControlInstance getControlInstance() throws JStartupClusterControlException {
        if (this.ctrlInstance == null && this.getMessageType() == 1) {
            this.ctrlInstance = new JStartupControlInstanceImpl(this.clusterController, this.getName());
        }
        return this.ctrlInstance;
    }

    public JStartupClusterController getClusterController() throws JStartupClusterControlException {
        return this.clusterController;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("|Name:" + this.getName());
        stringBuffer.append("|Host:" + this.getHost());
        stringBuffer.append("|State:" + this.getState());
        stringBuffer.append("|");
        return stringBuffer.toString();
    }

    String getService() {
        return this.service.getString();
    }

    InetAddress getHostadr() {
        try {
            return InetAddress.getByName(this.host.getString());
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    short getServerNumber() {
        return this.serverNumber.getShort();
    }

    int deserialize(byte[] byArray, int n) {
        System.arraycopy(byArray, n, this.buf, 0, 115);
        this.name.Deserialize();
        this.host.Deserialize();
        this.service.Deserialize();
        return 115;
    }
}

