/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.proj.jstartup.impl;

import com.sap.bc.proj.jstartup.api.JStartupClusterControlException;
import com.sap.bc.proj.jstartup.api.JStartupClusterController;
import com.sap.bc.proj.jstartup.api.JStartupClusterInstance;
import com.sap.bc.proj.jstartup.impl.JStartupClusterControllerFactoryImpl;
import com.sap.bc.proj.jstartup.impl.JStartupRawConnection;
import java.io.IOException;

class JStartupClusterControllerImpl
extends JStartupClusterController {
    public static long DEFAULT_TIMEOUT = 60000L;
    private String msHost;
    private int msPort;
    private JStartupRawConnection connection;

    JStartupClusterControllerImpl(String string, int n) throws IOException {
        this.msHost = string;
        this.msPort = n;
        this.connection = new JStartupRawConnection(string, n, this);
    }

    public JStartupClusterInstance[] getInstances() throws JStartupClusterControlException {
        return this.connection.getClusterList();
    }

    public void restartCluster(long l) throws JStartupClusterControlException {
        this.connection.sendCommandToCluster((byte)2);
        this.connection.sendState((byte)0);
        this.connection.waitForClusterState(l, (byte)4, (byte)5);
    }

    public void restartInstance(String string, long l) throws JStartupClusterControlException {
        this.connection.sendCommandToInstance(string, (byte)2);
        this.connection.waitForInstanceState(string, l, (byte)5);
    }

    public void shutdownInstance(String string, boolean bl, long l) throws JStartupClusterControlException {
        this.shutdownInstanceAsync(string, bl);
        this.connection.waitForInstanceState(string, l, (byte)7);
    }

    public void shutdownInstanceAsync(String string, boolean bl) throws JStartupClusterControlException {
        if (bl) {
            this.connection.sendCommandToInstance(string, (byte)1);
        } else {
            this.connection.sendCommandToInstance(string, (byte)0);
        }
    }

    public void shutdownCluster(boolean bl, long l) throws JStartupClusterControlException {
        this.shutdownClusterAsync(bl);
        this.connection.waitForClusterState(l, (byte)7, (byte)8);
    }

    public void shutdownClusterAsync(boolean bl) throws JStartupClusterControlException {
        if (bl) {
            this.connection.sendState((byte)101);
            this.connection.sendCommandToCluster((byte)1);
        } else {
            this.connection.sendState((byte)100);
            this.connection.sendCommandToCluster((byte)0);
        }
    }

    public void shutdownClusterWithoutSDM(long l) throws JStartupClusterControlException {
        this.shutdownClusterWithoutSDMAsync();
        this.connection.waitForClusterState(l, (byte)7, (byte)8);
    }

    public void shutdownClusterWithoutSDMAsync() throws JStartupClusterControlException {
        this.connection.sendState((byte)101);
        this.connection.sendCommandToCluster((byte)21);
    }

    public void syncProperties() throws JStartupClusterControlException {
        this.connection.sendCommandToCluster((byte)3);
    }

    public void syncProperties(String string) throws JStartupClusterControlException {
        this.connection.sendCommandToInstance(string, (byte)3);
    }

    public void freeCluster() throws JStartupClusterControlException {
        this.connection.sendState((byte)0);
    }

    public void exit() {
        try {
            this.connection.detachFromMessageServer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JStartupClusterControllerFactoryImpl.getInstance().deregisterClusterController(this);
    }

    public boolean disableProcesses(int n) {
        try {
            this.connection.sendCommandToCluster((byte)12, n);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public boolean enableProcesses(int n) {
        try {
            this.connection.sendCommandToCluster((byte)11, n);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public boolean disableProcessesExclude(int n) {
        try {
            this.connection.sendCommandToCluster((byte)14, n);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public boolean enableProcessesExclude(int n) {
        try {
            this.connection.sendCommandToCluster((byte)13, n);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public boolean bootstrapProcesses(int n) {
        try {
            this.connection.sendCommandToCluster((byte)30, n);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public boolean bootstrapProcessesExclude(int n) {
        try {
            this.connection.sendCommandToCluster((byte)31, n);
            return true;
        }
        catch (JStartupClusterControlException jStartupClusterControlException) {
            return false;
        }
    }

    public String getMsHost() {
        return this.msHost;
    }

    public int getMsPort() {
        return this.msPort;
    }

    JStartupRawConnection getConnection() {
        return this.connection;
    }
}

