/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.proj.jstartup.impl;

import com.sap.bc.proj.jstartup.api.JStartupClusterControlException;
import com.sap.bc.proj.jstartup.api.JStartupClusterController;
import com.sap.bc.proj.jstartup.api.JStartupClusterControllerFactory;
import com.sap.bc.proj.jstartup.api.JStartupMonitor;
import com.sap.bc.proj.jstartup.impl.JStartupClusterControlExceptionImpl;
import com.sap.bc.proj.jstartup.impl.JStartupClusterControllerImpl;
import com.sap.bc.proj.jstartup.impl.JStartupMonitorImpl;
import java.io.IOException;
import java.util.Hashtable;

final class JStartupClusterControllerFactoryImpl
extends JStartupClusterControllerFactory {
    private static JStartupClusterControllerFactoryImpl factory = null;
    private Hashtable clusterControllers = new Hashtable();

    private JStartupClusterControllerFactoryImpl() {
    }

    static JStartupClusterControllerFactoryImpl getInstance() {
        if (factory == null) {
            factory = new JStartupClusterControllerFactoryImpl();
        }
        return factory;
    }

    public JStartupClusterController getClusterController(String string, int n) throws IOException {
        return this.getClusterControllerImpl(string, n);
    }

    public JStartupClusterController createClusterController() throws IOException, JStartupClusterControlException {
        return this.createClusterControllerImpl();
    }

    public JStartupClusterController createClusterController(String string, int n) throws IOException {
        return this.createClusterControllerImpl(string, n);
    }

    public JStartupMonitor createMonitor() {
        return new JStartupMonitorImpl();
    }

    JStartupClusterControllerImpl getClusterControllerImpl(String string, int n) throws IOException {
        String string2 = this.computeHashKey(string, n);
        JStartupClusterControllerImpl jStartupClusterControllerImpl = (JStartupClusterControllerImpl)((Object)this.clusterControllers.get(string2));
        if (jStartupClusterControllerImpl == null) {
            jStartupClusterControllerImpl = this.createClusterControllerImpl(string, n);
        }
        return jStartupClusterControllerImpl;
    }

    JStartupClusterControllerImpl createClusterControllerImpl() throws IOException, JStartupClusterControlException {
        String string = System.getProperty("SAPMSHOST");
        String string2 = System.getProperty("SAPMSPORT");
        if (string == null || string2 == null) {
            throw new JStartupClusterControlExceptionImpl("system properties SAPMSHOST and/or SAPMSPORT not set");
        }
        int n = new Integer(string2);
        return this.createClusterControllerImpl(string, n);
    }

    JStartupClusterControllerImpl createClusterControllerImpl(String string, int n) throws IOException {
        String string2 = this.computeHashKey(string, n);
        JStartupClusterControllerImpl jStartupClusterControllerImpl = (JStartupClusterControllerImpl)((Object)this.clusterControllers.get(string2));
        if (jStartupClusterControllerImpl != null) {
            jStartupClusterControllerImpl.exit();
        }
        jStartupClusterControllerImpl = new JStartupClusterControllerImpl(string, n);
        this.clusterControllers.put(string2, jStartupClusterControllerImpl);
        return jStartupClusterControllerImpl;
    }

    void deregisterClusterController(JStartupClusterControllerImpl jStartupClusterControllerImpl) {
        int n;
        String string = jStartupClusterControllerImpl.getMsHost();
        String string2 = this.computeHashKey(string, n = jStartupClusterControllerImpl.getMsPort());
        Object v = this.clusterControllers.get(string2);
        if (v != null && v.equals((Object)jStartupClusterControllerImpl)) {
            this.clusterControllers.remove(string2);
        }
    }

    private String computeHashKey(String string, int n) {
        return string + ":" + n;
    }
}

