/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.relationshippage;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ejbjar.dd.IEjbJar;
import com.tssap.j2ee.model.ejbjar.dd.IEjbName;
import com.tssap.j2ee.model.ejbjar.dd.IEjbRelation;
import com.tssap.j2ee.model.ejbjar.dd.IEjbRelationshipRole;
import com.tssap.j2ee.model.ejbjar.dd.IMultiplicity;
import com.tssap.j2ee.model.ejbjar.dd.IRelationshipRoleSource;
import com.tssap.j2ee.model.ejbjar.dd.IRelationships;
import com.tssap.j2ee.ui.ejbjar.editor.IEjbJarHolder;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;

public class RelationshipsAddRemoveCallback
implements IAddRemoveCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$relationshippage$RelationshipsAddRemoveCallback == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$relationshippage$RelationshipsAddRemoveCallback = RelationshipsAddRemoveCallback.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.relationshippage.RelationshipsAddRemoveCallback")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$relationshippage$RelationshipsAddRemoveCallback));
    private IEjbJarHolder ejbJarHolder;
    private static final String DEFAULT_NAME_PREFIX = "DefaultEjbRelation";
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$relationshippage$RelationshipsAddRemoveCallback;

    public RelationshipsAddRemoveCallback(IEjbJarHolder holder) {
        this.setEjbJarHolder(holder);
    }

    public boolean canAddElement(Object currentSelection) {
        return false;
    }

    public Object addElement(Object currentSelection) {
        IEjbRelation ret = null;
        if (this.getRelationships() == null && this.getEjbJarHolder() != null && this.getEjbJarHolder().getEjbJar() != null) {
            try {
                this.getEjbJarHolder().getEjbJar().createRelationships(null);
            }
            catch (J2eeCreateException e) {
                this.handleJ2eeCreateException("<relationships> tag could not be created", e);
            }
        }
        if (this.getRelationships() != null && this.getEjbJarHolder() != null) {
            String defaultEjbRelationName = this.getDefaultRelationName(this.getEjbJarHolder().getEjbJar());
            try {
                IEjbRelation ejbRelation = this.getRelationships().createEjbRelation(null);
                ejbRelation.createEjbRelationName(null).setValue(defaultEjbRelationName);
                ret = ejbRelation;
                RelationshipsAddRemoveCallback.createEjbRelationshipRole(ejbRelation);
            }
            catch (J2eeCreateException e) {
                this.handleJ2eeCreateException("tag could not be created", e);
            }
        }
        return ret;
    }

    private String getDefaultRelationName(IEjbJar ejbJar) {
        String defaultEjbRelationName = "<no name specified>";
        IRelationships relationships = null;
        IEjbRelation[] ejbRelationArr = null;
        int prefix = 0;
        if (ejbJar != null) {
            defaultEjbRelationName = DEFAULT_NAME_PREFIX;
            relationships = ejbJar.getRelationships();
            ejbRelationArr = relationships.getEjbRelations();
            if (ejbRelationArr != null) {
                int i = 0;
                while (i < ejbRelationArr.length) {
                    if (ejbRelationArr[i].getEjbRelationName() != null && ejbRelationArr[i].getEjbRelationName().getValue().equalsIgnoreCase(defaultEjbRelationName)) {
                        defaultEjbRelationName = DEFAULT_NAME_PREFIX + String.valueOf(++prefix);
                        i = 0;
                        continue;
                    }
                    ++i;
                }
            }
            ejbRelationArr = null;
        }
        return defaultEjbRelationName;
    }

    private static void createEjbRelationshipRole(IEjbRelation ejbRelation) throws J2eeCreateException {
        IEjbRelationshipRole[] roles = ejbRelation.createEjbRelationshipRoles(null, null);
        int i = 0;
        while (i < roles.length) {
            IEjbRelationshipRole role = roles[i];
            IMultiplicity multiplicity = role.createMultiplicity(null);
            multiplicity.setValue("One");
            IRelationshipRoleSource source = role.createRelationshipRoleSource(null);
            IEjbName name = source.createEjbName(null);
            String nameValue = "";
            if (name != null) {
                name.setValue(nameValue);
            }
            ++i;
        }
    }

    public boolean canRemoveElement(Object currentSelection) {
        boolean ret = false;
        return ret;
    }

    public boolean removeElement(Object currentSelection) {
        boolean ret = false;
        if (currentSelection instanceof IEjbRelation && this.getRelationships() != null) {
            this.getRelationships().removeEjbRelation((IEjbRelation)currentSelection);
            ret = true;
        }
        return ret;
    }

    private IRelationships getRelationships() {
        IRelationships ret = null;
        if (this.getEjbJarHolder() != null && this.getEjbJarHolder().getEjbJar() != null) {
            ret = this.getEjbJarHolder().getEjbJar().getRelationships();
        }
        return ret;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(this.getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    private IEjbJarHolder getEjbJarHolder() {
        return this.ejbJarHolder;
    }

    private void setEjbJarHolder(IEjbJarHolder ejbJarHolder) {
        this.ejbJarHolder = ejbJarHolder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

