/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.relationshippage;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ejbjar.dd.IDescription;
import com.tssap.j2ee.model.ejbjar.dd.IEjbJar;
import com.tssap.j2ee.model.ejbjar.dd.IRelationships;
import com.tssap.j2ee.ui.ejbjar.editor.IEjbJarEditor;
import com.tssap.j2ee.ui.ejbjar.editor.IEjbJarHolder;
import com.tssap.j2ee.ui.ejbjar.editor.internal.EjbJarEditorPage;
import com.tssap.j2ee.ui.ejbjar.editor.internal.relationshippage.RelationshipsAddRemoveCallback;
import com.tssap.j2ee.ui.ejbjar.editor.internal.relationshippage.RelationshipsContentProvider;
import com.tssap.j2ee.ui.ejbjar.editor.internal.relationshippage.RelationshipsLabelProvider;
import com.tssap.j2ee.ui.ejbjar.editor.internal.relationshippage.RelationshipsReusableManager;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import com.tssap.util.ui.reuse.tree.TreeSelectorEditorComponent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class EjbJarRelationshipsPage
extends EjbJarEditorPage
implements IModifiedCallback,
IEjbJarHolder {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$relationshippage$EjbJarRelationshipsPage == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$relationshippage$EjbJarRelationshipsPage = EjbJarRelationshipsPage.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.relationshippage.EjbJarRelationshipsPage")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$relationshippage$EjbJarRelationshipsPage));
    private static final int NUM_OF_COLS = 1;
    private static final String PAGE_NAME = "Relationships";
    private static final String TXT_HELP_HOW_TO_CREATE_EJB_RELATIONS = " EJB Relations can be created with the EJB Editor.";
    private TreeSelectorEditorComponent treeEditor;
    private IEjbJar ejbJar;
    private Label warningImg;
    private Label helpEjbRel;
    private Text descriptionTextField;
    private boolean isModListenerActive = false;
    private boolean isDescriptionTextFieldEnabled = false;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$relationshippage$EjbJarRelationshipsPage;

    public EjbJarRelationshipsPage(Composite parent, IEjbJarEditor editor) {
        super(parent, editor, 1);
    }

    protected void initControlsWithEjbJar(IEjbJar ejbJar) {
        this.isModListenerActive = false;
        this.setEjbJar(ejbJar);
        this.getTreeSelector().setTreeInput((Object)ejbJar);
        this.getDescriptionTextField().setText("");
        if (this.getEjbJar() != null && this.getEjbJar().getRelationships() != null && this.getEjbJar().getRelationships().getEjbRelations() != null) {
            this.setDescriptionTextFieldEnabled(true);
            IDescription description = this.getEjbJar().getRelationships().getDescription();
            if (description != null) {
                this.getDescriptionTextField().setText(description.getValue());
            }
            this.getWarningImg().setVisible(false);
            this.getHelpEjbRel().setVisible(false);
        } else {
            this.setDescriptionTextFieldEnabled(false);
            this.getWarningImg().setVisible(true);
            this.getHelpEjbRel().setVisible(true);
        }
        this.updateEditableBehavior();
        this.isModListenerActive = true;
    }

    protected void updateEjbJarFromControls(IEjbJar ejbJar) {
        this.getTreeEditor().aboutToLeave();
        String value = this.getDescriptionTextField().getText().trim();
        IRelationships relationships = this.getEjbJar().getRelationships();
        if (value.length() > 0) {
            if (relationships == null) {
                try {
                    relationships = this.getEjbJar().createRelationships(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("Cannot create tag <relationships>", e);
                }
            }
            if (relationships != null) {
                this.setDescriptionTextFieldEnabled(true);
                IDescription description = relationships.getDescription();
                if (description == null) {
                    try {
                        description = relationships.createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("Cannot create tag <description>", e);
                    }
                }
                if (description != null) {
                    description.setValue(value);
                }
            }
        } else if (relationships != null && relationships.getDescription() != null) {
            relationships.removeDescription();
        }
        this.deleteRelationshipsTagIfPossible();
    }

    private void deleteRelationshipsTagIfPossible() {
        IRelationships relationshipsTag;
        if (this.getEjbJar() != null && (relationshipsTag = this.getEjbJar().getRelationships()) != null) {
            boolean isEjbRelationEmpty;
            boolean bl = isEjbRelationEmpty = relationshipsTag.getEjbRelations() == null || relationshipsTag.getEjbRelations().length < 1;
            if (isEjbRelationEmpty) {
                this.getEjbJar().removeRelationships();
            } else {
                this.setDescriptionTextFieldEnabled(true);
            }
        }
    }

    public String getPageName() {
        return PAGE_NAME;
    }

    protected Control createControls(IGridLayoutPane grid) {
        IGridLayoutPane helpPane = grid.addGridLayoutPane(2);
        this.createHelpControls(helpPane);
        grid.addTextLabel("Description");
        this.descriptionTextField = grid.addTextPane("", false, true, grid.createGridLayoutData(4, 4, true, false, 1, 1));
        TreeSelector treeSelector = new TreeSelector(false);
        if (treeSelector != null) {
            treeSelector.setSplitterWeight(3);
        }
        this.treeEditor = new TreeSelectorEditorComponent(treeSelector);
        this.setTreeEditor(this.treeEditor);
        treeSelector.createPartControl(grid);
        return grid.getComposite();
    }

    protected void createHelpControls(IGridLayoutPane grid) {
        this.warningImg = grid.addImage(SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_MESSAGE_WARNING), false, grid.createGridLayoutData(1, 1, false, false, 1, 1));
        this.helpEjbRel = grid.addTextLabel(TXT_HELP_HOW_TO_CREATE_EJB_RELATIONS, grid.createGridLayoutData(1, 4, true, false, 1, 1));
        this.warningImg.setVisible(false);
        this.helpEjbRel.setVisible(false);
    }

    protected void decorateControls() {
        this.treeEditor.setTreeContentProvider((ITreeContentProvider)new RelationshipsContentProvider());
        this.treeEditor.setTreeLabelProvider((ILabelProvider)new RelationshipsLabelProvider());
        this.treeEditor.setAddRemoveCallback((IAddRemoveCallback)new RelationshipsAddRemoveCallback(this));
        this.treeEditor.setReusableManager((IReuseableManager)new RelationshipsReusableManager(this.getUnderlyingFile().getProject()));
        this.treeEditor.setModifiedCallback((IModifiedCallback)this);
        this.getDescriptionTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EjbJarRelationshipsPage.this.dataModified(true);
            }
        });
    }

    private TreeSelector getTreeSelector() {
        TreeSelector ret = null;
        if (this.getTreeEditor() != null) {
            ret = this.getTreeEditor().getTreeSelector();
        }
        return ret;
    }

    private TreeSelectorEditorComponent getTreeEditor() {
        return this.treeEditor;
    }

    private void setTreeEditor(TreeSelectorEditorComponent treeEditor) {
        this.treeEditor = treeEditor;
    }

    public void dataModified(boolean modified) {
        if (this.isModListenerActive) {
            this.getEditor().setDirtyFlag(modified);
        }
        TreeItem[] selectedItems = this.getTreeSelector().getTreeViewer().getTree().getSelection();
        int i = 0;
        while (i < selectedItems.length) {
            TreeItem selectedItem = selectedItems[i];
            this.getTreeSelector().getTreeViewer().refresh(selectedItem.getData(), true);
            ++i;
        }
    }

    private Text getDescriptionTextField() {
        return this.descriptionTextField;
    }

    public IEjbJar getEjbJar() {
        return this.ejbJar;
    }

    private void setEjbJar(IEjbJar ejbJar) {
        this.ejbJar = ejbJar;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(this.getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.getTreeEditor() != null) {
            this.getTreeEditor().setEditable(editable);
        }
        if (this.getDescriptionTextField() != null) {
            this.getDescriptionTextField().setEditable(editable && this.isDescriptionTextFieldEnabled());
        }
    }

    private boolean isDescriptionTextFieldEnabled() {
        return this.isDescriptionTextFieldEnabled;
    }

    private void setDescriptionTextFieldEnabled(boolean b) {
        this.isDescriptionTextFieldEnabled = b;
    }

    private Label getWarningImg() {
        return this.warningImg;
    }

    private Label getHelpEjbRel() {
        return this.helpEjbRel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

