/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IMutable;
import com.tssap.j2ee.model.dd.MutableUtil;
import com.tssap.j2ee.model.ejbjar.dd.IDescription;
import com.tssap.j2ee.model.ejbjar.dd.IDisplayName;
import com.tssap.j2ee.model.ejbjar.dd.ILargeIcon;
import com.tssap.j2ee.model.ejbjar.dd.ISession;
import com.tssap.j2ee.model.ejbjar.dd.ISmallIcon;
import com.tssap.j2ee.ui.editor.reuse.gi.DDGeneralInfoComponent;
import com.tssap.j2ee.ui.editor.reuse.gi.IDDGeneralInfoComponent;
import com.tssap.j2ee.ui.editor.reuse.gi.IDDGeneralInfoComponentAdapter;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class UiSessionGeneral
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiSessionGeneral == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiSessionGeneral = UiSessionGeneral.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects.UiSessionGeneral")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiSessionGeneral));
    private IDDGeneralInfoComponent infoComponent;
    private InnerComponentAdapter infoComponentAdapter;
    private IModifiedCallback myModifyCallback;
    private Text ejbNameTextField;
    private Text homeTextField;
    private Text remoteTextField;
    private Text localHomeTextField;
    private Text localTextField;
    private Text ejbClassTextField;
    private Text sessionTypeTextField;
    private Combo transactionTypeCombo;
    private static final String[] transTypeItems = new String[]{"Bean", "Container"};
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiSessionGeneral;

    public void initContainer(IGridLayoutPane userArea) {
        userArea.setTitle("Session Bean");
        this.infoComponent = new DDGeneralInfoComponent();
        this.infoComponentAdapter = new InnerComponentAdapter();
        this.infoComponent.setAdapter((IDDGeneralInfoComponentAdapter)this.infoComponentAdapter);
        IGridLayoutPane infoPane = userArea.addGridLayoutPane(this.infoComponent.getUserGridNumOfColumns(), userArea.createGridLayoutData(4, 4, true, false, this.getUserGridNumOfColumns(), 1));
        this.infoComponent.createPartControl(infoPane);
        userArea.addPlaceholder(this.getUserGridNumOfColumns(), 1);
        userArea.addTextLabel("EJB Name");
        this.ejbNameTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEjbNameTextField(this.ejbNameTextField);
        userArea.addTextLabel("Home");
        this.homeTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setHomeTextField(this.homeTextField);
        userArea.addTextLabel("Remote");
        this.remoteTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setRemoteTextField(this.remoteTextField);
        userArea.addTextLabel("Local home");
        this.localHomeTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setLocalHomeTextField(this.localHomeTextField);
        userArea.addTextLabel("Local");
        this.localTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setLocalTextField(this.localTextField);
        userArea.addTextLabel("EJB class");
        this.ejbClassTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEjbClassTextField(this.ejbClassTextField);
        userArea.addTextLabel("Session type");
        this.sessionTypeTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setSessionTypeTextField(this.sessionTypeTextField);
        userArea.addTextLabel("Transaction type");
        this.transactionTypeCombo = userArea.addComboBox(transTypeItems, "", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setTransactionTypeCombo(this.transactionTypeCombo);
        this.decorateControls();
    }

    private void decorateControls() {
        this.getSessionTypeTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getEjbNameTextField().addModifyListener((ModifyListener)new EjbNameModifyAdapter());
        this.getHomeTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getRemoteTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getLocalHomeTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getLocalTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getEjbClassTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getTransactionTypeCombo().addModifyListener(this.getModifyAdapterSingleton());
    }

    public Text getEjbClassTextField() {
        return this.ejbClassTextField;
    }

    public Text getEjbNameTextField() {
        return this.ejbNameTextField;
    }

    public Text getHomeTextField() {
        return this.homeTextField;
    }

    public Text getLocalHomeTextField() {
        return this.localHomeTextField;
    }

    public Text getLocalTextField() {
        return this.localTextField;
    }

    public Text getRemoteTextField() {
        return this.remoteTextField;
    }

    public Text getSessionTypeTextField() {
        return this.sessionTypeTextField;
    }

    public void setEjbClassTextField(Text ejbClassTextField) {
        this.ejbClassTextField = ejbClassTextField;
    }

    public void setEjbNameTextField(Text ejbNameTextField) {
        this.ejbNameTextField = ejbNameTextField;
    }

    public void setHomeTextField(Text homeTextField) {
        this.homeTextField = homeTextField;
    }

    public void setLocalHomeTextField(Text localHomeTextField) {
        this.localHomeTextField = localHomeTextField;
    }

    public void setLocalTextField(Text localTextField) {
        this.localTextField = localTextField;
    }

    public void setRemoteTextField(Text remoteTextField) {
        this.remoteTextField = remoteTextField;
    }

    public void setSessionTypeTextField(Text sessionTypeTextField) {
        this.sessionTypeTextField = sessionTypeTextField;
    }

    private Combo getTransactionTypeCombo() {
        return this.transactionTypeCombo;
    }

    private void setTransactionTypeCombo(Combo combo) {
        this.transactionTypeCombo = combo;
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        ISession session = this.getSession();
        this.refreshEjbNameFieldFromUI();
        if (session != null) {
            if (session.getHome() != null && session.getHome().getValue().trim().length() == 0) {
                session.removeHome();
            }
            if (session.getRemote() != null && session.getRemote().getValue().trim().length() == 0) {
                session.removeRemote();
            }
            if (session.getLocalHome() != null && session.getLocalHome().getValue().trim().length() == 0) {
                session.removeLocalHome();
            }
            if (session.getLocal() != null && session.getLocal().getValue().trim().length() == 0) {
                session.removeLocal();
            }
            if (session.getTransactionType() == null) {
                try {
                    session.createTransactionType(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<transaction-type> could not be created.", e);
                }
            }
            if (this.getTransactionTypeCombo() != null && !this.getTransactionTypeCombo().getText().equals("")) {
                if (session.getTransactionType() == null) {
                    try {
                        session.createTransactionType(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<transaction-type> tag could not be created.", e);
                    }
                }
                session.getTransactionType().setValue(this.getTransactionTypeCombo().getText());
            }
        }
    }

    private void refreshEjbNameFieldFromUI() {
        ISession session = this.getSession();
        if (session != null) {
            if (!this.getEjbNameTextField().getText().trim().equals("")) {
                if (session.getEjbName() == null) {
                    try {
                        session.createEjbName(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<ejb-name> could not be created.", e);
                    }
                }
                session.getEjbName().setValue(this.getEjbNameTextField().getText().trim());
            } else if (session.getEjbName() != null) {
                session.getEjbName().setValue("");
            }
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        ISession session = this.getSession();
        if (session != null) {
            this.infoComponentAdapter.setSession(session);
            this.infoComponent.initialize();
            this.getEjbNameTextField().setText(session.getEjbName() != null ? session.getEjbName().getValue() : "");
            this.getHomeTextField().setText(session.getHome() != null ? session.getHome().getValue() : "");
            this.getRemoteTextField().setText(session.getRemote() != null ? session.getRemote().getValue() : "");
            this.getLocalHomeTextField().setText(session.getLocalHome() != null ? session.getLocalHome().getValue() : "");
            this.getLocalTextField().setText(session.getLocal() != null ? session.getLocal().getValue() : "");
            this.getEjbClassTextField().setText(session.getEjbClass() != null ? session.getEjbClass().getValue() : "");
            this.getSessionTypeTextField().setText(session.getSessionType() != null ? session.getSessionType().getValue() : "");
            if (session.getTransactionType() != null) {
                if (session.getTransactionType().getValue().equalsIgnoreCase(transTypeItems[0])) {
                    this.getTransactionTypeCombo().setText(transTypeItems[0]);
                } else {
                    this.getTransactionTypeCombo().setText(transTypeItems[1]);
                }
            } else {
                tracer.error("refreshUiFromData()", "transaction-type is null but is a mandatory tag!");
            }
        } else {
            throw new IllegalArgumentException("No object of ISession found!");
        }
        this.stopRefreshingUI();
    }

    protected ISession getSession() {
        ISession ret = null;
        if (this.getData() instanceof ISession) {
            ret = (ISession)this.getData();
        }
        return ret;
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof ISession)) {
            ret = "No object of ISession found!";
        }
        return ret;
    }

    public void setModifyCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    private IDDGeneralInfoComponent getInfoComponent() {
        return this.infoComponent;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected void handleEjbNameEvent() {
        if (!this.isRefreshingUI()) {
            this.refreshEjbNameFieldFromUI();
            super.handleEvent();
        }
    }

    protected void updateEditableBehavior() {
        boolean editable = this.isEditable();
        if (this.getInfoComponent() != null) {
            this.getInfoComponent().setEditable(editable);
        }
        if (this.getEjbNameTextField() != null) {
            this.getEjbNameTextField().setEditable(editable);
        }
        if (this.getTransactionTypeCombo() != null) {
            this.getTransactionTypeCombo().setEnabled(editable);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EjbNameModifyAdapter
    implements ModifyListener {
        private EjbNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UiSessionGeneral.this.handleEjbNameEvent();
        }
    }

    private class InnerComponentAdapter
    implements IDDGeneralInfoComponentAdapter {
        private ISession session;

        public String getDescription() {
            if (this.getSession() == null) {
                return "";
            }
            IDescription descriptionMutable = this.getSession().getDescription();
            String description = MutableUtil.mutableToValue((IMutable)descriptionMutable);
            return description;
        }

        public String getDisplayName() {
            if (this.getSession() == null) {
                return "";
            }
            IDisplayName displayNameMutable = this.getSession().getDisplayName();
            String displayName = MutableUtil.mutableToValue((IMutable)displayNameMutable);
            return displayName;
        }

        public String getLargeIcon() {
            String ret = "";
            if (this.isIconsChecked()) {
                ILargeIcon largeIconMutable = this.getSession().getLargeIcon();
                ret = MutableUtil.mutableToValue((IMutable)largeIconMutable);
            }
            return ret;
        }

        public String getSmallIcon() {
            String ret = "";
            if (this.isIconsChecked()) {
                ISmallIcon smallIconMutable = this.getSession().getSmallIcon();
                ret = MutableUtil.mutableToValue((IMutable)smallIconMutable);
            }
            return ret;
        }

        public boolean isIconsChecked() {
            ILargeIcon largeIcon = this.getSession() != null ? this.getSession().getLargeIcon() : null;
            ISmallIcon smallIcon = this.getSession() != null ? this.getSession().getSmallIcon() : null;
            return largeIcon != null || smallIcon != null;
        }

        public void setDescription(String description) {
            if (description.trim().length() != 0) {
                if (this.getSession().getDescription() != null) {
                    this.getSession().getDescription().setValue(description);
                } else {
                    try {
                        this.getSession().createDescription(null).setValue(description);
                    }
                    catch (J2eeCreateException e) {
                        UiSessionGeneral.this.handleJ2eeCreateException("<description> could not be created.", e);
                    }
                }
            } else if (this.getSession().getDescription() != null) {
                this.getSession().removeDescription();
            }
            UiSessionGeneral.super.handleEvent();
        }

        public void setDisplayName(String displayName) {
            if (displayName.trim().length() != 0) {
                if (this.getSession().getDisplayName() != null) {
                    this.getSession().getDisplayName().setValue(displayName);
                } else {
                    try {
                        this.getSession().createDisplayName(null).setValue(displayName);
                    }
                    catch (J2eeCreateException e) {
                        UiSessionGeneral.this.handleJ2eeCreateException("<display-name> could not be created.", e);
                    }
                }
            } else if (this.getSession().getDisplayName() != null) {
                this.getSession().removeDisplayName();
            }
            UiSessionGeneral.super.handleEvent();
        }

        public void setIconsChecked(boolean checkFlag) {
        }

        public void setLargeIcon(String largeIcon) {
            if (this.getSession() != null) {
                if (largeIcon.trim().length() != 0) {
                    if (this.getSession().getLargeIcon() != null) {
                        this.getSession().getLargeIcon().setValue(largeIcon);
                    } else {
                        try {
                            this.getSession().createLargeIcon(null).setValue(largeIcon);
                        }
                        catch (J2eeCreateException e) {
                            UiSessionGeneral.this.handleJ2eeCreateException("<large-icon> could not be created.", e);
                        }
                    }
                } else if (this.getSession().getLargeIcon() != null) {
                    this.getSession().removeLargeIcon();
                }
                UiSessionGeneral.super.handleEvent();
            }
        }

        public void setSmallIcon(String smallIcon) {
            if (this.getSession() != null) {
                if (smallIcon.trim().length() != 0) {
                    if (this.getSession().getSmallIcon() != null) {
                        this.getSession().getSmallIcon().setValue(smallIcon);
                    } else {
                        try {
                            this.getSession().createSmallIcon(null).setValue(smallIcon);
                        }
                        catch (J2eeCreateException e) {
                            UiSessionGeneral.this.handleJ2eeCreateException("Tag <small-icon> could not be created.", e);
                        }
                    }
                } else if (this.getSession().getSmallIcon() != null) {
                    this.getSession().removeSmallIcon();
                }
                UiSessionGeneral.super.handleEvent();
            }
        }

        public ISession getSession() {
            return this.session;
        }

        public void setSession(ISession session) {
            this.session = session;
        }
    }
}

