/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ejbjar.dd.IAssemblyDescriptor;
import com.tssap.j2ee.model.ejbjar.dd.ISecurityIdentity;
import com.tssap.j2ee.ui.SecurityRolesDialog;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.SecurityIdentityRoleRefWrapper;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

public class UiSecurityIdentity
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiSecurityIdentity == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiSecurityIdentity = UiSecurityIdentity.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects.UiSecurityIdentity")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiSecurityIdentity));
    private IModifiedCallback myModifyCallback;
    private Text descriptionTextPane;
    private Text runAsDescriptionTextPane;
    private Text runAsRoleNameTextField;
    private Button addRoleNameButton;
    private Button removeRoleNameButton;
    private Button useCallerIdRadioButton;
    private Button runAsRadioButton;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiSecurityIdentity;

    public void initContainer(IGridLayoutPane userArea) {
        ISecurityIdentity securityIdentity = (ISecurityIdentity)this.getData();
        IGridLayoutPane gridPane = userArea.addGridLayoutPane(this.getUserGridNumOfColumns(), userArea.createGridLayoutData(4, 4, true, true));
        IGridLayoutPane gridPane1 = userArea.addGridLayoutPane(this.getUserGridNumOfColumns(), userArea.createGridLayoutData(4, 4, true, true));
        gridPane1.addTextLabel("Description");
        this.descriptionTextPane = gridPane1.addTextPane("", false, true, gridPane.createGridLayoutData(4, 4, true, true, 5, 1));
        this.setDescriptionTextPane(this.descriptionTextPane);
        gridPane1.addPlaceholder(5, 1);
        Button useCallerIdRadioButton = gridPane.addRadioButton("Use caller identity", gridPane.createGridLayoutData(4, 4, true, false, 5, 1));
        this.setUseCallerIdRadioButton(useCallerIdRadioButton);
        Button runAsRadioButton = gridPane.addRadioButton("run-as", gridPane.createGridLayoutData(4, 4, true, false, 5, 1));
        this.setRunAsRadioButton(runAsRadioButton);
        gridPane.addTextLabel("Role name");
        this.runAsRoleNameTextField = gridPane.addTextField("", true, gridPane.createGridLayoutData(4, 4, true, false, 2, 1));
        this.setRunAsRoleNameTextField(this.runAsRoleNameTextField);
        this.addRoleNameButton = gridPane.addPushButton("Add", gridPane.createGridLayoutData(1, 4, false, false, 1, 1));
        this.removeRoleNameButton = gridPane.addPushButton("Remove", gridPane.createGridLayoutData(1, 4, false, false, 1, 1));
        this.setAddRoleNameButton(this.addRoleNameButton);
        this.setRemoveRoleNameButton(this.removeRoleNameButton);
        gridPane.addTextLabel("Description");
        this.runAsDescriptionTextPane = gridPane.addTextPane("", false, false, gridPane.createGridLayoutData(4, 4, true, true, 5, 1));
        this.setRunAsDescriptionTextPane(this.runAsDescriptionTextPane);
        this.decorateControls();
    }

    private void decorateControls() {
        this.getDescriptionTextPane().addModifyListener((ModifyListener)new DescriptionModifyAdapter());
        this.getUseCallerIdRadioButton().addSelectionListener((SelectionListener)new SelectionAdapter());
        this.getRunAsRadioButton().addSelectionListener((SelectionListener)new SelectionAdapter());
        this.getRunAsDescriptionTextPane().addModifyListener(this.getModifyAdapterSingleton());
        this.getRunAsRoleNameTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getAddRoleNameButton().addSelectionListener((SelectionListener)new AddButtonListener());
        this.getRemoveRoleNameButton().addSelectionListener((SelectionListener)new RemoveButtonListener());
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    private Text getRunAsDescriptionTextPane() {
        return this.runAsDescriptionTextPane;
    }

    private Text getRunAsRoleNameTextField() {
        return this.runAsRoleNameTextField;
    }

    private void setRunAsDescriptionTextPane(Text runAsDescriptionTextPane) {
        this.runAsDescriptionTextPane = runAsDescriptionTextPane;
    }

    private void setRunAsRoleNameTextField(Text runAsRoleNameTextField) {
        this.runAsRoleNameTextField = runAsRoleNameTextField;
    }

    private Button getRunAsRadioButton() {
        return this.runAsRadioButton;
    }

    private Button getUseCallerIdRadioButton() {
        return this.useCallerIdRadioButton;
    }

    private void setRunAsRadioButton(Button runAsRadioButton) {
        this.runAsRadioButton = runAsRadioButton;
    }

    private void setUseCallerIdRadioButton(Button useCallerIdRadioButton) {
        this.useCallerIdRadioButton = useCallerIdRadioButton;
    }

    public int getUserGridNumOfColumns() {
        return 5;
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof SecurityIdentityRoleRefWrapper)) {
            ret = "No object of SecurityIdentityRoleRefWrapper found!";
        }
        return ret;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        ISecurityIdentity securityIdentity = this.getSecurityIdentity();
        if (securityIdentity != null) {
            this.refreshDescriptionFromUI();
            if (this.getUseCallerIdRadioButton().getSelection()) {
                this.getSecurityIdentity().removeRunAs();
                this.getRunAsRoleNameTextField().setText("");
                if (securityIdentity.getUseCallerIdentity() == null) {
                    try {
                        securityIdentity.createUseCallerIdentity(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<use-caller-identity> could not be created.", e);
                    }
                }
            } else {
                if (securityIdentity.getUseCallerIdentity() != null) {
                    securityIdentity.removeUseCallerIdentity();
                }
                if (securityIdentity.getRunAs() == null) {
                    try {
                        securityIdentity.createRunAs(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<run-as> could not be created.", e);
                    }
                }
                if (this.getRunAsRoleNameTextField() != null && !this.getRunAsRoleNameTextField().getText().trim().equals("")) {
                    if (securityIdentity.getRunAs().getRoleName() == null) {
                        try {
                            securityIdentity.getRunAs().createRoleName(null);
                        }
                        catch (J2eeCreateException e) {
                            this.handleJ2eeCreateException("<role-name> could not be created.", e);
                        }
                    }
                    securityIdentity.getRunAs().getRoleName().setValue(this.getRunAsRoleNameTextField().getText().trim());
                } else if (securityIdentity.getRunAs().getRoleName() != null) {
                    securityIdentity.getRunAs().getRoleName().setValue("");
                }
                if (!this.getRunAsDescriptionTextPane().getText().trim().equals("")) {
                    if (securityIdentity.getRunAs().getDescription() == null) {
                        try {
                            securityIdentity.getRunAs().createDescription(null);
                        }
                        catch (J2eeCreateException e) {
                            this.handleJ2eeCreateException("<description> belonging to <run-as> could not be created.", e);
                        }
                    }
                    securityIdentity.getRunAs().getDescription().setValue(this.getRunAsDescriptionTextPane().getText().trim());
                } else if (securityIdentity.getRunAs().getDescription() != null) {
                    securityIdentity.getRunAs().removeDescription();
                }
            }
        }
    }

    private void refreshDescriptionFromUI() {
        ISecurityIdentity securityIdentity = this.getSecurityIdentity();
        if (securityIdentity != null) {
            if (!this.getDescriptionTextPane().getText().trim().equals("")) {
                if (securityIdentity.getDescription() == null) {
                    try {
                        securityIdentity.createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<description> could not be created.", e);
                    }
                }
                securityIdentity.getDescription().setValue(this.getDescriptionTextPane().getText().trim());
            } else if (securityIdentity.getDescription() != null) {
                securityIdentity.getDescription().setValue("");
            }
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        ISecurityIdentity securityIdentity = this.getSecurityIdentity();
        if (securityIdentity != null && securityIdentity instanceof ISecurityIdentity) {
            this.getDescriptionTextPane().setText(securityIdentity.getDescription() != null ? securityIdentity.getDescription().getValue() : "");
            this.getUseCallerIdRadioButton().setSelection(securityIdentity.getUseCallerIdentity() != null);
            this.getRunAsRadioButton().setSelection(securityIdentity.getRunAs() != null);
            if (this.getRunAsRadioButton().getSelection()) {
                this.getRunAsDescriptionTextPane().setEnabled(true);
                this.getRunAsDescriptionTextPane().setText(securityIdentity.getRunAs().getDescription() != null ? securityIdentity.getRunAs().getDescription().getValue() : "");
                this.getAddRoleNameButton().setEnabled(true);
                this.getRemoveRoleNameButton().setEnabled(true);
                this.getRunAsRoleNameTextField().setText(securityIdentity.getRunAs().getRoleName() != null ? securityIdentity.getRunAs().getRoleName().getValue() : "");
            } else {
                this.getRunAsDescriptionTextPane().setEnabled(false);
                this.getRunAsRoleNameTextField().setEnabled(false);
                this.getAddRoleNameButton().setEnabled(false);
                this.getRemoveRoleNameButton().setEnabled(false);
            }
        } else {
            throw new IllegalArgumentException("No object of ISecurityIdentity found!");
        }
        this.stopRefreshingUI();
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.getRunAsRoleNameTextField() != null) {
            this.getRunAsRoleNameTextField().setEditable(false);
        }
    }

    protected ISecurityIdentity getSecurityIdentity() {
        TreeNode securityIdentityRoleRefTreeNode;
        ISecurityIdentity ret = null;
        SecurityIdentityRoleRefWrapper securityIdentityRoleRefWrapper = this.getSecurityIdentityRoleRefWrapper();
        if (securityIdentityRoleRefWrapper != null && (securityIdentityRoleRefTreeNode = securityIdentityRoleRefWrapper.getSecurityRoleRefTreeNode()) != null) {
            ret = (ISecurityIdentity)securityIdentityRoleRefTreeNode.getIdentifiable();
        }
        return ret;
    }

    public void setModifyCallback(IModifiedCallback callback) {
    }

    protected void handleEvent() {
        if (!this.isRefreshingUI()) {
            if (this.getSecurityIdentity() != null) {
                if (this.getRunAsRadioButton().getSelection()) {
                    this.getSecurityIdentity().removeUseCallerIdentity();
                    this.addRoleNameButton.setEnabled(true);
                    this.removeRoleNameButton.setEnabled(true);
                    this.getRunAsDescriptionTextPane().setEnabled(true);
                    this.getRunAsRoleNameTextField().setEnabled(true);
                } else {
                    this.getRunAsDescriptionTextPane().setEnabled(false);
                    this.getRunAsRoleNameTextField().setEnabled(false);
                    this.addRoleNameButton.setEnabled(false);
                    this.removeRoleNameButton.setEnabled(false);
                    this.getSecurityIdentity().removeRunAs();
                }
            }
            super.handleEvent();
        }
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected void handleDescriptionEvent() {
        if (!this.isRefreshingUI()) {
            this.refreshDescriptionFromUI();
            super.handleEvent();
        }
    }

    private Button getAddRoleNameButton() {
        return this.addRoleNameButton;
    }

    private void setAddRoleNameButton(Button addRoleNameButton) {
        this.addRoleNameButton = addRoleNameButton;
    }

    private Button getRemoveRoleNameButton() {
        return this.removeRoleNameButton;
    }

    private void setRemoveRoleNameButton(Button removeRoleNameButton) {
        this.removeRoleNameButton = removeRoleNameButton;
    }

    private IAssemblyDescriptor getAssemblyDescriptor() {
        IAssemblyDescriptor assemblyDescriptor = null;
        SecurityIdentityRoleRefWrapper securityIdentityRoleRefWrapper = this.getSecurityIdentityRoleRefWrapper();
        if (securityIdentityRoleRefWrapper != null) {
            assemblyDescriptor = securityIdentityRoleRefWrapper.getAssemblyDescriptor();
        }
        return assemblyDescriptor;
    }

    private SecurityIdentityRoleRefWrapper getSecurityIdentityRoleRefWrapper() {
        SecurityIdentityRoleRefWrapper securityIdentityRoleRefWrapper = null;
        if (this.getData() instanceof SecurityIdentityRoleRefWrapper) {
            securityIdentityRoleRefWrapper = (SecurityIdentityRoleRefWrapper)this.getData();
        }
        return securityIdentityRoleRefWrapper;
    }

    public String okToLeave() {
        String retMsg = super.okToLeave();
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            retMsg = status.getMessage();
        }
        return retMsg;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        if (this.getRunAsRadioButton().getSelection() && this.getRunAsRoleNameTextField().getText().equals("")) {
            status.setError("Please add role name or change to use-caller-identity.");
        }
        return status;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RemoveButtonListener
    extends SelectionAdapter {
        private RemoveButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            UiSecurityIdentity.this.getRunAsRoleNameTextField().setText("");
        }
    }

    private class AddButtonListener
    extends SelectionAdapter {
        private AddButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            SecurityRolesDialog securityRolesDialog = new SecurityRolesDialog(UiSecurityIdentity.this.getAssemblyDescriptor());
            Object[] resultSelections = securityRolesDialog.getRoleNamesFromSelectionDialog(true);
            if (resultSelections != null && UiSecurityIdentity.this.getSecurityIdentity() != null) {
                int i = 0;
                while (i < resultSelections.length) {
                    UiSecurityIdentity.this.getRunAsRoleNameTextField().setText(resultSelections[i].toString());
                    ++i;
                }
            }
        }
    }

    private class DescriptionModifyAdapter
    implements ModifyListener {
        private DescriptionModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UiSecurityIdentity.this.handleDescriptionEvent();
        }
    }

    private class SelectionAdapter
    implements SelectionListener {
        private SelectionAdapter() {
        }

        public void widgetDefaultSelected(SelectionEvent evt) {
            UiSecurityIdentity.this.handleEvent();
        }

        public void widgetSelected(SelectionEvent evt) {
            this.widgetDefaultSelected(evt);
        }
    }
}

