/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.ejbjar.dd.IEnterpriseBean;
import com.tssap.j2ee.model.ejbjar.dd.IResAuth;
import com.tssap.j2ee.model.ejbjar.dd.IResSharingScope;
import com.tssap.j2ee.model.ejbjar.dd.IResourceRef;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.EnterpriseBeansContentProvider;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class UiResourceRef
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiResourceRef == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiResourceRef = UiResourceRef.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects.UiResourceRef")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiResourceRef));
    private static final String TEXT_RESOURCE_TYPE = "Resource Type (fully qualified name)";
    private static final String[] RES_TYPES = new String[]{"javax.sql.DataSource", "javax.jms.QueueConnectionFactory", "javax.jms.TopicConnectionFactory", "javax.resource.cci.ConnectionFactory", "javax.mail.Session", "java.net.URL"};
    private static final int CONTAINER = 0;
    private static final int APPLICATION = 1;
    private static final int SHAREABLE = 0;
    private static final int UNSHAREABLE = 1;
    private static final String TEXT_CONTAINER = "Container";
    private static final String TEXT_APPLICATION = "Application";
    private Text descriptionTextPane;
    private Text resRefNameTextField;
    private Combo resTypeCombo;
    private Button[] resAuthRadioButtons = new Button[2];
    private Button resSharingScopeCheckbox;
    private Button[] resSharingScopeRadioButtons = new Button[2];
    private boolean isDuplicateResRefName = false;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiResourceRef;

    public UiResourceRef(IModifiedCallback myModifiedCallback) {
        this.setModifiedCallback(myModifiedCallback);
    }

    public void initContainer(IGridLayoutPane userArea) {
        userArea.addTextLabel("Resource Reference Name");
        this.resRefNameTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setResRefNameTextField(this.resRefNameTextField);
        userArea.addTextLabel(TEXT_RESOURCE_TYPE);
        this.resTypeCombo = userArea.addComboBox(RES_TYPES, "", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setResTypeCombo(this.resTypeCombo);
        userArea.addPlaceholder(2, 1);
        userArea.addTextLabel("Resource Authentication", userArea.createGridLayoutData(4, 4, 2, 1));
        this.resAuthRadioButtons[0] = userArea.addRadioButton(TEXT_CONTAINER);
        this.resAuthRadioButtons[1] = userArea.addRadioButton(TEXT_APPLICATION);
        this.setResAuthRadioButtons(this.resAuthRadioButtons);
        userArea.addPlaceholder(2, 1);
        this.resSharingScopeCheckbox = userArea.addCheckBox("Resource Sharing Scope", true, userArea.createGridLayoutData(4, 4, 2, 1));
        this.setResSharingScopeCheckbox(this.resSharingScopeCheckbox);
        this.resSharingScopeRadioButtons[0] = userArea.addRadioButton("Shareable");
        this.resSharingScopeRadioButtons[1] = userArea.addRadioButton("Unshareable");
        this.setResSharingScopeRadioButtons(this.resSharingScopeRadioButtons);
        userArea.addPlaceholder(2, 1);
        userArea.addTextLabel("Description");
        this.descriptionTextPane = userArea.addTextPane("", false, true, userArea.createGridLayoutData(4, 4, true, true, 1, 1));
        this.setDescriptionTextPane(this.descriptionTextPane);
        this.decorateControls();
    }

    private void decorateControls() {
        SelectionListener resAuthSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UiResourceRef.this.resAuthRadioSelectionChanged(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        SelectionListener resSharingScopeSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UiResourceRef.this.resSharingScopeRadioSelectionChanged(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.getResRefNameTextField().addModifyListener((ModifyListener)new ResourceRefNameModifyAdapter());
        this.getDescriptionTextPane().addModifyListener(this.getModifyAdapterSingleton());
        this.getResTypeCombo().addModifyListener((ModifyListener)new ResourceTypeModifyAdapter());
        this.getResAuthRadioButtons()[0].addSelectionListener(resAuthSelectionListener);
        this.getResAuthRadioButtons()[1].addSelectionListener(resAuthSelectionListener);
        this.getResSharingScopeCheckbox().addSelectionListener(resSharingScopeSelectionListener);
        this.getResSharingScopeRadioButtons()[0].addSelectionListener(resSharingScopeSelectionListener);
        this.getResSharingScopeRadioButtons()[1].addSelectionListener(resSharingScopeSelectionListener);
    }

    private void resAuthRadioSelectionChanged(SelectionEvent e) {
        if (this.getResAuthRadioButtons() != null) {
            Button[] resAuthRadioButtons = this.getResAuthRadioButtons();
            if (e.getSource() == resAuthRadioButtons[0]) {
                resAuthRadioButtons[0].setSelection(true);
                resAuthRadioButtons[1].setSelection(false);
            } else if (e.getSource() == resAuthRadioButtons[1]) {
                resAuthRadioButtons[0].setSelection(false);
                resAuthRadioButtons[1].setSelection(true);
            }
        }
        if (!this.isRefreshingUI()) {
            this.handleEvent();
        }
    }

    private void resSharingScopeRadioSelectionChanged(SelectionEvent e) {
        if (this.getResSharingScopeCheckbox() != null && this.getResSharingScopeRadioButtons() != null) {
            Button[] resSharingScopeRadioButtons = this.getResSharingScopeRadioButtons();
            resSharingScopeRadioButtons[0].setEnabled(this.getResSharingScopeCheckbox().getSelection());
            resSharingScopeRadioButtons[1].setEnabled(this.getResSharingScopeCheckbox().getSelection());
            if (!this.getResSharingScopeCheckbox().getSelection()) {
                resSharingScopeRadioButtons[0].setSelection(false);
                resSharingScopeRadioButtons[1].setSelection(false);
            } else {
                resSharingScopeRadioButtons[0].setSelection(true);
                if (e.getSource() == resSharingScopeRadioButtons[0]) {
                    resSharingScopeRadioButtons[0].setSelection(true);
                    resSharingScopeRadioButtons[1].setSelection(false);
                } else if (e.getSource() == resSharingScopeRadioButtons[1]) {
                    resSharingScopeRadioButtons[0].setSelection(false);
                    resSharingScopeRadioButtons[1].setSelection(true);
                }
            }
        }
        if (!this.isRefreshingUI()) {
            this.handleEvent();
        }
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof TreeNode)) {
            ret = "No object of TreeNode found!";
        }
        return ret;
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    private Button[] getResAuthRadioButtons() {
        return this.resAuthRadioButtons;
    }

    private Text getResRefNameTextField() {
        return this.resRefNameTextField;
    }

    private Button getResSharingScopeCheckbox() {
        return this.resSharingScopeCheckbox;
    }

    private Button[] getResSharingScopeRadioButtons() {
        return this.resSharingScopeRadioButtons;
    }

    private Combo getResTypeCombo() {
        return this.resTypeCombo;
    }

    private void setResTypeCombo(Combo resTypeCombo) {
        this.resTypeCombo = resTypeCombo;
    }

    private void setResAuthRadioButtons(Button[] resAuthRadioButtons) {
        this.resAuthRadioButtons = resAuthRadioButtons;
    }

    private void setResSharingScopeCheckbox(Button resSharingScopeCheckbox) {
        this.resSharingScopeCheckbox = resSharingScopeCheckbox;
    }

    private void setResSharingScopeRadioButtons(Button[] resSharingScopeRadioButtons) {
        this.resSharingScopeRadioButtons = resSharingScopeRadioButtons;
    }

    private void setResRefNameTextField(Text resRefNameTextField) {
        this.resRefNameTextField = resRefNameTextField;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        IResourceRef resourceRef = this.getResourceRef();
        IResAuth resAuth = null;
        IResSharingScope resSharingScope = null;
        if (resourceRef != null) {
            if (this.getDescriptionTextPane() != null && !this.getDescriptionTextPane().getText().trim().equals("")) {
                if (resourceRef.getDescription() == null) {
                    try {
                        resourceRef.createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<description> could not be created.", e);
                    }
                }
                resourceRef.getDescription().setValue(this.getDescriptionTextPane().getText().trim());
            } else if (resourceRef.getDescription() != null) {
                resourceRef.removeDescription();
            }
            this.refreshResourceRefNameFromUI();
            String resTypeString = null;
            if (resourceRef.getResType() == null) {
                try {
                    resourceRef.createResType(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<res-type> could not be created.", e);
                }
            }
            if (!this.getResTypeCombo().getText().equals("")) {
                resTypeString = this.getResTypeCombo().getText();
                resourceRef.getResType().setValue(resTypeString);
            }
            if (this.getResAuthRadioButtons() != null) {
                if ((this.getResAuthRadioButtons()[0].getSelection() || this.getResAuthRadioButtons()[1].getSelection()) && (resAuth = resourceRef.getResAuth()) == null) {
                    try {
                        resAuth = resourceRef.createResAuth(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<res-auth> tag could not be created.", e);
                    }
                }
                if (this.getResAuthRadioButtons()[0].getSelection()) {
                    resAuth.setValue(TEXT_CONTAINER);
                } else if (this.getResAuthRadioButtons()[1].getSelection()) {
                    resAuth.setValue(TEXT_APPLICATION);
                }
            }
            if (this.getResSharingScopeCheckbox() != null && this.getResSharingScopeCheckbox().getSelection()) {
                if (this.getResSharingScopeRadioButtons() != null) {
                    if ((this.getResSharingScopeRadioButtons()[0].getSelection() || this.getResSharingScopeRadioButtons()[1].getSelection()) && (resSharingScope = resourceRef.getResSharingScope()) == null) {
                        try {
                            resSharingScope = resourceRef.createResSharingScope(null);
                        }
                        catch (J2eeCreateException e) {
                            this.handleJ2eeCreateException("<res-sharing-scope> tag could not be created.", e);
                        }
                    }
                    if (this.getResSharingScopeRadioButtons()[0].getSelection()) {
                        resSharingScope.setValue("Shareable");
                    } else if (this.getResSharingScopeRadioButtons()[1].getSelection()) {
                        resSharingScope.setValue("Unshareable");
                    }
                }
            } else if (resourceRef.getResSharingScope() != null) {
                resourceRef.removeResSharingScope();
            }
        }
    }

    private void refreshResourceRefNameFromUI() {
        IResourceRef resourceRef = this.getResourceRef();
        if (resourceRef != null) {
            if (!this.getResRefNameTextField().getText().trim().equals("")) {
                if (resourceRef.getResRefName() == null) {
                    try {
                        resourceRef.createResRefName(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<res-ref-name> could not be created.", e);
                    }
                }
                resourceRef.getResRefName().setValue(this.getResRefNameTextField().getText().trim());
            } else if (resourceRef.getResRefName() != null) {
                resourceRef.getResRefName().setValue("");
            } else {
                try {
                    resourceRef.createResRefName(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<res-ref-name> could not be created.", e);
                }
            }
            IEnterpriseBean iejb = this.getEnterpriseBean();
            if (iejb != null && iejb.getResourceEnvRefs() != null) {
                IResourceRef[] resRefsArr = iejb.getResourceRefs();
                int resEnvRefsDuplicateCounter = 0;
                int i = 0;
                while (i < resRefsArr.length) {
                    if (resRefsArr[i].getResRefName().getValue().equals(this.getResRefNameTextField().getText())) {
                        ++resEnvRefsDuplicateCounter;
                    }
                    if (resEnvRefsDuplicateCounter > 1) {
                        this.setDuplicateResRefName(true);
                    } else {
                        this.setDuplicateResRefName(false);
                    }
                    ++i;
                }
            }
        }
    }

    private IEnterpriseBean getEnterpriseBean() {
        TreeNode tn;
        if (this.getData() instanceof TreeNode && (tn = (TreeNode)this.getData()).getFolder() instanceof EnterpriseBeansContentProvider.ResourceRefFolder) {
            return ((EnterpriseBeansContentProvider.ResourceRefFolder)tn.getFolder()).getEnterpriseBean();
        }
        return null;
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        IResourceRef resourceRef = this.getResourceRef();
        if (resourceRef != null) {
            this.getDescriptionTextPane().setText(resourceRef.getDescription() != null ? resourceRef.getDescription().getValue() : "");
            if (this.getResRefNameTextField() != null) {
                String resourceRefName = resourceRef.getResRefName() != null ? resourceRef.getResRefName().getValue() : "";
                this.getResRefNameTextField().setText(resourceRefName);
            }
            this.getResTypeCombo().setText(resourceRef.getResType() != null && !resourceRef.getResType().getValue().equals("") ? resourceRef.getResType().getValue() : RES_TYPES[0]);
            if (this.getResAuthRadioButtons() != null) {
                if (resourceRef.getResAuth() != null) {
                    IResAuth resAuth = resourceRef.getResAuth();
                    if (resAuth.getValue() != null && resAuth.getValue().equals(TEXT_CONTAINER)) {
                        this.getResAuthRadioButtons()[0].setSelection(true);
                        this.getResAuthRadioButtons()[1].setSelection(false);
                    } else {
                        this.getResAuthRadioButtons()[1].setSelection(true);
                        this.getResAuthRadioButtons()[0].setSelection(false);
                    }
                } else {
                    try {
                        resourceRef.createResAuth(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<res-auth> could not be created.", e);
                    }
                    resourceRef.getResAuth().setValue(TEXT_CONTAINER);
                    this.getResAuthRadioButtons()[0].setSelection(true);
                    this.getResAuthRadioButtons()[1].setSelection(false);
                }
            }
            if (this.getResSharingScopeCheckbox() != null && this.getResSharingScopeRadioButtons() != null) {
                if (resourceRef.getResSharingScope() != null && resourceRef.getResSharingScope().getValue() != null) {
                    String resSharingScopeValue = resourceRef.getResSharingScope().getValue();
                    this.getResSharingScopeCheckbox().setSelection(true);
                    this.getResSharingScopeRadioButtons()[0].setEnabled(this.isEditable());
                    this.getResSharingScopeRadioButtons()[1].setEnabled(this.isEditable());
                    if (resSharingScopeValue.equals("Shareable")) {
                        this.getResSharingScopeRadioButtons()[0].setSelection(true);
                        this.getResSharingScopeRadioButtons()[1].setSelection(false);
                    } else if (resSharingScopeValue.equals("Unshareable")) {
                        this.getResSharingScopeRadioButtons()[1].setSelection(true);
                        this.getResSharingScopeRadioButtons()[0].setSelection(false);
                    } else if (this.getResSharingScopeCheckbox().getSelection()) {
                        this.getResSharingScopeCheckbox().setSelection(false);
                        this.getResSharingScopeRadioButtons()[0].setEnabled(false);
                        this.getResSharingScopeRadioButtons()[1].setEnabled(false);
                    }
                } else {
                    this.getResSharingScopeCheckbox().setSelection(false);
                    this.getResSharingScopeRadioButtons()[0].setEnabled(false);
                    this.getResSharingScopeRadioButtons()[1].setEnabled(false);
                }
            }
        } else {
            throw new IllegalArgumentException("No object of IResourceRef found!");
        }
        this.stopRefreshingUI();
    }

    protected void updateEditableBehavior() {
        int i;
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.getDescriptionTextPane() != null) {
            this.getDescriptionTextPane().setEditable(editable);
        }
        if (this.getResRefNameTextField() != null) {
            this.getResRefNameTextField().setEditable(editable);
        }
        if (this.getResTypeCombo() != null) {
            this.getResTypeCombo().setEnabled(editable);
        }
        if (this.getResSharingScopeCheckbox() != null) {
            this.getResSharingScopeCheckbox().setEnabled(editable);
        }
        if (this.resAuthRadioButtons != null) {
            i = 0;
            while (i < this.resAuthRadioButtons.length) {
                if (this.resAuthRadioButtons[i] != null) {
                    this.resAuthRadioButtons[i].setEnabled(editable);
                }
                ++i;
            }
        }
        if (this.resSharingScopeRadioButtons != null) {
            i = 0;
            while (i < this.resSharingScopeRadioButtons.length) {
                if (this.resSharingScopeRadioButtons[i] != null) {
                    this.resSharingScopeRadioButtons[i].setEnabled(editable && this.resSharingScopeCheckbox.getSelection());
                }
                ++i;
            }
        }
    }

    protected IResourceRef getResourceRef() {
        IIdentifiable identifiable;
        IResourceRef ret = null;
        if (this.getData() instanceof TreeNode && (identifiable = ((TreeNode)this.getData()).getIdentifiable()) instanceof IResourceRef) {
            ret = (IResourceRef)identifiable;
        }
        return ret;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected void handleResourceRefNameEvent() {
        if (!this.isRefreshingUI()) {
            this.refreshResourceRefNameFromUI();
            super.handleEvent();
        }
    }

    public String okToLeave() {
        String message = null;
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        if (this.getResRefNameTextField().getText().equals("")) {
            status.setError("Please enter res-ref-name.");
        } else if (this.getResTypeCombo().getText().equals("")) {
            status.setError("Please select a resource type!");
        } else if (this.isDuplicateResRefName()) {
            status.setError("Duplicate name. Please choose another resource environment reference name.");
        }
        return status;
    }

    private boolean isDuplicateResRefName() {
        return this.isDuplicateResRefName;
    }

    private void setDuplicateResRefName(boolean b) {
        this.isDuplicateResRefName = b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ResourceTypeModifyAdapter
    implements ModifyListener {
        private ResourceTypeModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (!UiResourceRef.super.isRefreshingUI()) {
                StringBuffer temporaryResourceName = new StringBuffer(UiResourceRef.this.getResRefNameTextField().getText());
                if (UiResourceRef.this.getResTypeCombo().getText().equals("javax.jms.QueueConnectionFactory") || UiResourceRef.this.getResTypeCombo().getText().equals("javax.jms.TopicConnectionFactory")) {
                    if (UiResourceRef.this.getResRefNameTextField().getText().indexOf("/") == -1) {
                        temporaryResourceName.insert(0, "jms/");
                    }
                } else if (UiResourceRef.this.getResTypeCombo().getText().equals("javax.mail.Session")) {
                    if (UiResourceRef.this.getResRefNameTextField().getText().indexOf("/") == -1) {
                        temporaryResourceName.insert(0, "mail/");
                    }
                } else if (UiResourceRef.this.getResTypeCombo().getText().equals("java.net.URL")) {
                    if (UiResourceRef.this.getResRefNameTextField().getText().indexOf("/") == -1) {
                        temporaryResourceName.insert(0, "url/");
                    }
                } else if (UiResourceRef.this.getResTypeCombo().getText().equals("javax.sql.DataSource")) {
                    if (UiResourceRef.this.getResRefNameTextField().getText().indexOf("/") == -1) {
                        temporaryResourceName.insert(0, "jdbc/");
                    }
                } else if (UiResourceRef.this.getResTypeCombo().getText().equals("javax.resource.cci.ConnectionFactory") && UiResourceRef.this.getResRefNameTextField().getText().indexOf("/") == -1) {
                    temporaryResourceName.insert(0, "eis/");
                }
                UiResourceRef.this.getResRefNameTextField().setText(temporaryResourceName.toString());
                UiResourceRef.super.handleEvent();
            }
        }
    }

    private class ResourceRefNameModifyAdapter
    implements ModifyListener {
        private ResourceRefNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UiResourceRef.this.handleResourceRefNameEvent();
        }
    }
}

