/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.ejbjar.dd.IEnterpriseBean;
import com.tssap.j2ee.model.ejbjar.dd.IResourceEnvRef;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.EnterpriseBeansContentProvider;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class UiResourceEnvRef
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiResourceRef == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiResourceRef = UiResourceEnvRef.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects.UiResourceRef")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiResourceRef));
    private static final String TEXT_RESOURCE_ENV_REF_NAME = "Resource Environment Reference Name";
    private static final String TEXT_RESOURCE_ENV_REF_TYPE = "Resource Environment Reference Type (fully qualified name)";
    private static final String[] RES_ENV_TYPES = new String[]{"javax.jms.Queue", "javax.jms.Topic"};
    private Text descriptionTextPane;
    private Text resEnvRefNameTextField;
    private Combo resEnvRefTypeCombo;
    private boolean isDuplicateResEnvRefName = false;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiResourceRef;

    public UiResourceEnvRef(IModifiedCallback ejbJarEnterpriseBeansPage) {
        this.setModifiedCallback(ejbJarEnterpriseBeansPage);
    }

    public void initContainer(IGridLayoutPane userArea) {
        userArea.addTextLabel("Description");
        this.descriptionTextPane = userArea.addTextPane("", false, true, userArea.createGridLayoutData(4, 4, true, true, 1, 1));
        this.setDescriptionTextPane(this.descriptionTextPane);
        userArea.addTextLabel(TEXT_RESOURCE_ENV_REF_NAME);
        this.resEnvRefNameTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setResEnvRefNameTextField(this.resEnvRefNameTextField);
        userArea.addTextLabel(TEXT_RESOURCE_ENV_REF_TYPE);
        this.resEnvRefTypeCombo = userArea.addComboBox(RES_ENV_TYPES, "", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setResEnvRefTypeCombo(this.resEnvRefTypeCombo);
        this.decorateControls();
    }

    private void decorateControls() {
        this.getDescriptionTextPane().addModifyListener(this.getModifyAdapterSingleton());
        this.getResEnvRefNameTextField().addModifyListener((ModifyListener)new ResEnvRefNameModAdapt());
        this.getResEnvRefTypeCombo().addModifyListener((ModifyListener)new ResEnvTypeModAdapt());
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    private Text getResEnvRefNameTextField() {
        return this.resEnvRefNameTextField;
    }

    private void setResEnvRefNameTextField(Text resEnvRefNameTextField) {
        this.resEnvRefNameTextField = resEnvRefNameTextField;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        IResourceEnvRef resourceEnvRef = this.getResourceEnvRef();
        if (resourceEnvRef != null) {
            if (!this.getDescriptionTextPane().getText().trim().equals("")) {
                if (resourceEnvRef.getDescription() == null) {
                    try {
                        resourceEnvRef.createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<description> could not be created.", e);
                    }
                }
                resourceEnvRef.getDescription().setValue(this.getDescriptionTextPane().getText().trim());
            }
            this.refreshResourceEnvRefNameFromUI();
            String resEnvRefTypeString = null;
            if (resourceEnvRef.getResourceEnvRefType() == null) {
                try {
                    resourceEnvRef.createResourceEnvRefType(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<resource-env-ref-type> could not be created.", e);
                }
            }
            if (!this.getResEnvRefTypeCombo().getText().equals("")) {
                resEnvRefTypeString = this.getResEnvRefTypeCombo().getText();
                resourceEnvRef.getResourceEnvRefType().setValue(resEnvRefTypeString);
            }
        }
    }

    private void refreshResourceEnvRefNameFromUI() {
        IResourceEnvRef resourceEnvRef = this.getResourceEnvRef();
        if (resourceEnvRef != null) {
            if (!this.getResEnvRefNameTextField().getText().trim().equals("")) {
                if (resourceEnvRef.getResourceEnvRefName() == null) {
                    try {
                        resourceEnvRef.createResourceEnvRefName(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<resource-env-ref-name> could not be created.", e);
                    }
                }
                resourceEnvRef.getResourceEnvRefName().setValue(this.getResEnvRefNameTextField().getText().trim());
            } else if (resourceEnvRef.getResourceEnvRefName() != null) {
                resourceEnvRef.getResourceEnvRefName().setValue("");
            } else {
                try {
                    resourceEnvRef.createResourceEnvRefName(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<resource-env-ref-name> could not be created.", e);
                }
            }
            IEnterpriseBean iejb = this.getEnterpriseBean();
            if (iejb != null && iejb.getResourceEnvRefs() != null) {
                IResourceEnvRef[] resEnvRefsArr = iejb.getResourceEnvRefs();
                int resEnvRefsDuplicateCounter = 0;
                int i = 0;
                while (i < resEnvRefsArr.length) {
                    if (resEnvRefsArr[i].getResourceEnvRefName().getValue().equals(this.getResEnvRefNameTextField().getText())) {
                        ++resEnvRefsDuplicateCounter;
                    }
                    if (resEnvRefsDuplicateCounter > 1) {
                        this.setDuplicateResEnvRefName(true);
                    } else {
                        this.setDuplicateResEnvRefName(false);
                    }
                    ++i;
                }
            }
        }
    }

    private IEnterpriseBean getEnterpriseBean() {
        TreeNode tn;
        if (this.getData() instanceof TreeNode && (tn = (TreeNode)this.getData()).getFolder() instanceof EnterpriseBeansContentProvider.ResourceEnvRefFolder) {
            return ((EnterpriseBeansContentProvider.ResourceEnvRefFolder)tn.getFolder()).getEnterpriseBean();
        }
        return null;
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        IResourceEnvRef resourceEnvRef = this.getResourceEnvRef();
        if (resourceEnvRef != null) {
            this.getDescriptionTextPane().setText(resourceEnvRef.getDescription() != null ? resourceEnvRef.getDescription().getValue() : "");
            this.getResEnvRefTypeCombo().setText(resourceEnvRef.getResourceEnvRefType() != null && !resourceEnvRef.getResourceEnvRefType().getValue().equals("") ? resourceEnvRef.getResourceEnvRefType().getValue() : RES_ENV_TYPES[0]);
            if (this.getResEnvRefNameTextField() != null) {
                String resourceEnvRefName;
                String string = resourceEnvRefName = resourceEnvRef.getResourceEnvRefName() != null ? resourceEnvRef.getResourceEnvRefName().getValue() : "";
                if (resourceEnvRefName.length() <= 0 || resourceEnvRef.getResourceEnvRefType() != null) {
                    // empty if block
                }
                this.getResEnvRefNameTextField().setText(resourceEnvRefName);
            }
        } else {
            throw new IllegalArgumentException("No object of IResourceEnvRef found!");
        }
        this.stopRefreshingUI();
    }

    protected void updateEditableBehavior() {
        if (this.getResEnvRefNameTextField() != null) {
            this.getResEnvRefNameTextField().setEditable(this.isEditable());
        }
        if (this.getDescriptionTextPane() != null) {
            this.getDescriptionTextPane().setEditable(this.isEditable());
        }
        if (this.getResEnvRefTypeCombo() != null) {
            this.getResEnvRefTypeCombo().setEnabled(this.isEditable());
        }
    }

    protected IResourceEnvRef getResourceEnvRef() {
        IIdentifiable identifiable;
        IResourceEnvRef ret = null;
        if (this.getData() instanceof TreeNode && (identifiable = ((TreeNode)this.getData()).getIdentifiable()) instanceof IResourceEnvRef) {
            ret = (IResourceEnvRef)identifiable;
        }
        return ret;
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof TreeNode)) {
            ret = "No object of TreeNode found!";
        }
        return ret;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected void handleResourceEnvRefNameEvent() {
        if (!this.isRefreshingUI()) {
            this.refreshResourceEnvRefNameFromUI();
            super.handleEvent();
        }
    }

    private Combo getResEnvRefTypeCombo() {
        return this.resEnvRefTypeCombo;
    }

    private void setResEnvRefTypeCombo(Combo resEnvRefTypeCombo) {
        this.resEnvRefTypeCombo = resEnvRefTypeCombo;
    }

    public String okToLeave() {
        String message = null;
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        if (this.getResEnvRefNameTextField().getText().equals("")) {
            status.setError("Please enter resource-env-ref-name.");
        } else if (this.getResEnvRefTypeCombo().getText().equals("")) {
            status.setError("Please select a resource environment reference type!");
        } else if (this.isDuplicateResEnvRefName()) {
            status.setError("Duplicate name. Please choose another resource environment reference name.");
        }
        return status;
    }

    private boolean isDuplicateResEnvRefName() {
        return this.isDuplicateResEnvRefName;
    }

    private void setDuplicateResEnvRefName(boolean b) {
        this.isDuplicateResEnvRefName = b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ResEnvTypeModAdapt
    implements ModifyListener {
        private ResEnvTypeModAdapt() {
        }

        public void modifyText(ModifyEvent e) {
            if (!UiResourceEnvRef.super.isRefreshingUI()) {
                StringBuffer temporaryResourceName = new StringBuffer(UiResourceEnvRef.this.getResEnvRefNameTextField().getText());
                if ((UiResourceEnvRef.this.getResEnvRefTypeCombo().getText().equals("javax.jms.Queue") || UiResourceEnvRef.this.getResEnvRefTypeCombo().getText().equals("javax.jms.Topic")) && UiResourceEnvRef.this.getResEnvRefNameTextField().getText().indexOf("/") == -1) {
                    temporaryResourceName.insert(0, "jms/");
                    UiResourceEnvRef.this.getResEnvRefNameTextField().setText(temporaryResourceName.toString());
                }
                UiResourceEnvRef.super.handleEvent();
            }
        }
    }

    private class ResEnvRefNameModAdapt
    implements ModifyListener {
        private ResEnvRefNameModAdapt() {
        }

        public void modifyText(ModifyEvent e) {
            UiResourceEnvRef.this.handleResourceEnvRefNameEvent();
        }
    }
}

