/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IMutable;
import com.tssap.j2ee.model.dd.MutableUtil;
import com.tssap.j2ee.model.ejbjar.dd.IDescription;
import com.tssap.j2ee.model.ejbjar.dd.IDisplayName;
import com.tssap.j2ee.model.ejbjar.dd.ILargeIcon;
import com.tssap.j2ee.model.ejbjar.dd.IMessageDriven;
import com.tssap.j2ee.model.ejbjar.dd.IMessageDrivenDestination;
import com.tssap.j2ee.model.ejbjar.dd.ISmallIcon;
import com.tssap.j2ee.ui.editor.reuse.gi.DDGeneralInfoComponent;
import com.tssap.j2ee.ui.editor.reuse.gi.IDDGeneralInfoComponent;
import com.tssap.j2ee.ui.editor.reuse.gi.IDDGeneralInfoComponentAdapter;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class UiMessageDrivenGeneral
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiMessageDrivenGeneral == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiMessageDrivenGeneral = UiMessageDrivenGeneral.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects.UiMessageDrivenGeneral")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiMessageDrivenGeneral));
    private IDDGeneralInfoComponent infoComponent;
    private InfoCompAdapter infoComponentAdapter;
    private IModifiedCallback myModifyCallback;
    private static final String[] transTypeItems = new String[]{"Bean", "Container"};
    private static final String[] destinationTypeItems = new String[]{"javax.jms.Queue", "javax.jms.Topic"};
    private static final String[] subscriptionDurability = new String[]{"Durable", "NonDurable"};
    private static final String TEXT_AUTO_ACKN = "Auto-acknowledge";
    private static final String TEXT_DUPS_OK = "Dups-ok-acknowledge";
    private static final int DEST_TYPE_QUEUE = 0;
    private static final int DEST_TYPE_TOPIC = 1;
    private static final int SUBSCR_DURABLE = 0;
    private static final int SUBSCR_NON_DURABLE = 1;
    private static final int UNKNOWN = -1;
    private Text ejbNameTextField;
    private Text ejbClassTextField;
    private Combo transactionTypeCombo;
    private Text messageSelectorTextField;
    private Button acknowledgeModeCheckbox;
    private Button acknowledgeModeAutoRadioButton;
    private Button acknowledgeModeDupsRadioButton;
    private Button messageDrivenDestinationCheckbox;
    private Button subscriptionDurabilityCheckbox;
    private Button[] destTypeRadios = new Button[2];
    private Button[] subscrDurabilityRadios = new Button[2];
    private int currentDestTypeSelection = -1;
    private int currentSubscrDurSelection = -1;
    private boolean isContainerInitialized = false;
    private boolean acknowledgeModeCbSelected = false;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiMessageDrivenGeneral;

    public void initContainer(IGridLayoutPane userArea) {
        userArea.setTitle("Message-driven bean");
        this.infoComponent = new DDGeneralInfoComponent();
        this.infoComponentAdapter = new InfoCompAdapter();
        this.infoComponent.setAdapter((IDDGeneralInfoComponentAdapter)this.infoComponentAdapter);
        IGridLayoutPane infoPane = userArea.addGridLayoutPane(this.infoComponent.getUserGridNumOfColumns(), userArea.createGridLayoutData(4, 4, true, false, this.getUserGridNumOfColumns(), 1));
        this.infoComponent.createPartControl(infoPane);
        userArea.addPlaceholder(this.getUserGridNumOfColumns(), 1);
        userArea.addTextLabel("EJB Name");
        this.ejbNameTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.setEjbNameTextField(this.ejbNameTextField);
        userArea.addTextLabel("EJB class");
        this.ejbClassTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.setEjbClassTextField(this.ejbClassTextField);
        userArea.addTextLabel("Transaction type");
        this.transactionTypeCombo = userArea.addComboBox(transTypeItems, "", true, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.setTransactionTypeCombo(this.transactionTypeCombo);
        userArea.addTextLabel("Message selector");
        this.messageSelectorTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.setMessageSelectorTextField(this.messageSelectorTextField);
        this.acknowledgeModeCheckbox = userArea.addCheckBox("acknowledge-mode", false, userArea.createGridLayoutData(4, 4, true, false, this.getUserGridNumOfColumns(), 1));
        this.setAcknowledgeModeCheckbox(this.acknowledgeModeCheckbox);
        this.acknowledgeModeAutoRadioButton = userArea.addRadioButton(TEXT_AUTO_ACKN, userArea.createGridLayoutData(4, 4, true, false, this.getUserGridNumOfColumns(), 1));
        this.setAcknowledgeModeAutoRadioButton(this.acknowledgeModeAutoRadioButton);
        this.acknowledgeModeDupsRadioButton = userArea.addRadioButton(TEXT_DUPS_OK, userArea.createGridLayoutData(4, 4, true, false, this.getUserGridNumOfColumns(), 1));
        this.setAcknowledgeModeDupsRadioButton(this.acknowledgeModeDupsRadioButton);
        this.messageDrivenDestinationCheckbox = userArea.addCheckBox("Message Driven Destination", false, userArea.createGridLayoutData(4, 4, true, false, this.getUserGridNumOfColumns(), 1));
        this.setMessageDrivenDestinationCheckbox(this.messageDrivenDestinationCheckbox);
        userArea.addTextLabel("Destination Type", userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.destTypeRadios[0] = userArea.addRadioButton(destinationTypeItems[0], userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.destTypeRadios[1] = userArea.addRadioButton(destinationTypeItems[1], userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.subscriptionDurabilityCheckbox = userArea.addCheckBox("Subscription Durability", false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setSubscriptionDurabilityCheckbox(this.subscriptionDurabilityCheckbox);
        this.subscrDurabilityRadios[0] = userArea.addRadioButton(subscriptionDurability[0], userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.subscrDurabilityRadios[1] = userArea.addRadioButton(subscriptionDurability[1], userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.decorateControls();
        this.isContainerInitialized = true;
    }

    private void decorateControls() {
        SelectionAdapter mySelectionAdapter = new SelectionAdapter();
        this.getEjbNameTextField().addModifyListener((ModifyListener)new EjbNameModifyAdapter());
        this.getEjbClassTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getTransactionTypeCombo().addModifyListener((ModifyListener)new TransTypeModAdapter());
        this.getMessageSelectorTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getAcknowledgeModeCheckbox().addSelectionListener((SelectionListener)mySelectionAdapter);
        this.getAcknowledgeModeAutoRadioButton().addSelectionListener((SelectionListener)mySelectionAdapter);
        this.getAcknowledgeModeDupsRadioButton().addSelectionListener((SelectionListener)mySelectionAdapter);
        this.getMessageDrivenDestinationCheckbox().addSelectionListener((SelectionListener)mySelectionAdapter);
        this.getSubscriptionDurabilityCheckbox().addSelectionListener((SelectionListener)mySelectionAdapter);
        this.destTypeRadios[0].addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UiMessageDrivenGeneral.this.radioSelectionChanged(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                UiMessageDrivenGeneral.this.radioSelectionChanged(e);
            }
        });
        this.destTypeRadios[1].addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UiMessageDrivenGeneral.this.radioSelectionChanged(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                UiMessageDrivenGeneral.this.radioSelectionChanged(e);
            }
        });
        this.subscrDurabilityRadios[0].addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UiMessageDrivenGeneral.this.radioSelectionChanged(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                UiMessageDrivenGeneral.this.radioSelectionChanged(e);
            }
        });
        this.subscrDurabilityRadios[1].addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UiMessageDrivenGeneral.this.radioSelectionChanged(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                UiMessageDrivenGeneral.this.radioSelectionChanged(e);
            }
        });
    }

    private void radioSelectionChanged(SelectionEvent e) {
        int oldDestTypeSelection = this.currentDestTypeSelection;
        int oldSubscrDurSelection = this.currentSubscrDurSelection;
        if (e.getSource() == this.destTypeRadios[0]) {
            this.currentDestTypeSelection = 0;
        } else if (e.getSource() == this.destTypeRadios[1]) {
            this.currentDestTypeSelection = 1;
        }
        if (e.getSource() == this.subscrDurabilityRadios[0]) {
            this.currentSubscrDurSelection = 0;
        } else if (e.getSource() == this.subscrDurabilityRadios[1]) {
            this.currentSubscrDurSelection = 1;
        }
        if (this.currentDestTypeSelection != oldDestTypeSelection) {
            this.updateDestTypeSelection(this.isEditable());
            if (!this.isRefreshingUI()) {
                this.handleTextModified();
            }
        }
        if (this.currentSubscrDurSelection != oldSubscrDurSelection) {
            this.updateSubscDurSelection(this.isEditable());
            if (!this.isRefreshingUI()) {
                this.handleTextModified();
            }
        }
    }

    private void handleTextModified() {
        if (this.myModifyCallback != null) {
            this.myModifyCallback.dataModified(true);
        }
    }

    public Text getEjbClassTextField() {
        return this.ejbClassTextField;
    }

    public Text getEjbNameTextField() {
        return this.ejbNameTextField;
    }

    public Text getMessageSelectorTextField() {
        return this.messageSelectorTextField;
    }

    private Combo getTransactionTypeCombo() {
        return this.transactionTypeCombo;
    }

    private void setTransactionTypeCombo(Combo combo) {
        this.transactionTypeCombo = combo;
    }

    public void setEjbClassTextField(Text ejbClassTextField) {
        this.ejbClassTextField = ejbClassTextField;
    }

    public void setEjbNameTextField(Text ejbNameTextField) {
        this.ejbNameTextField = ejbNameTextField;
    }

    private Button getAcknowledgeModeCheckbox() {
        return this.acknowledgeModeCheckbox;
    }

    private void setAcknowledgeModeCheckbox(Button acknowledgeModeCheckbox) {
        this.acknowledgeModeCheckbox = acknowledgeModeCheckbox;
    }

    private Button getAcknowledgeModeAutoRadioButton() {
        return this.acknowledgeModeAutoRadioButton;
    }

    private Button getAcknowledgeModeDupsRadioButton() {
        return this.acknowledgeModeDupsRadioButton;
    }

    private void setAcknowledgeModeAutoRadioButton(Button acknowledgeModeAutoRadioButton) {
        this.acknowledgeModeAutoRadioButton = acknowledgeModeAutoRadioButton;
    }

    private void setAcknowledgeModeDupsRadioButton(Button acknowledgeModeDupsRadioButton) {
        this.acknowledgeModeDupsRadioButton = acknowledgeModeDupsRadioButton;
    }

    public void setMessageSelectorTextField(Text messageSelectorTextField) {
        this.messageSelectorTextField = messageSelectorTextField;
    }

    public int getUserGridNumOfColumns() {
        return 3;
    }

    public boolean isDataAutoRefreshing() {
        return false;
    }

    public String okToLeave() {
        String message = super.okToLeave();
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK() && !status.isInfo()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        if (this.getTransactionTypeCombo().getText().equals("Container") && this.getAcknowledgeModeCheckbox().getSelection()) {
            status.setError("Acknowledge-mode is not allowed for beans with container managed transaction demarcation.");
        }
        return status;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        IMessageDriven msgDriven = this.getMessageDriven();
        if (msgDriven != null) {
            if (this.getAcknowledgeModeCheckbox().getSelection()) {
                if (this.getAcknowledgeModeAutoRadioButton() != null && this.getAcknowledgeModeAutoRadioButton().getSelection()) {
                    if (msgDriven.getAcknowledgeMode() == null) {
                        try {
                            msgDriven.createAcknowledgeMode(null);
                        }
                        catch (J2eeCreateException e) {
                            this.handleJ2eeCreateException("<acknowledge-mode> tag could not be created.", e);
                        }
                    }
                    msgDriven.getAcknowledgeMode().setValue(TEXT_AUTO_ACKN);
                } else if (this.getAcknowledgeModeDupsRadioButton() != null && this.getAcknowledgeModeDupsRadioButton().getSelection()) {
                    if (msgDriven.getAcknowledgeMode() == null) {
                        try {
                            msgDriven.createAcknowledgeMode(null);
                        }
                        catch (J2eeCreateException e) {
                            this.handleJ2eeCreateException("<acknowledge-mode> tag could not be created.", e);
                        }
                    }
                    msgDriven.getAcknowledgeMode().setValue(TEXT_DUPS_OK);
                }
            } else {
                msgDriven.removeAcknowledgeMode();
            }
            if (this.getMessageSelectorTextField() != null && !this.getMessageSelectorTextField().getText().trim().equals("")) {
                if (msgDriven.getMessageSelector() == null) {
                    try {
                        msgDriven.createMessageSelector(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<message-selector> tag could not be created.", e);
                    }
                }
                msgDriven.getMessageSelector().setValue(this.getMessageSelectorTextField().getText().trim());
            } else if (msgDriven.getMessageSelector() != null) {
                msgDriven.removeMessageSelector();
            }
            if (this.getTransactionTypeCombo() != null && !this.getTransactionTypeCombo().getText().equals("")) {
                if (msgDriven.getTransactionType().equals("Container") && msgDriven.getAcknowledgeMode() != null) {
                    msgDriven.removeAcknowledgeMode();
                }
                if (msgDriven.getTransactionType() == null) {
                    try {
                        msgDriven.createTransactionType(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<transaction-type> tag could not be created.", e);
                    }
                }
                msgDriven.getTransactionType().setValue(this.getTransactionTypeCombo().getText());
            }
            if (this.getMessageDrivenDestinationCheckbox().getSelection()) {
                if (msgDriven.getMessageDrivenDestination() == null) {
                    try {
                        IMessageDrivenDestination msgDrivenDest = msgDriven.createMessageDrivenDestination(null);
                        msgDrivenDest.createDestinationType(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<message-driven-destination> tag could not be created.", e);
                    }
                }
                if (this.currentDestTypeSelection == 0) {
                    msgDriven.getMessageDrivenDestination().getDestinationType().setValue(destinationTypeItems[0]);
                } else if (this.currentDestTypeSelection == 1) {
                    msgDriven.getMessageDrivenDestination().getDestinationType().setValue(destinationTypeItems[1]);
                } else {
                    tracer.error("refreshDataFromUI()", "Problems on destinationType radiobutton selection occured.");
                }
                if (this.getSubscriptionDurabilityCheckbox().getSelection()) {
                    if (msgDriven.getMessageDrivenDestination().getSubscriptionDurability() == null) {
                        try {
                            msgDriven.getMessageDrivenDestination().createSubscriptionDurability(null);
                        }
                        catch (J2eeCreateException e) {
                            this.handleJ2eeCreateException("<subscription-durability> tag could not be created.", e);
                        }
                    }
                    if (this.currentSubscrDurSelection == 0) {
                        msgDriven.getMessageDrivenDestination().getSubscriptionDurability().setValue(subscriptionDurability[0]);
                    } else if (this.currentSubscrDurSelection == 1) {
                        msgDriven.getMessageDrivenDestination().getSubscriptionDurability().setValue(subscriptionDurability[1]);
                    } else {
                        tracer.error("refreshDataFromUI()", "Problems on subscriptionDurability radiobutton selection occured.");
                    }
                } else if (msgDriven.getMessageDrivenDestination().getSubscriptionDurability() != null) {
                    msgDriven.getMessageDrivenDestination().removeSubscriptionDurability();
                }
            } else if (msgDriven.getMessageDrivenDestination() != null) {
                msgDriven.removeMessageDrivenDestination();
            }
        } else {
            throw new IllegalArgumentException("No object of IMessageDriven found!");
        }
        this.refreshEjbNameFieldFromUI();
    }

    private void refreshEjbNameFieldFromUI() {
        IMessageDriven msgDriven = this.getMessageDriven();
        if (msgDriven != null) {
            if (!this.getEjbNameTextField().getText().trim().equals("")) {
                if (msgDriven.getEjbName() == null) {
                    try {
                        msgDriven.createEjbName(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<ejb-name> could not be created.", e);
                    }
                }
                msgDriven.getEjbName().setValue(this.getEjbNameTextField().getText().trim());
            } else if (msgDriven.getEjbName() != null) {
                msgDriven.getEjbName().setValue("");
            }
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        IMessageDriven msgDriven = this.getMessageDriven();
        if (msgDriven != null && msgDriven instanceof IMessageDriven) {
            this.infoComponentAdapter.setMsgDriven(msgDriven);
            this.infoComponent.initialize();
            this.getEjbNameTextField().setText(msgDriven.getEjbName() != null ? msgDriven.getEjbName().getValue() : "");
            this.getEjbClassTextField().setText(msgDriven.getEjbClass() != null ? msgDriven.getEjbClass().getValue() : "");
            if (msgDriven.getTransactionType() != null) {
                if (msgDriven.getTransactionType().getValue().equalsIgnoreCase(transTypeItems[0])) {
                    this.getTransactionTypeCombo().setText(transTypeItems[0]);
                } else {
                    this.getTransactionTypeCombo().setText(transTypeItems[1]);
                }
            } else {
                tracer.error("refreshUiFromData()", "transaction-type is null but is a mandatory tag!");
            }
            this.getMessageSelectorTextField().setText(msgDriven.getMessageSelector() != null ? msgDriven.getMessageSelector().getValue() : "");
            if (msgDriven.getAcknowledgeMode() != null && !msgDriven.getAcknowledgeMode().getValue().equals("")) {
                if (msgDriven.getTransactionType().getValue().equalsIgnoreCase("Bean")) {
                    this.setAcknowledgeModeCbSelected(true);
                    this.enableAcknowledgeModePart(this.isAcknowledgeModeCbSelected(), this.isEditable());
                    if (msgDriven.getAcknowledgeMode().getValue().equals(TEXT_AUTO_ACKN)) {
                        this.getAcknowledgeModeAutoRadioButton().setSelection(true);
                        this.getAcknowledgeModeDupsRadioButton().setSelection(false);
                    } else if (msgDriven.getAcknowledgeMode().getValue().equals(TEXT_DUPS_OK)) {
                        this.getAcknowledgeModeAutoRadioButton().setSelection(false);
                        this.getAcknowledgeModeDupsRadioButton().setSelection(true);
                    } else {
                        msgDriven.removeAcknowledgeMode();
                        this.enableAcknowledgeModePart(false, this.isEditable());
                        this.getAcknowledgeModeAutoRadioButton().setSelection(true);
                    }
                } else {
                    this.setAcknowledgeModeCbSelected(false);
                    msgDriven.removeAcknowledgeMode();
                    this.getAcknowledgeModeCheckbox().setEnabled(false);
                    this.enableAcknowledgeModePart(false, this.isEditable());
                    this.getAcknowledgeModeAutoRadioButton().setSelection(true);
                }
            } else {
                if (msgDriven.getAcknowledgeMode() != null) {
                    this.setAcknowledgeModeCbSelected(false);
                    msgDriven.removeAcknowledgeMode();
                }
                if (!msgDriven.getTransactionType().getValue().equalsIgnoreCase("Bean")) {
                    this.getAcknowledgeModeCheckbox().setEnabled(false);
                }
                this.enableAcknowledgeModePart(false, this.isEditable());
                this.getAcknowledgeModeAutoRadioButton().setSelection(true);
            }
            if (msgDriven.getMessageDrivenDestination() != null) {
                if (msgDriven.getMessageDrivenDestination().getDestinationType() != null && !msgDriven.getMessageDrivenDestination().getDestinationType().getValue().equals("")) {
                    this.getMessageDrivenDestinationCheckbox().setSelection(true);
                    this.currentDestTypeSelection = this.getDestinationTypeSelection(msgDriven.getMessageDrivenDestination());
                    if (msgDriven.getMessageDrivenDestination().getSubscriptionDurability() != null && !msgDriven.getMessageDrivenDestination().getSubscriptionDurability().getValue().equals("")) {
                        this.getSubscriptionDurabilityCheckbox().setSelection(true);
                        this.currentSubscrDurSelection = this.getSubscriptionDurabilitySelection(msgDriven.getMessageDrivenDestination());
                    } else {
                        if (msgDriven.getMessageDrivenDestination().getSubscriptionDurability() != null) {
                            msgDriven.getMessageDrivenDestination().removeSubscriptionDurability();
                        }
                        this.getSubscriptionDurabilityCheckbox().setSelection(false);
                        if (!this.getMessageDrivenDestinationCheckbox().getSelection()) {
                            this.getSubscriptionDurabilityCheckbox().setEnabled(false);
                        }
                    }
                } else {
                    this.getMessageDrivenDestinationCheckbox().setSelection(false);
                    this.getSubscriptionDurabilityCheckbox().setSelection(false);
                    this.getSubscriptionDurabilityCheckbox().setEnabled(false);
                }
            } else {
                msgDriven.removeMessageDrivenDestination();
                this.getMessageDrivenDestinationCheckbox().setSelection(false);
                this.getSubscriptionDurabilityCheckbox().setSelection(false);
                this.getSubscriptionDurabilityCheckbox().setEnabled(false);
            }
        } else {
            throw new IllegalArgumentException("No object of IMessageDriven found!");
        }
        this.updateDestTypeSelection(this.isEditable());
        this.updateSubscDurSelection(this.isEditable());
        this.stopRefreshingUI();
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.getEjbNameTextField() != null) {
            this.getEjbNameTextField().setEditable(false);
        }
        if (this.getEjbClassTextField() != null) {
            this.getEjbClassTextField().setEditable(false);
        }
        if (this.infoComponent != null) {
            this.infoComponent.setEditable(editable);
        }
        if (this.isContainerInitialized) {
            if (this.getTransactionTypeCombo().getText().equals("Container")) {
                this.getAcknowledgeModeCheckbox().setEnabled(false);
                this.enableAcknowledgeModePart(false, editable);
            } else if (this.getTransactionTypeCombo().getText().equals("Bean")) {
                this.getAcknowledgeModeCheckbox().setEnabled(editable);
                this.enableAcknowledgeModePart(this.isAcknowledgeModeCbSelected(), editable);
            }
            if (this.getAcknowledgeModeCheckbox().getSelection()) {
                this.getAcknowledgeModeAutoRadioButton().setEnabled(editable);
                this.getAcknowledgeModeDupsRadioButton().setEnabled(editable);
            } else {
                this.setAcknowledgeModeCbSelected(false);
                this.getAcknowledgeModeAutoRadioButton().setSelection(true);
                this.getAcknowledgeModeDupsRadioButton().setSelection(false);
                this.getAcknowledgeModeAutoRadioButton().setEnabled(false);
                this.getAcknowledgeModeDupsRadioButton().setEnabled(false);
            }
            this.updateDestTypeSelection(editable);
            this.updateSubscDurSelection(editable);
        }
    }

    private void enableAcknowledgeModePart(boolean acknowledgeModeSelected, boolean isPageEditable) {
        if (isPageEditable) {
            this.getAcknowledgeModeCheckbox().setSelection(acknowledgeModeSelected);
            this.getAcknowledgeModeAutoRadioButton().setEnabled(acknowledgeModeSelected);
            this.getAcknowledgeModeDupsRadioButton().setEnabled(acknowledgeModeSelected);
        } else {
            this.getAcknowledgeModeCheckbox().setSelection(acknowledgeModeSelected);
            this.getAcknowledgeModeAutoRadioButton().setEnabled(isPageEditable);
            this.getAcknowledgeModeDupsRadioButton().setEnabled(isPageEditable);
        }
    }

    private void updateDestTypeSelection(boolean isPageEditable) {
        if (isPageEditable) {
            this.destTypeRadios[0].setEnabled(this.getMessageDrivenDestinationCheckbox().getSelection());
            this.destTypeRadios[1].setEnabled(this.getMessageDrivenDestinationCheckbox().getSelection());
        } else {
            this.destTypeRadios[0].setEnabled(isPageEditable);
            this.destTypeRadios[1].setEnabled(isPageEditable);
        }
        if (this.currentDestTypeSelection != -1) {
            this.destTypeRadios[0].setSelection(this.currentDestTypeSelection == 0);
            this.destTypeRadios[1].setSelection(this.currentDestTypeSelection == 1);
            if (this.currentDestTypeSelection == 1) {
                this.getSubscriptionDurabilityCheckbox().setEnabled(isPageEditable);
            } else {
                this.getSubscriptionDurabilityCheckbox().setEnabled(false);
                this.getSubscriptionDurabilityCheckbox().setSelection(false);
                this.updateSubscDurSelection(false);
            }
        } else {
            this.destTypeRadios[0].setSelection(true);
            this.currentDestTypeSelection = 0;
            this.destTypeRadios[1].setSelection(false);
        }
    }

    private void updateSubscDurSelection(boolean isPageEditable) {
        if (this.destTypeRadios[1].getSelection() && this.getMessageDrivenDestinationCheckbox().getSelection()) {
            this.getSubscriptionDurabilityCheckbox().setEnabled(isPageEditable);
        } else {
            this.getSubscriptionDurabilityCheckbox().setEnabled(false);
            this.getSubscriptionDurabilityCheckbox().setSelection(false);
        }
        if (isPageEditable) {
            boolean durabilityIsSelectable = this.getSubscriptionDurabilityCheckbox().getSelection() && this.destTypeRadios[1].getSelection();
            this.subscrDurabilityRadios[0].setEnabled(durabilityIsSelectable);
            this.subscrDurabilityRadios[1].setEnabled(durabilityIsSelectable);
        } else {
            this.subscrDurabilityRadios[0].setEnabled(isPageEditable);
            this.subscrDurabilityRadios[1].setEnabled(isPageEditable);
        }
        if (this.currentSubscrDurSelection != -1) {
            this.subscrDurabilityRadios[0].setSelection(this.currentSubscrDurSelection == 0);
            this.subscrDurabilityRadios[1].setSelection(this.currentSubscrDurSelection == 1);
        } else {
            this.subscrDurabilityRadios[0].setSelection(true);
            this.currentSubscrDurSelection = 0;
            this.subscrDurabilityRadios[1].setSelection(false);
        }
    }

    private int getDestinationTypeSelection(IMessageDrivenDestination msgDrivenDest) {
        int ret = -1;
        if (msgDrivenDest.getDestinationType() != null && msgDrivenDest.getDestinationType() != null) {
            String destType = msgDrivenDest.getDestinationType().getValue();
            if (destType.equals(destinationTypeItems[0])) {
                ret = 0;
            } else if (destType.equals(destinationTypeItems[1])) {
                ret = 1;
            }
        }
        return ret;
    }

    private int getSubscriptionDurabilitySelection(IMessageDrivenDestination msgDrivenDest) {
        int ret = -1;
        if (msgDrivenDest.getSubscriptionDurability() != null) {
            String subscrDur = msgDrivenDest.getSubscriptionDurability().getValue();
            if (subscrDur.equals(subscriptionDurability[0])) {
                ret = 0;
            } else if (subscrDur.equals(subscriptionDurability[1])) {
                ret = 1;
            }
        }
        return ret;
    }

    protected IMessageDriven getMessageDriven() {
        IMessageDriven ret = null;
        if (this.getData() instanceof IMessageDriven) {
            ret = (IMessageDriven)this.getData();
        }
        return ret;
    }

    public void setModifyCallback(IModifiedCallback callback) {
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof IMessageDriven)) {
            ret = "No object of IMessageDriven found!";
        }
        return ret;
    }

    protected void handleEjbNameEvent() {
        if (!this.isRefreshingUI()) {
            this.refreshEjbNameFieldFromUI();
            super.handleEvent();
        }
    }

    protected void handleSelectionEvent() {
        if (!this.isRefreshingUI()) {
            if (this.getMessageDriven() != null) {
                if (this.getAcknowledgeModeCheckbox() != null && this.getAcknowledgeModeCheckbox().getSelection()) {
                    this.setAcknowledgeModeCbSelected(true);
                } else {
                    this.setAcknowledgeModeCbSelected(false);
                }
                this.updateEditableBehavior();
            }
            super.handleEvent();
        }
    }

    private Button getMessageDrivenDestinationCheckbox() {
        return this.messageDrivenDestinationCheckbox;
    }

    private void setMessageDrivenDestinationCheckbox(Button button) {
        this.messageDrivenDestinationCheckbox = button;
    }

    private Button getSubscriptionDurabilityCheckbox() {
        return this.subscriptionDurabilityCheckbox;
    }

    private void setSubscriptionDurabilityCheckbox(Button button) {
        this.subscriptionDurabilityCheckbox = button;
    }

    private boolean isAcknowledgeModeCbSelected() {
        return this.acknowledgeModeCbSelected;
    }

    private void setAcknowledgeModeCbSelected(boolean b) {
        this.acknowledgeModeCbSelected = b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TransTypeModAdapter
    implements ModifyListener {
        private TransTypeModAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (!UiMessageDrivenGeneral.super.isRefreshingUI()) {
                if (UiMessageDrivenGeneral.this.getMessageDriven() != null) {
                    UiMessageDrivenGeneral.this.updateEditableBehavior();
                }
                if (UiMessageDrivenGeneral.this.getModifiedCallback() != null) {
                    UiMessageDrivenGeneral.this.getModifiedCallback().dataModified(true);
                }
            }
        }
    }

    private class SelectionAdapter
    implements SelectionListener {
        private SelectionAdapter() {
        }

        public void widgetDefaultSelected(SelectionEvent evt) {
            UiMessageDrivenGeneral.this.handleSelectionEvent();
        }

        public void widgetSelected(SelectionEvent evt) {
            this.widgetDefaultSelected(evt);
        }
    }

    private class EjbNameModifyAdapter
    implements ModifyListener {
        private EjbNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UiMessageDrivenGeneral.this.handleEjbNameEvent();
        }
    }

    private class InfoCompAdapter
    implements IDDGeneralInfoComponentAdapter {
        private IMessageDriven msgDriven = null;

        public String getDescription() {
            if (this.getMsgDriven() == null) {
                return "";
            }
            IDescription descriptionMutable = this.getMsgDriven().getDescription();
            String description = MutableUtil.mutableToValue((IMutable)descriptionMutable);
            return description;
        }

        public String getDisplayName() {
            if (this.getMsgDriven() == null) {
                return "";
            }
            IDisplayName displayNameMutable = this.getMsgDriven().getDisplayName();
            String displayName = MutableUtil.mutableToValue((IMutable)displayNameMutable);
            return displayName;
        }

        public String getLargeIcon() {
            String ret = "";
            if (this.isIconsChecked()) {
                ILargeIcon largeIconMutable = this.getMsgDriven().getLargeIcon();
                ret = MutableUtil.mutableToValue((IMutable)largeIconMutable);
            }
            return ret;
        }

        public String getSmallIcon() {
            String ret = "";
            if (this.isIconsChecked()) {
                ISmallIcon smallIconMutable = this.getMsgDriven().getSmallIcon();
                ret = MutableUtil.mutableToValue((IMutable)smallIconMutable);
            }
            return ret;
        }

        public void setDescription(String description) {
            if (description.trim().length() != 0) {
                if (this.getMsgDriven().getDescription() != null) {
                    this.getMsgDriven().getDescription().setValue(description);
                } else {
                    try {
                        this.getMsgDriven().createDescription(null).setValue(description);
                    }
                    catch (J2eeCreateException e) {
                        UiMessageDrivenGeneral.this.handleJ2eeCreateException("<description> could not be created.", e);
                    }
                }
            } else if (this.getMsgDriven().getDescription() != null) {
                this.getMsgDriven().removeDescription();
            }
            UiMessageDrivenGeneral.super.handleEvent();
        }

        public void setDisplayName(String displayName) {
            if (displayName.trim().length() != 0) {
                if (this.getMsgDriven().getDisplayName() != null) {
                    this.getMsgDriven().getDisplayName().setValue(displayName);
                } else {
                    try {
                        this.getMsgDriven().createDisplayName(null).setValue(displayName);
                    }
                    catch (J2eeCreateException e) {
                        UiMessageDrivenGeneral.this.handleJ2eeCreateException("<display-name> could not be created.", e);
                    }
                }
            } else if (this.getMsgDriven().getDisplayName() != null) {
                this.getMsgDriven().removeDisplayName();
            }
            UiMessageDrivenGeneral.super.handleEvent();
        }

        public void setLargeIcon(String largeIcon) {
            if (largeIcon.trim().length() != 0) {
                if (this.msgDriven.getLargeIcon() != null) {
                    this.msgDriven.getLargeIcon().setValue(largeIcon);
                } else {
                    try {
                        this.msgDriven.createLargeIcon(null).setValue(largeIcon);
                    }
                    catch (J2eeCreateException e) {
                        UiMessageDrivenGeneral.this.handleJ2eeCreateException("<large-icon> could not be created.", e);
                    }
                }
            } else if (this.msgDriven.getLargeIcon() != null) {
                this.msgDriven.removeLargeIcon();
            }
            UiMessageDrivenGeneral.super.handleEvent();
        }

        public void setSmallIcon(String smallIcon) {
            if (smallIcon.trim().length() != 0) {
                if (this.msgDriven.getSmallIcon() != null) {
                    this.msgDriven.getSmallIcon().setValue(smallIcon);
                } else {
                    try {
                        this.msgDriven.createSmallIcon(null).setValue(smallIcon);
                    }
                    catch (J2eeCreateException e) {
                        UiMessageDrivenGeneral.this.handleJ2eeCreateException("<small-icon> could not be created.", e);
                    }
                }
            } else if (this.msgDriven.getSmallIcon() != null) {
                this.msgDriven.removeSmallIcon();
            }
            UiMessageDrivenGeneral.super.handleEvent();
        }

        public IMessageDriven getMsgDriven() {
            return this.msgDriven;
        }

        public void setMsgDriven(IMessageDriven msgDriven) {
            this.msgDriven = msgDriven;
        }

        public boolean isIconsChecked() {
            ILargeIcon largeIcon = this.getMsgDriven() != null ? this.getMsgDriven().getLargeIcon() : null;
            ISmallIcon smallIcon = this.getMsgDriven() != null ? this.getMsgDriven().getSmallIcon() : null;
            return largeIcon != null || smallIcon != null;
        }

        public void setIconsChecked(boolean checkFlag) {
        }
    }
}

