/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.ejbjar.dd.IEnvEntry;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class UiEnvEntry
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEnvEntry == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEnvEntry = UiEnvEntry.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects.UiEnvEntry")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEnvEntry));
    private static final String TXT_PLEASE_SET_THE = "Please set the ";
    private static final String TXT_IS_NOT_COMPATIBLE_TO_TYPE = " is not compatible to type ";
    private static final String TXT_ENV_ENTRY_VALUE = "Environment entry value";
    private static final String TXT_ENV_ENTRY_NAME = "Environment entry name";
    private static final String TXT_ENV_ENTRY_TYPE = "Environment entry type";
    private static final String ENV_ENTRY_TYPE_BOOLEAN = "java.lang.Boolean";
    private static final String ENV_ENTRY_TYPE_BYTE = "java.lang.Byte";
    private static final String ENV_ENTRY_TYPE_CHARACTER = "java.lang.Character";
    private static final String ENV_ENTRY_TYPE_STRING = "java.lang.String";
    private static final String ENV_ENTRY_TYPE_SHORT = "java.lang.Short";
    private static final String ENV_ENTRY_TYPE_INTEGER = "java.lang.Integer";
    private static final String ENV_ENTRY_TYPE_LONG = "java.lang.Long";
    private static final String ENV_ENTRY_TYPE_FLOAT = "java.lang.Float";
    private static final String ENV_ENTRY_TYPE_DOUBLE = "java.lang.Double";
    private IModifiedCallback myModifyCallback;
    private Text descriptionTextPane;
    private Combo envEntryTypeCombobox;
    private Text envEntryNameTextField;
    private Text envEntryValueTextField;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEnvEntry;

    public void initContainer(IGridLayoutPane userArea) {
        userArea.addTextLabel(TXT_ENV_ENTRY_NAME);
        this.envEntryNameTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEnvEntryNameTextField(this.envEntryNameTextField);
        String[] envEntryTypes = new String[]{ENV_ENTRY_TYPE_BOOLEAN, ENV_ENTRY_TYPE_BYTE, ENV_ENTRY_TYPE_CHARACTER, ENV_ENTRY_TYPE_STRING, ENV_ENTRY_TYPE_SHORT, ENV_ENTRY_TYPE_INTEGER, ENV_ENTRY_TYPE_LONG, ENV_ENTRY_TYPE_FLOAT, ENV_ENTRY_TYPE_DOUBLE};
        userArea.addTextLabel(TXT_ENV_ENTRY_TYPE);
        this.envEntryTypeCombobox = userArea.addComboBox(envEntryTypes, "", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEnvEntryTypeCombobox(this.envEntryTypeCombobox);
        userArea.addTextLabel(TXT_ENV_ENTRY_VALUE);
        this.envEntryValueTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEnvEntryValueTextField(this.envEntryValueTextField);
        userArea.addTextLabel("Description");
        this.descriptionTextPane = userArea.addTextPane("", false, true, userArea.createGridLayoutData(4, 4, true, true, 1, 1));
        this.setDescriptionTextPane(this.descriptionTextPane);
        this.decorateControls();
    }

    private void decorateControls() {
        this.getDescriptionTextPane().addModifyListener(this.getModifyAdapterSingleton());
        this.getEnvEntryNameTextField().addModifyListener((ModifyListener)new EnvEntryNameModifyAdapter());
        this.getEnvEntryTypeCombobox().addModifyListener(this.getModifyAdapterSingleton());
        this.getEnvEntryValueTextField().addModifyListener(this.getModifyAdapterSingleton());
    }

    public String okToLeave() {
        String message = super.okToLeave();
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        String envEntryName = this.getEnvEntryNameTextField().getText();
        if (envEntryName.equals("")) {
            status.setError("Please enter an environment entry name.");
        }
        String selectedEnvEntryType = this.getEnvEntryTypeCombobox().getText();
        String selectedEnvEntryValue = this.getEnvEntryValueTextField().getText();
        if (selectedEnvEntryValue != null && !selectedEnvEntryValue.equals("")) {
            if (selectedEnvEntryType.equals(ENV_ENTRY_TYPE_BOOLEAN)) {
                if (!selectedEnvEntryValue.equalsIgnoreCase("false") && !selectedEnvEntryValue.equalsIgnoreCase("true")) {
                    status.setError(TXT_ENV_ENTRY_VALUE + selectedEnvEntryValue + TXT_IS_NOT_COMPATIBLE_TO_TYPE + ENV_ENTRY_TYPE_BOOLEAN);
                }
            } else if (selectedEnvEntryType.equals(ENV_ENTRY_TYPE_BYTE)) {
                try {
                    Byte.parseByte(selectedEnvEntryValue);
                }
                catch (NumberFormatException e) {
                    status.setError(TXT_ENV_ENTRY_VALUE + selectedEnvEntryValue + TXT_IS_NOT_COMPATIBLE_TO_TYPE + ENV_ENTRY_TYPE_BYTE);
                }
            } else if (selectedEnvEntryType.equals(ENV_ENTRY_TYPE_CHARACTER)) {
                if (selectedEnvEntryValue.length() > 1) {
                    status.setError(TXT_ENV_ENTRY_VALUE + selectedEnvEntryValue + TXT_IS_NOT_COMPATIBLE_TO_TYPE + ENV_ENTRY_TYPE_CHARACTER);
                }
            } else if (selectedEnvEntryType.equals(ENV_ENTRY_TYPE_DOUBLE)) {
                try {
                    Double.parseDouble(selectedEnvEntryValue);
                }
                catch (NumberFormatException e) {
                    status.setError(TXT_ENV_ENTRY_VALUE + selectedEnvEntryValue + TXT_IS_NOT_COMPATIBLE_TO_TYPE + ENV_ENTRY_TYPE_DOUBLE);
                }
            } else if (selectedEnvEntryType.equals(ENV_ENTRY_TYPE_FLOAT)) {
                try {
                    Float.parseFloat(selectedEnvEntryValue);
                }
                catch (NumberFormatException e) {
                    status.setError(TXT_ENV_ENTRY_VALUE + selectedEnvEntryValue + TXT_IS_NOT_COMPATIBLE_TO_TYPE + ENV_ENTRY_TYPE_FLOAT);
                }
            } else if (selectedEnvEntryType.equals(ENV_ENTRY_TYPE_INTEGER)) {
                try {
                    Integer.parseInt(selectedEnvEntryValue);
                }
                catch (NumberFormatException e) {
                    status.setError(TXT_ENV_ENTRY_VALUE + selectedEnvEntryValue + TXT_IS_NOT_COMPATIBLE_TO_TYPE + ENV_ENTRY_TYPE_INTEGER);
                }
            } else if (selectedEnvEntryType.equals(ENV_ENTRY_TYPE_LONG)) {
                try {
                    Long.parseLong(selectedEnvEntryValue);
                }
                catch (NumberFormatException e) {
                    status.setError(TXT_ENV_ENTRY_VALUE + selectedEnvEntryValue + TXT_IS_NOT_COMPATIBLE_TO_TYPE + ENV_ENTRY_TYPE_LONG);
                }
            } else if (selectedEnvEntryType.equals(ENV_ENTRY_TYPE_SHORT)) {
                try {
                    Short.parseShort(selectedEnvEntryValue);
                }
                catch (NumberFormatException e) {
                    status.setError(TXT_ENV_ENTRY_VALUE + selectedEnvEntryValue + TXT_IS_NOT_COMPATIBLE_TO_TYPE + ENV_ENTRY_TYPE_SHORT);
                }
            }
        } else {
            status.setError("Please set the Environment entry value");
        }
        return status;
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    private Text getEnvEntryValueTextField() {
        return this.envEntryValueTextField;
    }

    private Combo getEnvEntryTypeCombobox() {
        return this.envEntryTypeCombobox;
    }

    private void setEnvEntryTypeCombobox(Combo envEntryTypeCombobox) {
        this.envEntryTypeCombobox = envEntryTypeCombobox;
    }

    private void setEnvEntryValueTextField(Text envEntryValueTextField) {
        this.envEntryValueTextField = envEntryValueTextField;
    }

    private Text getEnvEntryNameTextField() {
        return this.envEntryNameTextField;
    }

    private void setEnvEntryNameTextField(Text envEntryNameTextField) {
        this.envEntryNameTextField = envEntryNameTextField;
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        IEnvEntry envEntry = this.getEnvEntry();
        if (!this.getDescriptionTextPane().getText().trim().equals("") && envEntry != null) {
            if (envEntry.getDescription() == null) {
                try {
                    envEntry.createDescription(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<description> could not be created.", e);
                }
            }
            envEntry.getDescription().setValue(this.getDescriptionTextPane().getText().trim());
        }
        if (envEntry != null) {
            this.refreshEnvEntryNameFromUI();
            if (envEntry.getEnvEntryType() == null) {
                try {
                    envEntry.createEnvEntryType(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<env-entry-type> could not be created.", e);
                }
            }
            if (!this.getEnvEntryTypeCombobox().getText().equals("Select Environment Entry Type")) {
                envEntry.getEnvEntryType().setValue(this.getEnvEntryTypeCombobox().getText());
            } else if (envEntry.getEnvEntryType() != null) {
                envEntry.getEnvEntryType().setValue("");
            }
            if (!this.getEnvEntryValueTextField().getText().trim().equals("")) {
                if (envEntry.getEnvEntryValue() == null) {
                    try {
                        envEntry.createEnvEntryValue(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("", e);
                    }
                }
                envEntry.getEnvEntryValue().setValue(this.getEnvEntryValueTextField().getText().trim());
            }
        }
    }

    private void refreshEnvEntryNameFromUI() {
        IEnvEntry envEntry = this.getEnvEntry();
        if (envEntry != null) {
            if (envEntry.getEnvEntryName() == null) {
                try {
                    envEntry.createEnvEntryName(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<env-entry-name> could not be created.", e);
                }
            }
            if (!this.getEnvEntryNameTextField().getText().trim().equals("")) {
                envEntry.getEnvEntryName().setValue(this.getEnvEntryNameTextField().getText().trim());
            } else if (envEntry.getEnvEntryName() != null) {
                envEntry.getEnvEntryName().setValue("");
            }
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        IEnvEntry envEntry = this.getEnvEntry();
        if (envEntry == null || !(envEntry instanceof IEnvEntry)) {
            throw new IllegalArgumentException("No object of IEnvEntry found!");
        }
        this.getDescriptionTextPane().setText(envEntry.getDescription() != null ? envEntry.getDescription().getValue() : "");
        this.getEnvEntryNameTextField().setText(envEntry.getEnvEntryName() != null ? envEntry.getEnvEntryName().getValue() : "");
        this.getEnvEntryTypeCombobox().setText(envEntry.getEnvEntryType() != null && !envEntry.getEnvEntryType().getValue().equals("") ? envEntry.getEnvEntryType().getValue() : ENV_ENTRY_TYPE_STRING);
        this.getEnvEntryValueTextField().setText(envEntry.getEnvEntryValue() != null ? envEntry.getEnvEntryValue().getValue() : "");
        this.stopRefreshingUI();
    }

    protected IEnvEntry getEnvEntry() {
        IIdentifiable identifiable;
        IEnvEntry ret = null;
        if (this.getData() instanceof TreeNode && (identifiable = ((TreeNode)this.getData()).getIdentifiable()) instanceof IEnvEntry) {
            ret = (IEnvEntry)identifiable;
        }
        return ret;
    }

    public void setModifyCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof TreeNode)) {
            ret = "No object of TreeNode found!";
        }
        return ret;
    }

    protected void handleEnvEntryNameEvent() {
        if (!this.isRefreshingUI()) {
            this.refreshEnvEntryNameFromUI();
            super.handleEvent();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EnvEntryNameModifyAdapter
    implements ModifyListener {
        private EnvEntryNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UiEnvEntry.this.handleEnvEntryNameEvent();
        }
    }
}

