/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IMutable;
import com.tssap.j2ee.model.dd.MutableUtil;
import com.tssap.j2ee.model.ejbjar.dd.IDescription;
import com.tssap.j2ee.model.ejbjar.dd.IDisplayName;
import com.tssap.j2ee.model.ejbjar.dd.IEntity;
import com.tssap.j2ee.model.ejbjar.dd.ILargeIcon;
import com.tssap.j2ee.model.ejbjar.dd.ISmallIcon;
import com.tssap.j2ee.ui.editor.reuse.gi.DDGeneralInfoComponent;
import com.tssap.j2ee.ui.editor.reuse.gi.IDDGeneralInfoComponent;
import com.tssap.j2ee.ui.editor.reuse.gi.IDDGeneralInfoComponentAdapter;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class UiEntityGeneral
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEntityGeneral == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEntityGeneral = UiEntityGeneral.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects.UiEntityGeneral")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEntityGeneral));
    private IDDGeneralInfoComponent infoComponent;
    private InnerComponentAdapter infoComponentAdapter;
    private IModifiedCallback myModifyCallback;
    private Text ejbNameTextField;
    private Text homeTextField;
    private Text remoteTextField;
    private Text localHomeTextField;
    private Text localTextField;
    private Text ejbClassTextField;
    private Text persistenceTypeTextField;
    private Text primKeyClassTextField;
    private Text reentrantTextField;
    private Text cmpVersionTextField;
    private Text abstractSchemaNameTextField;
    private Text primKeyFieldTextField;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEntityGeneral;

    public void initContainer(IGridLayoutPane userArea) {
        userArea.setTitle("Entity bean");
        this.infoComponent = new DDGeneralInfoComponent();
        this.infoComponentAdapter = new InnerComponentAdapter();
        this.infoComponent.setAdapter((IDDGeneralInfoComponentAdapter)this.infoComponentAdapter);
        IGridLayoutPane infoPane = userArea.addGridLayoutPane(this.infoComponent.getUserGridNumOfColumns(), userArea.createGridLayoutData(4, 4, true, false, this.getUserGridNumOfColumns(), 1));
        this.infoComponent.createPartControl(infoPane);
        userArea.addPlaceholder(this.getUserGridNumOfColumns(), 1);
        userArea.addTextLabel("EJB Name");
        this.ejbNameTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEjbNameTextField(this.ejbNameTextField);
        userArea.addTextLabel("Home");
        this.homeTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setHomeTextField(this.homeTextField);
        userArea.addTextLabel("Remote");
        this.remoteTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setRemoteTextField(this.remoteTextField);
        userArea.addTextLabel("Local home");
        this.localHomeTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setLocalHomeTextField(this.localHomeTextField);
        userArea.addTextLabel("Local");
        this.localTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setLocalTextField(this.localTextField);
        userArea.addTextLabel("EJB class");
        this.ejbClassTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEjbClassTextField(this.ejbClassTextField);
        userArea.addTextLabel("Persistence type");
        this.persistenceTypeTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setPersistenceTypeTextField(this.persistenceTypeTextField);
        userArea.addTextLabel("Primary key class");
        this.primKeyClassTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setPrimKeyClassTextField(this.primKeyClassTextField);
        userArea.addTextLabel("Reentrant");
        this.reentrantTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setReentrantTextField(this.reentrantTextField);
        userArea.addTextLabel("CMP version");
        this.cmpVersionTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setCmpVersionTextField(this.cmpVersionTextField);
        userArea.addTextLabel("Abstract schema name");
        this.abstractSchemaNameTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setAbstractSchemaNameTextField(this.abstractSchemaNameTextField);
        userArea.addTextLabel("Primary key field");
        this.primKeyFieldTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setPrimKeyFieldTextField(this.primKeyFieldTextField);
        this.decorateControls();
    }

    private void decorateControls() {
        this.getEjbNameTextField().addModifyListener((ModifyListener)new EjbNameModifyAdapter());
        this.getHomeTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getRemoteTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getLocalHomeTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getLocalTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getEjbClassTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getPersistenceTypeTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getPrimKeyClassTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getReentrantTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getCmpVersionTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getAbstractSchemaNameTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getPrimKeyFieldTextField().addModifyListener(this.getModifyAdapterSingleton());
    }

    public Text getEjbClassTextField() {
        return this.ejbClassTextField;
    }

    public Text getEjbNameTextField() {
        return this.ejbNameTextField;
    }

    public Text getHomeTextField() {
        return this.homeTextField;
    }

    public Text getLocalHomeTextField() {
        return this.localHomeTextField;
    }

    public Text getLocalTextField() {
        return this.localTextField;
    }

    public Text getRemoteTextField() {
        return this.remoteTextField;
    }

    public void setEjbClassTextField(Text ejbClassTextField) {
        this.ejbClassTextField = ejbClassTextField;
    }

    public void setEjbNameTextField(Text ejbNameTextField) {
        this.ejbNameTextField = ejbNameTextField;
    }

    public void setHomeTextField(Text homeTextField) {
        this.homeTextField = homeTextField;
    }

    public void setLocalHomeTextField(Text localHomeTextField) {
        this.localHomeTextField = localHomeTextField;
    }

    public void setLocalTextField(Text localTextField) {
        this.localTextField = localTextField;
    }

    public void setRemoteTextField(Text remoteTextField) {
        this.remoteTextField = remoteTextField;
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public Text getAbstractSchemaNameTextField() {
        return this.abstractSchemaNameTextField;
    }

    public Text getCmpVersionTextField() {
        return this.cmpVersionTextField;
    }

    public Text getPersistenceTypeTextField() {
        return this.persistenceTypeTextField;
    }

    public Text getPrimKeyClassTextField() {
        return this.primKeyClassTextField;
    }

    public Text getPrimKeyFieldTextField() {
        return this.primKeyFieldTextField;
    }

    public Text getReentrantTextField() {
        return this.reentrantTextField;
    }

    public void setAbstractSchemaNameTextField(Text abstractSchemaNameTextField) {
        this.abstractSchemaNameTextField = abstractSchemaNameTextField;
    }

    public void setCmpVersionTextField(Text cmpVersionTextField) {
        this.cmpVersionTextField = cmpVersionTextField;
    }

    public void setPersistenceTypeTextField(Text persistenceTypeTextField) {
        this.persistenceTypeTextField = persistenceTypeTextField;
    }

    public void setPrimKeyClassTextField(Text primKeyClassTextField) {
        this.primKeyClassTextField = primKeyClassTextField;
    }

    public void setPrimKeyFieldTextField(Text primKeyFieldTextField) {
        this.primKeyFieldTextField = primKeyFieldTextField;
    }

    public void setReentrantTextField(Text reentrantTextField) {
        this.reentrantTextField = reentrantTextField;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        IEntity entity = this.getEntity();
        if (entity != null) {
            if (entity.getHome() != null && entity.getHome().getValue().trim().length() == 0) {
                entity.removeHome();
            }
            if (entity.getRemote() != null && entity.getRemote().getValue().trim().length() == 0) {
                entity.removeRemote();
            }
            if (entity.getLocalHome() != null && entity.getLocalHome().getValue().trim().length() == 0) {
                entity.removeLocalHome();
            }
            if (entity.getLocal() != null && entity.getLocal().getValue().trim().length() == 0) {
                entity.removeLocal();
            }
            if (entity.getAbstractSchemaName() == null) {
                try {
                    entity.createAbstractSchemaName(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<abstract-schema-name> could not be created.", e);
                }
            }
            if (!this.getAbstractSchemaNameTextField().equals("")) {
                entity.getAbstractSchemaName().setValue(this.getAbstractSchemaNameTextField().getText().trim());
            } else if (entity.getAbstractSchemaName() != null) {
                entity.getAbstractSchemaName().setValue("");
            }
            this.refreshEjbNameFieldFromUI();
        }
    }

    private void refreshEjbNameFieldFromUI() {
        IEntity entity = this.getEntity();
        if (entity != null) {
            if (!this.getEjbNameTextField().getText().trim().equals("")) {
                if (entity.getEjbName() == null) {
                    try {
                        entity.createEjbName(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<ejb-name> could not be created.", e);
                    }
                }
                entity.getEjbName().setValue(this.getEjbNameTextField().getText().trim());
            } else if (entity.getEjbName() != null) {
                entity.getEjbName().setValue("");
            }
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        IEntity entity = this.getEntity();
        if (entity == null || !(entity instanceof IEntity)) {
            throw new IllegalArgumentException("No object of IEntity found!");
        }
        this.infoComponentAdapter.setEntity(entity);
        this.infoComponent.initialize();
        this.getEjbNameTextField().setText(entity.getEjbName() != null ? entity.getEjbName().getValue() : "");
        this.getHomeTextField().setText(entity.getHome() != null ? entity.getHome().getValue() : "");
        this.getRemoteTextField().setText(entity.getRemote() != null ? entity.getRemote().getValue() : "");
        this.getLocalHomeTextField().setText(entity.getLocalHome() != null ? entity.getLocalHome().getValue() : "");
        this.getLocalTextField().setText(entity.getLocal() != null ? entity.getLocal().getValue() : "");
        this.getEjbClassTextField().setText(entity.getEjbClass() != null ? entity.getEjbClass().getValue() : "");
        this.getPersistenceTypeTextField().setText(entity.getPersistenceType() != null ? entity.getPersistenceType().getValue() : "");
        this.getPrimKeyClassTextField().setText(entity.getPrimKeyClass() != null ? entity.getPrimKeyClass().getValue() : "");
        this.getReentrantTextField().setText(entity.getReentrant() != null ? entity.getReentrant().getValue() : "");
        this.getCmpVersionTextField().setText(entity.getCmpVersion() != null ? entity.getCmpVersion().getValue() : "");
        this.getAbstractSchemaNameTextField().setText(entity.getAbstractSchemaName() != null ? entity.getAbstractSchemaName().getValue() : "");
        this.getPrimKeyFieldTextField().setText(entity.getPrimkeyField() != null ? entity.getPrimkeyField().getValue() : "");
        this.stopRefreshingUI();
    }

    protected void updateEditableBehavior() {
        if (this.infoComponent != null) {
            this.infoComponent.setEditable(this.isEditable());
        }
        if (this.getEjbNameTextField() != null) {
            this.getEjbNameTextField().setEditable(this.isEditable());
        }
        if (this.getAbstractSchemaNameTextField() != null) {
            this.getAbstractSchemaNameTextField().setEditable(this.isEditable());
        }
    }

    protected IEntity getEntity() {
        IEntity ret = null;
        if (this.getData() instanceof IEntity) {
            ret = (IEntity)this.getData();
        }
        return ret;
    }

    public void setModifyCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected void handleEjbNameEvent() {
        if (!this.isRefreshingUI()) {
            this.refreshEjbNameFieldFromUI();
            super.handleEvent();
        }
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof IEntity)) {
            ret = "No object of IEntity found!";
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EjbNameModifyAdapter
    implements ModifyListener {
        private EjbNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (!UiEntityGeneral.super.isRefreshingUI()) {
                UiEntityGeneral.this.handleEjbNameEvent();
            }
        }
    }

    private class InnerComponentAdapter
    implements IDDGeneralInfoComponentAdapter {
        private IEntity entity;

        public String getDescription() {
            if (this.getEntity() == null) {
                return "";
            }
            IDescription descriptionMutable = this.getEntity().getDescription();
            String description = MutableUtil.mutableToValue((IMutable)descriptionMutable);
            return description;
        }

        public String getDisplayName() {
            if (this.getEntity() == null) {
                return "";
            }
            IDisplayName displayNameMutable = this.getEntity().getDisplayName();
            String displayName = MutableUtil.mutableToValue((IMutable)displayNameMutable);
            return displayName;
        }

        public String getLargeIcon() {
            String ret = "";
            if (this.isIconsChecked()) {
                ILargeIcon largeIconMutable = this.getEntity().getLargeIcon();
                ret = MutableUtil.mutableToValue((IMutable)largeIconMutable);
            }
            return ret;
        }

        public String getSmallIcon() {
            String ret = "";
            if (this.isIconsChecked()) {
                ISmallIcon smallIconMutable = this.getEntity().getSmallIcon();
                ret = MutableUtil.mutableToValue((IMutable)smallIconMutable);
            }
            return ret;
        }

        public boolean isIconsChecked() {
            ILargeIcon largeIcon = this.getEntity() != null ? this.getEntity().getLargeIcon() : null;
            ISmallIcon smallIcon = this.getEntity() != null ? this.getEntity().getSmallIcon() : null;
            return largeIcon != null || smallIcon != null;
        }

        public void setDescription(String description) {
            if (description.trim().length() != 0) {
                if (this.getEntity().getDescription() != null) {
                    this.getEntity().getDescription().setValue(description);
                } else {
                    try {
                        this.getEntity().createDescription(null).setValue(description);
                    }
                    catch (J2eeCreateException e) {
                        UiEntityGeneral.this.handleJ2eeCreateException("<description> could not be created.", e);
                    }
                }
            } else if (this.getEntity().getDescription() != null) {
                this.getEntity().removeDescription();
            }
            UiEntityGeneral.super.handleEvent();
        }

        public void setDisplayName(String displayName) {
            if (displayName.trim().length() != 0) {
                if (this.getEntity().getDisplayName() != null) {
                    this.getEntity().getDisplayName().setValue(displayName);
                } else {
                    try {
                        this.getEntity().createDisplayName(null).setValue(displayName);
                    }
                    catch (J2eeCreateException e) {
                        UiEntityGeneral.this.handleJ2eeCreateException("<display-name> could not be created.", e);
                    }
                }
            } else if (this.getEntity().getDisplayName() != null) {
                this.getEntity().removeDisplayName();
            }
            UiEntityGeneral.super.handleEvent();
        }

        public void setIconsChecked(boolean checkFlag) {
        }

        public void setLargeIcon(String largeIcon) {
            if (this.getEntity() != null) {
                if (largeIcon.trim().length() != 0) {
                    if (this.getEntity().getLargeIcon() != null) {
                        this.getEntity().getLargeIcon().setValue(largeIcon);
                    } else {
                        try {
                            this.getEntity().createLargeIcon(null).setValue(largeIcon);
                        }
                        catch (J2eeCreateException e) {
                            UiEntityGeneral.this.handleJ2eeCreateException("<large-icon> could not be created.", e);
                        }
                    }
                } else if (this.getEntity().getLargeIcon() != null) {
                    this.getEntity().removeLargeIcon();
                }
                UiEntityGeneral.super.handleEvent();
            }
        }

        public void setSmallIcon(String smallIcon) {
            if (this.getEntity() != null) {
                if (smallIcon.trim().length() != 0) {
                    if (this.getEntity().getSmallIcon() != null) {
                        this.getEntity().getSmallIcon().setValue(smallIcon);
                    } else {
                        try {
                            this.getEntity().createSmallIcon(null).setValue(smallIcon);
                        }
                        catch (J2eeCreateException e) {
                            UiEntityGeneral.this.handleJ2eeCreateException("<small-icon> could not be created.", e);
                        }
                    }
                } else if (this.getEntity().getSmallIcon() != null) {
                    this.getEntity().removeSmallIcon();
                }
                UiEntityGeneral.super.handleEvent();
            }
        }

        public IEntity getEntity() {
            return this.entity;
        }

        public void setEntity(IEntity entity) {
            this.entity = entity;
        }
    }
}

