/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.ejbjar.dd.ICmpField;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class UiEntityCmpField
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiResourceRef == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiResourceRef = UiEntityCmpField.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects.UiResourceRef")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiResourceRef));
    private IModifiedCallback myModifyCallback;
    private Text descriptionTextPane;
    private Text fieldNameTextField;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiResourceRef;

    public void initContainer(IGridLayoutPane userArea) {
        ICmpField cmpField = (ICmpField)this.getData();
        userArea.addTextLabel("Field name");
        this.fieldNameTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setFieldNameTextField(this.fieldNameTextField);
        userArea.addTextLabel("Description");
        this.descriptionTextPane = userArea.addTextPane("", false, true, userArea.createGridLayoutData(4, 4, true, true, 1, 1));
        this.setDescriptionTextPane(this.descriptionTextPane);
        this.decorateControls();
    }

    private void decorateControls() {
        this.getDescriptionTextPane().addModifyListener(this.getModifyAdapterSingleton());
        this.getFieldNameTextField().addModifyListener((ModifyListener)new FieldNameModifyAdapter());
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    public Text getFieldNameTextField() {
        return this.fieldNameTextField;
    }

    protected void updateEditableBehavior() {
        if (this.getDescriptionTextPane() != null) {
            this.getDescriptionTextPane().setEditable(this.isEditable());
        }
    }

    public void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    public void setFieldNameTextField(Text fieldNameTextField) {
        this.fieldNameTextField = fieldNameTextField;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        ICmpField cmpField = this.getCmpField();
        if (cmpField != null) {
            if (!this.getDescriptionTextPane().equals("")) {
                if (cmpField.getDescription() == null) {
                    try {
                        cmpField.createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("", e);
                    }
                }
                cmpField.getDescription().setValue(this.getDescriptionTextPane().getText());
            }
            this.refreshFieldNameFromUI();
        }
    }

    private void refreshFieldNameFromUI() {
        ICmpField cmpField = this.getCmpField();
        if (cmpField != null) {
            if (cmpField.getFieldName() == null) {
                try {
                    cmpField.createFieldName(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("", e);
                }
            }
            if (!this.getFieldNameTextField().equals("")) {
                cmpField.getFieldName().setValue(this.getFieldNameTextField().getText());
            } else if (cmpField.getFieldName() != null) {
                cmpField.getFieldName().setValue("");
            }
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        ICmpField cmpField = this.getCmpField();
        if (cmpField == null || !(cmpField instanceof ICmpField)) {
            throw new IllegalArgumentException("No object of ICmpField found!");
        }
        this.getDescriptionTextPane().setText(cmpField.getDescription() != null ? cmpField.getDescription().getValue() : "");
        this.getFieldNameTextField().setText(cmpField.getFieldName() != null ? cmpField.getFieldName().getValue() : "");
        this.stopRefreshingUI();
    }

    protected ICmpField getCmpField() {
        IIdentifiable identifiable;
        ICmpField ret = null;
        if (this.getData() instanceof TreeNode && (identifiable = ((TreeNode)this.getData()).getIdentifiable()) instanceof ICmpField) {
            ret = (ICmpField)identifiable;
        }
        return ret;
    }

    public void setModifyCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof TreeNode)) {
            ret = "No object of TreeNode found!";
        }
        return ret;
    }

    protected void handleFieldNameEvent() {
        if (!this.isRefreshingUI()) {
            this.refreshFieldNameFromUI();
            super.handleEvent();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FieldNameModifyAdapter
    implements ModifyListener {
        private FieldNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UiEntityCmpField.this.handleFieldNameEvent();
        }
    }
}

