/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ejbjar.dd.IEjbJar;
import com.tssap.j2ee.model.ejbjar.dd.IEnterpriseBeans;
import com.tssap.j2ee.model.ejbjar.dd.IEntity;
import com.tssap.j2ee.model.ejbjar.dd.IMethodParam;
import com.tssap.j2ee.model.ejbjar.dd.IMethodParams;
import com.tssap.j2ee.model.ejbjar.dd.IQuery;
import com.tssap.j2ee.model.ejbjar.dd.IResultTypeMapping;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.EntityBeanQueryWrapper;
import com.tssap.j2ee.ui.ejbjar.ejbql.EjbQlValidationImpl;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.trace.ui.UserOutputViews;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

public class UiEntityBeanQuery
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEntityBeanQuery == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEntityBeanQuery = UiEntityBeanQuery.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects.UiEntityBeanQuery")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEntityBeanQuery));
    private IModifiedCallback myModifyCallback;
    private Text descriptionTextPane;
    private Text methodNameTextField;
    private Text methodParamsTextField;
    private Text resultTypeMappingTextField;
    private Button resultTypeMappingCheckbox;
    private Button resultTypeMappingLocalRadiobutton;
    private Button resultTypeMappingRemoteRadiobutton;
    private Button validateEjbQlPushButton;
    private Text ejbQlTextField;
    private Text ejbqlValidationTf;
    private IResultTypeMapping resultTypeMapping;
    private static final String TEXT_QUERY_METHOD_NAME = "Query method name";
    private static final String TEXT_RESULT_TYPE_MAPPING = "Result Type Mapping";
    private static final String TEXT_LOCAL = "Local";
    private static final String TEXT_REMOTE = "Remote";
    private static final String TEXT_EJB_QL = "EJB QL Statement";
    private static final String TEXT_VALIDATE_EJB_QL = "validate";
    private static final String TEXT_DESCR = "Description";
    private static final String TEXT_METHOD_PARAMS = "Method parameters      ";
    private static final String TEXT_MESSAGE_VALID = "EJB QL Statement is valid.";
    private static final String TEXT_MESSAGE_INVALID = "EJB QL statement is invalid.";
    private static final String TEXT_MESSAGE_GEN_USER_OUT = "See General User Output View for details.";
    public static final String MARKER = "com.tssap.j2ee.ui.ejbjar.ejbqlproblemmarker";
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEntityBeanQuery;

    public UiEntityBeanQuery(IModifiedCallback ejbJarEnterpriseBeansPage) {
        this.setMyModifyCallback(ejbJarEnterpriseBeansPage);
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane leftGlp = userArea.addGridLayoutPane(5, userArea.createGridLayoutData(4, 4, true, true));
        leftGlp.addTextLabel(TEXT_QUERY_METHOD_NAME, leftGlp.createGridLayoutData(4, 4, false, false, 2, 1));
        this.methodNameTextField = leftGlp.addTextField("", false, leftGlp.createGridLayoutData(4, 4, true, false, 3, 1));
        this.setMethodNameTextField(this.methodNameTextField);
        leftGlp.addTextLabel("Method parameters", leftGlp.createGridLayoutData(4, 4, false, false, 2, 1));
        this.methodParamsTextField = leftGlp.addTextField("", true, leftGlp.createGridLayoutData(4, 4, true, false, 3, 1));
        this.setMethodParamsTextField(this.methodParamsTextField);
        this.resultTypeMappingCheckbox = leftGlp.addCheckBox(TEXT_RESULT_TYPE_MAPPING, false, leftGlp.createGridLayoutData(4, 4, true, false, 5, 1));
        this.setResultTypeMappingCheckbox(this.resultTypeMappingCheckbox);
        this.resultTypeMappingLocalRadiobutton = leftGlp.addRadioButton(TEXT_LOCAL, leftGlp.createGridLayoutData(4, 4, true, false, 5, 1));
        this.setResultTypeMappingLocalRadiobutton(this.resultTypeMappingLocalRadiobutton);
        this.resultTypeMappingRemoteRadiobutton = leftGlp.addRadioButton(TEXT_REMOTE, leftGlp.createGridLayoutData(4, 4, true, false, 5, 1));
        this.setResultTypeMappingRemoteRadiobutton(this.resultTypeMappingRemoteRadiobutton);
        leftGlp.addPlaceholder(5, 1);
        leftGlp.addTextLabel(TEXT_EJB_QL, leftGlp.createGridLayoutData(4, 4, false, false, 5, 1));
        this.ejbQlTextField = leftGlp.addTextPane("", false, leftGlp.createGridLayoutData(4, 4, true, true, 5, 1));
        this.setEjbQlTextField(this.ejbQlTextField);
        this.validateEjbQlPushButton = leftGlp.addPushButton(TEXT_VALIDATE_EJB_QL, leftGlp.createGridLayoutData(1, 4, false, false, 1, 1));
        this.validateEjbQlPushButton.setEnabled(false);
        this.setValidateEjbQlPushButton(this.validateEjbQlPushButton);
        this.ejbqlValidationTf = leftGlp.addTextField("", true, leftGlp.createGridLayoutData(4, 4, true, false, 4, 1));
        this.setEjbqlValidationTf(this.ejbqlValidationTf);
        leftGlp.addPlaceholder(5, 1);
        leftGlp.addTextLabel(TEXT_DESCR, leftGlp.createGridLayoutData(4, 4, true, false, 5, 1));
        this.descriptionTextPane = leftGlp.addTextPane("", false, true, leftGlp.createGridLayoutData(4, 4, true, true, 5, 1));
        this.setDescriptionTextPane(this.descriptionTextPane);
        this.decorateControls();
    }

    private void decorateControls() {
        SelectionAdapter mySelectionAdapter = new SelectionAdapter();
        this.getDescriptionTextPane().addModifyListener(this.getModifyAdapterSingleton());
        this.getEjbQlTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getValidateEjbQlPushButton().addSelectionListener((SelectionListener)new EjbQlSelectionAdapter());
        this.getMethodNameTextField().addModifyListener((ModifyListener)new MethodNameModifyAdapter());
        this.getResultTypeMappingCheckbox().addSelectionListener((SelectionListener)mySelectionAdapter);
        this.getResultTypeMappingLocalRadiobutton().addSelectionListener((SelectionListener)mySelectionAdapter);
        this.getResultTypeMappingRemoteRadiobutton().addSelectionListener((SelectionListener)mySelectionAdapter);
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    private Text getEjbQlTextField() {
        return this.ejbQlTextField;
    }

    private Text getMethodNameTextField() {
        return this.methodNameTextField;
    }

    private Text getResultTypeMappingTextField() {
        return this.resultTypeMappingTextField;
    }

    private void setEjbQlTextField(Text ejbQlTextField) {
        this.ejbQlTextField = ejbQlTextField;
    }

    private void setMethodNameTextField(Text methodNameTextField) {
        this.methodNameTextField = methodNameTextField;
    }

    private void setResultTypeMappingTextField(Text resultTypeMappingTextField) {
        this.resultTypeMappingTextField = resultTypeMappingTextField;
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        IQuery query = this.getQuery();
        if (query != null) {
            if (this.getDescriptionTextPane().getText().trim().length() != 0) {
                if (query.getDescription() == null) {
                    try {
                        query.createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("", e);
                    }
                }
                query.getDescription().setValue(this.getDescriptionTextPane().getText().trim());
            } else if (query.getDescription() != null) {
                query.removeDescription();
            }
            if (!this.getEjbQlTextField().equals("")) {
                if (query.getEjbQl() == null) {
                    try {
                        query.createEjbQl(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("", e);
                    }
                }
                query.getEjbQl().setValue(this.getEjbQlTextField().getText().trim());
            }
            if (this.getResultTypeMappingCheckbox().getSelection()) {
                if (this.getResultTypeMappingLocalRadiobutton() != null && this.getResultTypeMappingLocalRadiobutton().getSelection()) {
                    if (query.getResultTypeMapping() == null) {
                        try {
                            this.resultTypeMapping = query.createResultTypeMapping(null);
                        }
                        catch (J2eeCreateException e) {
                            this.handleJ2eeCreateException("<result-type-mapping> tag could not be created.", e);
                        }
                        query.getResultTypeMapping().setValue(TEXT_LOCAL);
                    }
                } else if (this.getResultTypeMappingRemoteRadiobutton() != null && this.getResultTypeMappingRemoteRadiobutton().getSelection() && query.getResultTypeMapping() == null) {
                    try {
                        this.resultTypeMapping = query.createResultTypeMapping(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<result-type-mapping> tag could not be created.", e);
                    }
                    query.getResultTypeMapping().setValue(TEXT_REMOTE);
                }
            } else {
                if (query.getResultTypeMapping() != null) {
                    query.removeResultTypeMapping();
                }
                this.disableResultTypeMappingPart();
            }
            if (query.getQueryMethod() == null) {
                try {
                    query.createQueryMethod(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("", e);
                }
            }
            this.refreshQueryMethodNameFromUI();
        }
    }

    private void refreshQueryMethodNameFromUI() {
        IQuery query = this.getQuery();
        if (query != null && query.getQueryMethod() != null) {
            if (query.getQueryMethod().getMethodName() == null) {
                try {
                    query.getQueryMethod().createMethodName(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("", e);
                }
            }
            if (!this.getMethodNameTextField().getText().trim().equals("")) {
                query.getQueryMethod().getMethodName().setValue(this.getMethodNameTextField().getText().trim());
            } else {
                query.getQueryMethod().getMethodName().setValue("");
            }
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        IQuery query = this.getQuery();
        if (query != null) {
            this.getDescriptionTextPane().setText(query.getDescription() != null ? query.getDescription().getValue() : "");
            this.getMethodNameTextField().setText(query.getQueryMethod() != null && query.getQueryMethod().getMethodName() != null ? query.getQueryMethod().getMethodName().getValue() : "");
            if (query.getResultTypeMapping() != null) {
                this.getResultTypeMappingCheckbox().setSelection(true);
                this.getResultTypeMappingLocalRadiobutton().setEnabled(true);
                this.getResultTypeMappingRemoteRadiobutton().setEnabled(true);
                if (query.getResultTypeMapping().getValue().equalsIgnoreCase(TEXT_LOCAL)) {
                    this.getResultTypeMappingLocalRadiobutton().setSelection(true);
                    this.getResultTypeMappingRemoteRadiobutton().setSelection(false);
                } else if (query.getResultTypeMapping().getValue().equalsIgnoreCase(TEXT_REMOTE)) {
                    this.getResultTypeMappingLocalRadiobutton().setSelection(false);
                    this.getResultTypeMappingRemoteRadiobutton().setSelection(true);
                } else {
                    this.disableResultTypeMappingPart();
                }
            } else {
                this.disableResultTypeMappingPart();
            }
            if (query.getEjbQl() != null && !query.getEjbQl().getValue().equals("")) {
                this.getValidateEjbQlPushButton().setEnabled(true);
            }
            this.getEjbQlTextField().setText(query.getEjbQl() != null ? query.getEjbQl().getValue() : "");
            IMethodParams methodParams = query.getQueryMethod().getMethodParams();
            if (query.getQueryMethod() != null && methodParams != null) {
                IMethodParam[] methodParamArr = methodParams.getMethodParams();
                StringBuffer methodParamStringBf = new StringBuffer();
                if (methodParamArr != null && methodParamArr.length > 0) {
                    int i = 0;
                    while (i < methodParamArr.length) {
                        if (i != methodParamArr.length - 1) {
                            methodParamStringBf.append(methodParamArr[i].getValue()).append(", ");
                        } else {
                            methodParamStringBf.append(methodParamArr[i].getValue());
                        }
                        ++i;
                    }
                }
                if (methodParamStringBf.length() > 0) {
                    this.getMethodParamsTextField().setText(methodParamStringBf.toString());
                }
            }
        } else {
            throw new IllegalArgumentException("No object of IQuery found!");
        }
        this.stopRefreshingUI();
    }

    private void disableResultTypeMappingPart() {
        this.getResultTypeMappingCheckbox().setSelection(false);
        this.getResultTypeMappingLocalRadiobutton().setEnabled(false);
        this.getResultTypeMappingRemoteRadiobutton().setEnabled(false);
        this.getResultTypeMappingLocalRadiobutton().setSelection(true);
        this.getResultTypeMappingRemoteRadiobutton().setSelection(false);
    }

    private IEjbJar getEjbJar() {
        IEjbJar ejbJar = null;
        EntityBeanQueryWrapper entityBeanQueryWrapper = this.getEntityBeanQueryWrapper();
        if (entityBeanQueryWrapper != null) {
            ejbJar = entityBeanQueryWrapper.getEjbJar();
        }
        return ejbJar;
    }

    private EntityBeanQueryWrapper getEntityBeanQueryWrapper() {
        EntityBeanQueryWrapper entityBeanQueryWrapper = null;
        if (this.getData() instanceof EntityBeanQueryWrapper) {
            entityBeanQueryWrapper = (EntityBeanQueryWrapper)this.getData();
        }
        return entityBeanQueryWrapper;
    }

    protected IQuery getQuery() {
        TreeNode entityBeanQueryTreeNode;
        IQuery ret = null;
        EntityBeanQueryWrapper entityBeanQueryWrapper = this.getEntityBeanQueryWrapper();
        if (entityBeanQueryWrapper != null && (entityBeanQueryTreeNode = entityBeanQueryWrapper.getEntityBeanQueryTreeNode()) != null) {
            ret = (IQuery)entityBeanQueryTreeNode.getIdentifiable();
        }
        return ret;
    }

    public void setModifyCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof EntityBeanQueryWrapper)) {
            ret = "No object of EntityBeanQueryWrapper found!";
        }
        return ret;
    }

    protected void handleMethodNameEvent() {
        if (!this.isRefreshingUI()) {
            this.refreshQueryMethodNameFromUI();
            super.handleEvent();
        }
    }

    private Button getResultTypeMappingCheckbox() {
        return this.resultTypeMappingCheckbox;
    }

    private Button getResultTypeMappingLocalRadiobutton() {
        return this.resultTypeMappingLocalRadiobutton;
    }

    private Button getResultTypeMappingRemoteRadiobutton() {
        return this.resultTypeMappingRemoteRadiobutton;
    }

    private void setResultTypeMappingCheckbox(Button resultTypeMappingCheckbox) {
        this.resultTypeMappingCheckbox = resultTypeMappingCheckbox;
    }

    private void setResultTypeMappingLocalRadiobutton(Button resultTypeMappingLocalRadiobutton) {
        this.resultTypeMappingLocalRadiobutton = resultTypeMappingLocalRadiobutton;
    }

    private void setResultTypeMappingRemoteRadiobutton(Button resultTypeMappingRemoteRadiobutton) {
        this.resultTypeMappingRemoteRadiobutton = resultTypeMappingRemoteRadiobutton;
    }

    protected void handleEvent() {
        if (!this.isRefreshingUI()) {
            if (this.getQuery() != null) {
                if (this.getResultTypeMappingCheckbox().getSelection()) {
                    this.getResultTypeMappingLocalRadiobutton().setEnabled(true);
                    this.getResultTypeMappingRemoteRadiobutton().setEnabled(true);
                    if (this.getResultTypeMappingLocalRadiobutton().getSelection()) {
                        try {
                            if (this.getQuery().getResultTypeMapping() == null) {
                                this.resultTypeMapping = this.getQuery().createResultTypeMapping(null);
                            }
                            this.getQuery().getResultTypeMapping().setValue(TEXT_LOCAL);
                        }
                        catch (J2eeCreateException e) {
                            this.handleJ2eeCreateException("<result-type-mapping> tag could not be created.", e);
                        }
                    } else if (this.getResultTypeMappingRemoteRadiobutton().getSelection()) {
                        try {
                            if (this.getQuery().getResultTypeMapping() == null) {
                                this.resultTypeMapping = this.getQuery().createResultTypeMapping(null);
                            }
                            this.getQuery().getResultTypeMapping().setValue(TEXT_REMOTE);
                        }
                        catch (J2eeCreateException e) {
                            this.handleJ2eeCreateException("<result-type-mapping> tag could not be created.", e);
                        }
                    }
                } else {
                    this.getResultTypeMappingLocalRadiobutton().setEnabled(false);
                    this.getResultTypeMappingRemoteRadiobutton().setEnabled(false);
                }
                if (this.getEjbQlTextField().getText() != null && !this.getEjbQlTextField().getText().equals("")) {
                    this.getValidateEjbQlPushButton().setEnabled(true);
                } else {
                    this.getValidateEjbQlPushButton().setEnabled(false);
                }
            }
            super.handleEvent();
        }
    }

    private Button getValidateEjbQlPushButton() {
        return this.validateEjbQlPushButton;
    }

    private void setValidateEjbQlPushButton(Button validateEjbQlPushButton) {
        this.validateEjbQlPushButton = validateEjbQlPushButton;
    }

    private IModifiedCallback getMyModifyCallback() {
        return this.myModifyCallback;
    }

    private void setMyModifyCallback(IModifiedCallback myModifyCallback) {
        this.myModifyCallback = myModifyCallback;
    }

    public String okToLeave() {
        String message = super.okToLeave();
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK() && !status.isInfo()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        if (!this.beansHaveAbstractSchemaName(this.getEjbJar())) {
            status.setInfo("Please assign abstract-schema-names to referenced entity beans first before entering ejbql statements.");
        }
        return status;
    }

    private boolean beansHaveAbstractSchemaName(IEjbJar ejbJar) {
        boolean ret = true;
        if (ejbJar != null) {
            IEnterpriseBeans ejbs = ejbJar.getEnterpriseBeans();
            IEntity[] entityArr = ejbs.getEntitys();
            int i = 0;
            while (i < entityArr.length) {
                if (entityArr[i].getAbstractSchemaName() == null || entityArr[i].getAbstractSchemaName().equals("")) {
                    ret = false;
                }
                ++i;
            }
        } else {
            tracer.error("beansHaveAbstractSchemaName(IEjbJar)", "Input parameter IEjbJar is null.");
        }
        return ret;
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.getMethodNameTextField() != null) {
            this.getMethodNameTextField().setEditable(false);
        }
        if (this.getMethodParamsTextField() != null) {
            this.getMethodParamsTextField().setEditable(false);
        }
        if (this.getEjbqlValidationTf() != null) {
            this.getEjbqlValidationTf().setEditable(false);
        }
        if (this.getResultTypeMappingCheckbox() != null && !this.getResultTypeMappingCheckbox().getSelection()) {
            this.disableResultTypeMappingPart();
        }
    }

    private Text getMethodParamsTextField() {
        return this.methodParamsTextField;
    }

    private void setMethodParamsTextField(Text text) {
        this.methodParamsTextField = text;
    }

    private Text getEjbqlValidationTf() {
        return this.ejbqlValidationTf;
    }

    private void setEjbqlValidationTf(Text text) {
        this.ejbqlValidationTf = text;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SelectionAdapter
    implements SelectionListener {
        private SelectionAdapter() {
        }

        public void widgetDefaultSelected(SelectionEvent evt) {
            UiEntityBeanQuery.this.handleEvent();
        }

        public void widgetSelected(SelectionEvent evt) {
            this.widgetDefaultSelected(evt);
        }
    }

    private class EjbQlSelectionAdapter
    implements SelectionListener {
        private EjbQlSelectionAdapter() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            String ejbQlQueryString;
            EjbQlValidationImpl ejbQlValidation;
            String[] errorMessagesArr;
            String[] methodInputParams = null;
            IMethodParams methodParams = UiEntityBeanQuery.this.getQuery().getQueryMethod().getMethodParams();
            if (methodParams != null) {
                IMethodParam[] methodParamArr = methodParams.getMethodParams();
                methodInputParams = new String[methodParamArr.length];
                int i = 0;
                while (i < methodParamArr.length) {
                    methodInputParams[i] = methodParamArr[i].getValue();
                    ++i;
                }
            }
            if ((errorMessagesArr = (ejbQlValidation = new EjbQlValidationImpl()).validateEjbQl(ejbQlQueryString = UiEntityBeanQuery.this.getEjbQlTextField().getText(), methodInputParams, UiEntityBeanQuery.this.getEjbJar())).length == 0) {
                UiEntityBeanQuery.this.getEjbqlValidationTf().setText(UiEntityBeanQuery.TEXT_MESSAGE_VALID);
                tracer.userOut(4, "EJB QL Statement is valid. (" + UiEntityBeanQuery.this.getEjbQlTextField().getText() + ")");
            } else {
                UiEntityBeanQuery.this.getEjbqlValidationTf().setText("EJB QL statement is invalid. See General User Output View for details.");
                int mess = 0;
                while (mess < errorMessagesArr.length) {
                    tracer.userOut(2, UiEntityBeanQuery.TEXT_MESSAGE_INVALID + errorMessagesArr[mess] + " (" + UiEntityBeanQuery.this.getEjbQlTextField().getText() + ")");
                    ++mess;
                }
            }
            UserOutputViews.activateGeneralUserOut();
        }
    }

    private class MethodNameModifyAdapter
    implements ModifyListener {
        private MethodNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UiEntityBeanQuery.this.handleMethodNameEvent();
        }
    }
}

