/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.ejbjar.dd.IEjbRef;
import com.tssap.j2ee.model.ejbjar.dd.IEnterpriseBean;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.EnterpriseBeansContentProvider;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class UiEjbRef
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEjbRef == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEjbRef = UiEjbRef.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects.UiEjbRef")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEjbRef));
    private static final String DEFAULT_TEXT_EJB_TYPE = "Please define the ejb type.";
    private static final String TXT_DUPLICATE_NAME = "Duplicate name. Please choose another ejb reference name.";
    private boolean isDuplicateEjbRefName = false;
    private IModifiedCallback myModifyCallback;
    private Text descriptionTextPane;
    private Text ejbRefNameTextField;
    private Text ejbTypeTextField;
    private Text homeTextField;
    private Text remoteTextField;
    private Text ejbLinkTextField;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEjbRef;

    public void initContainer(IGridLayoutPane userArea) {
        userArea.addTextLabel("EJB Reference Name");
        Text ejbRefNameTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEjbRefNameTextField(ejbRefNameTextField);
        userArea.addTextLabel("Description");
        this.descriptionTextPane = userArea.addTextPane("", false, true, userArea.createGridLayoutData(4, 4, true, true, 1, 1));
        this.setDescriptionTextPane(this.descriptionTextPane);
        userArea.addTextLabel("EJB Reference Type");
        this.ejbTypeTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEjbTypeTextField(this.ejbTypeTextField);
        userArea.addTextLabel("Home");
        this.homeTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setHomeTextField(this.homeTextField);
        userArea.addTextLabel("Remote");
        this.remoteTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setRemoteTextField(this.remoteTextField);
        userArea.addTextLabel("EJB Link");
        this.ejbLinkTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEjbLinkTextField(this.ejbLinkTextField);
        this.decorateControls();
    }

    private void decorateControls() {
        this.getDescriptionTextPane().addModifyListener(this.getModifyAdapterSingleton());
        this.getEjbRefNameTextField().addModifyListener((ModifyListener)new EjbRefNameModifyAdapter());
        this.getHomeTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getRemoteTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getEjbLinkTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getEjbTypeTextField().addModifyListener(this.getModifyAdapterSingleton());
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    private Text getHomeTextField() {
        return this.homeTextField;
    }

    private Text getEjbLinkTextField() {
        return this.ejbLinkTextField;
    }

    private Text getRemoteTextField() {
        return this.remoteTextField;
    }

    private void setHomeTextField(Text homeTextField) {
        this.homeTextField = homeTextField;
    }

    private void setEjbLinkTextField(Text ejbLinkTextField) {
        this.ejbLinkTextField = ejbLinkTextField;
    }

    private void setRemoteTextField(Text remoteTextField) {
        this.remoteTextField = remoteTextField;
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        IEjbRef ejbRef = this.getEjbRef();
        this.refreshEjbRefNameFromUI();
        if (ejbRef != null) {
            if (this.getDescriptionTextPane().getText().trim().length() != 0) {
                if (ejbRef.getDescription() == null) {
                    try {
                        ejbRef.createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("", e);
                    }
                }
                ejbRef.getDescription().setValue(this.getDescriptionTextPane().getText().trim());
            } else if (ejbRef.getDescription() != null) {
                ejbRef.removeDescription();
            }
            if (this.getEjbLinkTextField().getText().trim().length() != 0) {
                if (ejbRef.getEjbLink() == null) {
                    try {
                        ejbRef.createEjbLink(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<ejb-link> could not be created.", e);
                    }
                }
                ejbRef.getEjbLink().setValue(this.getEjbLinkTextField().getText().trim());
            } else if (ejbRef.getEjbLink() != null) {
                ejbRef.removeEjbLink();
            }
        }
    }

    private void refreshEjbRefNameFromUI() {
        IEnterpriseBean iejb;
        IEjbRef ejbRef = this.getEjbRef();
        if (ejbRef != null) {
            if (ejbRef.getEjbRefName() == null) {
                try {
                    ejbRef.createEjbRefName(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<ejb-ref-name> could not be created.", e);
                }
            }
            if (!this.getEjbRefNameTextField().equals("")) {
                ejbRef.getEjbRefName().setValue(this.getEjbRefNameTextField().getText().trim());
            } else if (ejbRef.getEjbRefName() != null) {
                ejbRef.getEjbRefName().setValue("");
            }
        }
        if ((iejb = this.getEnterpriseBean()) != null && iejb.getEjbRefs() != null) {
            IEjbRef[] ejbRefsArr = null;
            ejbRefsArr = iejb.getEjbRefs();
            int ejbRefsDuplicateCounter = 0;
            int i = 0;
            while (i < ejbRefsArr.length) {
                if (ejbRefsArr[i].getEjbRefName().getValue().equals(this.getEjbRefNameTextField().getText().trim())) {
                    ++ejbRefsDuplicateCounter;
                }
                if (ejbRefsDuplicateCounter > 1) {
                    this.setDuplicateEjbRefName(true);
                } else {
                    this.setDuplicateEjbRefName(false);
                }
                ++i;
            }
        } else {
            tracer.warning("refreshEjbRefNameFromUI()", "Problems with duplicate ejb local ref name validation occured.");
        }
    }

    protected IEjbRef getEjbRef() {
        IIdentifiable identifiable;
        IEjbRef ret = null;
        if (this.getData() instanceof TreeNode && (identifiable = ((TreeNode)this.getData()).getIdentifiable()) instanceof IEjbRef) {
            ret = (IEjbRef)identifiable;
        }
        return ret;
    }

    private IEnterpriseBean getEnterpriseBean() {
        IEnterpriseBean iejb = null;
        if (this.getData() instanceof TreeNode && ((TreeNode)this.getData()).getFolder() instanceof EnterpriseBeansContentProvider.EjbRefFolder) {
            iejb = ((EnterpriseBeansContentProvider.EjbRefFolder)((TreeNode)this.getData()).getFolder()).getEnterpriseBean();
        }
        return iejb;
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        IEjbRef ejbRef = this.getEjbRef();
        if (ejbRef instanceof IEjbRef && ejbRef != null) {
            this.getEjbRefNameTextField().setText(ejbRef.getEjbRefName() != null ? ejbRef.getEjbRefName().getValue() : "");
            this.getDescriptionTextPane().setText(ejbRef.getDescription() != null ? ejbRef.getDescription().getValue() : "");
            if (ejbRef.getEjbRefType() != null) {
                this.getEjbTypeTextField().setText(!ejbRef.getEjbRefType().getValue().equals(DEFAULT_TEXT_EJB_TYPE) && !ejbRef.getEjbRefType().getValue().equals("") ? ejbRef.getEjbRefType().getValue() : DEFAULT_TEXT_EJB_TYPE);
            }
        } else {
            throw new IllegalArgumentException("No object of IEjbRef found!");
        }
        this.getHomeTextField().setText(ejbRef.getHome() != null ? ejbRef.getHome().getValue() : "");
        this.getRemoteTextField().setText(ejbRef.getRemote() != null ? ejbRef.getRemote().getValue() : "");
        this.getEjbLinkTextField().setText(ejbRef.getEjbLink() != null ? ejbRef.getEjbLink().getValue() : "");
        this.stopRefreshingUI();
    }

    public void setModifyCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    private Text getEjbRefNameTextField() {
        return this.ejbRefNameTextField;
    }

    private void setEjbRefNameTextField(Text ejbRefNameTextField) {
        this.ejbRefNameTextField = ejbRefNameTextField;
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof TreeNode)) {
            ret = "No object of TreeNode found!";
        }
        return ret;
    }

    protected void handleEjbRefNameEvent() {
        if (!this.isRefreshingUI()) {
            this.refreshEjbRefNameFromUI();
            super.handleEvent();
        }
    }

    private Text getEjbTypeTextField() {
        return this.ejbTypeTextField;
    }

    private void setEjbTypeTextField(Text ejbTypeTextField) {
        this.ejbTypeTextField = ejbTypeTextField;
    }

    protected void updateEditableBehavior() {
        boolean editable = this.isEditable();
        if (this.getDescriptionTextPane() != null) {
            this.getDescriptionTextPane().setEditable(editable);
        }
        if (this.getEjbRefNameTextField() != null) {
            this.getEjbRefNameTextField().setEditable(editable);
        }
        if (this.getEjbLinkTextField() != null) {
            this.getEjbLinkTextField().setEditable(editable);
        }
    }

    public String okToLeave() {
        String ret = super.okToLeave();
        StatusWrapper validationStatus = this.isContentValid();
        if (validationStatus != null) {
            ret = validationStatus.getMessage();
        }
        return ret;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        if (this.isDuplicateEjbRefName()) {
            status.setError(TXT_DUPLICATE_NAME);
        }
        return status;
    }

    private boolean isDuplicateEjbRefName() {
        return this.isDuplicateEjbRefName;
    }

    private void setDuplicateEjbRefName(boolean b) {
        this.isDuplicateEjbRefName = b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EjbRefNameModifyAdapter
    implements ModifyListener {
        private EjbRefNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UiEjbRef.this.handleEjbRefNameEvent();
        }
    }
}

