/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.ejbjar.dd.IEjbLocalRef;
import com.tssap.j2ee.model.ejbjar.dd.IEnterpriseBean;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.EnterpriseBeansContentProvider;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class UiEjbLocalRef
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEjbLocalRef == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEjbLocalRef = UiEjbLocalRef.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.editorobjects.UiEjbLocalRef")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEjbLocalRef));
    private static final String DEFAULT_TEXT_EJB_TYPE = "Please define the ejb type.";
    private static final String TXT_DUPLICATE_NAME = "Duplicate name. Please choose another ejb local reference name.";
    private boolean isDuplicateEjbLocalRefName = false;
    private IModifiedCallback myModifyCallback;
    private Text descriptionTextPane;
    private Text ejbRefNameTextField;
    private Text ejbRefTypeTextField;
    private Text localHomeTextField;
    private Text localTextField;
    private Text ejbLinkTextField;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$editorobjects$UiEjbLocalRef;

    public void initContainer(IGridLayoutPane userArea) {
        userArea.addTextLabel("EJB Reference Name");
        Text ejbRefNameTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEjbRefNameTextField(ejbRefNameTextField);
        userArea.addTextLabel("Description");
        this.descriptionTextPane = userArea.addTextPane("", false, true, userArea.createGridLayoutData(4, 4, true, true, 1, 1));
        this.setDescriptionTextPane(this.descriptionTextPane);
        userArea.addTextLabel("EJB Reference Type");
        this.ejbRefTypeTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEjbRefTypeTextField(this.ejbRefTypeTextField);
        userArea.addTextLabel("Local Home");
        this.localHomeTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setLocalHomeTextField(this.localHomeTextField);
        userArea.addTextLabel("Local");
        this.localTextField = userArea.addTextField("", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setLocalTextField(this.localTextField);
        userArea.addTextLabel("EJB Link");
        Text ejbLinkTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEjbLinkTextField(ejbLinkTextField);
        this.decorateControls();
    }

    private void decorateControls() {
        this.getDescriptionTextPane().addModifyListener(this.getModifyAdapterSingleton());
        this.getEjbRefNameTextField().addModifyListener((ModifyListener)new EjbRefNameModifyAdapter());
        this.getEjbRefTypeTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getEjbLinkTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getLocalHomeTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getLocalTextField().addModifyListener(this.getModifyAdapterSingleton());
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    private Text getLocalHomeTextField() {
        return this.localHomeTextField;
    }

    private Text getEjbLinkTextField() {
        return this.ejbLinkTextField;
    }

    private Text getLocalTextField() {
        return this.localTextField;
    }

    private void setLocalHomeTextField(Text localHomeTextField) {
        this.localHomeTextField = localHomeTextField;
    }

    private void setEjbLinkTextField(Text ejbLinkTextField) {
        this.ejbLinkTextField = ejbLinkTextField;
    }

    private void setLocalTextField(Text localTextField) {
        this.localTextField = localTextField;
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        IEjbLocalRef ejbLocalRef = this.getEjbLocalRef();
        if (ejbLocalRef != null) {
            if (this.getDescriptionTextPane().getText().trim().length() != 0) {
                if (ejbLocalRef.getDescription() == null) {
                    try {
                        ejbLocalRef.createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<description> could not be created.", e);
                    }
                }
                ejbLocalRef.getDescription().setValue(this.getDescriptionTextPane().getText().trim());
            } else if (ejbLocalRef.getDescription() != null) {
                ejbLocalRef.removeDescription();
            }
            this.refreshEjbRefNameFromUI();
            if (this.getEjbLinkTextField().getText().trim().length() != 0) {
                if (ejbLocalRef.getEjbLink() == null) {
                    try {
                        ejbLocalRef.createEjbLink(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<ejb-link> could not be created.", e);
                    }
                }
                ejbLocalRef.getEjbLink().setValue(this.getEjbLinkTextField().getText());
            } else if (ejbLocalRef.getEjbLink() != null) {
                ejbLocalRef.removeEjbLink();
            }
        }
    }

    private void refreshEjbRefNameFromUI() {
        IEnterpriseBean iejb;
        IEjbLocalRef ejbLocalRef = this.getEjbLocalRef();
        if (ejbLocalRef != null) {
            if (!this.getEjbRefNameTextField().getText().trim().equals("")) {
                if (ejbLocalRef.getEjbRefName() == null) {
                    try {
                        ejbLocalRef.createEjbRefName(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<ejb-ref-name> could not be created.", e);
                    }
                }
                ejbLocalRef.getEjbRefName().setValue(this.getEjbRefNameTextField().getText().trim());
            } else if (ejbLocalRef.getEjbRefName() != null) {
                ejbLocalRef.getEjbRefName().setValue("");
            }
        }
        if ((iejb = this.getEnterpriseBean()) != null && iejb.getEjbLocalRefs() != null) {
            IEjbLocalRef[] ejbRefsArr = null;
            ejbRefsArr = iejb.getEjbLocalRefs();
            int ejbRefsDuplicateCounter = 0;
            int i = 0;
            while (i < ejbRefsArr.length) {
                if (ejbRefsArr[i].getEjbRefName().getValue().equals(this.getEjbRefNameTextField().getText())) {
                    ++ejbRefsDuplicateCounter;
                }
                if (ejbRefsDuplicateCounter > 1) {
                    this.setDuplicateEjbLocalRefName(true);
                } else {
                    this.setDuplicateEjbLocalRefName(false);
                }
                ++i;
            }
        } else {
            tracer.warning("refreshEjbRefNameFromUI()", "Problems with duplicate ejb local ref name validation occured.");
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        IEjbLocalRef ejbLocalRef = this.getEjbLocalRef();
        if (ejbLocalRef != null && ejbLocalRef instanceof IEjbLocalRef) {
            this.getEjbRefNameTextField().setText(ejbLocalRef.getEjbRefName() != null ? ejbLocalRef.getEjbRefName().getValue() : "");
            this.getDescriptionTextPane().setText(ejbLocalRef.getDescription() != null ? ejbLocalRef.getDescription().getValue() : "");
            if (ejbLocalRef.getEjbRefType() != null) {
                this.getEjbRefTypeTextField().setText(!ejbLocalRef.getEjbRefType().getValue().equals(DEFAULT_TEXT_EJB_TYPE) && !ejbLocalRef.getEjbRefType().getValue().equals("") ? ejbLocalRef.getEjbRefType().getValue() : DEFAULT_TEXT_EJB_TYPE);
            }
        } else {
            throw new IllegalArgumentException("No object of IEjbLocalRef found!");
        }
        this.getLocalHomeTextField().setText(ejbLocalRef.getLocalHome() != null ? ejbLocalRef.getLocalHome().getValue() : "");
        this.getLocalTextField().setText(ejbLocalRef.getLocal() != null ? ejbLocalRef.getLocal().getValue() : "");
        this.getEjbLinkTextField().setText(ejbLocalRef.getEjbLink() != null ? ejbLocalRef.getEjbLink().getValue() : "");
        this.stopRefreshingUI();
    }

    protected IEjbLocalRef getEjbLocalRef() {
        IIdentifiable identifiable;
        IEjbLocalRef ret = null;
        if (this.getData() instanceof TreeNode && (identifiable = ((TreeNode)this.getData()).getIdentifiable()) instanceof IEjbLocalRef) {
            ret = (IEjbLocalRef)identifiable;
        }
        return ret;
    }

    private IEnterpriseBean getEnterpriseBean() {
        IEnterpriseBean iejb = null;
        if (this.getData() instanceof TreeNode && ((TreeNode)this.getData()).getFolder() instanceof EnterpriseBeansContentProvider.EjbLocalRefFolder) {
            iejb = ((EnterpriseBeansContentProvider.EjbLocalRefFolder)((TreeNode)this.getData()).getFolder()).getEnterpriseBean();
        }
        return iejb;
    }

    public void setModifyCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    public Text getEjbRefNameTextField() {
        return this.ejbRefNameTextField;
    }

    public void setEjbRefNameTextField(Text ejbRefNameTextField) {
        this.ejbRefNameTextField = ejbRefNameTextField;
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof TreeNode)) {
            ret = "No object of TreeNode found!";
        }
        return ret;
    }

    protected void handleEjbRefNameEvent() {
        if (!this.isRefreshingUI()) {
            this.refreshEjbRefNameFromUI();
            super.handleEvent();
        }
    }

    private Text getEjbRefTypeTextField() {
        return this.ejbRefTypeTextField;
    }

    private void setEjbRefTypeTextField(Text ejbRefTypeTextField) {
        this.ejbRefTypeTextField = ejbRefTypeTextField;
    }

    protected void updateEditableBehavior() {
        boolean editable = this.isEditable();
        if (this.getDescriptionTextPane() != null) {
            this.getDescriptionTextPane().setEditable(editable);
        }
        if (this.getEjbRefNameTextField() != null) {
            this.getEjbRefNameTextField().setEditable(editable);
        }
        if (this.getEjbLinkTextField() != null) {
            this.getEjbLinkTextField().setEditable(editable);
        }
    }

    public String okToLeave() {
        String ret = super.okToLeave();
        StatusWrapper validationStatus = this.isContentValid();
        if (validationStatus != null) {
            ret = validationStatus.getMessage();
        }
        return ret;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        if (this.isDuplicateEjbLocalRefName()) {
            status.setError(TXT_DUPLICATE_NAME);
        }
        return status;
    }

    private boolean isDuplicateEjbLocalRefName() {
        return this.isDuplicateEjbLocalRefName;
    }

    private void setDuplicateEjbLocalRefName(boolean b) {
        this.isDuplicateEjbLocalRefName = b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EjbRefNameModifyAdapter
    implements ModifyListener {
        private EjbRefNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UiEjbLocalRef.this.handleEjbRefNameEvent();
        }
    }
}

