/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.ejb.IEjbMethod;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejb.impl.FinderMethod;
import com.tssap.j2ee.model.ejb.impl.SelectMethod;
import com.tssap.j2ee.model.ejbjar.IEjbAssemblyProject;
import com.tssap.j2ee.model.ejbjar.dd.ICmpField;
import com.tssap.j2ee.model.ejbjar.dd.IEjbJar;
import com.tssap.j2ee.model.ejbjar.dd.IEjbLink;
import com.tssap.j2ee.model.ejbjar.dd.IEjbLocalRef;
import com.tssap.j2ee.model.ejbjar.dd.IEjbRef;
import com.tssap.j2ee.model.ejbjar.dd.IEjbRefName;
import com.tssap.j2ee.model.ejbjar.dd.IEjbRefType;
import com.tssap.j2ee.model.ejbjar.dd.IEnterpriseBean;
import com.tssap.j2ee.model.ejbjar.dd.IEnterpriseBeans;
import com.tssap.j2ee.model.ejbjar.dd.IEntity;
import com.tssap.j2ee.model.ejbjar.dd.IEnvEntry;
import com.tssap.j2ee.model.ejbjar.dd.IHome;
import com.tssap.j2ee.model.ejbjar.dd.ILocal;
import com.tssap.j2ee.model.ejbjar.dd.ILocalHome;
import com.tssap.j2ee.model.ejbjar.dd.IMessageDriven;
import com.tssap.j2ee.model.ejbjar.dd.IMethodName;
import com.tssap.j2ee.model.ejbjar.dd.IMethodParams;
import com.tssap.j2ee.model.ejbjar.dd.IQuery;
import com.tssap.j2ee.model.ejbjar.dd.IQueryMethod;
import com.tssap.j2ee.model.ejbjar.dd.IRemote;
import com.tssap.j2ee.model.ejbjar.dd.IResourceEnvRef;
import com.tssap.j2ee.model.ejbjar.dd.IResourceRef;
import com.tssap.j2ee.model.ejbjar.dd.IRoleLink;
import com.tssap.j2ee.model.ejbjar.dd.IRoleName;
import com.tssap.j2ee.model.ejbjar.dd.ISecurityIdentity;
import com.tssap.j2ee.model.ejbjar.dd.ISecurityRoleRef;
import com.tssap.j2ee.model.ejbjar.dd.ISession;
import com.tssap.j2ee.ui.EjbRefDialogTreeContentProvider;
import com.tssap.j2ee.ui.EjbRefDialogTreeLabelProvider;
import com.tssap.j2ee.ui.EnterpriseBeanObj;
import com.tssap.j2ee.ui.Folder;
import com.tssap.j2ee.ui.SecurityRolesDialog;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.ejbjar.editor.IEjbJarHolder;
import com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.EnterpriseBeansContentProvider;
import com.tssap.util.core.IFilter;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.dialog.ObjectSelectionDialog;
import com.tssap.util.ui.dialog.StructuredObjectSelectionDialog;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class EnterpriseBeansAddRemoveCallback
implements IAddRemoveCallback {
    private static final String TXT_SELECT_EJBS_FROM_LIST = "Select EJBs from the list below.";
    private static final String TXT_NO_EJBS_TO_BE_REFERENCED = "No EJBs available to reference.";
    private static final String TXT_NO_EJBS_TO_BE_REFERENCED_REM = "In order to add EJB References, there must be EJBs available in the workspace, which have methods in the remote interface. ";
    private static final String TXT_NO_EJBS_TO_BE_REFERENCED_LOC = "In order to add EJB Local References, there must be EJBs available in the workspace, which have methods in the local interface. ";
    private static final String TXT_HOW_TO_ADD_EJBS = "\n\nEJBs can be added in J2EE Explorer view.\nSelect an EJB Module Project and choose New... from the context menu.";
    private static final String TXT_SELECT_EJBS = "Select EJBs";
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$EnterpriseBeansAddRemoveCallback == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$EnterpriseBeansAddRemoveCallback = EnterpriseBeansAddRemoveCallback.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.enterprisebeanpage.EnterpriseBeansAddRemoveCallback")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$EnterpriseBeansAddRemoveCallback));
    private static final int SESSION = 1;
    private static final int ENTITY = 2;
    private static final int MESSAGE_DRIVEN = 3;
    private static final int ENV_ENTRY = 4;
    private static final int EJB_REF = 5;
    private static final int EJB_LOCAL_REF = 6;
    private static final int SECURITY_ROLE_REF = 7;
    private static final int RESOURCE_REF = 8;
    private static final int RESOURCE_ENV_REF = 9;
    private static final int CMP_FIELD = 10;
    private static final int QUERY = 11;
    private static final int SECURITY_IDENTITY = 12;
    protected static final int EJB_REF_ADD = 1;
    protected static final int EJB_LOCAL_REF_ADD = 2;
    private EnterpriseBeansContentProvider myTreeContentProvider = null;
    private IProject project;
    private String projectName = null;
    private IEjbJarHolder ejbJarHolder = null;
    private StructuredObjectSelectionDialog diag = null;
    private EjbRefDialogTreeContentProvider ejbRefDialogTCP = null;
    private String mDDEjbName = null;
    private String mDDEjbType = null;
    private String mDDHome = null;
    private String mDDRemote = null;
    private String mDDLocal = null;
    private String mDDLocalHome = null;
    private String mDDEjbLink = null;
    private String mDefaultEjbRefName = null;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$enterprisebeanpage$EnterpriseBeansAddRemoveCallback;

    public EnterpriseBeansAddRemoveCallback(IProject project, IEjbJarHolder holder, EnterpriseBeansContentProvider treeContentProvider) {
        this.project = project;
        this.setEjbJarHolder(holder);
        this.setTreeContentProvider(treeContentProvider);
    }

    public Object addElement(Object currentSelection) {
        Object ret = null;
        int type = 0;
        type = this.defineType(currentSelection);
        if (currentSelection instanceof EnterpriseBeansContentProvider.EnvEntryFolder) {
            IEnvEntry envEntry = (IEnvEntry)this.addChild(((EnterpriseBeansContentProvider.EnvEntryFolder)currentSelection).myEnterpriseBean, type);
            ret = ((EnterpriseBeansContentProvider.EnvEntryFolder)currentSelection).getTreeNode(envEntry);
        } else if (currentSelection instanceof TreeNode && ((TreeNode)currentSelection).getIdentifiable() instanceof IEnvEntry) {
            IEnvEntry envEntry = (IEnvEntry)this.addChild(((EnterpriseBeansContentProvider.EnvEntryFolder)((TreeNode)currentSelection).getFolder()).myEnterpriseBean, type);
            EnterpriseBeansContentProvider.EnvEntryFolder envEntryFolder = (EnterpriseBeansContentProvider.EnvEntryFolder)((TreeNode)currentSelection).getFolder();
            ret = envEntryFolder.getTreeNode(envEntry);
        } else if (currentSelection instanceof EnterpriseBeansContentProvider.EjbRefFolder) {
            ret = this.addEjbRefElement((EnterpriseBeansContentProvider.EjbRefFolder)currentSelection, type);
        } else if (currentSelection instanceof TreeNode && ((TreeNode)currentSelection).getIdentifiable() instanceof IEjbRef) {
            EnterpriseBeansContentProvider.EjbRefFolder ejbRefFolder = (EnterpriseBeansContentProvider.EjbRefFolder)((TreeNode)currentSelection).getFolder();
            ret = this.addEjbRefElement(ejbRefFolder, type);
        } else if (currentSelection instanceof EnterpriseBeansContentProvider.EjbLocalRefFolder) {
            ret = this.addEjbRefElement((EnterpriseBeansContentProvider.EjbLocalRefFolder)currentSelection, type);
        } else if (currentSelection instanceof TreeNode && ((TreeNode)currentSelection).getIdentifiable() instanceof IEjbLocalRef) {
            EnterpriseBeansContentProvider.EjbLocalRefFolder ejbLocalRefFolder = (EnterpriseBeansContentProvider.EjbLocalRefFolder)((TreeNode)currentSelection).getFolder();
            ret = this.addEjbRefElement(ejbLocalRefFolder, type);
        } else if (currentSelection instanceof EnterpriseBeansContentProvider.SecurityRoleRefFolder) {
            SecurityRolesDialog securityRolesDialog = new SecurityRolesDialog(this.getEjbJarHolder().getEjbJar().getAssemblyDescriptor());
            Object[] resultSelections = securityRolesDialog.getRoleNamesFromSelectionDialog(true);
            if (resultSelections != null && resultSelections.length > 0) {
                ISecurityRoleRef securityRoleRef = (ISecurityRoleRef)this.addChild(((EnterpriseBeansContentProvider.SecurityRoleRefFolder)currentSelection).myEnterpriseBean, type);
                try {
                    IRoleName roleName = securityRoleRef.createRoleName(null);
                    roleName.setValue(this.createUniqueRoleName(((EnterpriseBeansContentProvider.SecurityRoleRefFolder)currentSelection).myEnterpriseBean, (String)resultSelections[0]));
                    IRoleLink roleLink = securityRoleRef.createRoleLink(null);
                    roleLink.setValue((String)resultSelections[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ret = ((EnterpriseBeansContentProvider.SecurityRoleRefFolder)currentSelection).getTreeNode(securityRoleRef);
            } else {
                ret = null;
            }
        } else if (currentSelection instanceof TreeNode && ((TreeNode)currentSelection).getIdentifiable() instanceof ISecurityRoleRef) {
            IEnterpriseBean ejb = ((EnterpriseBeansContentProvider.SecurityRoleRefFolder)((TreeNode)currentSelection).getFolder()).getEnterpriseBean();
            SecurityRolesDialog securityRolesDialog = new SecurityRolesDialog(this.getEjbJarHolder().getEjbJar().getAssemblyDescriptor());
            Object[] resultSelections = securityRolesDialog.getRoleNamesFromSelectionDialog(true);
            if (resultSelections != null && resultSelections.length > 0) {
                ISecurityRoleRef securityRoleRef = (ISecurityRoleRef)this.addChild(ejb, type);
                try {
                    IRoleName roleName = securityRoleRef.createRoleName(null);
                    roleName.setValue(this.createUniqueRoleName(ejb, (String)resultSelections[0]));
                    IRoleLink roleLink = securityRoleRef.createRoleLink(null);
                    roleLink.setValue((String)resultSelections[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ret = ((EnterpriseBeansContentProvider.SecurityRoleRefFolder)((TreeNode)currentSelection).getFolder()).getTreeNode(securityRoleRef);
            } else {
                ret = null;
            }
        } else if (currentSelection instanceof EnterpriseBeansContentProvider.SecurityIdentityFolder) {
            ISecurityIdentity securityIdentity = (ISecurityIdentity)this.addChild(((EnterpriseBeansContentProvider.SecurityIdentityFolder)currentSelection).myEnterpriseBean, type);
            ret = ((EnterpriseBeansContentProvider.SecurityIdentityFolder)currentSelection).getTreeNode(securityIdentity);
        } else if (currentSelection instanceof EnterpriseBeansContentProvider.ResourceRefFolder) {
            IResourceRef resourceRef = (IResourceRef)this.addChild(((EnterpriseBeansContentProvider.ResourceRefFolder)currentSelection).myEnterpriseBean, type);
            ret = ((EnterpriseBeansContentProvider.ResourceRefFolder)currentSelection).getTreeNode(resourceRef);
        } else if (currentSelection instanceof TreeNode && ((TreeNode)currentSelection).getIdentifiable() instanceof IResourceRef) {
            IEnterpriseBean ejb = ((EnterpriseBeansContentProvider.ResourceRefFolder)((TreeNode)currentSelection).getFolder()).getEnterpriseBean();
            IResourceRef resourceRef = (IResourceRef)this.addChild(ejb, type);
            ret = ((EnterpriseBeansContentProvider.ResourceRefFolder)((TreeNode)currentSelection).getFolder()).getTreeNode(resourceRef);
        } else if (currentSelection instanceof EnterpriseBeansContentProvider.ResourceEnvRefFolder) {
            IResourceEnvRef resourceEnvRef = (IResourceEnvRef)this.addChild(((EnterpriseBeansContentProvider.ResourceEnvRefFolder)currentSelection).myEnterpriseBean, type);
            ret = ((EnterpriseBeansContentProvider.ResourceEnvRefFolder)currentSelection).getTreeNode(resourceEnvRef);
        } else if (currentSelection instanceof TreeNode && ((TreeNode)currentSelection).getIdentifiable() instanceof IResourceEnvRef) {
            IEnterpriseBean ejb = ((EnterpriseBeansContentProvider.ResourceEnvRefFolder)((TreeNode)currentSelection).getFolder()).getEnterpriseBean();
            IResourceEnvRef resourceEnvRef = (IResourceEnvRef)this.addChild(ejb, type);
            ret = ((EnterpriseBeansContentProvider.ResourceEnvRefFolder)((TreeNode)currentSelection).getFolder()).getTreeNode(resourceEnvRef);
        }
        return ret;
    }

    private Object addEjbRefElement(Folder folder, int type) {
        Object ret = null;
        IEnterpriseBean ejb = null;
        int refAddType = -1;
        if (folder instanceof EnterpriseBeansContentProvider.EjbRefFolder) {
            ejb = ((EnterpriseBeansContentProvider.EjbRefFolder)folder).getEnterpriseBean();
        } else if (folder instanceof EnterpriseBeansContentProvider.EjbLocalRefFolder) {
            ejb = ((EnterpriseBeansContentProvider.EjbLocalRefFolder)folder).getEnterpriseBean();
        }
        if (type == 5) {
            refAddType = 1;
        } else if (type == 6) {
            refAddType = 2;
        }
        Object[] iejbArr = this.getEjbsForEjbReferencesFromDialog(this.getEjbJarHolder().getEjbJar(), refAddType);
        IEjbRef ejbRef = null;
        IEjbLocalRef ejbLocalRef = null;
        if (iejbArr != null) {
            if (iejbArr.length > 0) {
                Object[] retObj = new Object[iejbArr.length];
                int i = 0;
                while (i < iejbArr.length) {
                    if (iejbArr[i] instanceof IEnterpriseJavaBean) {
                        if (type == 5) {
                            ejbRef = (IEjbRef)this.addChild(ejb, (IEnterpriseJavaBean)iejbArr[i], null, type);
                            retObj[i] = ((EnterpriseBeansContentProvider.EjbRefFolder)folder).getTreeNode(ejbRef);
                        } else if (type == 6) {
                            ejbLocalRef = (IEjbLocalRef)this.addChild(ejb, (IEnterpriseJavaBean)iejbArr[i], null, type);
                            retObj[i] = ((EnterpriseBeansContentProvider.EjbLocalRefFolder)folder).getTreeNode(ejbLocalRef);
                        }
                    } else if (iejbArr[i] instanceof EnterpriseBeanObj) {
                        if (type == 5) {
                            ejbRef = (IEjbRef)this.addChild(ejb, null, (EnterpriseBeanObj)iejbArr[i], type);
                            retObj[i] = ((EnterpriseBeansContentProvider.EjbRefFolder)folder).getTreeNode(ejbRef);
                        } else if (type == 6) {
                            ejbLocalRef = (IEjbLocalRef)this.addChild(ejb, null, (EnterpriseBeanObj)iejbArr[i], type);
                            retObj[i] = ((EnterpriseBeansContentProvider.EjbLocalRefFolder)folder).getTreeNode(ejbLocalRef);
                        }
                    }
                    ++i;
                }
                ret = retObj[0];
            } else if (type == 5) {
                ejbRef = (IEjbRef)this.addChild(ejb, type);
                ret = ((EnterpriseBeansContentProvider.EjbRefFolder)folder).getTreeNode(ejbRef);
            } else if (type == 6) {
                ejbLocalRef = (IEjbLocalRef)this.addChild(ejb, type);
                ret = ((EnterpriseBeansContentProvider.EjbLocalRefFolder)folder).getTreeNode(ejbLocalRef);
            }
        }
        return ret;
    }

    private int defineType(Object selection) {
        int type = 0;
        if (selection instanceof IEnterpriseBean && (IEnterpriseBean)selection instanceof ISession || selection instanceof EnterpriseBeansContentProvider.SessionFolder) {
            type = 1;
        } else if (selection instanceof IEnterpriseBean && (IEnterpriseBean)selection instanceof IEntity || selection instanceof EnterpriseBeansContentProvider.EntityFolder) {
            type = 2;
        } else if (selection instanceof IEnterpriseBean && (IEnterpriseBean)selection instanceof IMessageDriven || selection instanceof EnterpriseBeansContentProvider.MessageDrivenFolder) {
            type = 3;
        }
        if (selection instanceof TreeNode && ((TreeNode)selection).getIdentifiable() instanceof IEnvEntry || selection instanceof EnterpriseBeansContentProvider.EnvEntryFolder) {
            type = 4;
        } else if (selection instanceof TreeNode && ((TreeNode)selection).getIdentifiable() instanceof IEjbRef || selection instanceof EnterpriseBeansContentProvider.EjbRefFolder) {
            type = 5;
        } else if (selection instanceof TreeNode && ((TreeNode)selection).getIdentifiable() instanceof IEjbLocalRef || selection instanceof EnterpriseBeansContentProvider.EjbLocalRefFolder) {
            type = 6;
        } else if (selection instanceof TreeNode && ((TreeNode)selection).getIdentifiable() instanceof ISecurityRoleRef || selection instanceof EnterpriseBeansContentProvider.SecurityRoleRefFolder) {
            type = 7;
        } else if (selection instanceof TreeNode && ((TreeNode)selection).getIdentifiable() instanceof ISecurityIdentity || selection instanceof EnterpriseBeansContentProvider.SecurityIdentityFolder) {
            type = 12;
        } else if (selection instanceof TreeNode && ((TreeNode)selection).getIdentifiable() instanceof IResourceRef || selection instanceof EnterpriseBeansContentProvider.ResourceRefFolder) {
            type = 8;
        } else if (selection instanceof TreeNode && ((TreeNode)selection).getIdentifiable() instanceof IResourceEnvRef || selection instanceof EnterpriseBeansContentProvider.ResourceEnvRefFolder) {
            type = 9;
        } else if (selection instanceof TreeNode && ((TreeNode)selection).getIdentifiable() instanceof ICmpField || selection instanceof EnterpriseBeansContentProvider.CmpFieldFolder) {
            type = 10;
        } else if (selection instanceof TreeNode && ((TreeNode)selection).getIdentifiable() instanceof IQuery || selection instanceof EnterpriseBeansContentProvider.QueryFolder) {
            type = 11;
        }
        return type;
    }

    private Object addChild(IEnterpriseBean enterpriseBean, int type) {
        Object ret = null;
        if (enterpriseBean != null) {
            switch (type) {
                case 4: {
                    ret = this.createObject(4, enterpriseBean);
                    break;
                }
                case 5: {
                    ret = this.createObject(5, enterpriseBean);
                    break;
                }
                case 6: {
                    ret = this.createObject(6, enterpriseBean);
                    break;
                }
                case 7: {
                    if (enterpriseBean instanceof ISession) {
                        ret = this.createSessionObject(7, enterpriseBean);
                        break;
                    }
                    if (!(enterpriseBean instanceof IEntity)) break;
                    ret = this.createEntityObject(7, enterpriseBean);
                    break;
                }
                case 12: {
                    ret = this.createObject(12, enterpriseBean);
                    break;
                }
                case 8: {
                    ret = this.createObject(8, enterpriseBean);
                    break;
                }
                case 9: {
                    ret = this.createObject(9, enterpriseBean);
                    break;
                }
                case 10: {
                    ret = this.createEntityObject(10, enterpriseBean);
                    break;
                }
                case 11: {
                    ret = this.createEntityObject(11, enterpriseBean);
                    break;
                }
                default: {
                    tracer.error(this.getClass(), "addChild(enterpriseBean, type)", " Error: Illegal Argument provided (type). ");
                }
            }
        }
        return ret;
    }

    private Object addChild(IEnterpriseBean iejb, IEnterpriseJavaBean referencedEjb, EnterpriseBeanObj referencedEjbObj, int type) {
        Object ret = null;
        if (iejb != null) {
            IEjbAssemblyProject iejbAssProj = null;
            if (referencedEjb != null && this.ejbRefDialogTCP != null) {
                iejbAssProj = (IEjbAssemblyProject)this.ejbRefDialogTCP.getParent((Object)referencedEjb);
            }
            if (referencedEjb != null) {
                this.setDDEntryValues(referencedEjb, iejbAssProj, iejb, type);
                ret = this.createEjbReferencesInDD(iejb, type);
            } else {
                this.setDDEntryValues(referencedEjbObj, iejbAssProj, iejb, type);
                ret = this.createEjbReferencesInDD(iejb, type);
            }
        }
        return ret;
    }

    private Object createEjbReferencesInDD(IEnterpriseBean iejb, int type) {
        IEjbRef ret = null;
        try {
            switch (type) {
                case 5: {
                    IEjbRef ejbRef = iejb.createEjbRef(null);
                    if (this.mDDEjbName != null) {
                        IEjbRefName iejbRefName = ejbRef.createEjbRefName(null);
                        iejbRefName.setValue(this.mDefaultEjbRefName);
                    }
                    if (this.mDDEjbType != null) {
                        IEjbRefType iejbRefType = ejbRef.createEjbRefType(null);
                        iejbRefType.setValue(this.mDDEjbType);
                    }
                    if (this.mDDHome != null) {
                        IHome ihome = ejbRef.createHome(null);
                        ihome.setValue(this.mDDHome);
                    }
                    if (this.mDDRemote != null) {
                        IRemote iremote = ejbRef.createRemote(null);
                        iremote.setValue(this.mDDRemote);
                    }
                    if (this.mDDEjbLink != null && !this.mDDEjbLink.equals("")) {
                        IEjbLink iejbLink = ejbRef.createEjbLink(null);
                        iejbLink.setValue(this.mDDEjbLink);
                    }
                    ret = ejbRef;
                    break;
                }
                case 6: {
                    IEjbLocalRef ejbLocalRef = iejb.createEjbLocalRef(null);
                    if (this.mDDEjbName != null) {
                        IEjbRefName iejbRefName = ejbLocalRef.createEjbRefName(null);
                        iejbRefName.setValue(this.mDefaultEjbRefName);
                    }
                    if (this.mDDEjbType != null) {
                        IEjbRefType iejbRefType = ejbLocalRef.createEjbRefType(null);
                        iejbRefType.setValue(this.mDDEjbType);
                    }
                    if (this.mDDLocal != null) {
                        ILocal ilocal = ejbLocalRef.createLocal(null);
                        ilocal.setValue(this.mDDLocal);
                    }
                    if (this.mDDLocalHome != null) {
                        ILocalHome ilocalHome = ejbLocalRef.createLocalHome(null);
                        ilocalHome.setValue(this.mDDLocalHome);
                    }
                    if (this.mDDEjbLink != null && !this.mDDEjbLink.equals("")) {
                        IEjbLink iejbLink = ejbLocalRef.createEjbLink(null);
                        iejbLink.setValue(this.mDDEjbLink);
                    }
                    ret = ejbLocalRef;
                    break;
                }
                default: {
                    tracer.error(this.getClass(), "createEjbReferencesInDD(iejb, type)", " Error: Illegal Argument provided (type). ");
                    break;
                }
            }
        }
        catch (J2eeCreateException e) {
            this.handleJ2eeCreateException("an error occured when creating <ejb-ref> or <ejb-local-ref>.", e);
        }
        return ret;
    }

    private void setDDEntryValues(IEnterpriseJavaBean referencedEjb, IEjbAssemblyProject iejbAssProj, IEnterpriseBean iejb, int type) {
        this.mDDEjbName = this.createUniqueEjbRefName(iejb, referencedEjb.getEjbName(), type);
        this.mDefaultEjbRefName = "ejb/".concat(this.mDDEjbName);
        int iejbType = referencedEjb.getEjbType();
        if (iejbType == 0) {
            this.mDDEjbType = "Entity";
        } else if (iejbType == 1) {
            this.mDDEjbType = "Session";
        }
        this.mDDHome = referencedEjb.getHomeInterfaceClass() != null ? referencedEjb.getHomeInterfaceClass().getFullyQualifiedName() : "";
        this.mDDRemote = referencedEjb.getRemoteInterfaceClass() != null ? referencedEjb.getRemoteInterfaceClass().getFullyQualifiedName() : "";
        this.mDDLocal = referencedEjb.getLocalInterfaceClass() != null ? referencedEjb.getLocalInterfaceClass().getFullyQualifiedName() : "";
        this.mDDLocalHome = referencedEjb.getLocalHomeInterfaceClass() != null ? referencedEjb.getLocalHomeInterfaceClass().getFullyQualifiedName() : "";
        this.mDDEjbLink = null;
        this.mDDEjbLink = iejbAssProj != null ? (this.mDDEjbName != null && !this.mDDEjbName.equals("") && iejbAssProj.getArchiveLocationFullPath() != null ? iejbAssProj.getArchiveLocationFullPath().getName().concat("#").concat(this.mDDEjbName) : this.mDDEjbName) : this.mDDEjbName;
    }

    private void setDDEntryValues(EnterpriseBeanObj referencedEjbObj, IEjbAssemblyProject iejbAssProj, IEnterpriseBean iejb, int type) {
        IEnterpriseBean referencedEjb = referencedEjbObj.getDdEjb();
        this.mDDEjbName = this.createUniqueEjbRefName(iejb, referencedEjb.getEjbName().getValue(), type);
        this.mDefaultEjbRefName = "ejb/".concat(this.mDDEjbName);
        if (referencedEjb instanceof IEntity) {
            this.mDDEjbType = "Entity";
            this.mDDHome = ((IEntity)referencedEjb).getHome() != null ? ((IEntity)referencedEjb).getHome().getValue() : "";
            this.mDDRemote = ((IEntity)referencedEjb).getRemote() != null ? ((IEntity)referencedEjb).getRemote().getValue() : "";
            this.mDDLocal = ((IEntity)referencedEjb).getLocal() != null ? ((IEntity)referencedEjb).getLocal().getValue() : "";
            this.mDDLocalHome = ((IEntity)referencedEjb).getLocalHome() != null ? ((IEntity)referencedEjb).getLocalHome().getValue() : "";
        } else if (referencedEjb instanceof ISession) {
            this.mDDEjbType = "Session";
            this.mDDHome = ((ISession)referencedEjb).getHome() != null ? ((ISession)referencedEjb).getHome().getValue() : "";
            this.mDDRemote = ((ISession)referencedEjb).getRemote() != null ? ((ISession)referencedEjb).getRemote().getValue() : "";
            this.mDDLocal = ((ISession)referencedEjb).getLocal() != null ? ((ISession)referencedEjb).getLocal().getValue() : "";
            this.mDDLocalHome = ((ISession)referencedEjb).getLocalHome() != null ? ((ISession)referencedEjb).getLocalHome().getValue() : "";
        }
        this.mDDEjbLink = null;
        this.mDDEjbLink = iejbAssProj != null ? (this.mDDEjbName != null && !this.mDDEjbName.equals("") && iejbAssProj.getArchiveLocationFullPath() != null ? iejbAssProj.getArchiveLocationFullPath().getName().concat("#").concat(this.mDDEjbName) : this.mDDEjbName) : this.mDDEjbName;
    }

    private Object[] getEjbsForEjbReferencesFromDialog(IEjbJar ejbJar, int type) {
        Object[] ret = null;
        this.project = this.getProject();
        IEjbAssemblyProject ejbAssemblyProject = this.getCurrentEjbAssemblyProject(this.project);
        this.ejbRefDialogTCP = new EjbRefDialogTreeContentProvider(ejbJar, type, ejbAssemblyProject);
        EjbRefDialogTreeLabelProvider ejbRefDialogTLP = new EjbRefDialogTreeLabelProvider();
        Shell shell = new Shell();
        this.diag = null;
        IEnterpriseJavaBean[] iejbs = new IEnterpriseJavaBean[]{};
        InnerFilter elementsToReturnFilter = new InnerFilter(iejbs);
        if (this.ejbRefDialogTCP.getElements(null).length == 0) {
            if (type == 1) {
                MessageDialog.openWarning((Shell)shell, (String)TXT_NO_EJBS_TO_BE_REFERENCED, (String)"In order to add EJB References, there must be EJBs available in the workspace, which have methods in the remote interface. \n\nEJBs can be added in J2EE Explorer view.\nSelect an EJB Module Project and choose New... from the context menu.");
            } else if (type == 2) {
                MessageDialog.openWarning((Shell)shell, (String)TXT_NO_EJBS_TO_BE_REFERENCED, (String)"In order to add EJB Local References, there must be EJBs available in the workspace, which have methods in the local interface. \n\nEJBs can be added in J2EE Explorer view.\nSelect an EJB Module Project and choose New... from the context menu.");
            }
        } else {
            this.diag = new StructuredObjectSelectionDialog(shell, TXT_SELECT_EJBS, TXT_SELECT_EJBS_FROM_LIST);
            this.diag.setTreeInput((Object)ResourcesPlugin.getWorkspace());
            this.diag.setLabelProvider((ILabelProvider)ejbRefDialogTLP);
            this.setDiag(this.diag);
            Object[] result = this.diag.openDialog((ITreeContentProvider)this.ejbRefDialogTCP, (IFilter)elementsToReturnFilter, 2);
            if (result != null && result.length > 0) {
                ret = result;
                shell.dispose();
            }
        }
        return ret;
    }

    private String createUniqueEjbRefName(IEnterpriseBean ejb, String origEjbName, int type) {
        String ejbRefName = null;
        String ejbName = origEjbName;
        int prefix = 0;
        switch (type) {
            case 5: {
                if (ejb == null) break;
                IEjbRef[] ejbRefArr = ejb.getEjbRefs();
                int i = 0;
                while (i < ejbRefArr.length) {
                    if (ejbRefArr[i].getEjbRefName() == null) continue;
                    ejbRefName = ejbRefArr[i].getEjbRefName().getValue();
                    if (ejbRefName.startsWith("ejb/")) {
                        ejbRefName = ejbRefName.substring(4, ejbRefName.length());
                    }
                    if (ejbRefName.equalsIgnoreCase(ejbName)) {
                        ejbName = origEjbName + String.valueOf(++prefix);
                        i = 0;
                        continue;
                    }
                    ++i;
                }
                break;
            }
            case 6: {
                if (ejb == null) break;
                IEjbLocalRef[] ejbLocalRefArr = ejb.getEjbLocalRefs();
                int i = 0;
                while (i < ejbLocalRefArr.length) {
                    if (ejbLocalRefArr[i].getEjbRefName() == null) continue;
                    ejbRefName = ejbLocalRefArr[i].getEjbRefName().getValue();
                    if (ejbRefName.startsWith("ejb/")) {
                        ejbRefName = ejbRefName.substring(4, ejbRefName.length());
                    }
                    if (ejbRefName.equalsIgnoreCase(ejbName)) {
                        ejbName = origEjbName + String.valueOf(++prefix);
                        i = 0;
                        continue;
                    }
                    ++i;
                }
                break;
            }
            default: {
                tracer.error(this.getClass(), "createUniqueEjbRefName(ejb, origEjbName, type)", " Error: Illegal Argument provided (type). ");
            }
        }
        return ejbName;
    }

    public Object createObject(int elementNo, IEnterpriseBean ejb) {
        IEjbRef ret = null;
        try {
            switch (elementNo) {
                case 4: {
                    IEnvEntry envEntry = ejb.createEnvEntry(null);
                    envEntry.createEnvEntryName(null).setValue(this.getDefaultName(ejb, "DefaultEnvEntry", (IIdentifiable)envEntry));
                    ret = envEntry;
                    break;
                }
                case 5: {
                    ret = ejb.createEjbRef(null);
                    break;
                }
                case 6: {
                    ret = ejb.createEjbLocalRef(null);
                    break;
                }
                case 12: {
                    ISecurityIdentity securityIdentity = ejb.createSecurityIdentity(null);
                    securityIdentity.createUseCallerIdentity(null);
                    securityIdentity.createDescription(null).setValue("SecurityIdentity");
                    ret = securityIdentity;
                    break;
                }
                case 8: {
                    IResourceRef resourceRef = ejb.createResourceRef(null);
                    resourceRef.createResRefName(null).setValue(this.getDefaultName(ejb, "jdbc/DefaultResourceRef", (IIdentifiable)resourceRef));
                    resourceRef.createResType(null).setValue("javax.sql.DataSource");
                    ret = resourceRef;
                    break;
                }
                case 9: {
                    IResourceEnvRef resourceEnvRef = ejb.createResourceEnvRef(null);
                    resourceEnvRef.createResourceEnvRefName(null).setValue(this.getDefaultName(ejb, "jms/DefaultResEnvRef", (IIdentifiable)resourceEnvRef));
                    resourceEnvRef.createResourceEnvRefType(null).setValue("javax.jms.Queue");
                    ret = resourceEnvRef;
                    break;
                }
                default: {
                    tracer.error(this.getClass(), "createObject(int, IEnterpriseBean)", " Error: Illegal Argument provided (elementNo). ");
                    break;
                }
            }
        }
        catch (J2eeCreateException e) {
            this.handleJ2eeCreateException("an error occured when creating <env-entry>, <ejb-ref>, <ejb-local-ref>, <resource-ref> or <resource-env-ref>.", e);
        }
        return ret;
    }

    private String getDefaultName(IEnterpriseBean ejb, String defaultNamePrefix, IIdentifiable tagIdentifiable) {
        String defaultName;
        block7: {
            IResourceEnvRef[] resourceEnvRefArr;
            int prefix;
            block9: {
                block8: {
                    defaultName = "<..>";
                    prefix = 0;
                    if (ejb == null || tagIdentifiable == null || defaultNamePrefix == null || defaultNamePrefix.equals("")) break block7;
                    defaultName = defaultNamePrefix;
                    if (!(tagIdentifiable instanceof IEnvEntry)) break block8;
                    IEnvEntry[] envEntryArr = ejb.getEnvEntrys();
                    if (envEntryArr == null) break block7;
                    int i = 0;
                    while (i < envEntryArr.length) {
                        if (envEntryArr[i].getEnvEntryName() != null && envEntryArr[i].getEnvEntryName().getValue().equalsIgnoreCase(defaultName)) {
                            defaultName = defaultNamePrefix + String.valueOf(++prefix);
                            i = 0;
                            continue;
                        }
                        ++i;
                    }
                    break block7;
                }
                if (!(tagIdentifiable instanceof IResourceRef)) break block9;
                IResourceRef[] resourceRefArr = ejb.getResourceRefs();
                if (resourceRefArr == null) break block7;
                int i = 0;
                while (i < resourceRefArr.length) {
                    if (resourceRefArr[i].getResRefName() != null && resourceRefArr[i].getResRefName().getValue().equalsIgnoreCase(defaultName)) {
                        defaultName = defaultNamePrefix + String.valueOf(++prefix);
                        i = 0;
                        continue;
                    }
                    ++i;
                }
                break block7;
            }
            if (tagIdentifiable instanceof IResourceEnvRef && (resourceEnvRefArr = ejb.getResourceEnvRefs()) != null) {
                int i = 0;
                while (i < resourceEnvRefArr.length) {
                    if (resourceEnvRefArr[i].getResourceEnvRefName() != null && resourceEnvRefArr[i].getResourceEnvRefName().getValue().equalsIgnoreCase(defaultName)) {
                        defaultName = defaultNamePrefix + String.valueOf(++prefix);
                        i = 0;
                        continue;
                    }
                    ++i;
                }
            }
        }
        return defaultName;
    }

    public Object createEntityObject(int elementNo, IEnterpriseBean ejb) {
        IEntity entity = (IEntity)ejb;
        ISecurityRoleRef ret = null;
        Object[] selectableQueryMethods = null;
        try {
            switch (elementNo) {
                case 7: {
                    ret = entity.createSecurityRoleRef(null);
                    break;
                }
                case 10: {
                    ret = entity.createCmpField(null);
                    break;
                }
                case 11: {
                    if (this.project != null) {
                        selectableQueryMethods = this.getQueryMethods(entity);
                    }
                    Shell shell = new Shell();
                    String message = null;
                    message = selectableQueryMethods != null ? "Choose one query method among the available methods." : "Sorry, no query methods available.";
                    ObjectSelectionDialog selectionDialog = new ObjectSelectionDialog(shell, "Choose query method", message);
                    selectionDialog.setSingleSelection(false);
                    selectionDialog.setLabelProvider((ILabelProvider)new InnerQueryLabelProvider());
                    Object[] resultSelections = selectionDialog.openDialog(selectableQueryMethods);
                    if (resultSelections != null) {
                        int j = 0;
                        while (j < resultSelections.length) {
                            if (resultSelections[j] instanceof FinderMethod || resultSelections[j] instanceof SelectMethod) {
                                IEjbMethod selectedQueryMethod = (IEjbMethod)resultSelections[j];
                                String queryMethodName = selectedQueryMethod.getName();
                                String[] queryMethodParamTypes = selectedQueryMethod.getParameterTypes();
                                ret = entity.createQuery(null);
                                ((IQuery)ret).createEjbQl(null);
                                ((IQuery)ret).createDescription(null).setValue("If this query is not expressible in EJB QL, use this text pane to describe the semantics of the query and leave the EJB QL field empty.");
                                IQueryMethod queryMethod = ((IQuery)ret).createQueryMethod(null);
                                queryMethod.createMethodName(null).setValue(queryMethodName);
                                IMethodParams methodParamsTag = queryMethod.createMethodParams(null);
                                int i = 0;
                                while (i < queryMethodParamTypes.length) {
                                    methodParamsTag.createMethodParam(null).setValue(queryMethodParamTypes[i]);
                                    ++i;
                                }
                            }
                            ++j;
                        }
                    }
                    break;
                }
                default: {
                    tracer.error(this.getClass(), "createEntityObject(int elementNo, IEnterpriseBean ejb)", " Error: Illegal Argument provided (elementNo). ");
                }
            }
        }
        catch (J2eeCreateException ex) {
            this.handleJ2eeCreateException("Some of <cmp-field>, <security-role-ref>, <query> tags could not be created.", ex);
        }
        return ret;
    }

    private IEjbMethod[] getQueryMethods(IEntity ejb) {
        IEjbMethod[] queryMethods = null;
        if (this.project != null) {
            this.projectName = this.project.getName();
            this.setProjectName(this.projectName);
            IEjbModule ejbAssProject = J2eeProjectManager.getEjbModule((String)this.projectName);
            IEnterpriseJavaBean[] refEjbs = ejbAssProject.getReferencedEjbs();
            if (refEjbs != null) {
                int i = 0;
                while (i < refEjbs.length) {
                    if (refEjbs[i].getBeanClass().getFullyQualifiedName().equals(ejb.getEjbClass().getValue())) {
                        IEjbMethod[] methods = refEjbs[i].getEJBMethods();
                        ArrayList<IEjbMethod> queryMethodsArL = new ArrayList<IEjbMethod>();
                        int j = 0;
                        while (j < methods.length) {
                            int methodType = methods[j].getType();
                            if (!(methodType != 5 && (methodType != 4 || methods[j].getName().equals("ejbFindByPrimaryKey")) || this.getRefQueryMethodsL(this.getEjbJarHolder().getEjbJar(), ejb) != null && this.getRefQueryMethodsL(this.getEjbJarHolder().getEjbJar(), ejb).size() != 0 && this.getRefQueryMethodsL(this.getEjbJarHolder().getEjbJar(), ejb).contains(methods[j].getName()))) {
                                queryMethodsArL.add(methods[j]);
                            }
                            ++j;
                        }
                        queryMethods = queryMethodsArL.toArray(new IEjbMethod[queryMethodsArL.size()]);
                    }
                    ++i;
                }
            }
        }
        return queryMethods;
    }

    private List getRefQueryMethodsL(IEjbJar ejbJar, IEntity ejb) {
        IEnterpriseBeans enterpriseBeans;
        ArrayList<IMethodName> queryMethodsL = new ArrayList<IMethodName>();
        IEntity[] entityBeans = null;
        if (ejbJar != null && (enterpriseBeans = ejbJar.getEnterpriseBeans()) != null) {
            entityBeans = enterpriseBeans.getEntitys();
            int i = 0;
            while (i < entityBeans.length) {
                if (entityBeans[i].getEjbName().getValue().equals(ejb.getEjbName().getValue())) {
                    IQuery[] queries = entityBeans[i].getQuerys();
                    int j = 0;
                    while (j < queries.length) {
                        queryMethodsL.add(queries[j].getQueryMethod().getMethodName());
                        ++j;
                    }
                }
                ++i;
            }
        }
        return queryMethodsL;
    }

    public Object createSessionObject(int elementNo, IEnterpriseBean ejb) {
        ISession session = (ISession)ejb;
        ISecurityRoleRef ret = null;
        try {
            switch (elementNo) {
                case 7: {
                    ret = session.createSecurityRoleRef(null);
                    break;
                }
                default: {
                    tracer.error(this.getClass(), "createSessionObject(int elementNo, IEnterpriseBean ejb)", " Error: Illegal Argument provided (elementNo). ");
                    break;
                }
            }
        }
        catch (J2eeCreateException ex) {
            this.handleJ2eeCreateException("Tag <security-role-ref> could not be created.", ex);
        }
        return ret;
    }

    public boolean canAddElement(Object currentSelection) {
        if (currentSelection instanceof EnterpriseBeansContentProvider.EjbJarHolder | currentSelection instanceof IEnterpriseBean) {
            return false;
        }
        if (currentSelection instanceof EnterpriseBeansContentProvider.CmpFieldFolder || currentSelection instanceof TreeNode && ((TreeNode)currentSelection).getIdentifiable() instanceof ICmpField) {
            return false;
        }
        if (currentSelection instanceof TreeNode && ((TreeNode)currentSelection).getIdentifiable() instanceof ISecurityIdentity) {
            return false;
        }
        if (currentSelection instanceof EnterpriseBeansContentProvider.QueryFolder || currentSelection instanceof TreeNode && ((TreeNode)currentSelection).getIdentifiable() instanceof IQuery) {
            return false;
        }
        if (this.myTreeContentProvider != null) {
            if (currentSelection instanceof EnterpriseBeansContentProvider.SecurityIdentityFolder && this.myTreeContentProvider.isSecurityIdentitySet((EnterpriseBeansContentProvider.SecurityIdentityFolder)currentSelection)) {
                return false;
            }
            return currentSelection != null;
        }
        return currentSelection != null;
    }

    public boolean canRemoveElement(Object currentSelection) {
        boolean ret = true;
        if (currentSelection == null | currentSelection instanceof EnterpriseBeansContentProvider.EjbJarHolder | currentSelection instanceof Folder | currentSelection instanceof IEnterpriseBean | (currentSelection instanceof TreeNode && ((TreeNode)currentSelection).getIdentifiable() instanceof ICmpField) | (currentSelection instanceof TreeNode && ((TreeNode)currentSelection).getIdentifiable() instanceof IQuery)) {
            ret = false;
        }
        return ret;
    }

    public boolean removeElement(Object currentSelection) {
        int type = 0;
        IEnterpriseBean ejb = null;
        if (currentSelection instanceof IEnterpriseBean && this.canRemoveElement(currentSelection)) {
            type = this.defineType(currentSelection);
            if (type != 0) {
                this.removeCurrentElement(this.getEjbJarHolder().getEjbJar(), type, (IEnterpriseBean)currentSelection);
            }
        } else if (currentSelection instanceof TreeNode && this.canRemoveElement(currentSelection)) {
            type = this.defineType(currentSelection);
            if (((TreeNode)currentSelection).getIdentifiable() instanceof IEnvEntry) {
                ejb = ((EnterpriseBeansContentProvider.EnvEntryFolder)((TreeNode)currentSelection).getFolder()).getEnterpriseBean();
            } else if (((TreeNode)currentSelection).getIdentifiable() instanceof IEjbRef) {
                ejb = ((EnterpriseBeansContentProvider.EjbRefFolder)((TreeNode)currentSelection).getFolder()).getEnterpriseBean();
            } else if (((TreeNode)currentSelection).getIdentifiable() instanceof IEjbLocalRef) {
                ejb = ((EnterpriseBeansContentProvider.EjbLocalRefFolder)((TreeNode)currentSelection).getFolder()).getEnterpriseBean();
            } else if (((TreeNode)currentSelection).getIdentifiable() instanceof ISecurityRoleRef) {
                ejb = ((EnterpriseBeansContentProvider.SecurityRoleRefFolder)((TreeNode)currentSelection).getFolder()).getEnterpriseBean();
            } else if (((TreeNode)currentSelection).getIdentifiable() instanceof ISecurityIdentity) {
                ejb = ((EnterpriseBeansContentProvider.SecurityIdentityFolder)((TreeNode)currentSelection).getFolder()).getEnterpriseBean();
            } else if (((TreeNode)currentSelection).getIdentifiable() instanceof IResourceRef) {
                ejb = ((EnterpriseBeansContentProvider.ResourceRefFolder)((TreeNode)currentSelection).getFolder()).getEnterpriseBean();
            } else if (((TreeNode)currentSelection).getIdentifiable() instanceof IResourceEnvRef) {
                ejb = ((EnterpriseBeansContentProvider.ResourceEnvRefFolder)((TreeNode)currentSelection).getFolder()).getEnterpriseBean();
            } else if (((TreeNode)currentSelection).getIdentifiable() instanceof ICmpField) {
                ejb = ((EnterpriseBeansContentProvider.CmpFieldFolder)((TreeNode)currentSelection).getFolder()).getEnterpriseBean();
            } else if (((TreeNode)currentSelection).getIdentifiable() instanceof IQuery) {
                ejb = ((EnterpriseBeansContentProvider.QueryFolder)((TreeNode)currentSelection).getFolder()).getEnterpriseBean();
            }
            if (ejb != null && type != 0) {
                this.removeCurrentElement(ejb, type, (TreeNode)currentSelection);
            }
        }
        return true;
    }

    private void removeCurrentElement(IEnterpriseBean enterpriseBean, int type, TreeNode currentSelection) {
        if (enterpriseBean != null) {
            switch (type) {
                case 4: {
                    this.removeObject(4, enterpriseBean, currentSelection);
                    break;
                }
                case 5: {
                    this.removeObject(5, enterpriseBean, currentSelection);
                    break;
                }
                case 6: {
                    this.removeObject(6, enterpriseBean, currentSelection);
                    break;
                }
                case 7: {
                    if (enterpriseBean instanceof ISession) {
                        this.removeObject(7, enterpriseBean, currentSelection);
                        break;
                    }
                    if (!(enterpriseBean instanceof IEntity)) break;
                    this.removeObject(7, enterpriseBean, currentSelection);
                    break;
                }
                case 12: {
                    this.removeObject(12, enterpriseBean, currentSelection);
                    break;
                }
                case 8: {
                    this.removeObject(8, enterpriseBean, currentSelection);
                    break;
                }
                case 9: {
                    this.removeObject(9, enterpriseBean, currentSelection);
                    break;
                }
                case 10: {
                    this.removeObject(10, enterpriseBean, currentSelection);
                    break;
                }
                case 11: {
                    this.removeObject(11, enterpriseBean, currentSelection);
                    break;
                }
                default: {
                    tracer.error(this.getClass(), "removeCurrentElement(enterpriseBean,type,currentSelection)", " Error: Illegal Argument provided (type). ");
                }
            }
        }
    }

    private void removeCurrentElement(IEjbJar ejbJar, int type, IEnterpriseBean currentSelection) {
        if (ejbJar != null) {
            switch (type) {
                case 1: {
                    ejbJar.getEnterpriseBeans().removeSession((ISession)currentSelection);
                    break;
                }
                case 2: {
                    ejbJar.getEnterpriseBeans().removeEntity((IEntity)currentSelection);
                    break;
                }
                case 3: {
                    ejbJar.getEnterpriseBeans().removeMessageDriven((IMessageDriven)currentSelection);
                    break;
                }
                default: {
                    tracer.error(this.getClass(), "removeCurrentElement(ejbJar,type,currentSelection)", " Error: Illegal Argument provided (type). ");
                }
            }
        }
    }

    public void removeObject(int elementNo, IEnterpriseBean ejb, TreeNode currentSelection) {
        switch (elementNo) {
            case 4: {
                ejb.removeEnvEntry((IEnvEntry)currentSelection.getIdentifiable());
                ((EnterpriseBeansContentProvider.EnvEntryFolder)currentSelection.getFolder()).removeTreeNode(currentSelection);
                break;
            }
            case 5: {
                ejb.removeEjbRef((IEjbRef)currentSelection.getIdentifiable());
                ((EnterpriseBeansContentProvider.EjbRefFolder)currentSelection.getFolder()).removeTreeNode(currentSelection);
                break;
            }
            case 7: {
                if (ejb instanceof ISession) {
                    ((ISession)ejb).removeSecurityRoleRef((ISecurityRoleRef)currentSelection.getIdentifiable());
                } else if (ejb instanceof IEntity) {
                    ((IEntity)ejb).removeSecurityRoleRef((ISecurityRoleRef)currentSelection.getIdentifiable());
                }
                ((EnterpriseBeansContentProvider.SecurityRoleRefFolder)currentSelection.getFolder()).removeTreeNode(currentSelection);
                break;
            }
            case 12: {
                ejb.removeSecurityIdentity();
                ((EnterpriseBeansContentProvider.SecurityIdentityFolder)currentSelection.getFolder()).removeTreeNode(currentSelection);
                break;
            }
            case 6: {
                ejb.removeEjbLocalRef((IEjbLocalRef)currentSelection.getIdentifiable());
                ((EnterpriseBeansContentProvider.EjbLocalRefFolder)currentSelection.getFolder()).removeTreeNode(currentSelection);
                break;
            }
            case 8: {
                ejb.removeResourceRef((IResourceRef)currentSelection.getIdentifiable());
                ((EnterpriseBeansContentProvider.ResourceRefFolder)currentSelection.getFolder()).removeTreeNode(currentSelection);
                break;
            }
            case 9: {
                ejb.removeResourceEnvRef((IResourceEnvRef)currentSelection.getIdentifiable());
                ((EnterpriseBeansContentProvider.ResourceEnvRefFolder)currentSelection.getFolder()).removeTreeNode(currentSelection);
                break;
            }
            case 10: {
                if (ejb instanceof IEntity) {
                    ((IEntity)ejb).removeCmpField((ICmpField)currentSelection.getIdentifiable());
                }
                ((EnterpriseBeansContentProvider.CmpFieldFolder)currentSelection.getFolder()).removeTreeNode(currentSelection);
                break;
            }
            case 11: {
                if (ejb instanceof IEntity) {
                    ((IEntity)ejb).removeQuery((IQuery)currentSelection.getIdentifiable());
                }
                ((EnterpriseBeansContentProvider.QueryFolder)currentSelection.getFolder()).removeTreeNode(currentSelection);
                break;
            }
            default: {
                tracer.error(this.getClass(), "removeObject(elementNo, ejb,currentSelection)", " Error: Illegal Argument provided (elementNo). ");
            }
        }
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(this.getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    private void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    private IEjbJarHolder getEjbJarHolder() {
        return this.ejbJarHolder;
    }

    private void setEjbJarHolder(IEjbJarHolder ejbJarHolder) {
        this.ejbJarHolder = ejbJarHolder;
    }

    public EnterpriseBeansContentProvider getTreeContentProvider() {
        return this.myTreeContentProvider;
    }

    public void setTreeContentProvider(EnterpriseBeansContentProvider myTreeContentProvider) {
        this.myTreeContentProvider = myTreeContentProvider;
    }

    private void setDiag(StructuredObjectSelectionDialog diag) {
        this.diag = diag;
    }

    private IProject getProject() {
        return this.project;
    }

    private IEjbAssemblyProject getCurrentEjbAssemblyProject(IProject project) {
        IEjbModule ejbAssemblyProject = null;
        if (project != null) {
            String projectName = project.getName();
            ejbAssemblyProject = J2eeProjectManager.getEjbModule((String)projectName);
        }
        return ejbAssemblyProject;
    }

    private String createUniqueRoleName(IEnterpriseBean ejb, String roleLink) {
        int suffix = -1;
        ISecurityRoleRef[] srr = null;
        if (ejb instanceof ISession) {
            srr = ((ISession)ejb).getSecurityRoleRefs();
        } else if (ejb instanceof IEntity) {
            srr = ((IEntity)ejb).getSecurityRoleRefs();
        }
        boolean hasRoleName = false;
        String tempRoleName = "";
        if (srr != null && srr.length > 0) {
            int i1 = 0;
            while (i1 < 255 && suffix < 0) {
                hasRoleName = false;
                tempRoleName = i1 > 0 ? roleLink + i1 : roleLink;
                int i = 0;
                while (i < srr.length && !hasRoleName) {
                    if (tempRoleName.equals(srr[i].getRoleName().getValue())) {
                        hasRoleName = true;
                    }
                    ++i;
                }
                if (!hasRoleName) {
                    suffix = i1;
                }
                ++i1;
            }
        }
        return suffix > 0 ? roleLink + suffix : roleLink;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InnerFilter
    implements IFilter {
        private IEnterpriseJavaBean[] iejbs = null;

        public InnerFilter(IEnterpriseJavaBean[] iejbs) {
            this.iejbs = iejbs;
        }

        public boolean accept(Object o) {
            return o instanceof IEnterpriseJavaBean || o instanceof EnterpriseBeanObj;
        }
    }

    private class InnerQueryLabelProvider
    extends LabelProvider {
        private Image iDefaultMethod = UIPlugin.getImage((String)"defaultMethod");
        private Image iFinderMethod = UIPlugin.getImage((String)"finderMethod");
        private Image iSelectMethod = UIPlugin.getImage((String)"selectMethod");

        private InnerQueryLabelProvider() {
        }

        public Image getImage(Object element) {
            Image retImage = this.iDefaultMethod;
            if (element instanceof IEjbMethod) {
                if (((IEjbMethod)element).getType() == 4) {
                    retImage = this.iFinderMethod;
                } else if (((IEjbMethod)element).getType() == 5) {
                    retImage = this.iSelectMethod;
                }
            }
            return retImage;
        }

        public String getText(Object element) {
            String ret = null;
            if (element instanceof IEjbMethod) {
                ret = ((IEjbMethod)element).getName();
            }
            return ret;
        }
    }
}

