/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.editorobjects;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.ejbjar.dd.IEjbJar;
import com.tssap.j2ee.model.ejbjar.dd.ISecurityRole;
import com.tssap.j2ee.ui.GenericReferencesCheck;
import com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.SecurityRoleWrapper;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class UiAssemblySecurityRole
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$editorobjects$UiAssemblySecurityRole == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$editorobjects$UiAssemblySecurityRole = UiAssemblySecurityRole.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.editorobjects.UiAssemblySecurityRole")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$editorobjects$UiAssemblySecurityRole));
    private IModifiedCallback myModifyCallback;
    private Text descriptionTextPane;
    private Text roleNameTextField;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$editorobjects$UiAssemblySecurityRole;

    public void initContainer(IGridLayoutPane userArea) {
        userArea.addTextLabel("Role name");
        this.roleNameTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        userArea.addTextLabel("Description");
        this.descriptionTextPane = userArea.addTextPane("", false, true, userArea.createGridLayoutData(4, 4, true, true, 1, 1));
        this.decorateControls();
    }

    private void decorateControls() {
        this.getDescriptionTextPane().addModifyListener(this.getModifyAdapterSingleton());
        this.getRoleNameTextField().addModifyListener((ModifyListener)new RoleNameModifyAdapter());
    }

    private Text getRoleNameTextField() {
        return this.roleNameTextField;
    }

    private void setRoleNameTextField(Text roleNameTextField) {
        this.roleNameTextField = roleNameTextField;
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        if (this.getSecurityRole() != null) {
            this.refreshRoleNameFromUI();
            String descr = this.getDescriptionTextPane().getText().trim();
            if (!descr.equals("")) {
                if (this.getSecurityRole().getDescription() == null) {
                    try {
                        this.getSecurityRole().createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("", e);
                    }
                }
                this.getSecurityRole().getDescription().setValue(descr);
            } else if (this.getSecurityRole().getDescription() != null) {
                this.getSecurityRole().getDescription().setValue("");
            }
        }
    }

    private void refreshRoleNameFromUI() {
        String oldRoleName = null;
        if (this.getSecurityRole() != null) {
            String roleNameTxt = this.getRoleNameTextField().getText().trim();
            if (roleNameTxt.length() != 0) {
                if (this.getSecurityRole().getRoleName() == null) {
                    try {
                        this.getSecurityRole().createRoleName(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("", e);
                    }
                } else {
                    oldRoleName = this.getSecurityRole().getRoleName().getValue();
                }
                if (this.getRoleNameTextField().getText().equals("<fill in security-role-name>")) {
                    this.getSecurityRole().getRoleName().setValue("");
                } else {
                    this.getSecurityRole().getRoleName().setValue(roleNameTxt);
                }
                if (oldRoleName != null && !oldRoleName.equals(roleNameTxt)) {
                    GenericReferencesCheck genericReferencesCheck = new GenericReferencesCheck((IIdentifiable)this.getEjbJar(), oldRoleName, (Object)this.getSecurityRole());
                }
            } else if (this.getSecurityRole().getRoleName() != null) {
                this.getSecurityRole().getRoleName().setValue("");
            }
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        ISecurityRole securityRole = this.getSecurityRole();
        if (!(securityRole instanceof ISecurityRole)) {
            throw new IllegalArgumentException("No object of ISecurityRole found!");
        }
        this.getDescriptionTextPane().setText(securityRole.getDescription() != null ? securityRole.getDescription().getValue() : "");
        this.getRoleNameTextField().setText(securityRole.getRoleName() != null && securityRole.getRoleName().getValue() != null && securityRole.getRoleName().getValue().trim().length() > 0 ? securityRole.getRoleName().getValue() : "<fill in security-role-name>");
        this.stopRefreshingUI();
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof SecurityRoleWrapper)) {
            ret = "No object of SecurityRoleWrapper found!";
        }
        return ret;
    }

    public void setModifyCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    protected ISecurityRole getSecurityRole() {
        ISecurityRole ret = null;
        SecurityRoleWrapper securityRoleWrapper = this.getSecurityRoleWrapper();
        if (securityRoleWrapper != null) {
            ret = securityRoleWrapper.getSecurityRole();
        }
        return ret;
    }

    private SecurityRoleWrapper getSecurityRoleWrapper() {
        SecurityRoleWrapper securityRoleWrapper = null;
        if (this.getData() instanceof SecurityRoleWrapper) {
            securityRoleWrapper = (SecurityRoleWrapper)this.getData();
        }
        return securityRoleWrapper;
    }

    private IEjbJar getEjbJar() {
        IEjbJar ret = null;
        SecurityRoleWrapper securityRoleWrapper = this.getSecurityRoleWrapper();
        if (securityRoleWrapper != null) {
            ret = securityRoleWrapper.getEjbJar();
        }
        return ret;
    }

    protected void handleRoleNameEvent() {
        this.refreshRoleNameFromUI();
        super.handleEvent();
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.getDescriptionTextPane() != null) {
            this.getDescriptionTextPane().setEditable(this.isEditable());
        }
        if (this.getRoleNameTextField() != null) {
            this.getRoleNameTextField().setEditable(this.isEditable());
        }
    }

    public String okToLeave() {
        String message = super.okToLeave();
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        String secRoleName = this.getRoleNameTextField().getText();
        if (secRoleName.trim().length() == 0 || secRoleName.equals("<fill in security-role-name>")) {
            status.setError("Please fill in a security role name.");
        }
        return status;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RoleNameModifyAdapter
    implements ModifyListener {
        private RoleNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UiAssemblySecurityRole.this.handleRoleNameEvent();
        }
    }
}

