/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.editorobjects;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ejbjar.dd.IAssemblyDescriptor;
import com.tssap.j2ee.model.ejbjar.dd.IMethodPermission;
import com.tssap.j2ee.model.ejbjar.dd.IRoleName;
import com.tssap.j2ee.model.ejbjar.dd.IUnchecked;
import com.tssap.j2ee.ui.SecurityRolesDialog;
import com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.MethodPermissionWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import com.tssap.util.ui.reuse.list.IListElement;
import com.tssap.util.ui.reuse.list.IListSelectorCallback;
import com.tssap.util.ui.reuse.list.ListComponent;
import com.tssap.util.ui.reuse.list.ListElement;
import com.tssap.util.ui.reuse.list.ListSelectorCallback;
import java.util.ArrayList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

public class UiAssemblyMethodPermGeneral
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$editorobjects$UiAssemblyMethodPermGeneral == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$editorobjects$UiAssemblyMethodPermGeneral = UiAssemblyMethodPermGeneral.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.editorobjects.UiAssemblyMethodPermGeneral")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$editorobjects$UiAssemblyMethodPermGeneral));
    private boolean unchecked = false;
    private boolean isRoleNamesPartEnabled = false;
    private InnerRoleNamesAdapter roleNamesAdapt;
    private IModifiedCallback myModifyCallback;
    private ListComponent roleNamesListComponent;
    private Text descriptionTextPane;
    private Button uncheckedCheckbox;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$editorobjects$UiAssemblyMethodPermGeneral;

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane leftGlp = userArea.addGridLayoutPane(1, userArea.createGridLayoutData(4, 4, true, true));
        IGridLayoutPane rightGlp = userArea.addGridLayoutPane(1, userArea.createGridLayoutData(4, 4, true, true));
        leftGlp.addTextLabel("Description", leftGlp.createGridLayoutData(4, 4, true, false, 1, 1));
        this.descriptionTextPane = leftGlp.addTextPane("", false, true, leftGlp.createGridLayoutData(4, 4, true, true, 1, 1));
        this.setDescriptionTextPane(this.descriptionTextPane);
        Button uncheckedCheckbox = rightGlp.addCheckBox("Unchecked", this.isUnchecked(), rightGlp.createGridLayoutData(4, 4, false, false, 1, 1));
        this.setUncheckedCheckbox(uncheckedCheckbox);
        rightGlp.addTextLabel("Role Names", rightGlp.createGridLayoutData(4, 4, false, false, 2, 1));
        InnerRoleNamesAdapter roleNamesAdapter = new InnerRoleNamesAdapter();
        this.setRoleNamesListComponent(new ListComponent((IListSelectorCallback)roleNamesAdapter));
        this.setInnerRoleNamesAdapter(roleNamesAdapter);
        this.getRoleNamesListComponent().createPartControl(rightGlp);
        this.decorateControls();
    }

    private void decorateControls() {
        this.getDescriptionTextPane().addModifyListener((ModifyListener)new DescrModAdapter());
        this.getUncheckedCheckbox().addSelectionListener((SelectionListener)new InnerSelectionAdapter());
    }

    private void manageControls() {
        if (this.getMethodPermission() != null) {
            IUnchecked unchecked = this.getMethodPermission().getUnchecked();
            if (this.getUncheckedCheckbox().getSelection()) {
                this.uncheckedCheckbox.setSelection(true);
                this.setUnchecked(true);
                this.setRoleNamesPartEnabled(false);
                if (unchecked == null) {
                    try {
                        this.getMethodPermission().createUnchecked(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<unchecked/> tag could not be created", e);
                    }
                    this.getRoleNamesListComponent().getList().removeAll();
                    IRoleName[] roleNames = this.getMethodPermission().getRoleNames();
                    int i = 0;
                    while (i < roleNames.length) {
                        this.getMethodPermission().removeRoleName(roleNames[i]);
                        ++i;
                    }
                }
            } else {
                this.uncheckedCheckbox.setSelection(false);
                this.setUnchecked(false);
                this.setRoleNamesPartEnabled(true);
                if (unchecked != null) {
                    this.getMethodPermission().removeUnchecked();
                }
                this.roleNamesAdapt = this.getInnerRoleNamesAdapter();
                IListElement[] listElementArr = this.roleNamesAdapt.getNewElements();
                if (this.getRoleNamesListComponent() != null && listElementArr != null) {
                    this.getRoleNamesListComponent().setElements(listElementArr);
                }
            }
        }
        this.updateEditableBehavior();
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    private Button getUncheckedCheckbox() {
        return this.uncheckedCheckbox;
    }

    private void setUncheckedCheckbox(Button uncheckedCheckbox) {
        this.uncheckedCheckbox = uncheckedCheckbox;
    }

    private boolean isUnchecked() {
        return this.unchecked;
    }

    private void setUnchecked(boolean unchecked) {
        this.unchecked = unchecked;
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public InnerRoleNamesAdapter getInnerRoleNamesAdapter() {
        return this.roleNamesAdapt;
    }

    public void setInnerRoleNamesAdapter(InnerRoleNamesAdapter roleNamesAdapt) {
        this.roleNamesAdapt = roleNamesAdapt;
    }

    private ListComponent getRoleNamesListComponent() {
        return this.roleNamesListComponent;
    }

    private void setRoleNamesListComponent(ListComponent component) {
        this.roleNamesListComponent = component;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        IMethodPermission methodPermission = this.getMethodPermission();
        this.refreshDescriptionFieldFromUI();
        if (methodPermission != null) {
            IUnchecked unchecked = methodPermission.getUnchecked();
            if (this.getUncheckedCheckbox().getSelection()) {
                this.setUnchecked(true);
            } else {
                this.setUnchecked(false);
            }
            if (unchecked == null && this.isUnchecked()) {
                try {
                    IRoleName[] roleNames = methodPermission.getRoleNames();
                    int i = 0;
                    while (i < roleNames.length) {
                        methodPermission.removeRoleName(roleNames[i]);
                        ++i;
                    }
                    methodPermission.createUnchecked(null);
                    this.getRoleNamesListComponent().refresh();
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<unchecked/> tag could not be created", e);
                }
            } else if (unchecked != null && !this.isUnchecked()) {
                methodPermission.removeUnchecked();
            }
        }
    }

    private void refreshDescriptionFieldFromUI() {
        if (this.getMethodPermission() != null) {
            String desc = this.getDescriptionTextPane().getText().trim();
            if (!desc.equals("")) {
                if (this.getMethodPermission().getDescription() == null) {
                    try {
                        this.getMethodPermission().createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("", e);
                    }
                }
                this.getMethodPermission().getDescription().setValue(desc);
            } else if (this.getMethodPermission().getDescription() != null) {
                this.getMethodPermission().getDescription().setValue("");
            }
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        IMethodPermission methodPerm = this.getMethodPermission();
        if (methodPerm instanceof IMethodPermission && methodPerm != null) {
            this.getDescriptionTextPane().setText(methodPerm.getDescription() != null ? methodPerm.getDescription().getValue() : "");
            this.roleNamesAdapt = this.getInnerRoleNamesAdapter();
            this.getRoleNamesListComponent().getList().removeAll();
            IRoleName[] roleNames = methodPerm.getRoleNames();
            ArrayList<IRoleName> roleNamesArL = new ArrayList<IRoleName>();
            int i = 0;
            while (i < roleNames.length) {
                if (!roleNames[i].getValue().equals("")) {
                    roleNamesArL.add(roleNames[i]);
                }
                ++i;
            }
            IListElement[] listElements = new IListElement[roleNamesArL.size()];
            IRoleName[] nonEmptyRoleNames = roleNamesArL.toArray(new IRoleName[roleNamesArL.size()]);
            int i2 = 0;
            while (i2 < nonEmptyRoleNames.length) {
                listElements[i2] = new ListElement(nonEmptyRoleNames[i2].getValue(), (Object)nonEmptyRoleNames[i2]);
                ++i2;
            }
            this.getRoleNamesListComponent().setElements(listElements);
            if (nonEmptyRoleNames.length > 0) {
                this.getRoleNamesListComponent().setSelection(0);
            }
            if (methodPerm.getUnchecked() != null) {
                this.setUnchecked(true);
                this.getUncheckedCheckbox().setSelection(this.isUnchecked());
                this.setRoleNamesPartEnabled(false);
            } else if (nonEmptyRoleNames == null || nonEmptyRoleNames.length == 0) {
                this.setUnchecked(true);
                this.getUncheckedCheckbox().setSelection(this.isUnchecked());
                this.setRoleNamesPartEnabled(false);
            } else {
                this.setUnchecked(false);
                this.getUncheckedCheckbox().setSelection(this.isUnchecked());
                this.setRoleNamesPartEnabled(true);
            }
        } else {
            throw new IllegalArgumentException("No object of IMethodPermission found!");
        }
        this.stopRefreshingUI();
        this.updateEditableBehavior();
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof MethodPermissionWrapper)) {
            ret = "No object of MethodPermissionWrapper found!";
        }
        return ret;
    }

    public void setModifyCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    private MethodPermissionWrapper getMethodPermissionWrapper() {
        MethodPermissionWrapper methodPermissionWrapper = null;
        if (this.getData() instanceof MethodPermissionWrapper) {
            methodPermissionWrapper = (MethodPermissionWrapper)this.getData();
        }
        return methodPermissionWrapper;
    }

    private IMethodPermission getMethodPermission() {
        IMethodPermission ret = null;
        MethodPermissionWrapper methodPermissionWrapper = this.getMethodPermissionWrapper();
        if (methodPermissionWrapper != null) {
            ret = methodPermissionWrapper.getMethodPermission();
        }
        return ret;
    }

    private IAssemblyDescriptor getAssemblyDescriptor() {
        IAssemblyDescriptor assemblyDescriptor = null;
        MethodPermissionWrapper methodPermissionWrapper = this.getMethodPermissionWrapper();
        if (methodPermissionWrapper != null) {
            assemblyDescriptor = methodPermissionWrapper.getAssemblyDescriptor();
        }
        return assemblyDescriptor;
    }

    protected void handleDescriptionEvent() {
        this.refreshDescriptionFieldFromUI();
        super.handleEvent();
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.getDescriptionTextPane() != null) {
            this.getDescriptionTextPane().setEditable(editable);
        }
        if (this.getRoleNamesListComponent() != null) {
            this.getRoleNamesListComponent().setEnabled(editable && this.isRoleNamesPartEnabled());
            this.getRoleNamesListComponent().setAddRemoveButtonsEnabled(editable && this.isRoleNamesPartEnabled());
        }
        if (this.getUncheckedCheckbox() != null) {
            this.getUncheckedCheckbox().setEnabled(editable);
        }
    }

    private boolean isRoleNamesPartEnabled() {
        return this.isRoleNamesPartEnabled;
    }

    private void setRoleNamesPartEnabled(boolean b) {
        this.isRoleNamesPartEnabled = b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InnerSelectionAdapter
    implements SelectionListener {
        private InnerSelectionAdapter() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (UiAssemblyMethodPermGeneral.this.getUncheckedCheckbox().getSelection()) {
                UiAssemblyMethodPermGeneral.this.setUnchecked(true);
            } else {
                UiAssemblyMethodPermGeneral.this.setUnchecked(false);
            }
            UiAssemblyMethodPermGeneral.this.manageControls();
            if (UiAssemblyMethodPermGeneral.this.getModifiedCallback() != null) {
                UiAssemblyMethodPermGeneral.this.getModifiedCallback().dataModified(true);
            }
        }
    }

    private class InnerRoleNamesAdapter
    extends ListSelectorCallback {
        private InnerRoleNamesAdapter() {
        }

        public void elementAdded(IListElement element) {
        }

        public void elementRemoved(IListElement element) {
            if (UiAssemblyMethodPermGeneral.this.getMethodPermission() != null && element != null && element.getUserObject() instanceof IRoleName) {
                IRoleName roleName = (IRoleName)element.getUserObject();
                UiAssemblyMethodPermGeneral.this.getMethodPermission().removeRoleName(roleName);
                if (UiAssemblyMethodPermGeneral.this.getMethodPermission().getRoleNames() == null || UiAssemblyMethodPermGeneral.this.getMethodPermission().getRoleNames().length == 0) {
                    UiAssemblyMethodPermGeneral.this.getUncheckedCheckbox().setSelection(true);
                    UiAssemblyMethodPermGeneral.this.setRoleNamesPartEnabled(false);
                }
                if (UiAssemblyMethodPermGeneral.this.getRoleNamesListComponent().getElements() != null && UiAssemblyMethodPermGeneral.this.getRoleNamesListComponent().getElements().length == 0) {
                    UiAssemblyMethodPermGeneral.this.getUncheckedCheckbox().setSelection(true);
                    UiAssemblyMethodPermGeneral.this.setRoleNamesPartEnabled(false);
                }
            }
            if (UiAssemblyMethodPermGeneral.this.getModifiedCallback() != null) {
                UiAssemblyMethodPermGeneral.this.getModifiedCallback().dataModified(true);
            }
            UiAssemblyMethodPermGeneral.this.refreshUIFromData();
            UiAssemblyMethodPermGeneral.this.updateEditableBehavior();
        }

        public IListElement[] getNewElements() {
            SecurityRolesDialog securityRolesDialog = new SecurityRolesDialog(UiAssemblyMethodPermGeneral.this.getAssemblyDescriptor());
            Object[] resultSelections = securityRolesDialog.getRoleNamesFromSelectionDialog(false);
            ListElement[] ret = new ListElement[]{};
            IRoleName[] existingRoleNameArr = null;
            if (UiAssemblyMethodPermGeneral.this.getMethodPermission() != null) {
                existingRoleNameArr = UiAssemblyMethodPermGeneral.this.getMethodPermission().getRoleNames();
            }
            ArrayList<Object> resultSelectionArL = new ArrayList<Object>();
            String selectedRoleName = null;
            if (resultSelections != null && resultSelections.length > 0) {
                int i = 0;
                while (i < resultSelections.length) {
                    selectedRoleName = resultSelections[i].toString();
                    boolean roleNameExists = false;
                    if (existingRoleNameArr != null && existingRoleNameArr.length > 0) {
                        int j = 0;
                        while (j < existingRoleNameArr.length && !roleNameExists) {
                            if (existingRoleNameArr[j].getValue().equals(selectedRoleName)) {
                                roleNameExists = true;
                            }
                            ++j;
                        }
                    }
                    if (!roleNameExists) {
                        resultSelectionArL.add(resultSelections[i]);
                    }
                    ++i;
                }
                ret = new ListElement[resultSelectionArL.size()];
                resultSelections = resultSelectionArL.toArray();
                int i2 = 0;
                while (i2 < resultSelections.length) {
                    if (UiAssemblyMethodPermGeneral.this.getMethodPermission() != null) {
                        try {
                            selectedRoleName = resultSelections[i2].toString();
                            IRoleName newRoleName = UiAssemblyMethodPermGeneral.this.getMethodPermission().createRoleName(null);
                            newRoleName.setValue(selectedRoleName);
                            ret[i2] = new ListElement(selectedRoleName);
                            ret[i2].setUserObject((Object)newRoleName);
                        }
                        catch (J2eeCreateException ex) {
                            UiAssemblyMethodPermGeneral.this.handleJ2eeCreateException("<role-name> could not be created.", ex);
                        }
                    }
                    ++i2;
                }
                if (UiAssemblyMethodPermGeneral.this.getModifiedCallback() != null) {
                    UiAssemblyMethodPermGeneral.this.getModifiedCallback().dataModified(true);
                }
            } else if (UiAssemblyMethodPermGeneral.this.getRoleNamesListComponent().getListElements() == null || UiAssemblyMethodPermGeneral.this.getRoleNamesListComponent().getListElements().length == 0) {
                UiAssemblyMethodPermGeneral.this.setUnchecked(true);
                UiAssemblyMethodPermGeneral.this.getUncheckedCheckbox().setSelection(true);
                UiAssemblyMethodPermGeneral.this.setRoleNamesPartEnabled(false);
            }
            UiAssemblyMethodPermGeneral.this.updateEditableBehavior();
            UiAssemblyMethodPermGeneral.this.refreshDataFromUI();
            return ret;
        }
    }

    private class DescrModAdapter
    implements ModifyListener {
        private DescrModAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UiAssemblyMethodPermGeneral.this.handleDescriptionEvent();
        }
    }
}

