/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.editorobjects;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.ejb.IBusinessMethod;
import com.tssap.j2ee.model.ejb.ICreateMethod;
import com.tssap.j2ee.model.ejb.IEjbMethod;
import com.tssap.j2ee.model.ejb.IFinderMethod;
import com.tssap.j2ee.model.ejb.IHomeMethod;
import com.tssap.j2ee.model.ejbjar.dd.IMethod;
import com.tssap.j2ee.model.ejbjar.dd.IMethodParam;
import com.tssap.j2ee.model.ejbjar.dd.IMethodParams;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.AssemblyDescriptorContentProvider;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import com.tssap.util.ui.reuse.list.IListElement;
import com.tssap.util.ui.reuse.list.ListSelectorCallback;
import java.util.ArrayList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class UiAssemblyMethod
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$editorobjects$UiAssemblyMethod == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$editorobjects$UiAssemblyMethod = UiAssemblyMethod.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.editorobjects.UiAssemblyMethod")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$editorobjects$UiAssemblyMethod));
    private static final int CHECKBOX_REMOTE_IF = 0;
    private static final int CHECKBOX_HOME_IF = 1;
    private static final int CHECKBOX_LOCAL_IF = 2;
    private static final int CHECKBOX_LOCAL_HOME_IF = 3;
    private static final String TEXT_NO_INTF = "< ALL INTERFACES >";
    private static final String TEXT_REMOTE = "Remote";
    private static final String TEXT_HOME = "Home";
    private static final String TEXT_LOCAL = "Local";
    private static final String TEXT_LOCAL_HOME = "LocalHome";
    private Text ejbNameTextField;
    private Text descriptionTextPane;
    private Text methodNameTextField;
    private Combo methodIntfCombo;
    private Text methodParamsTextField;
    private String[] mMethodIntfItems = new String[0];
    private InnerCallbackAdapter callbackAdapter;
    private IModifiedCallback myModifyCallback;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$editorobjects$UiAssemblyMethod;

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane leftGlp = userArea.addGridLayoutPane(2, userArea.createGridLayoutData(4, 4, true, true));
        leftGlp.addTextLabel("EJB Name");
        this.ejbNameTextField = leftGlp.addTextField("", true, leftGlp.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEjbNameTextField(this.ejbNameTextField);
        leftGlp.addTextLabel("Method name");
        Text mNameTextField = leftGlp.addTextField("", true, leftGlp.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setMethodNameTextField(mNameTextField);
        leftGlp.addTextLabel("Method intf");
        this.methodIntfCombo = leftGlp.addComboBox(this.mMethodIntfItems, "", true, leftGlp.createGridLayoutData(4, 4, true, false, 1, 1));
        leftGlp.addTextLabel("Method parameters", leftGlp.createGridLayoutData(4, 4, false, false, 1, 1));
        this.methodParamsTextField = leftGlp.addTextField("", true, leftGlp.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setMethodParamsTextField(this.methodParamsTextField);
        leftGlp.addTextLabel("Description", leftGlp.createGridLayoutData(4, 4, true, false, 2, 1));
        this.descriptionTextPane = leftGlp.addTextPane("", false, true, leftGlp.createGridLayoutData(4, 4, true, true, 2, 1));
        this.setDescriptionTextPane(this.descriptionTextPane);
        this.decorateControls();
    }

    private void decorateControls() {
        this.getDescriptionTextPane().addModifyListener(this.getModifyAdapterSingleton());
        this.getMethodIntfCombo().addModifyListener(this.getModifyAdapterSingleton());
    }

    private Text getEjbNameTextField() {
        return this.ejbNameTextField;
    }

    private void setEjbNameTextField(Text ejbNameTextField) {
        this.ejbNameTextField = ejbNameTextField;
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    public int getUserGridNumOfColumns() {
        return 3;
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof TreeNode)) {
            ret = "No object of TreeNode found!";
        }
        return ret;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        IMethod method = this.getMethod();
        String descr = this.getDescriptionTextPane().getText().trim();
        if (!descr.equals("")) {
            if (method.getDescription() == null) {
                try {
                    method.createDescription(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("", e);
                }
            }
            method.getDescription().setValue(descr);
        } else if (method.getDescription() != null) {
            method.removeDescription();
        }
        if (method.getEjbName() == null) {
            try {
                method.createEjbName(null);
            }
            catch (J2eeCreateException e) {
                this.handleJ2eeCreateException("", e);
            }
        }
        method.getEjbName().setValue(this.getEjbNameTextField().getText() != null ? this.getEjbNameTextField().getText().trim() : "");
        if (!this.getMethodIntfCombo().getText().equals("")) {
            if (method.getMethodIntf() == null) {
                try {
                    method.createMethodIntf(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("", e);
                }
            }
            if (this.getMethodIntfCombo().getText().equals(TEXT_NO_INTF)) {
                method.removeMethodIntf();
            } else {
                method.getMethodIntf().setValue(this.getMethodIntfCombo().getText());
            }
        } else if (method.getMethodIntf() != null) {
            method.removeMethodIntf();
        }
        this.refreshMethodNameFromUI();
    }

    private void refreshMethodNameFromUI() {
        IMethod method = this.getMethod();
        if (method != null) {
            if (method.getMethodName() == null) {
                try {
                    method.createMethodName(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("", e);
                }
            }
            if (!this.getMethodNameTextField().getText().trim().equals("")) {
                method.getMethodName().setValue(this.getMethodNameTextField().getText().trim());
            } else if (method.getMethodName() != null) {
                method.getMethodName().setValue("");
            }
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        IMethod method = this.getMethod();
        if (method != null) {
            this.getDescriptionTextPane().setText(method.getDescription() != null ? method.getDescription().getValue() : "");
            this.getEjbNameTextField().setText(method.getEjbName() != null ? method.getEjbName().getValue() : "");
            this.getMethodNameTextField().setText(method.getMethodName() != null ? method.getMethodName().getValue() : "");
            this.mMethodIntfItems = this.getMethodInterfaces();
            if (this.mMethodIntfItems != null && this.mMethodIntfItems.length > 0) {
                this.getMethodIntfCombo().setItems(this.mMethodIntfItems);
                if (this.mMethodIntfItems.length > 1) {
                    this.getMethodIntfCombo().setEnabled(this.isEditable());
                } else {
                    this.getMethodIntfCombo().setEnabled(false);
                }
            } else {
                this.getMethodIntfCombo().setEnabled(false);
            }
            if (method.getMethodIntf() != null) {
                if (!method.getMethodIntf().getValue().equals("")) {
                    this.getMethodIntfCombo().setText(method.getMethodIntf().getValue());
                } else {
                    method.removeMethodIntf();
                    this.getMethodIntfCombo().setText(TEXT_NO_INTF);
                }
            } else {
                this.getMethodIntfCombo().setText(TEXT_NO_INTF);
            }
            this.getCallbackAdapter().setMethod(method);
            IMethodParams methodParams = method.getMethodParams();
            if (method != null && methodParams != null) {
                IMethodParam[] methodParamArr = methodParams.getMethodParams();
                StringBuffer methodParamStringBf = new StringBuffer();
                if (methodParamArr != null && methodParamArr.length > 0) {
                    int i = 0;
                    while (i < methodParamArr.length) {
                        if (i != methodParamArr.length - 1) {
                            methodParamStringBf.append(methodParamArr[i].getValue()).append(", ");
                        } else {
                            methodParamStringBf.append(methodParamArr[i].getValue());
                        }
                        ++i;
                    }
                }
                if (methodParamStringBf.length() > 0) {
                    this.getMethodParamsTextField().setText(methodParamStringBf.toString());
                }
            }
        } else {
            throw new IllegalArgumentException("No object of IMethod found!");
        }
        this.stopRefreshingUI();
    }

    private String[] getMethodInterfaces() {
        IEjbMethod iejbMethod;
        String[] ret = null;
        ArrayList<String> interfacesL = new ArrayList<String>();
        interfacesL.add(TEXT_NO_INTF);
        if (this.getData() instanceof AssemblyDescriptorContentProvider.MethodTreeNode && (iejbMethod = ((AssemblyDescriptorContentProvider.MethodTreeNode)((Object)this.getData())).getEjbMethod()) != null) {
            if (iejbMethod instanceof IBusinessMethod) {
                if (((IBusinessMethod)iejbMethod).isLocalExposed()) {
                    interfacesL.add(TEXT_LOCAL);
                }
                if (((IBusinessMethod)iejbMethod).isRemoteExposed()) {
                    interfacesL.add(TEXT_REMOTE);
                }
            } else if (iejbMethod instanceof IHomeMethod) {
                interfacesL.add(TEXT_HOME);
                interfacesL.add(TEXT_LOCAL_HOME);
            } else if (iejbMethod instanceof ICreateMethod) {
                if (((ICreateMethod)iejbMethod).getHomeDeclaration() != null) {
                    interfacesL.add(TEXT_HOME);
                }
                if (((ICreateMethod)iejbMethod).getLocalHomeDeclaration() != null) {
                    interfacesL.add(TEXT_LOCAL_HOME);
                }
            } else if (iejbMethod instanceof IFinderMethod) {
                if (((IFinderMethod)iejbMethod).getHomeDeclaration() != null) {
                    interfacesL.add(TEXT_HOME);
                }
                if (((IFinderMethod)iejbMethod).getLocalHomeDeclaration() != null) {
                    interfacesL.add(TEXT_LOCAL_HOME);
                }
            }
        }
        if (interfacesL.size() > 0) {
            ret = interfacesL.toArray(new String[interfacesL.size()]);
        }
        return ret;
    }

    protected IMethod getMethod() {
        IIdentifiable identifiable;
        IMethod ret = null;
        if (this.getData() instanceof TreeNode && (identifiable = ((TreeNode)this.getData()).getIdentifiable()) instanceof IMethod) {
            ret = (IMethod)identifiable;
        }
        return ret;
    }

    public Text getMethodNameTextField() {
        return this.methodNameTextField;
    }

    public void setMethodNameTextField(Text methodNameTextField) {
        this.methodNameTextField = methodNameTextField;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    private InnerCallbackAdapter getCallbackAdapter() {
        if (this.callbackAdapter == null) {
            this.callbackAdapter = new InnerCallbackAdapter();
        }
        return this.callbackAdapter;
    }

    private void setCallbackAdapter(InnerCallbackAdapter callbackAdapter) {
        this.callbackAdapter = callbackAdapter;
    }

    public void setModifyCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    protected void handleMethodNameEvent() {
        this.refreshMethodNameFromUI();
        super.handleEvent();
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.getDescriptionTextPane() != null) {
            this.getDescriptionTextPane().setEditable(editable);
        }
        if (this.getEjbNameTextField() != null) {
            this.getEjbNameTextField().setEditable(false);
        }
        if (this.getMethodIntfCombo() != null) {
            this.getMethodIntfCombo().setEnabled(editable && this.getMethodInterfaces() != null && this.getMethodInterfaces().length > 1);
        }
        if (this.getMethodParamsTextField() != null) {
            this.getMethodParamsTextField().setEditable(false);
        }
        if (this.getMethodNameTextField() != null) {
            this.getMethodNameTextField().setEditable(false);
        }
    }

    private Combo getMethodIntfCombo() {
        return this.methodIntfCombo;
    }

    private void setMethodIntfCombo(Combo combo) {
        this.methodIntfCombo = combo;
    }

    private Text getMethodParamsTextField() {
        return this.methodParamsTextField;
    }

    private void setMethodParamsTextField(Text text) {
        this.methodParamsTextField = text;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MethodNameModifyAdapter
    implements ModifyListener {
        private MethodNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UiAssemblyMethod.this.handleMethodNameEvent();
        }
    }

    private class InnerCallbackAdapter
    extends ListSelectorCallback {
        private IMethod method;
        private static final String TITLE = "Method params";
        private String newMethodParamValue;

        public String getTitle() {
            return TITLE;
        }

        public IListElement[] getNewElements() {
            return null;
        }

        public void elementAdded(IListElement element) {
        }

        public void elementRemoved(IListElement element) {
        }

        public IMethod getMethod() {
            return this.method;
        }

        public void setMethod(IMethod method) {
            this.method = method;
        }
    }
}

