/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.editorobjects;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ejbjar.dd.IContainerTransaction;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class UiAssemblyContainerTransGeneral
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$editorobjects$UiAssemblyContainerTransGeneral == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$editorobjects$UiAssemblyContainerTransGeneral = UiAssemblyContainerTransGeneral.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.editorobjects.UiAssemblyContainerTransGeneral")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$editorobjects$UiAssemblyContainerTransGeneral));
    private static final String DEFAULT_TRANS_ATTRIBUTE = "Required";
    private Text descriptionTextPane;
    private Combo transAttrCombobox;
    private IModifiedCallback myModifyCallback;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$editorobjects$UiAssemblyContainerTransGeneral;

    public void initContainer(IGridLayoutPane userArea) {
        userArea.addTextLabel("Description");
        this.descriptionTextPane = userArea.addTextPane("", false, true, userArea.createGridLayoutData(4, 4, true, true, 1, 1));
        this.setDescriptionTextPane(this.descriptionTextPane);
        String[] transAttributes = new String[]{DEFAULT_TRANS_ATTRIBUTE, "NotSupported", "Supports", "RequiresNew", "Mandatory", "Never"};
        userArea.addTextLabel("Transaction attribute");
        this.transAttrCombobox = userArea.addComboBox(transAttributes, "", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setTransAttrCombobox(this.transAttrCombobox);
        this.decorateControls();
    }

    private void decorateControls() {
        this.getDescriptionTextPane().addModifyListener((ModifyListener)new DescrModAdapter());
        this.getTransAttrCombobox().addModifyListener(this.getModifyAdapterSingleton());
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    private Combo getTransAttrCombobox() {
        return this.transAttrCombobox;
    }

    private void setTransAttrCombobox(Combo transAttrCombobox) {
        this.transAttrCombobox = transAttrCombobox;
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof IContainerTransaction)) {
            ret = "No object of IContainerTransaction found!";
        }
        return ret;
    }

    public void setModifyCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        IContainerTransaction containerTrans = this.getContainerTransaction();
        if (containerTrans.getTransAttribute() == null) {
            try {
                containerTrans.createTransAttribute(null);
            }
            catch (J2eeCreateException e) {
                this.handleJ2eeCreateException("<trans-attribute> could not be created.", e);
            }
        }
        containerTrans.getTransAttribute().setValue(this.getTransAttrCombobox().getText());
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        IContainerTransaction containerTrans = this.getContainerTransaction();
        if (containerTrans != null) {
            if (containerTrans instanceof IContainerTransaction) {
                this.getDescriptionTextPane().setText(containerTrans.getDescription() != null ? containerTrans.getDescription().getValue() : "");
                this.getTransAttrCombobox().setText(containerTrans.getTransAttribute() != null && !containerTrans.getTransAttribute().getValue().equals("") ? containerTrans.getTransAttribute().getValue() : DEFAULT_TRANS_ATTRIBUTE);
            } else {
                throw new IllegalArgumentException("No object of IContainerTransaction found!");
            }
        }
        this.stopRefreshingUI();
    }

    private void refreshDescriptionFieldFromUI() {
        IContainerTransaction containerTrans = this.getContainerTransaction();
        if (containerTrans != null) {
            if (!this.getDescriptionTextPane().equals("")) {
                if (containerTrans.getDescription() == null) {
                    try {
                        containerTrans.createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<description> could not be created.", e);
                    }
                }
                containerTrans.getDescription().setValue(this.getDescriptionTextPane().getText());
            } else if (containerTrans.getDescription() != null) {
                containerTrans.getDescription().setValue("");
            }
        }
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected IContainerTransaction getContainerTransaction() {
        IContainerTransaction ret = null;
        if (this.getData() instanceof IContainerTransaction) {
            ret = (IContainerTransaction)this.getData();
        }
        return ret;
    }

    protected void handleDescriptionEvent() {
        this.refreshDescriptionFieldFromUI();
        super.handleEvent();
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.descriptionTextPane != null) {
            this.descriptionTextPane.setEditable(this.isEditable());
        }
        if (this.transAttrCombobox != null) {
            this.transAttrCombobox.setEnabled(this.isEditable());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DescrModAdapter
    implements ModifyListener {
        private DescrModAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UiAssemblyContainerTransGeneral.this.handleDescriptionEvent();
        }
    }
}

