/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage;

import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejbjar.dd.IAssemblyDescriptor;
import com.tssap.j2ee.model.ejbjar.dd.IEjbJar;
import com.tssap.j2ee.model.ejbjar.dd.IMethodPermission;
import com.tssap.j2ee.model.ejbjar.dd.ISecurityRole;
import com.tssap.j2ee.ui.ejbjar.editor.IEjbJarEditor;
import com.tssap.j2ee.ui.ejbjar.editor.IEjbJarHolder;
import com.tssap.j2ee.ui.ejbjar.editor.internal.EjbJarEditorPage;
import com.tssap.j2ee.ui.ejbjar.editor.internal.EjbJarReuseableManager;
import com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.AssemblyDescriptorAddRemoveCallback;
import com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.AssemblyDescriptorContentProvider;
import com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.AssemblyDescriptorLabelProvider;
import com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.MethodPermissionWrapper;
import com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.SecurityRoleWrapper;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import com.tssap.util.ui.reuse.tree.ISelectionConverter;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import com.tssap.util.ui.reuse.tree.TreeSelectorEditorComponent;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;

public class EjbJarAssemblyDescriptorPage
extends EjbJarEditorPage
implements IModifiedCallback,
IEjbJarHolder {
    private static final int NUM_OF_COLS = 1;
    private static final String PAGE_NAME = "Assembly";
    private TreeSelectorEditorComponent myTreeEditor;
    private TreeSelector myTreeSelector;
    private AssemblyDescriptorContentProvider myTreeContentProvider;
    private AssemblyDescriptorLabelProvider myTreeLabelProvider;
    private IAddRemoveCallback myAddRemoveCallback;
    private IEjbJar ejbJar;

    public EjbJarAssemblyDescriptorPage(Composite parent, IEjbJarEditor editor) {
        super(parent, editor, 1);
    }

    protected void initControlsWithEjbJar(IEjbJar ejbJar) {
        AssemblyDescriptorContentProvider treeProv = (AssemblyDescriptorContentProvider)this.myTreeSelector.getTreeContentProvider();
        AssemblyDescriptorLabelProvider labelProv = (AssemblyDescriptorLabelProvider)this.myTreeSelector.getTreeLabelProvider();
        treeProv.setEjbJar(ejbJar);
        this.setEjbJar(ejbJar);
        this.myTreeSelector.getTreeViewer().setInput((Object)"");
    }

    protected void updateEjbJarFromControls(IEjbJar ejbJar) {
        this.myTreeEditor.aboutToLeave();
    }

    public String getPageName() {
        return PAGE_NAME;
    }

    protected Control createControls(IGridLayoutPane grid) {
        this.myTreeSelector = new TreeSelector();
        if (this.myTreeSelector != null) {
            this.myTreeSelector.setSplitterWeight(2);
        }
        this.myTreeEditor = new TreeSelectorEditorComponent(this.myTreeSelector);
        EjbJarReuseableManager erm = new EjbJarReuseableManager();
        this.myTreeEditor.setReusableManager((IReuseableManager)new EjbJarReuseableManager());
        this.myTreeContentProvider = new AssemblyDescriptorContentProvider(this.getReferencedEjbs());
        this.myTreeLabelProvider = new AssemblyDescriptorLabelProvider();
        this.myAddRemoveCallback = new AssemblyDescriptorAddRemoveCallback(this.getUnderlyingFile().getProject(), this, this.myTreeContentProvider, this.getReferencedEjbs());
        this.myTreeSelector.createPartControl(grid);
        return grid.getComposite();
    }

    public IEnterpriseJavaBean[] getReferencedEjbs() {
        IEnterpriseJavaBean[] ret = null;
        IProject myProject = this.getUnderlyingFile().getProject();
        if (myProject != null) {
            String projectName = myProject.getName();
            IEjbModule ejbAssemblyProject = J2eeProjectManager.getEjbModule((String)projectName);
            ret = ejbAssemblyProject.getReferencedEjbs();
        } else {
            ret = new IEnterpriseJavaBean[]{};
        }
        return ret;
    }

    protected void decorateControls() {
        this.myTreeEditor.setTreeContentProvider((ITreeContentProvider)this.myTreeContentProvider);
        this.myTreeEditor.setTreeLabelProvider((ILabelProvider)this.myTreeLabelProvider);
        this.myTreeEditor.setSelectionConverter((ISelectionConverter)new InnerMethodPermSelectionConverter(this.myTreeContentProvider));
        this.myTreeEditor.setModifiedCallback((IModifiedCallback)this);
        this.myTreeEditor.setAddRemoveCallback(this.myAddRemoveCallback);
    }

    public void dataModified(boolean modified) {
        this.getEditor().setDirtyFlag(modified);
        TreeViewer tv = this.myTreeEditor.getTreeSelector().getTreeViewer();
        TreeItem[] selection = tv.getTree().getSelection();
        int i = 0;
        while (i < selection.length) {
            tv.refresh(selection[i].getData(), true);
            ++i;
        }
    }

    public IEjbJar getEjbJar() {
        return this.ejbJar;
    }

    private void setEjbJar(IEjbJar ejbJar) {
        this.ejbJar = ejbJar;
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.myTreeEditor != null) {
            this.myTreeEditor.setEditable(editable);
        }
        if (this.myTreeSelector != null) {
            this.myTreeSelector.setEditable(editable);
        }
    }

    public class InnerMethodPermSelectionConverter
    implements ISelectionConverter {
        private AssemblyDescriptorContentProvider treeContentProvider;

        public InnerMethodPermSelectionConverter(AssemblyDescriptorContentProvider treeContentProvider) {
            this.treeContentProvider = treeContentProvider;
        }

        public Object convertSelection(Object selectedObject) {
            if (selectedObject instanceof IMethodPermission) {
                IAssemblyDescriptor assemblyDescriptor = this.treeContentProvider.getAssemblyDesc();
                MethodPermissionWrapper methodPermWrapper = new MethodPermissionWrapper((IMethodPermission)selectedObject, assemblyDescriptor);
                return methodPermWrapper;
            }
            if (selectedObject instanceof ISecurityRole) {
                IEjbJar ejbJar = this.treeContentProvider.getEjbJarHolder().getEjbJar();
                SecurityRoleWrapper securityRoleWrapper = new SecurityRoleWrapper((ISecurityRole)selectedObject, ejbJar);
                return securityRoleWrapper;
            }
            return selectedObject;
        }
    }
}

