/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage;

import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.dd.IMutable;
import com.tssap.j2ee.model.ejbjar.dd.IContainerTransaction;
import com.tssap.j2ee.model.ejbjar.dd.IEjbName;
import com.tssap.j2ee.model.ejbjar.dd.IExcludeList;
import com.tssap.j2ee.model.ejbjar.dd.IMethod;
import com.tssap.j2ee.model.ejbjar.dd.IMethodParam;
import com.tssap.j2ee.model.ejbjar.dd.IMethodPermission;
import com.tssap.j2ee.ui.Folder;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.J2eeModelLabelProvider;
import com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.AssemblyDescriptorContentProvider;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.swt.graphics.Image;

public class AssemblyDescriptorLabelProvider
extends J2eeModelLabelProvider {
    private Image iDefaultField = UIPlugin.getImage((String)"showchild");
    private static Image FOLDER_IMG = SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJ_FOLDER");
    private Image iBusinessMethod = UIPlugin.getImage((String)"businessMethod");
    private Image iBusinessMethodLocal = UIPlugin.getImage((String)"localPropagated");
    private Image iBusinessMethodRemote = UIPlugin.getImage((String)"remotePropagated");
    private Image iHomeMethod = UIPlugin.getImage((String)"homeMethod");
    private Image iDefaultMethod = UIPlugin.getImage((String)"defaultMethod");
    private Image iCreateMethod = UIPlugin.getImage((String)"createMethod");
    private Image iFinderMethod = UIPlugin.getImage((String)"finderMethod");
    private Image iSelectMethod = UIPlugin.getImage((String)"selectMethod");
    private Image iSecRole = UIPlugin.getImage((String)"SecurityRole");

    public Image getImage(Object element) {
        Image retImage = super.getImage(element);
        if (element instanceof AssemblyDescriptorContentProvider.IIdentifiableHolder || element instanceof Folder) {
            return FOLDER_IMG;
        }
        if (element instanceof AssemblyDescriptorContentProvider.EjbNameTreeNode) {
            return UIPlugin.getImage((String)"ejb");
        }
        if (element instanceof TreeNode) {
            IIdentifiable identifiable = ((TreeNode)element).getIdentifiable();
            if (identifiable != null && identifiable instanceof IMethod) {
                return this.iDefaultMethod;
            }
        } else {
            return retImage;
        }
        return retImage;
    }

    public String getText(Object element) {
        String ret = super.getText(element);
        if (element instanceof AssemblyDescriptorContentProvider.SecurityRoleFolder) {
            ret = "security-role";
        } else if (element instanceof AssemblyDescriptorContentProvider.MethodPermissionFolder) {
            ret = "method-permission";
        } else if (element instanceof AssemblyDescriptorContentProvider.ContainerTransactionFolder) {
            ret = "container-transaction";
        } else if (element instanceof AssemblyDescriptorContentProvider.ExcludeListFolder) {
            ret = "Exclude-list";
        } else if (element instanceof AssemblyDescriptorContentProvider.MethodFolder) {
            ret = "method";
        } else if (element instanceof IMethodPermission) {
            ret = this.getShortValueText((IMutable)((IMethodPermission)element).getDescription());
        } else if (element instanceof IContainerTransaction) {
            ret = this.getShortValueText((IMutable)((IContainerTransaction)element).getDescription());
        } else if (element instanceof IExcludeList) {
            ret = this.getShortValueText((IMutable)((IExcludeList)element).getDescription());
        } else if (element instanceof AssemblyDescriptorContentProvider.EjbNameTreeNode) {
            IEjbName ejbName;
            if (((AssemblyDescriptorContentProvider.EjbNameTreeNode)((Object)element)).getFolder() instanceof AssemblyDescriptorContentProvider.MethodFolder && (ejbName = ((AssemblyDescriptorContentProvider.EjbNameTreeNode)((Object)element)).getEjbName()) != null) {
                ret = ejbName.getValue();
            }
        } else if (element instanceof TreeNode && ((TreeNode)element).getIdentifiable() instanceof IMethod) {
            ret = this.getMethodNameWithParams((IMethod)((TreeNode)element).getIdentifiable());
        }
        return ret == null ? "..." : ret;
    }

    private String getMethodNameWithParams(IMethod method) {
        StringBuffer sb = new StringBuffer();
        String methodName = method.getMethodName().getValue();
        if (methodName.equals("*")) {
            return methodName;
        }
        IMethodParam[] methodParamsArr = method.getMethodParams() != null ? method.getMethodParams().getMethodParams() : null;
        sb.append(methodName);
        sb.append('(');
        if (methodParamsArr != null) {
            int i = 0;
            while (i < methodParamsArr.length) {
                if (i > 0) {
                    sb.append(',').append(' ');
                }
                sb.append(methodParamsArr[i].getValue());
                ++i;
            }
        }
        sb.append(')');
        return sb.toString();
    }

    private String getShortValueText(IMutable mutable) {
        String ret;
        String string = ret = mutable != null ? mutable.getValue() : null;
        if (ret != null) {
            if (ret.length() > 23) {
                ret = ret.substring(0, 22) + "...";
            } else if (ret.length() == 0) {
                ret = null;
            }
        }
        return ret;
    }
}

