/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage;

import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.ejb.IEjbMethod;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejbjar.dd.IAssemblyDescriptor;
import com.tssap.j2ee.model.ejbjar.dd.IContainerTransaction;
import com.tssap.j2ee.model.ejbjar.dd.IEjbJar;
import com.tssap.j2ee.model.ejbjar.dd.IEjbName;
import com.tssap.j2ee.model.ejbjar.dd.IExcludeList;
import com.tssap.j2ee.model.ejbjar.dd.IMethod;
import com.tssap.j2ee.model.ejbjar.dd.IMethodParam;
import com.tssap.j2ee.model.ejbjar.dd.IMethodPermission;
import com.tssap.j2ee.model.ejbjar.dd.ISecurityRole;
import com.tssap.j2ee.ui.Folder;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class AssemblyDescriptorContentProvider
implements ITreeContentProvider {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$AssemblyDescriptorContentProvider == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$AssemblyDescriptorContentProvider = AssemblyDescriptorContentProvider.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.assemblydescpage.AssemblyDescriptorContentProvider")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$AssemblyDescriptorContentProvider));
    private IEnterpriseJavaBean[] referencedEjbs;
    private IAssemblyDescriptor assemblyDesc;
    private IEjbJar ejbJar;
    private static final Object[] EMPTY_OBJ_AR = new Object[0];
    private SecurityRoleFolder securityRoleFolder = new SecurityRoleFolder();
    private MethodPermissionFolder methodPermissionFolder = new MethodPermissionFolder();
    private ContainerTransactionFolder containerTransactionFolder = new ContainerTransactionFolder();
    private ExcludeListFolder excludeListFolder = new ExcludeListFolder();
    private MethodFolderFactory methodFolderFactory = new MethodFolderFactory();
    private Object[] roots = new Object[]{this.securityRoleFolder, this.methodPermissionFolder, this.containerTransactionFolder, this.excludeListFolder};
    protected EjbJarHolder ejbJarHolder = new EjbJarHolder();
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$assemblydescpage$AssemblyDescriptorContentProvider;

    public AssemblyDescriptorContentProvider(IEnterpriseJavaBean[] refEjbs) {
        this.setReferencedEjbs(refEjbs);
    }

    public IEnterpriseJavaBean[] getReferencedEjbs() {
        return this.referencedEjbs;
    }

    private void setReferencedEjbs(IEnterpriseJavaBean[] beans) {
        this.referencedEjbs = beans;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] ret = EMPTY_OBJ_AR;
        this.ejbJar = this.ejbJarHolder.getEjbJar();
        if (this.ejbJar != null) {
            IAssemblyDescriptor assemblyDesc = this.ejbJar.getAssemblyDescriptor();
            this.setAssemblyDesc(assemblyDesc);
            if (assemblyDesc != null) {
                if (parentElement instanceof SecurityRoleFolder) {
                    ret = assemblyDesc.getSecurityRoles();
                } else if (parentElement instanceof MethodPermissionFolder) {
                    ret = assemblyDesc.getMethodPermissions();
                } else if (parentElement instanceof ContainerTransactionFolder) {
                    ret = assemblyDesc.getContainerTransactions();
                } else if (parentElement instanceof ExcludeListFolder) {
                    if (assemblyDesc.getExcludeList() != null) {
                        ret = new Object[]{assemblyDesc.getExcludeList()};
                    }
                } else if (parentElement instanceof IContainerTransaction || parentElement instanceof IMethodPermission || parentElement instanceof IExcludeList) {
                    MethodFolder methodFolder = this.methodFolderFactory.getInstance((IIdentifiable)parentElement);
                    ret = new Object[]{methodFolder};
                } else if (parentElement instanceof MethodFolder) {
                    ArrayList ejbNameTreeNodesArL = ((MethodFolder)parentElement).getTreeNodesArrayList();
                    ret = ejbNameTreeNodesArL.toArray(new Object[ejbNameTreeNodesArL.size()]);
                } else if (parentElement instanceof EjbNameTreeNode) {
                    ArrayList methodNodesArL = ((EjbNameTreeNode)((Object)parentElement)).getTreeNodesArrayList();
                    ret = methodNodesArL.toArray(new Object[methodNodesArL.size()]);
                }
            }
        }
        return ret;
    }

    public Object getParent(Object child) {
        IIdentifiableHolder ret = null;
        if (child instanceof ISecurityRole) {
            ret = this.securityRoleFolder;
        } else if (child instanceof IMethodPermission) {
            ret = this.methodPermissionFolder;
        } else if (child instanceof IContainerTransaction) {
            ret = this.containerTransactionFolder;
        } else if (child instanceof TreeNode) {
            ret = ((TreeNode)child).getFolder();
        }
        return ret;
    }

    public boolean hasChildren(Object parent) {
        return this.getChildren(parent).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.roots;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setEjbJar(IEjbJar ejbJar) {
        this.ejbJarHolder.setEjbJar(ejbJar);
    }

    public boolean isExcludeListSet() {
        IEjbJar ejbJar = this.ejbJarHolder.getEjbJar();
        if (ejbJar != null) {
            IAssemblyDescriptor assemblyDescriptor = ejbJar.getAssemblyDescriptor();
            if (assemblyDescriptor != null && ejbJar.getAssemblyDescriptor().getExcludeList() != null) {
                return true;
            }
        } else {
            tracer.warning("AssemblyDescriptorContentProvider", "isExcludeListSet", "ejbJar is null which should not occur!");
        }
        return false;
    }

    public IAssemblyDescriptor getAssemblyDesc() {
        return this.assemblyDesc;
    }

    private void setAssemblyDesc(IAssemblyDescriptor assemblyDesc) {
        this.assemblyDesc = assemblyDesc;
    }

    protected EjbJarHolder getEjbJarHolder() {
        return this.ejbJarHolder;
    }

    private void setEjbJarHolder(EjbJarHolder ejbJarHolder) {
        this.ejbJarHolder = ejbJarHolder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class MethodTreeNode
    extends TreeNode {
        IEjbMethod mEjbMethod;
        IEjbName ejbName;
        EjbNameTreeNode ejbTreeNode;

        public MethodTreeNode(IEjbMethod ejbMethod, IEjbName myEjbName, EjbNameTreeNode ejbNameTreeNode) {
            this.mEjbMethod = ejbMethod;
            this.ejbName = myEjbName;
            this.ejbTreeNode = ejbNameTreeNode;
        }

        public IEjbName getEjbName() {
            return this.ejbName;
        }

        public IEjbMethod getEjbMethod() {
            return this.mEjbMethod;
        }

        public EjbNameTreeNode getEjbNameTreeNode() {
            return this.ejbTreeNode;
        }
    }

    public class EjbNameTreeNode
    extends TreeNode {
        IEjbName ejbName;
        ArrayList treeNodesArL = null;
        ArrayList methodsArL = null;
        ArrayList methodsL = null;

        public IEjbName getEjbName() {
            return this.ejbName;
        }

        void setEjbName(IEjbName name) {
            this.ejbName = name;
        }

        void addMethod(IMethod method) {
            if (this.methodsArL == null) {
                this.methodsArL = new ArrayList();
            }
            if (!this.methodsArL.contains(method)) {
                this.methodsArL.add(method);
            }
        }

        public ArrayList getMethodsArL() {
            return this.methodsArL;
        }

        public ArrayList getTreeNodesArrayList() {
            this.createTreeNodes();
            return this.treeNodesArL;
        }

        private void createTreeNodes() {
            IMethod[] methods = null;
            if (this.methodsArL != null && this.methodsArL.size() > 0) {
                methods = this.methodsArL.toArray(new IMethod[this.methodsArL.size()]);
            }
            if (this.treeNodesArL == null) {
                this.treeNodesArL = new ArrayList();
            }
            if (this.methodsL == null) {
                this.methodsL = new ArrayList();
            }
            int i = 0;
            while (i < methods.length) {
                if (!this.methodsL.contains(methods[i])) {
                    this.methodsL.add(methods[i]);
                    IEnterpriseJavaBean[] allEjbs = AssemblyDescriptorContentProvider.this.getReferencedEjbs();
                    IEnterpriseJavaBean iejb = null;
                    int j = 0;
                    while (j < allEjbs.length && iejb == null) {
                        if (allEjbs[j].getEjbName().equals(methods[i].getEjbName().getValue())) {
                            iejb = allEjbs[j];
                        }
                        ++j;
                    }
                    IMethodParam[] mParamArr = null;
                    String[] mParamsStrg = null;
                    if (methods[i].getMethodParams() != null) {
                        mParamArr = methods[i].getMethodParams().getMethodParams();
                        mParamsStrg = new String[mParamArr.length];
                        int j2 = 0;
                        while (j2 < mParamArr.length) {
                            mParamsStrg[j2] = mParamArr[j2].getValue();
                            ++j2;
                        }
                    } else {
                        mParamsStrg = new String[]{};
                    }
                    String ddMethodName = methods[i].getMethodName().getValue();
                    if (ddMethodName.startsWith("create") || ddMethodName.startsWith("find")) {
                        ddMethodName = "ejb".concat(ddMethodName.substring(0, 1).toUpperCase()).concat(ddMethodName.substring(1, ddMethodName.length()));
                    } else if (ddMethodName.startsWith("method")) {
                        ddMethodName = "ejbHome".concat(ddMethodName.substring(0, 1).toUpperCase()).concat(ddMethodName.substring(1, ddMethodName.length()));
                    }
                    if (iejb != null) {
                        IEjbMethod iejbMethod = iejb.getEJBMethod(ddMethodName, mParamsStrg);
                        MethodTreeNode treeNode = new MethodTreeNode(iejbMethod, methods[i].getEjbName(), this);
                        treeNode.setIdentifiable((IIdentifiable)methods[i]);
                        treeNode.setFolder(this.getFolder());
                        this.treeNodesArL.add(treeNode);
                    } else {
                        MethodTreeNode treeNode = new MethodTreeNode(null, methods[i].getEjbName(), this);
                        treeNode.setIdentifiable((IIdentifiable)methods[i]);
                        treeNode.setFolder(this.getFolder());
                        this.treeNodesArL.add(treeNode);
                        tracer.error("AssemblyMethodChooserResult(IEjbAssemblyProject, IIdentifiable,IMethod) ", "The bean " + methods[i].getEjbName().getValue() + " does not appear to be in the workspace.");
                    }
                }
                ++i;
            }
        }
    }

    public class MethodFolder
    implements Folder {
        IIdentifiable myIdentifiable = null;
        List ejbNamesL = null;
        ArrayList ejbNameTreeNodesArL = null;
        HashMap ejbNameTreeNodesHm = null;

        public MethodFolder(IIdentifiable identifiable) {
            this.myIdentifiable = identifiable;
        }

        private IMethod[] getMethods() {
            IMethod[] methodArray = null;
            if (this.myIdentifiable instanceof IMethodPermission) {
                methodArray = ((IMethodPermission)this.getIdentifiable()).getMethods();
            } else if (this.myIdentifiable instanceof IContainerTransaction) {
                methodArray = ((IContainerTransaction)this.getIdentifiable()).getMethods();
            } else if (this.myIdentifiable instanceof IExcludeList) {
                methodArray = ((IExcludeList)this.getIdentifiable()).getMethods();
            }
            return methodArray;
        }

        private void createEjbNameTreeNodes() {
            IMethod[] methods = this.getMethods();
            if (methods != null) {
                if (this.ejbNamesL == null) {
                    this.ejbNamesL = new ArrayList();
                }
                if (this.ejbNameTreeNodesArL == null) {
                    this.ejbNameTreeNodesArL = new ArrayList();
                }
                if (this.ejbNameTreeNodesHm == null) {
                    this.ejbNameTreeNodesHm = new HashMap();
                }
                EjbNameTreeNode ejbNameTreeNode = null;
                int i = 0;
                while (i < methods.length) {
                    if (!this.ejbNamesL.contains(methods[i].getEjbName().getValue())) {
                        this.ejbNamesL.add(methods[i].getEjbName().getValue());
                        ejbNameTreeNode = new EjbNameTreeNode();
                        ejbNameTreeNode.setFolder(this);
                        ejbNameTreeNode.setIdentifiable(this.getIdentifiable());
                        ejbNameTreeNode.setEjbName(methods[i].getEjbName());
                        ejbNameTreeNode.addMethod(methods[i]);
                        this.ejbNameTreeNodesHm.put(methods[i].getEjbName().getValue(), ejbNameTreeNode);
                        this.ejbNameTreeNodesArL.add(ejbNameTreeNode);
                    } else {
                        ejbNameTreeNode = (EjbNameTreeNode)((Object)this.ejbNameTreeNodesHm.get(methods[i].getEjbName().getValue()));
                        ejbNameTreeNode.addMethod(methods[i]);
                    }
                    ++i;
                }
            }
        }

        public IIdentifiable getIdentifiable() {
            return this.myIdentifiable;
        }

        public void removeTreeNode(TreeNode treeNode, EjbNameTreeNode ejbNameTreeNode) {
            if (ejbNameTreeNode != null) {
                if (ejbNameTreeNode.getTreeNodesArrayList() != null) {
                    ((AbstractCollection)ejbNameTreeNode.getTreeNodesArrayList()).remove(treeNode);
                    if (ejbNameTreeNode.getTreeNodesArrayList().size() == 0) {
                        ((AbstractCollection)this.ejbNameTreeNodesArL).remove((Object)ejbNameTreeNode);
                    }
                } else {
                    tracer.error("MethodFolder", "removeTreeNode", "TreeNodesArrayList is empty!");
                }
            } else {
                tracer.error("MethodFolder", "removeTreeNode", "ejbNameTreeNode is null.");
            }
        }

        public ArrayList getTreeNodesArrayList() {
            this.createEjbNameTreeNodes();
            return this.ejbNameTreeNodesArL;
        }

        public void removeTreeNode(TreeNode treeNode) {
        }
    }

    private class MethodFolderFactory {
        private HashMap methodHashMap = new HashMap();

        private MethodFolderFactory() {
        }

        public MethodFolder getInstance(IIdentifiable identifiable) {
            MethodFolder ret = (MethodFolder)this.methodHashMap.get(identifiable);
            if (ret == null) {
                ret = new MethodFolder(identifiable);
                this.methodHashMap.put(identifiable, ret);
            }
            return ret;
        }
    }

    public class ExcludeListFolder
    extends IIdentifiableHolder {
    }

    public class ContainerTransactionFolder
    extends IIdentifiableHolder {
    }

    public class MethodPermissionFolder
    extends IIdentifiableHolder {
    }

    public class SecurityRoleFolder
    extends IIdentifiableHolder {
    }

    public class IIdentifiableHolder {
        public IIdentifiable identifiable;
        public IMethodPermission methodPermission;
        public IContainerTransaction containerTransaction;
        public IExcludeList excludeList;

        public IIdentifiable getIdentifiable() {
            return this.identifiable;
        }

        public void setIdentifiable(IIdentifiable identifiable) {
            this.identifiable = identifiable;
        }

        public IContainerTransaction getContainerTransaction() {
            return this.containerTransaction;
        }

        public IExcludeList getExcludeList() {
            return this.excludeList;
        }

        public IMethodPermission getMethodPermission() {
            return this.methodPermission;
        }

        public void setContainerTransaction(IContainerTransaction containerTransaction) {
            this.containerTransaction = containerTransaction;
        }

        public void setExcludeList(IExcludeList excludeList) {
            this.excludeList = excludeList;
        }

        public void setMethodPermission(IMethodPermission methodPermission) {
            this.methodPermission = methodPermission;
        }
    }

    public class EjbJarHolder {
        private IEjbJar myEjbJar;

        protected IEjbJar getEjbJar() {
            return this.myEjbJar;
        }

        protected void setEjbJar(IEjbJar ejbjar) {
            this.myEjbJar = ejbjar;
        }
    }
}

