/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.ejbjar.editor.internal;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IMutable;
import com.tssap.j2ee.model.dd.MutableUtil;
import com.tssap.j2ee.model.ejbjar.dd.IDescription;
import com.tssap.j2ee.model.ejbjar.dd.IDisplayName;
import com.tssap.j2ee.model.ejbjar.dd.IEjbClientJar;
import com.tssap.j2ee.model.ejbjar.dd.IEjbJar;
import com.tssap.j2ee.model.ejbjar.dd.ILargeIcon;
import com.tssap.j2ee.model.ejbjar.dd.ISmallIcon;
import com.tssap.j2ee.ui.editor.reuse.gi.DDGeneralInfoComponent;
import com.tssap.j2ee.ui.editor.reuse.gi.IDDGeneralInfoComponent;
import com.tssap.j2ee.ui.editor.reuse.gi.IDDGeneralInfoComponentAdapter;
import com.tssap.j2ee.ui.ejbjar.editor.IEjbJarEditor;
import com.tssap.j2ee.ui.ejbjar.editor.internal.EjbJarEditorPage;
import com.tssap.j2ee.ui.util.J2eePrjImageChooser;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.chooser.IDisplayableChooser;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class EjbJarGeneralPage
extends EjbJarEditorPage {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$ejbjar$editor$internal$EjbJarGeneralPage == null ? (class$com$tssap$j2ee$ui$ejbjar$editor$internal$EjbJarGeneralPage = EjbJarGeneralPage.class$("com.tssap.j2ee.ui.ejbjar.editor.internal.EjbJarGeneralPage")) : class$com$tssap$j2ee$ui$ejbjar$editor$internal$EjbJarGeneralPage));
    private static final int NUM_OF_COLS = 1;
    private static final String PAGE_NAME = "General";
    private IDDGeneralInfoComponent infoComponent;
    private InnerInfoComponentAdapter infoComponentAdapter;
    private Text ejbClientJarTextField;
    private boolean isUpdating = false;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$ejbjar$editor$internal$EjbJarGeneralPage;

    public EjbJarGeneralPage(Composite parent, IEjbJarEditor editor) {
        super(parent, editor, 1);
    }

    protected void initControlsWithEjbJar(IEjbJar ejbJar) {
        this.isUpdating = true;
        this.infoComponentAdapter.setEjbJar(ejbJar);
        this.infoComponent.initialize();
        if (ejbJar != null && ejbJar.getEjbClientJar() != null) {
            this.getEjbClientJarTextField().setText(ejbJar.getEjbClientJar().getValue());
        }
        this.isUpdating = false;
    }

    protected void updateEjbJarFromControls(IEjbJar ejbJar) {
        String ejbClientJarValue = this.getEjbClientJarTextField().getText();
        IEjbClientJar iejbClientJar = ejbJar.getEjbClientJar();
        if (ejbJar != null) {
            if (ejbJar.getSmallIcon() != null && (this.infoComponentAdapter.getSmallIcon() == null || this.infoComponentAdapter.getSmallIcon().length() == 0)) {
                ejbJar.removeSmallIcon();
            }
            if (ejbJar.getLargeIcon() != null && (this.infoComponentAdapter.getLargeIcon() == null || this.infoComponentAdapter.getLargeIcon().length() == 0)) {
                ejbJar.removeLargeIcon();
            }
            if (ejbClientJarValue != null && !ejbClientJarValue.equals("")) {
                if (iejbClientJar == null) {
                    try {
                        iejbClientJar = ejbJar.createEjbClientJar(null);
                        iejbClientJar.setValue(ejbClientJarValue);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<ejb-client-jar> could not be created.", e);
                    }
                } else {
                    iejbClientJar.setValue(ejbClientJarValue);
                }
            } else if (iejbClientJar != null) {
                ejbJar.removeEjbClientJar();
            }
        }
    }

    public String getPageName() {
        return PAGE_NAME;
    }

    protected Control createControls(IGridLayoutPane grid) {
        this.infoComponent = new DDGeneralInfoComponent();
        this.infoComponent.createPartControl(grid, true, false);
        J2eePrjImageChooser iconChooser = new J2eePrjImageChooser(this.getUnderlyingFile().getProject());
        ((DDGeneralInfoComponent)this.infoComponent).setDisplayableChooser(0, (IDisplayableChooser)iconChooser);
        ((DDGeneralInfoComponent)this.infoComponent).setDisplayableChooser(1, (IDisplayableChooser)iconChooser);
        this.infoComponentAdapter = new InnerInfoComponentAdapter();
        this.infoComponent.setAdapter((IDDGeneralInfoComponentAdapter)this.infoComponentAdapter);
        IGridLayoutPane ejbClientJarGlp = grid.addGridLayoutPane(2, false, grid.createGridLayoutData(4, 4, true, false));
        ejbClientJarGlp.addTextLabel("ejb-client-jar", ejbClientJarGlp.createGridLayoutData(4, 4, false, false, 1, 1));
        this.ejbClientJarTextField = ejbClientJarGlp.addTextField(false, ejbClientJarGlp.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEjbClientJarTextField(this.ejbClientJarTextField);
        return grid.getComposite();
    }

    protected void decorateControls() {
        this.getEjbClientJarTextField().addModifyListener((ModifyListener)new ModifyAdapter());
    }

    private Text getEjbClientJarTextField() {
        return this.ejbClientJarTextField;
    }

    private void setEjbClientJarTextField(Text ejbClientJarTextField) {
        this.ejbClientJarTextField = ejbClientJarTextField;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.infoComponent != null) {
            this.infoComponent.setEditable(editable);
        }
        if (this.getEjbClientJarTextField() != null) {
            this.getEjbClientJarTextField().setEditable(editable);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ModifyAdapter
    implements ModifyListener {
        public void modifyText(ModifyEvent e) {
            if (!EjbJarGeneralPage.this.isUpdating) {
                EjbJarGeneralPage.super.makeEditorDirty();
            }
        }
    }

    private class InnerInfoComponentAdapter
    implements IDDGeneralInfoComponentAdapter {
        private IEjbJar ejbJar = null;

        public String getDescription() {
            if (this.getEjbJar() == null) {
                return "";
            }
            IDescription descriptionMutable = this.getEjbJar().getDescription();
            String description = MutableUtil.mutableToValue((IMutable)descriptionMutable);
            return description;
        }

        public String getDisplayName() {
            if (this.getEjbJar() == null) {
                return "";
            }
            IDisplayName displayNameMutable = this.getEjbJar().getDisplayName();
            String displayName = MutableUtil.mutableToValue((IMutable)displayNameMutable);
            return displayName;
        }

        public String getLargeIcon() {
            String ret = "";
            if (this.isIconsChecked()) {
                ILargeIcon largeIconMutable = this.getEjbJar().getLargeIcon();
                ret = MutableUtil.mutableToValue((IMutable)largeIconMutable);
            }
            return ret;
        }

        public String getSmallIcon() {
            String ret = "";
            if (this.isIconsChecked()) {
                ISmallIcon smallIconMutable = this.getEjbJar().getSmallIcon();
                ret = MutableUtil.mutableToValue((IMutable)smallIconMutable);
            }
            return ret;
        }

        public void setDescription(String description) {
            if (this.getEjbJar().getDescription() != null) {
                this.getEjbJar().getDescription().setValue(description);
            } else {
                try {
                    this.getEjbJar().createDescription(null).setValue(description);
                }
                catch (J2eeCreateException e) {
                    tracer.error("setDescription", "description-tag could not be generated", (Throwable)e);
                }
            }
            EjbJarGeneralPage.super.makeEditorDirty();
        }

        public void setDisplayName(String displayName) {
            if (this.getEjbJar().getDisplayName() != null) {
                this.getEjbJar().getDisplayName().setValue(displayName);
            } else {
                try {
                    this.getEjbJar().createDisplayName(null).setValue(displayName);
                }
                catch (J2eeCreateException e) {
                    tracer.error("setDisplayName", "display-tag could not be generated", (Throwable)e);
                }
            }
            EjbJarGeneralPage.super.makeEditorDirty();
        }

        public void setLargeIcon(String largeIcon) {
            if (largeIcon.length() > 0) {
                if (this.getEjbJar().getLargeIcon() != null) {
                    this.getEjbJar().getLargeIcon().setValue(largeIcon);
                } else {
                    try {
                        this.getEjbJar().createLargeIcon(null).setValue(largeIcon);
                    }
                    catch (J2eeCreateException e) {
                        tracer.error("setLargeIcon", "large icon-tag could not be generated", (Throwable)e);
                    }
                }
            } else if (this.getEjbJar().getLargeIcon() != null) {
                this.getEjbJar().removeLargeIcon();
            }
            EjbJarGeneralPage.super.makeEditorDirty();
        }

        public void setSmallIcon(String smallIcon) {
            if (smallIcon.length() > 0) {
                if (this.getEjbJar().getSmallIcon() != null) {
                    this.getEjbJar().getSmallIcon().setValue(smallIcon);
                } else {
                    try {
                        this.getEjbJar().createSmallIcon(null).setValue(smallIcon);
                    }
                    catch (J2eeCreateException e) {
                        tracer.error("setSmallIcon", "small icon-tag could not be generated", (Throwable)e);
                    }
                }
            } else if (this.getEjbJar().getSmallIcon() != null) {
                this.getEjbJar().removeSmallIcon();
            }
            EjbJarGeneralPage.super.makeEditorDirty();
        }

        public boolean isIconsChecked() {
            ISmallIcon smallicon = this.getEjbJar().getSmallIcon();
            ILargeIcon largeicon = this.getEjbJar().getLargeIcon();
            boolean smalliconExists = false;
            boolean largeiconExists = false;
            if (smallicon != null && smallicon.getValue() != null && smallicon.getValue().length() > 0) {
                smalliconExists = true;
            }
            if (largeicon != null && largeicon.getValue() != null && largeicon.getValue().length() > 0) {
                largeiconExists = true;
            }
            return smalliconExists || largeiconExists;
        }

        public void setIconsChecked(boolean checkFlag) {
            if (this.getEjbJar() != null) {
                if (checkFlag) {
                    if (!this.isIconsChecked()) {
                        this.setLargeIcon("");
                        this.setSmallIcon("");
                    }
                } else {
                    this.getEjbJar().removeLargeIcon();
                    this.getEjbJar().removeSmallIcon();
                }
                EjbJarGeneralPage.super.makeEditorDirty();
            }
        }

        public IEjbJar getEjbJar() {
            return this.ejbJar;
        }

        public void setEjbJar(IEjbJar ejbJar) {
            this.ejbJar = ejbJar;
        }
    }
}

