/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.transport;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;

public class TransportException
extends IOException {
    protected static final String NEWLINE = System.getProperty("line.separator", "\n");
    private Throwable originalException;
    private String objectUrl;
    private String transportFilename;

    protected TransportException() {
    }

    public TransportException(String aMessage, Throwable aRootCause) {
        this(aMessage, aRootCause, null, null);
    }

    public TransportException(String aMessage, Throwable aRootCause, String aObjectUrl) {
        this(aMessage, aRootCause, aObjectUrl, null);
    }

    public TransportException(String aMessage, Throwable aRootCause, String aObjectUrl, String aTransportFilename) {
        super(aMessage);
        this.setException(aRootCause);
        this.setObjectUrl(aObjectUrl);
        this.setTransportFilename(aTransportFilename);
    }

    public TransportException(String aMessage) {
        super(aMessage);
    }

    public TransportException(Throwable aRootCause) {
        this.setException(aRootCause);
    }

    public Throwable getException() {
        return this.originalException;
    }

    public final void setException(Throwable t) {
        this.originalException = t;
    }

    public void printStackTrace(PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            super.printStackTrace(out);
            if (this.originalException != null) {
                out.println();
                out.println("Original exception: ");
                this.originalException.printStackTrace(out);
            }
        }
    }

    public void printStackTrace(PrintWriter out) {
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            super.printStackTrace(out);
            if (this.originalException != null) {
                out.println();
                out.println("Original exception: ");
                this.originalException.printStackTrace(out);
            }
        }
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public String getMessage() {
        String originalMsg;
        String msg = super.getMessage();
        if (msg == null) {
            msg = this.getClass().getName();
        }
        if (this.originalException != null && (originalMsg = this.originalException.getMessage()) != null) {
            StringBuffer sb = new StringBuffer(msg.length() + originalMsg.length() + 2);
            sb.append(msg).append(NEWLINE).append(originalMsg);
            msg = sb.toString();
        }
        return msg;
    }

    public final void setObjectUrl(String aObjectUrl) {
        this.objectUrl = aObjectUrl;
    }

    public String getObjectUrl() {
        return this.objectUrl;
    }

    public final void setTransportFilename(String aFilename) {
        this.transportFilename = aFilename;
    }

    public String getTransportFilename() {
        return this.transportFilename;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        sb.append(this.getMessage());
        if (this.getObjectUrl() != null) {
            sb.append(NEWLINE);
            sb.append("Object ID: ");
            sb.append(this.getObjectUrl());
        }
        if (this.getTransportFilename() != null) {
            sb.append(NEWLINE);
            sb.append("Transport File: ");
            sb.append(this.getTransportFilename());
        }
        return sb.toString();
    }
}

