/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.portaleventing.ui;

import com.sap.ide.metamodel.webdynpro.base.Procedure;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.tools.core.template.service.GenerationPositionEnum;
import com.sap.ide.webdynpro.controllereditor.context.ContextContentProvider;
import com.sap.ide.webdynpro.controllereditor.context.ContextElementSorter;
import com.sap.ide.webdynpro.controllereditor.context.ContextLabelProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.method.CreateMethodWizardDialog;
import com.sap.ide.webdynpro.template.portaleventing.PortalEventingData;
import com.sap.ide.webdynpro.template.portaleventing.TextPool;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import java.util.Arrays;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractPortalEventingWizardPage
extends WizardPage {
    protected static final TextPool mTextPool = TextPool.getInstance();
    protected PortalEventingData mData;

    public AbstractPortalEventingWizardPage(String pageName, PortalEventingData data) {
        super(pageName);
        this.mData = data;
    }

    public void setErrorMessage(String errorMessage) {
        this.setPageComplete(errorMessage == null);
        String message = null;
        if (errorMessage != null && errorMessage.length() > 0) {
            message = errorMessage;
        }
        super.setErrorMessage(message);
    }

    protected void indent(Control c, int indent) {
        GridData data;
        Object layoutData = c.getLayoutData();
        if (layoutData instanceof GridData) {
            data = (GridData)layoutData;
        } else {
            data = new GridData();
            c.setLayoutData((Object)data);
        }
        data.horizontalIndent = indent;
    }

    protected Label placeholder(Composite composite, int horizontalSpan) {
        Label label = this.placeholder(composite);
        GridData data = new GridData();
        data.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Label placeholder(Composite composite) {
        return new Label(composite, 0);
    }

    protected TreeViewer createContextTreeViewer(Composite parent, ISelectionChangedListener listener) {
        TreeViewer viewer = new TreeViewer(parent, 2052);
        this.configureTreeViewer(viewer, listener);
        return viewer;
    }

    protected TreeViewer createContextTreeViewer(IGridLayoutPane parent, ISelectionChangedListener listener) {
        return this.createContextTreeViewer(parent, null, listener);
    }

    protected TreeViewer createContextTreeViewer(IGridLayoutPane parent, IGridLayoutData data, ISelectionChangedListener listener) {
        TreeViewer viewer = null;
        viewer = data != null ? parent.addTreeViewer(false, data) : parent.addTreeViewer(false);
        this.configureTreeViewer(viewer, listener);
        return viewer;
    }

    protected boolean isAlive(Viewer v) {
        return v != null && v.getControl() != null && !v.getControl().isDisposed();
    }

    protected int indexOfPosition() {
        GenerationPositionEnum generationPositionEnum = this.mData.getMethodPosition();
        if (generationPositionEnum == GenerationPositionEnum.BEFORE) {
            return 0;
        }
        if (generationPositionEnum == GenerationPositionEnum.AFTER) {
            return 1;
        }
        return -1;
    }

    protected GenerationPositionEnum getPositionByIndex(int index) {
        if (index == 0) {
            return GenerationPositionEnum.BEFORE;
        }
        if (index == 1) {
            return GenerationPositionEnum.AFTER;
        }
        return this.mData.getMethodPosition();
    }

    private void configureTreeViewer(TreeViewer viewer, ISelectionChangedListener listener) {
        Controller viewController = this.mData.getView().getViewController();
        viewer.setContentProvider((IContentProvider)new ContextContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ContextLabelProvider(viewController.getOutgoingControllerUsages(), false));
        viewer.setSorter((ViewerSorter)new ContextElementSorter());
        viewer.addSelectionChangedListener(listener);
        viewer.setInput((Object)new ContextContentProvider.ContextRoot((ContextElement)viewController.getContext()));
        viewer.expandToLevel(2);
    }

    protected abstract class PortalWizardPageTextListener
    implements ModifyListener {
        protected PortalWizardPageTextListener() {
        }

        public void modifyText(ModifyEvent e) {
            String message;
            Text source = (Text)e.getSource();
            String text = source.getText();
            if (text != null && text.length() == 0) {
                text = null;
            }
            this.setText((message = this.isValid(text)) == null ? text : null);
            AbstractPortalEventingWizardPage.this.setErrorMessage(message);
        }

        protected String isValid(String text) {
            return null;
        }

        protected abstract void setText(String var1);
    }

    protected abstract class AbstractNewMethodListener
    extends PortalWizardPageSelectionListener {
        protected final Combo mCombo;

        AbstractNewMethodListener(Combo combo) {
            this.mCombo = combo;
        }

        public void widgetSelected(SelectionEvent e) {
            Procedure proc;
            CreateMethodWizardDialog dialog = new CreateMethodWizardDialog(AbstractPortalEventingWizardPage.this.mData.getView().getViewController());
            if (dialog.open() == 0 && (proc = dialog.getNewProcedure()) != null) {
                String name = proc.getName();
                this.mCombo.add(name);
                Object[] items = this.mCombo.getItems();
                Arrays.sort(items);
                this.mCombo.setItems((String[])items);
                this.mCombo.setText(name);
                this.setMethod(name);
            }
            super.widgetSelected(e);
        }

        protected abstract void setMethod(String var1);
    }

    protected abstract class AbstractMethodListener
    extends PortalWizardPageSelectionListener {
        protected AbstractMethodListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Combo combo = (Combo)e.getSource();
            String methodName = combo.getText();
            if (methodName != null) {
                this.setMethod(methodName);
            }
            super.widgetSelected(e);
        }

        protected abstract void setMethod(String var1);
    }

    protected abstract class ContextTreeSelectionChangedListener
    implements ISelectionChangedListener {
        private boolean mFirstTime = true;

        protected ContextTreeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            String errorMessage = null;
            String warningMessage = null;
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            if (sel.isEmpty()) {
                return;
            }
            ContextElement element = (ContextElement)sel.getFirstElement();
            if (element != null) {
                if (!(element instanceof ContextAttribute)) {
                    errorMessage = mTextPool.getText(50);
                } else {
                    ContextAttribute attribute = (ContextAttribute)element;
                    errorMessage = this.isValid(attribute);
                    if (errorMessage == null) {
                        warningMessage = this.hasWarnings(attribute);
                        this.setContextAttribute(attribute);
                    }
                }
            }
            if (errorMessage != null) {
                this.setContextAttribute(null);
            }
            if (!this.mFirstTime) {
                AbstractPortalEventingWizardPage.this.setErrorMessage(errorMessage);
                AbstractPortalEventingWizardPage.this.setMessage(warningMessage, 2);
            }
            this.mFirstTime = false;
        }

        protected String isValid(ContextAttribute attribute) {
            return null;
        }

        protected String hasWarnings(ContextAttribute attribute) {
            return null;
        }

        protected abstract void setContextAttribute(ContextAttribute var1);
    }

    protected class PortalWizardPageSelectionListener
    implements SelectionListener {
        protected PortalWizardPageSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            AbstractPortalEventingWizardPage.super.getContainer().updateButtons();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

