/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.portaleventing.generation;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Method;
import com.sap.ide.metamodel.webdynpro.component.controller.Action;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.tools.core.patternfwk.ISourcePatternResult;
import com.sap.ide.tools.core.template.service.GenerationPositionEnum;
import com.sap.ide.tools.core.template.service.IGenerationFacade;
import com.sap.ide.tools.core.template.service.ITemplateData;
import com.sap.ide.tools.core.template.service.ITemplateGeneration;
import com.sap.ide.webdynpro.template.portaleventing.PortalEventingData;

public class PortalEventingGeneration
implements ITemplateGeneration,
ISourcePatternResult {
    private static final MainDevelopmentObject[] EMPTY_MDO_ARRAY = new MainDevelopmentObject[0];
    private static final String LINE_SEP = System.getProperty("line.separator", "\n");
    private static final String TAB = "\t";
    private static final String EMPTY_STRING = "";
    private static final String SPACE = " ";
    private static final String QUOT = "\"";
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String DOT = ".";
    private static final String COLON = ",";
    private static final String SEMICOLON = ";";
    private static final String INTF_PREFIX = "I";
    private static final String PARENTHESES_OPENED = "(";
    private static final String PARENTHESES_CLOSED = ")";
    private static final String PARENTHESES_BOTH = "()";
    private static final String CURLY_BRACKET_OPENED = "{";
    private static final String CURLY_BRACKET_CLOSED = "}";
    private static final String NOT_EQUAL_NULL = " != null";
    private static final String IF = "if ";
    private static final String ASSIGNMENT_OP = " = ";
    private static final String STRING_CLASS = "String";
    private static final String STRING_CAST = "(String) ";
    private static final String STRING_VALUEOF = "String.valueOf";
    private static final String TO_STRING = "toString";
    private static final String WDTHIS = "wdThis";
    private static final String WDGET_PREFIX = "wdGet";
    private static final String ACTION_POSTFIX = "Action";
    private static final String WDCONTEXT = "wdContext";
    private static final String CURRENT = "current";
    private static final String ELEMENT = "Element";
    private static final String ATTRIBUTE_VALUE = "AttributeValue";
    private static final String GET_ATTRIBUTE_VALUE = "getAttributeValue";
    private static final String SET_ATTRIBUTE_VALUE = "setAttributeValue";
    private static final String WDPORTALEVENTING = "WDPortalEventing";
    private static final String WDPORTALEVENTING_QUALIFIED = "com.sap.tc.webdynpro.clientserver.event.api.WDPortalEventing";
    private static final String METHOD_EVENT_FIRE = "fire";
    private static final String METHOD_EVENT_SUBSCRIBE = "subscribe";
    private static final String METHOD_EVENT_UNSUBSCRIBE = "unsubscribe";
    private static final String NAMESPACE_PREFIX = "urn:";
    private PortalEventingData mData;
    private IGenerationFacade mFacade;

    public PortalEventingGeneration() {
    }

    public PortalEventingGeneration(PortalEventingData data) {
        this.mData = data;
    }

    public void generateMetaDataObjects(ITemplateData templateData, DevelopmentObject containingObject) {
    }

    public void generateCoding(IGenerationFacade facade) {
        this.mFacade = facade;
        this.mData = (PortalEventingData)facade.getTemplateData();
        if (this.mData.getEventingMode() == 1) {
            this.generateFireCodeComplete();
        } else if (this.mData.getEventingMode() == 0) {
            this.generateSubscriptionCodeComplete();
        }
    }

    public void finish(ITemplateData templateData) {
    }

    public boolean check(ITemplateData templateData, DevelopmentObject object) {
        return object instanceof View && templateData.isValid();
    }

    public MainDevelopmentObject[] getAffectedMDOs(ITemplateData templateData, DevelopmentObject object) {
        return new MainDevelopmentObject[]{object.getMDO()};
    }

    public MainDevelopmentObject[] getCreatedMDOs(ITemplateData templateData, DevelopmentObject object) {
        return EMPTY_MDO_ARRAY;
    }

    public MainDevelopmentObject[] getDeletedMDOs(ITemplateData templateData, DevelopmentObject object) {
        return EMPTY_MDO_ARRAY;
    }

    public String getCoding() {
        int eventingMode = this.mData.getEventingMode();
        if (eventingMode == 0) {
            return this.generateSubscriptionCode();
        }
        if (eventingMode == 2) {
            return this.generateUnsubscriptionCode();
        }
        if (eventingMode == 1) {
            return this.generateFireCode();
        }
        return null;
    }

    public void setCoding(String coding) {
    }

    public void addImport(String className) {
    }

    public void removeImport(String className) {
    }

    public String[] getImports() {
        return new String[]{WDPORTALEVENTING_QUALIFIED};
    }

    private String generateFireCode() {
        String param = null;
        ContextAttribute sourceContextAttribute = this.mData.getSourceContextAttribute();
        param = sourceContextAttribute != null ? (sourceContextAttribute.getNode().getTypedAccessRequired() ? this.generateFireParameterTyped() : this.generateFireParameterUntyped()) : QUOT + this.mData.getTextToPublish() + QUOT;
        StringBuffer buf = new StringBuffer();
        this.eventCallSkeleton(buf, METHOD_EVENT_FIRE, this.mData.getNamespace(), this.mData.getEventName(), param);
        return buf.toString();
    }

    private void generateFireCodeComplete() {
        this.insert(this.mData.getMethodName(), this.generateFireCode(), this.mData.getMethodPosition());
    }

    private String generateFireParameterTyped() {
        ContextAttribute sourceAtt = this.mData.getSourceContextAttribute();
        String nodeGetter = "wdContext." + this.currentElement(sourceAtt.getNode().getName());
        String attGetter = this.getter(sourceAtt.getName());
        String param = nodeGetter + DOT + attGetter;
        String primitiveName = this.mData.getJavaPrimitiveClassName(sourceAtt);
        if (primitiveName != null) {
            param = this.valueOf(param);
        } else if (!PortalEventingData.isStringType(sourceAtt)) {
            param = this.toString(param);
        }
        return param;
    }

    private String generateFireParameterUntyped() {
        ContextAttribute sourceAtt = this.mData.getSourceContextAttribute();
        String nodeGetter = "wdContext." + this.currentElement(sourceAtt.getNode().getName());
        String attGetter = this.getAttributeValue(sourceAtt.getName());
        String param = nodeGetter + DOT + attGetter;
        param = PortalEventingData.isStringType(sourceAtt) ? STRING_CAST + param : this.toString(param);
        return param;
    }

    private void generateSubscriptionCodeComplete() {
        ContextAttribute targetAtt;
        this.insert(this.mData.getMethodName(), this.generateSubscriptionCode(), this.mData.getMethodPosition());
        String unsubscribeMethodName = this.mData.getUnsubscribeMethodName();
        if (unsubscribeMethodName != null) {
            this.insert(unsubscribeMethodName, this.generateUnsubscriptionCode(), this.mData.getUnsubscribeMethodPosition());
        }
        if ((targetAtt = this.mData.getTargetContextAttribute()) != null) {
            String attSetter = null;
            attSetter = targetAtt.getNode().getTypedAccessRequired() ? this.generateFillDataCodeTyped() : this.generateFillDataCodeUntyped();
            this.insert(this.mData.getHandlerAction().getEventHandler().getName(), attSetter, GenerationPositionEnum.BEFORE);
        }
    }

    private String generateSubscriptionCode() {
        StringBuffer buf = new StringBuffer();
        String namespace = this.mData.getNamespace();
        String eventName = this.mData.getEventName();
        Action action = this.mData.getHandlerAction();
        String actionGetter = "wdThis.wdGet" + this.firstUpper(action.getName()) + ACTION_POSTFIX + PARENTHESES_BOTH;
        this.eventCallSkeleton(buf, METHOD_EVENT_SUBSCRIBE, namespace, eventName, actionGetter);
        return buf.toString();
    }

    private String generateUnsubscriptionCode() {
        StringBuffer buf = new StringBuffer();
        String namespace = this.mData.getNamespace();
        String eventName = this.mData.getEventName();
        Action action = this.mData.getHandlerAction();
        String actionGetter = "wdThis.wdGet" + this.firstUpper(action.getName()) + ACTION_POSTFIX + PARENTHESES_BOTH;
        this.eventCallSkeleton(buf, METHOD_EVENT_UNSUBSCRIBE, namespace, eventName, actionGetter);
        return buf.toString();
    }

    private String generateFillDataCodeTyped() {
        StringBuffer buf = new StringBuffer();
        ContextAttribute targetAtt = this.mData.getTargetContextAttribute();
        String nodeGetter = "wdContext." + this.currentElement(targetAtt.getNode().getName());
        String attSetter = this.setter(targetAtt.getName(), "dataObject");
        buf = new StringBuffer(this.indent());
        buf.append(nodeGetter + DOT + attSetter + SEMICOLON);
        return buf.toString();
    }

    private String generateFillDataCodeUntyped() {
        StringBuffer buf = new StringBuffer();
        ContextAttribute targetAtt = this.mData.getTargetContextAttribute();
        String nodeGetter = "wdContext." + this.currentElement(targetAtt.getNode().getName());
        String attSetter = this.setAttributeValue(targetAtt.getName(), "dataObject");
        buf = new StringBuffer(this.indent());
        buf.append(nodeGetter + DOT + attSetter + SEMICOLON);
        return buf.toString();
    }

    private void insert(String methodName, String code, GenerationPositionEnum position) {
        Controller viewController = this.mData.getView().getViewController();
        if ("wdDoInit".equals(methodName)) {
            if (position == GenerationPositionEnum.BEFORE) {
                this.mFacade.insert((DevelopmentObject)viewController, GenerationPositionEnum.INITBEFORE, code);
            } else {
                this.mFacade.insert((DevelopmentObject)viewController, GenerationPositionEnum.INITAFTER, code);
            }
        } else if ("wdDoExit".equals(methodName)) {
            if (position == GenerationPositionEnum.BEFORE) {
                this.mFacade.insert((DevelopmentObject)viewController, GenerationPositionEnum.EXITBEFORE, code);
            } else {
                this.mFacade.insert((DevelopmentObject)viewController, GenerationPositionEnum.EXITAFTER, code);
            }
        } else {
            Method proc = viewController.getMethod(methodName);
            if (proc == null) {
                proc = viewController.getEventHandler(methodName);
            }
            if (proc != null) {
                this.mFacade.insert((DevelopmentObject)proc, position, code);
            }
        }
    }

    private String indent() {
        return this.mData.isSourcePatternMode() ? EMPTY_STRING : TAB;
    }

    private void eventCallSkeleton(StringBuffer buf, String methodKind, String namespace, String eventName, String parameterString) {
        String indent = this.indent();
        buf.append(indent + WDPORTALEVENTING + DOT + methodKind + PARENTHESES_OPENED + LINE_SEP);
        buf.append(indent + TAB + QUOT + this.buildNamespace(namespace) + QUOT + COLON + LINE_SEP);
        buf.append(indent + TAB + QUOT + eventName + QUOT + COLON + LINE_SEP);
        buf.append(indent + TAB + parameterString + LINE_SEP);
        buf.append(indent + PARENTHESES_CLOSED + SEMICOLON);
    }

    private String buildNamespace(String namespace) {
        if (!namespace.startsWith(NAMESPACE_PREFIX)) {
            namespace = NAMESPACE_PREFIX + namespace;
        }
        return namespace;
    }

    private String getter(String name) {
        StringBuffer buf = new StringBuffer(GET);
        buf.append(this.firstUpper(name));
        buf.append(PARENTHESES_BOTH);
        return buf.toString();
    }

    private String setter(String name, String args) {
        StringBuffer buf = new StringBuffer(SET);
        buf.append(this.firstUpper(name));
        buf.append(PARENTHESES_OPENED);
        buf.append(args);
        buf.append(PARENTHESES_CLOSED);
        return buf.toString();
    }

    private String valueOf(String primitiveArgument) {
        StringBuffer buf = new StringBuffer("String.valueOf(");
        buf.append(primitiveArgument);
        buf.append(PARENTHESES_CLOSED);
        return buf.toString();
    }

    private String toString(String objectName) {
        return this.methodInvocation(objectName, TO_STRING) + PARENTHESES_BOTH;
    }

    private String methodInvocation(String objectName, String method) {
        StringBuffer buf = new StringBuffer(objectName);
        buf.append(DOT);
        buf.append(method);
        return buf.toString();
    }

    private void element(String name, StringBuffer buf) {
        buf.append(this.firstUpper(name));
        buf.append(ELEMENT);
    }

    private String element(String name) {
        StringBuffer buf = new StringBuffer(this.firstLower(name));
        buf.append(ELEMENT);
        return buf.toString();
    }

    private String currentElement(String name) {
        StringBuffer buf = new StringBuffer(CURRENT);
        this.element(name, buf);
        buf.append(PARENTHESES_BOTH);
        return buf.toString();
    }

    private String getAttributeValue(String attributeName) {
        StringBuffer buf = new StringBuffer("getAttributeValue(\"");
        buf.append(attributeName);
        buf.append("\")");
        return buf.toString();
    }

    private String setAttributeValue(String attributeName, String value) {
        StringBuffer buf = new StringBuffer("setAttributeValue(\"");
        buf.append(attributeName);
        buf.append("\", ");
        buf.append(value);
        buf.append(PARENTHESES_CLOSED);
        return buf.toString();
    }

    private String firstUpper(String name) {
        char[] chars = name.trim().toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private String firstLower(String name) {
        char[] chars = name.trim().toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }
}

