/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.sql.Datum;
import oracle.sql.TypeDescriptor;

public abstract class DatumWithConnection
extends Datum {
    private oracle.jdbc.internal.OracleConnection physicalConnection = null;

    public DatumWithConnection() {
    }

    public DatumWithConnection(byte[] byArray) throws SQLException {
        super(byArray);
    }

    public static void assertNotNull(Connection connection) throws SQLException {
        if (connection == null) {
            DBError.check_error(68, "Connection is null");
        }
    }

    public static void assertNotNull(TypeDescriptor typeDescriptor) throws SQLException {
        if (typeDescriptor == null) {
            DBError.check_error(61);
        }
    }

    public OracleConnection getConnection() throws SQLException {
        OracleConnection oracleConnection = null;
        try {
            oracleConnection = (OracleConnection)((OracleConnection)this.physicalConnection).getWrapper();
        }
        catch (ClassCastException classCastException) {
            DBError.throwSqlException(103);
        }
        return oracleConnection;
    }

    public oracle.jdbc.internal.OracleConnection getInternalConnection() throws SQLException {
        return this.getPhysicalConnection();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return this.getPhysicalConnection().getWrapper();
    }

    public oracle.jdbc.OracleConnection getOracleConnection() throws SQLException {
        return this.getPhysicalConnection().getWrapper();
    }

    oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        block2: {
            if (this.physicalConnection != null) break block2;
            try {
                this.physicalConnection = (oracle.jdbc.internal.OracleConnection)new OracleDriver().defaultConnection();
            }
            catch (SQLException sQLException) {}
        }
        return this.physicalConnection;
    }

    public void setPhysicalConnectionOf(Connection connection) {
        this.physicalConnection = OracleConnection.physicalConnectionWithin(connection);
    }
}

