/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.BlobDBAccess;
import oracle.sql.DatumWithConnection;

public class BLOB
extends DatumWithConnection
implements Blob {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    static final int OLD_WRONG_DURATION_SESSION = 1;
    static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    BlobDBAccess m_dbaccess;
    int m_dbChunkSize;

    protected BLOB() {
    }

    public BLOB(oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public BLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        DatumWithConnection.assertNotNull(oracleConnection);
        this.setPhysicalConnectionOf(oracleConnection);
        this.m_dbaccess = this.getPhysicalConnection().createBlobDBAccess();
        this.m_dbChunkSize = -1;
    }

    public InputStream asciiStreamValue() throws SQLException {
        BlobDBAccess blobDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return blobDBAccess.newConversionInputStream(this, 2);
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getBinaryStream();
    }

    public Reader characterStreamValue() throws SQLException {
        BlobDBAccess blobDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return blobDBAccess.newConversionReader(this, 8);
    }

    public void close() throws SQLException {
        this.getDBAccess().close(this);
    }

    public static BLOB createTemporary(Connection connection, boolean bl, int n) throws SQLException {
        int n2 = n;
        if (n == 1) {
            n2 = 10;
        }
        if (n == 2) {
            n2 = 12;
        }
        if (connection == null || n2 != 10 && n2 != 12) {
            DBError.throwSqlException(68);
        }
        oracle.jdbc.internal.OracleConnection oracleConnection = OracleConnection.physicalConnectionWithin(connection);
        return BLOB.getDBAccess(oracleConnection).createTemporaryBlob(oracleConnection, bl, n2);
    }

    public static BLOB empty_lob() throws SQLException {
        byte[] byArray = new byte[86];
        byArray[1] = 84;
        byArray[5] = 24;
        BLOB bLOB = new BLOB();
        bLOB.setShareBytes(byArray);
        return bLOB;
    }

    public void freeTemporary() throws SQLException {
        this.getDBAccess().freeTemporary(this);
    }

    public static void freeTemporary(BLOB bLOB) throws SQLException {
        if (bLOB == null) {
            return;
        }
        bLOB.freeTemporary();
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), 0L);
    }

    public OutputStream getBinaryOutputStream(long l) throws SQLException {
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), l);
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), 0L);
    }

    public InputStream getBinaryStream(long l) throws SQLException {
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), l);
    }

    public int getBufferSize() throws SQLException {
        int n;
        int n2 = n = this.getChunkSize();
        n2 = n >= 32768 || n <= 0 ? 32768 : 32768 / n * n;
        return n2;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (n < 0 || l < 1L) {
            DBError.throwSqlException(68, "getBytes()");
        }
        byte[] byArray = null;
        if (n == 0) {
            byArray = new byte[]{};
        } else {
            long l2 = 0L;
            byte[] byArray2 = new byte[n];
            l2 = this.getBytes(l, n, byArray2);
            if (l2 > 0L) {
                if (l2 == (long)n) {
                    byArray = byArray2;
                } else {
                    byArray = new byte[(int)l2];
                    System.arraycopy(byArray2, 0, byArray, 0, (int)l2);
                }
            }
        }
        return byArray;
    }

    public int getBytes(long l, int n, byte[] byArray) throws SQLException {
        return this.getDBAccess().getBytes(this, l, n, byArray);
    }

    public int getChunkSize() throws SQLException {
        if (this.m_dbChunkSize <= 0) {
            this.m_dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.m_dbChunkSize;
    }

    public OracleConnection getConnection() throws SQLException {
        return super.getConnection();
    }

    public BlobDBAccess getDBAccess() throws SQLException {
        if (this.m_dbaccess == null) {
            if (this.isEmptyLob()) {
                DBError.throwSqlException(98);
            }
            this.m_dbaccess = this.getInternalConnection().createBlobDBAccess();
        }
        return this.m_dbaccess;
    }

    public static BlobDBAccess getDBAccess(Connection connection) throws SQLException {
        return OracleConnection.physicalConnectionWithin(connection).createBlobDBAccess();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public boolean isEmptyLob() throws SQLException {
        boolean bl = (this.shareBytes()[5] & 0x10) != 0;
        return bl;
    }

    public boolean isOpen() throws SQLException {
        return this.getDBAccess().isOpen(this);
    }

    public boolean isTemporary() throws SQLException {
        return this.getDBAccess().isTemporary(this);
    }

    public static boolean isTemporary(BLOB bLOB) throws SQLException {
        if (bLOB == null) {
            return false;
        }
        return bLOB.isTemporary();
    }

    public long length() throws SQLException {
        return this.getDBAccess().length(this);
    }

    public Object makeJdbcArray(int n) {
        return new BLOB[n];
    }

    public void open(int n) throws SQLException {
        this.getDBAccess().open(this, n);
    }

    public long position(Blob blob, long l) throws SQLException {
        return this.getDBAccess().position(this, (BLOB)blob, l);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        return this.getDBAccess().position(this, byArray, l);
    }

    public int putBytes(long l, byte[] byArray) throws SQLException {
        return this.getDBAccess().putBytes(this, l, byArray, byArray != null ? byArray.length : 0);
    }

    public int putBytes(long l, byte[] byArray, int n) throws SQLException {
        return this.getDBAccess().putBytes(this, l, byArray, n);
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    public void trim(long l) throws SQLException {
        if (l < 0L) {
            DBError.throwSqlException(68);
        }
        this.getDBAccess().trim(this, l);
    }

    public void truncate(long l) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }
}

