/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.PooledConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;
import oracle.jdbc.xa.client.OracleXADataSource;

public class OracleXAResource
extends oracle.jdbc.xa.OracleXAResource {
    private short m_version = 0;
    private static String xa_start_816 = "begin ? := JAVA_XA.xa_start(?,?,?,?); end;";
    private static String xa_start_post_816 = "begin ? := JAVA_XA.xa_start_new(?,?,?,?,?); end;";
    private static String xa_end_816 = "begin ? := JAVA_XA.xa_end(?,?); end;";
    private static String xa_end_post_816 = "begin ? := JAVA_XA.xa_end_new(?,?,?,?); end;";
    private static String xa_commit_816 = "begin ? := JAVA_XA.xa_commit (?,?,?); end;";
    private static String xa_commit_post_816 = "begin ? := JAVA_XA.xa_commit_new (?,?,?,?); end;";
    private static String xa_prepare_816 = "begin ? := JAVA_XA.xa_prepare (?,?); end;";
    private static String xa_prepare_post_816 = "begin ? := JAVA_XA.xa_prepare_new (?,?,?); end;";
    private static String xa_rollback_816 = "begin ? := JAVA_XA.xa_rollback (?,?); end;";
    private static String xa_rollback_post_816 = "begin ? := JAVA_XA.xa_rollback_new (?,?,?); end;";
    private static String xa_forget_816 = "begin ? := JAVA_XA.xa_forget (?,?); end;";
    private static String xa_forget_post_816 = "begin ? := JAVA_XA.xa_forget_new (?,?,?); end;";

    public OracleXAResource() {
    }

    public OracleXAResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        super(connection, oracleXAConnection);
        try {
            this.m_version = ((OracleConnection)connection).getVersionNumber();
        }
        catch (SQLException sQLException) {}
        if (this.m_version < 8160) {
            throw new XAException(-6);
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        int n = -1;
        int n2 = 0;
        Statement statement = null;
        if (xid == null) {
            throw new XAException(-5);
        }
        int n3 = bl ? 1 : 0;
        try {
            block19: {
                try {
                    Xid xid2 = super.suspendStacked(xid);
                    if (this.m_version == 8160) {
                        if (!(xid instanceof OracleXid)) {
                            throw new XAException(-6);
                        }
                        statement = this.m_conn.prepareCall(xa_commit_816);
                        statement.registerOutParameter(1, 2);
                        byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                        statement.setBytes(2, byArray);
                        statement.setInt(3, n3);
                        statement.registerOutParameter(4, 2);
                        statement.execute();
                        n = statement.getInt(1);
                        n2 = statement.getInt(4);
                        ((OracleXid)xid).setState(n2);
                        if (n == 24780) {
                            PooledConnection pooledConnection = null;
                            OracleXADataSource oracleXADataSource = null;
                            try {
                                Properties properties = this.getConnectionProperties();
                                oracleXADataSource = new OracleXADataSource();
                                oracleXADataSource.setURL((String)((Hashtable)properties).get("connection_url"));
                                oracleXADataSource.setUser((String)((Hashtable)properties).get("user"));
                                oracleXADataSource.setPassword((String)((Hashtable)properties).get("password"));
                                pooledConnection = oracleXADataSource.getXAConnection();
                                XAResource xAResource = pooledConnection.getXAResource();
                                xAResource.commit(xid, n3 == 1);
                            }
                            finally {
                                Object var14_14 = null;
                                if (pooledConnection != null) {
                                    pooledConnection.close();
                                }
                            }
                            n = 0;
                        }
                    } else {
                        statement = this.m_conn.prepareCall(xa_commit_post_816);
                        statement.registerOutParameter(1, 2);
                        statement.setInt(2, xid.getFormatId());
                        statement.setBytes(3, xid.getGlobalTransactionId());
                        statement.setBytes(4, xid.getBranchQualifier());
                        statement.setInt(5, n3);
                        statement.execute();
                        n = statement.getInt(1);
                    }
                    super.resumeStacked(xid2);
                }
                catch (SQLException sQLException) {
                    n = sQLException.getErrorCode();
                    if (n != 0) break block19;
                    throw new XAException(-6);
                }
            }
            Object var8_17 = null;
        }
        catch (Throwable throwable) {
            Object var8_18 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            statement = null;
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {}
        statement = null;
        this.checkError(n);
    }

    public void end(Xid xid, int n) throws XAException {
        int n2 = -1;
        Statement statement = null;
        if (xid == null) {
            throw new XAException(-5);
        }
        if (n != 0x2000000 && n != 0x4000000 && n != 0x20000000 && (n & 2) != 2) {
            throw new XAException(-5);
        }
        try {
            block14: {
                try {
                    Xid xid2 = super.suspendStacked(xid, n);
                    super.pop();
                    if (this.m_version == 8160) {
                        if (!(xid instanceof OracleXid)) {
                            throw new XAException(-6);
                        }
                        statement = this.m_conn.prepareCall(xa_end_816);
                        statement.registerOutParameter(1, 2);
                        byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                        statement.setBytes(2, byArray);
                        statement.setInt(3, n);
                        statement.execute();
                        n2 = statement.getInt(1);
                    } else {
                        statement = this.m_conn.prepareCall(xa_end_post_816);
                        statement.registerOutParameter(1, 2);
                        statement.setInt(2, xid.getFormatId());
                        statement.setBytes(3, xid.getGlobalTransactionId());
                        statement.setBytes(4, xid.getBranchQualifier());
                        statement.setInt(5, n);
                        statement.execute();
                        n2 = statement.getInt(1);
                    }
                    super.resumeStacked(xid2);
                }
                catch (SQLException sQLException) {
                    n2 = sQLException.getErrorCode();
                    if (n2 != 0) break block14;
                    throw new XAException(-6);
                }
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.restoreAutoCommitModeForGlobalTransaction();
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            statement = null;
            throw throwable;
        }
        this.restoreAutoCommitModeForGlobalTransaction();
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {}
        statement = null;
        this.checkError(n2);
    }

    public void forget(Xid xid) throws XAException {
        int n = 0;
        int n2 = 0;
        Statement statement = null;
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            block13: {
                try {
                    this.saveTxnMode();
                    if (this.m_version == 8160) {
                        if (!(xid instanceof OracleXid)) {
                            throw new XAException(-6);
                        }
                        statement = this.m_conn.prepareCall(" begin ? := JAVA_XA.xa_forget (?,?); end; ");
                        statement.registerOutParameter(1, 2);
                        byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                        statement.setBytes(2, byArray);
                        statement.registerOutParameter(3, 2);
                        statement.execute();
                        n = statement.getInt(1);
                        n2 = statement.getInt(3);
                        ((OracleXid)xid).setState(n2);
                    } else {
                        statement = this.m_conn.prepareCall(xa_forget_post_816);
                        statement.registerOutParameter(1, 2);
                        statement.setInt(2, xid.getFormatId());
                        statement.setBytes(3, xid.getGlobalTransactionId());
                        statement.setBytes(4, xid.getBranchQualifier());
                        statement.execute();
                        n = statement.getInt(1);
                    }
                }
                catch (SQLException sQLException) {
                    n = sQLException.getErrorCode();
                    if (n != 0) break block13;
                    throw new XAException(-6);
                }
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            statement = null;
            this.restoreTxnMode();
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {}
        statement = null;
        this.restoreTxnMode();
        this.checkError(n);
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int prepare(Xid xid) throws XAException {
        int n;
        int n2 = 0;
        int n3 = 0;
        Statement statement = null;
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            block14: {
                try {
                    Xid xid2 = super.suspendStacked(xid);
                    if (this.m_version == 8160) {
                        if (!(xid instanceof OracleXid)) {
                            throw new XAException(-6);
                        }
                        statement = this.m_conn.prepareCall(xa_prepare_816);
                        statement.registerOutParameter(1, 2);
                        byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                        statement.setBytes(2, byArray);
                        statement.registerOutParameter(3, 2);
                        statement.execute();
                        n2 = statement.getInt(1);
                        n3 = statement.getInt(3);
                        ((OracleXid)xid).setState(n3);
                    } else {
                        statement = this.m_conn.prepareCall(xa_prepare_post_816);
                        statement.registerOutParameter(1, 2);
                        statement.setInt(2, xid.getFormatId());
                        statement.setBytes(3, xid.getGlobalTransactionId());
                        statement.setBytes(4, xid.getBranchQualifier());
                        statement.execute();
                        n2 = statement.getInt(1);
                    }
                    super.resumeStacked(xid2);
                }
                catch (SQLException sQLException) {
                    n2 = sQLException.getErrorCode();
                    if (n2 != 0) break block14;
                    throw new XAException(-6);
                }
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            statement = null;
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {}
        statement = null;
        int n4 = n = n2 == 0 ? 0 : OracleXAException.errorConvert(n2);
        if (n != 0 && n != 3) {
            throw new OracleXAException(n2);
        }
        return n;
    }

    public void rollback(Xid xid) throws XAException {
        int n = 0;
        int n2 = 0;
        Statement statement = null;
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            block19: {
                try {
                    Xid xid2 = super.suspendStacked(xid);
                    if (this.m_version == 8160) {
                        if (!(xid instanceof OracleXid)) {
                            throw new XAException(-6);
                        }
                        statement = this.m_conn.prepareCall(xa_rollback_816);
                        statement.registerOutParameter(1, 2);
                        byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                        statement.setBytes(2, byArray);
                        statement.registerOutParameter(3, 2);
                        statement.execute();
                        n = statement.getInt(1);
                        n2 = statement.getInt(3);
                        ((OracleXid)xid).setState(n2);
                        if (n == 24780) {
                            PooledConnection pooledConnection = null;
                            OracleXADataSource oracleXADataSource = null;
                            try {
                                Properties properties = this.getConnectionProperties();
                                oracleXADataSource = new OracleXADataSource();
                                oracleXADataSource.setURL((String)((Hashtable)properties).get("connection_url"));
                                oracleXADataSource.setUser((String)((Hashtable)properties).get("user"));
                                oracleXADataSource.setPassword((String)((Hashtable)properties).get("password"));
                                pooledConnection = oracleXADataSource.getXAConnection();
                                XAResource xAResource = pooledConnection.getXAResource();
                                xAResource.rollback(xid);
                            }
                            finally {
                                Object var12_12 = null;
                                if (pooledConnection != null) {
                                    pooledConnection.close();
                                }
                            }
                            n = 0;
                        }
                    } else {
                        statement = this.m_conn.prepareCall(xa_rollback_post_816);
                        statement.registerOutParameter(1, 2);
                        statement.setInt(2, xid.getFormatId());
                        statement.setBytes(3, xid.getGlobalTransactionId());
                        statement.setBytes(4, xid.getBranchQualifier());
                        statement.execute();
                        n = statement.getInt(1);
                    }
                    super.resumeStacked(xid2);
                }
                catch (SQLException sQLException) {
                    n = sQLException.getErrorCode();
                    if (n != 0) break block19;
                    throw new XAException(-6);
                }
            }
            Object var6_15 = null;
        }
        catch (Throwable throwable) {
            Object var6_16 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            statement = null;
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {}
        statement = null;
        this.checkError(n);
    }

    public void start(Xid xid, int n) throws XAException {
        int n2 = -1;
        Statement statement = null;
        this.disallowLocalTxnMode(-6);
        if (xid == null) {
            throw new XAException(-5);
        }
        int n3 = n & 0xFF00;
        int n4 = (n &= 0xFFFF00FF) & 0x10000;
        if ((n &= 0xFFFEFFFF) != 0 && n != 0x8000000 && n != 0x200000 && n != 2 || n4 != 0 && (n4 & 0x10000) != 65536) {
            throw new XAException(-5);
        }
        if ((n3 & 0xFF00) != 0 && n3 != 256 && n3 != 512 && n3 != 1024) {
            throw new XAException(-5);
        }
        if ((n & 0x8200000) != 0 && ((n3 & 0xFF00) != 0 || (n4 & 0x10000) != 0)) {
            throw new XAException(-5);
        }
        n |= n3 | n4;
        try {
            block16: {
                try {
                    this.saveAndAlterAutoCommitModeForGlobalTransaction();
                    if (this.m_version == 8160) {
                        if (!(xid instanceof OracleXid)) {
                            throw new XAException(-6);
                        }
                        statement = this.m_conn.prepareCall(xa_start_816);
                        statement.registerOutParameter(1, -2);
                        byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                        statement.setBytes(2, byArray);
                        statement.setInt(3, this.m_timeout);
                        statement.setInt(4, n);
                        statement.registerOutParameter(5, 2);
                        statement.execute();
                        byte[] byArray2 = statement.getBytes(1);
                        ((OracleXid)xid).setTxContext(byArray2);
                        n2 = statement.getInt(5);
                    } else {
                        statement = this.m_conn.prepareCall(xa_start_post_816);
                        statement.registerOutParameter(1, 2);
                        statement.setInt(2, xid.getFormatId());
                        statement.setBytes(3, xid.getGlobalTransactionId());
                        statement.setBytes(4, xid.getBranchQualifier());
                        statement.setInt(5, this.m_timeout);
                        statement.setInt(6, n);
                        statement.execute();
                        n2 = statement.getInt(1);
                    }
                }
                catch (SQLException sQLException) {
                    this.restoreAutoCommitModeForGlobalTransaction();
                    n2 = sQLException.getErrorCode();
                    if (n2 != 0) break block16;
                    throw new XAException(-6);
                }
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            statement = null;
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {}
        statement = null;
        this.checkError(n2);
        super.push(xid);
    }
}

