/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTIfun;
import oracle.jdbc.ttc7.TTIoer;
import oracle.jdbc.ttc7.v8TTILobd;
import oracle.net.ns.BreakNetException;
import oracle.sql.Datum;

public abstract class v8TTILob
extends TTIfun {
    protected static final int KPLOB_READ = 2;
    protected static final int KPLOB_WRITE = 64;
    protected static final int KPLOB_WRITE_APPEND = 8192;
    protected static final int KPLOB_PAGE_SIZE = 16384;
    protected static final int KPLOB_FILE_OPEN = 256;
    protected static final int KPLOB_FILE_ISOPEN = 1024;
    protected static final int KPLOB_FILE_EXISTS = 2048;
    protected static final int KPLOB_FILE_CLOSE = 512;
    protected static final int KPLOB_OPEN = 32768;
    protected static final int KPLOB_CLOSE = 65536;
    protected static final int KPLOB_ISOPEN = 69632;
    protected static final int KPLOB_TMP_CREATE = 272;
    protected static final int KPLOB_TMP_FREE = 273;
    protected static final int KPLOB_GET_LEN = 1;
    protected static final int KPLOB_TRIM = 32;
    protected static final int KOKL_ORDONLY = 1;
    protected static final int KOKL_ORDWR = 2;
    protected static final int KOLF_ORDONLY = 11;
    protected static final byte KOLBLOPEN = 8;
    protected static final byte KOLBLTMP = 1;
    protected static final byte KOLBLRDWR = 16;
    protected static final byte ALLFLAGS = -1;
    protected static final int DTYCLOB = 112;
    protected static final int DTYBLOB = 113;
    protected byte[] sourceLobLocator = null;
    protected byte[] destinationLobLocator = null;
    protected long sourceOffset = 0L;
    protected long destinationOffset = 0L;
    protected int destinationLength = 0;
    protected short characterSet = 0;
    protected long lobamt = 0L;
    protected boolean lobnull = false;
    protected long lobops = 0L;
    protected int[] lobscn = null;
    protected int lobscnl = 0;
    protected boolean nullO2U = false;
    protected boolean sendLobamt = false;
    protected byte[] inBuffer = null;
    protected byte[] outBuffer = null;
    public int rowsProcessed = 0;
    protected long lobBytesRead = 0L;
    protected boolean varWidthChar = false;
    protected v8TTILobd lobd = null;

    public v8TTILob(MAREngine mAREngine) {
        super((byte)3, 0, (byte)96);
        this.setMarshalingEngine(mAREngine);
        this.oer = new TTIoer(mAREngine);
        this.lobd = new v8TTILobd(mAREngine);
    }

    protected boolean _close(byte[] byArray, int n) throws SQLException, IOException {
        boolean bl = true;
        if ((byArray[7] & 1) == 1) {
            if ((byArray[7] & 8) != 8) {
                DBError.check_error(401);
            } else {
                byArray[7] = (byte)(byArray[7] & 0xFFFFFFE7);
            }
        } else {
            this.initializeLobdef();
            this.sourceLobLocator = byArray;
            this.lobops = n;
            this.marshalFunHeader();
            this.marshalOlobops();
            this.receiveReply();
        }
        return bl;
    }

    protected boolean _isOpen(byte[] byArray, int n) throws SQLException, IOException {
        boolean bl = false;
        if ((byArray[7] & 1) == 1) {
            if ((byArray[7] & 8) == 8) {
                bl = true;
            }
        } else {
            this.initializeLobdef();
            this.sourceLobLocator = byArray;
            this.lobops = n;
            this.nullO2U = true;
            this.marshalFunHeader();
            this.marshalOlobops();
            this.receiveReply();
            bl = this.lobnull;
        }
        return bl;
    }

    protected boolean _open(byte[] byArray, int n, int n2) throws SQLException, IOException {
        boolean bl = false;
        if ((byArray[7] & 1) == 1) {
            if ((byArray[7] & 8) == 8) {
                DBError.check_error(401);
            } else {
                byArray[7] = (byte)(byArray[7] | 8);
                if (n == 2) {
                    byArray[7] = (byte)(byArray[7] | 0x10);
                }
                bl = true;
            }
        } else {
            this.initializeLobdef();
            this.sourceLobLocator = byArray;
            this.lobops = n2;
            this.lobamt = n;
            this.sendLobamt = true;
            this.marshalFunHeader();
            this.marshalOlobops();
            this.receiveReply();
            if (this.lobamt != 0L) {
                bl = true;
            }
        }
        return bl;
    }

    public abstract boolean close(byte[] var1) throws SQLException, IOException;

    public abstract Datum createTemporaryLob(Connection var1, boolean var2, int var3) throws SQLException, IOException;

    public void freeTemporaryLob(byte[] byArray) throws SQLException, IOException {
        this.initializeLobdef();
        this.lobops = 273L;
        this.sourceLobLocator = byArray;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
    }

    public long getChunkSize(byte[] byArray) throws SQLException, IOException {
        long l = 0L;
        this.initializeLobdef();
        this.lobops = 16384L;
        this.sourceLobLocator = byArray;
        this.marshalFunHeader();
        this.sendLobamt = true;
        this.marshalOlobops();
        this.receiveReply();
        l = this.lobamt;
        return l;
    }

    public long getLength(byte[] byArray) throws SQLException, IOException {
        long l = 0L;
        this.initializeLobdef();
        this.lobops = 1L;
        this.sourceLobLocator = byArray;
        this.sendLobamt = true;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
        l = this.lobamt;
        return l;
    }

    public void initializeLobdef() {
        this.sourceLobLocator = null;
        this.destinationLobLocator = null;
        this.sourceOffset = 0L;
        this.destinationOffset = 0L;
        this.destinationLength = 0;
        this.characterSet = 0;
        this.lobamt = 0L;
        this.lobnull = false;
        this.lobops = 0L;
        this.lobscn = null;
        this.lobscnl = 0;
        this.inBuffer = null;
        this.outBuffer = null;
        this.nullO2U = false;
        this.sendLobamt = false;
        this.varWidthChar = false;
        this.lobBytesRead = 0L;
    }

    public abstract boolean isOpen(byte[] var1) throws SQLException, IOException;

    public void marshalOlobops() throws IOException {
        int n = 0;
        if (this.sourceLobLocator != null) {
            n = this.sourceLobLocator.length;
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(n);
        if (this.destinationLobLocator != null) {
            this.destinationLength = this.destinationLobLocator.length;
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(this.destinationLength);
        this.meg.marshalUB4(this.sourceOffset);
        this.meg.marshalUB4(this.destinationOffset);
        if (this.characterSet != 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (this.sendLobamt) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (this.nullO2U) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalUB4(this.lobops);
        if (this.lobscnl != 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(this.lobscnl);
        if (this.sourceLobLocator != null) {
            this.meg.marshalB1Array(this.sourceLobLocator);
        }
        if (this.destinationLobLocator != null) {
            this.meg.marshalB1Array(this.destinationLobLocator);
        }
        if (this.characterSet != 0) {
            this.meg.marshalUB2(this.characterSet);
        }
        if (this.sendLobamt) {
            this.meg.marshalUB4(this.lobamt);
        }
        if (this.lobscnl != 0) {
            int n2 = 0;
            while (n2 < this.lobscnl) {
                this.meg.marshalUB4(this.lobscn[n2]);
                ++n2;
            }
        }
    }

    public abstract boolean open(byte[] var1, int var2) throws SQLException, IOException;

    public long read(byte[] byArray, long l, long l2, byte[] byArray2) throws SQLException, IOException {
        this.initializeLobdef();
        this.lobops = 2L;
        this.sourceLobLocator = byArray;
        this.sourceOffset = l;
        this.lobamt = l2;
        this.sendLobamt = true;
        this.outBuffer = byArray2;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
        return this.lobBytesRead;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void receiveReply() throws IOException, SQLException {
        byte by = 0;
        while (true) {
            try {
                block9: while (true) {
                    by = this.meg.unmarshalSB1();
                    switch (by) {
                        case 8: {
                            this.unmarshalTTIRPA();
                            continue block9;
                        }
                        case 14: {
                            if (!this.varWidthChar) {
                                this.lobBytesRead = this.lobd.unmarshalLobData(this.outBuffer);
                                continue block9;
                            }
                            this.lobBytesRead = this.lobd.unmarshalClobUB2(this.outBuffer);
                            continue block9;
                        }
                        case 4: {
                            this.oer.init();
                            this.oer.unmarshal();
                            this.rowsProcessed = this.oer.getCurRowNumber();
                            if (this.oer.getRetCode() == 1403) return;
                            this.oer.processError();
                            return;
                        }
                        default: {
                            DBError.check_error(401);
                            return;
                        }
                        case 9: {
                            return;
                        }
                    }
                    break;
                }
            }
            catch (BreakNetException breakNetException) {
                continue;
            }
            break;
        }
    }

    public long trim(byte[] byArray, long l) throws SQLException, IOException {
        long l2 = 0L;
        this.initializeLobdef();
        this.lobops = 32L;
        this.sourceLobLocator = byArray;
        this.lobamt = l;
        this.sendLobamt = true;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
        l2 = this.lobamt;
        return l2;
    }

    public void unmarshalTTIRPA() throws SQLException, IOException {
        int n;
        if (this.sourceLobLocator != null) {
            n = this.sourceLobLocator.length;
            this.meg.getNBytes(this.sourceLobLocator, 0, n);
        }
        if (this.destinationLobLocator != null) {
            n = this.meg.unmarshalSB2();
            this.destinationLobLocator = this.meg.unmarshalNBytes(n);
        }
        if (this.characterSet != 0) {
            this.characterSet = this.meg.unmarshalSB2();
        }
        if (this.sendLobamt) {
            this.lobamt = this.meg.unmarshalUB4();
        }
        if (this.nullO2U && (n = (int)this.meg.unmarshalSB2()) != 0) {
            this.lobnull = true;
        }
        if (this.lobscnl != 0) {
            n = 0;
            while (n < this.lobscnl) {
                this.lobscn[n] = this.meg.unmarshalSB4();
                ++n;
            }
        }
    }

    public long write(byte[] byArray, long l, long l2, byte[] byArray2) throws SQLException, IOException {
        long l3 = 0L;
        this.initializeLobdef();
        this.lobops = 64L;
        this.sourceLobLocator = byArray;
        this.sourceOffset = l;
        this.lobamt = l2;
        this.sendLobamt = true;
        this.inBuffer = byArray2;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.lobd.marshalLobData(byArray2, l2);
        this.receiveReply();
        l3 = this.lobamt;
        return l3;
    }
}

