/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.PlsqlTTCDataSet;
import oracle.jdbc.ttc7.TTCDataSet;
import oracle.jdbc.ttc7.TTCTypeRep;
import oracle.jdbc.ttc7.TTIfun;
import oracle.jdbc.ttc7.TTIiov;
import oracle.jdbc.ttc7.TTIoer;
import oracle.jdbc.ttc7.TTIrxd;
import oracle.jdbc.ttc7.TTIrxh;
import oracle.net.ns.BreakNetException;

public class Oall7
extends TTIfun {
    public static final int PARSE = 1;
    public static final int BIND = 8;
    public static final int DEFINE = 16;
    public static final int EXECUTE = 32;
    public static final int FETCH = 64;
    public static final int CANCEL = 128;
    public static final int COMMIT = 256;
    public static final int EXACTFE = 512;
    public static final int SNDIOV = 1024;
    public static final int NOPLSQL = 32768;
    public int rowsProcessed;
    boolean streamingOn = false;
    private final int OACSIZE = 23;
    private long options;
    private int cursor;
    private byte[] sqlStmt = new byte[0];
    private byte[] dbLink = new byte[0];
    private long[] inVector = new long[0];
    private long[] outVector = new long[0];
    private boolean outVecO2U = false;
    private int outVecRet = 0;
    private boolean outVecRetO2U = false;
    private boolean plsql = false;
    private DBType[] bindTypes;
    private byte[] bindArgs;
    public TTCDataSet binds;
    public TTCDataSet defines;
    public TTIrxd rxd;
    public TTIrxh rxh;
    private byte type;
    private boolean sendDefines = true;
    boolean autoCommitSet;

    public Oall7(MAREngine mAREngine) throws IOException, SQLException {
        super((byte)3, 0, (byte)71);
        this.setMarshalingEngine(mAREngine);
        TTCTypeRep cfr_ignored_0 = this.meg.types;
        this.rxh = (TTIrxh)this.meg.types.newTTCMsgObject((byte)3, this.meg);
        this.rxd = new TTIrxd(this.meg);
        this.oer = new TTIoer(this.meg);
    }

    public boolean getColumnsUptoNextSream() throws SQLException, IOException {
        this.streamingOn = false;
        this.receive();
        return this.streamingOn;
    }

    private int getItemsValueLength(DBData[] dBDataArray, int n) throws SQLException {
        int n2 = 0;
        if (dBDataArray == null || n < 1) {
            return n2;
        }
        int n3 = 0;
        while (n3 < dBDataArray.length) {
            int n4 = 0;
            while (n4 < n) {
                n2 += dBDataArray[n3].getItem((int)n4).data_size;
                ++n2;
                ++n4;
            }
            ++n2;
            ++n3;
        }
        return n2;
    }

    public int getNumRows() {
        int n = 0;
        if (this.streamingOn) {
            n = -2;
        } else {
            switch (this.type) {
                case 2: 
                case 4: {
                    n = this.rowsProcessed;
                    break;
                }
                case 0: {
                    n = this.defines.unmarshaledRows;
                    break;
                }
                case 1: 
                case 3: {
                    n = this.binds.unmarshaledRows;
                    break;
                }
            }
        }
        return n;
    }

    public void init(byte by, byte by2, int n, byte[] byArray, TTCDataSet tTCDataSet, TTCDataSet tTCDataSet2) throws IOException, SQLException {
        this.rowsProcessed = 0;
        this.streamingOn = false;
        this.options = 0L;
        this.dbLink = new byte[0];
        this.plsql = false;
        this.bindTypes = null;
        this.bindArgs = null;
        this.rxh.init();
        this.rxd.init(tTCDataSet, tTCDataSet2);
        this.oer.init();
        if (byArray == null) {
            DBError.check_error(431);
        }
        this.binds = tTCDataSet;
        this.defines = tTCDataSet2;
        this.type = by2;
        this.sendDefines = by != 3;
        this.options = this.setOptions(by, by2, tTCDataSet, tTCDataSet2);
        if (this.type == 1 || this.type == 3) {
            this.plsql = true;
        }
        this.cursor = n;
        this.sqlStmt = byArray;
        this.inVector = new long[7];
        this.inVector[0] = 1L;
        if (this.plsql) {
            this.inVector[1] = 1L;
        } else if ((this.options & 0x20L) > 0L && (this.options & 0x40L) == 0L) {
            this.inVector[1] = this.binds.depth == 0 ? 1 : this.binds.depth;
        } else if ((this.options & 0x40L) > 0L) {
            this.inVector[1] = this.defines.depth;
        }
        this.outVecO2U = true;
        this.outVecRetO2U = false;
        this.outVector = new long[2];
        boolean bl = false;
    }

    protected void marshal() throws IOException, SQLException {
        super.marshalFunHeader();
        this.meg.marshalUB4(this.options);
        this.meg.marshalSWORD(this.cursor);
        if (this.sqlStmt.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.sqlStmt.length);
        if (this.dbLink.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.dbLink.length);
        if (this.inVector.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.inVector.length);
        this.meg.marshalO2U(this.outVecO2U);
        this.meg.marshalSB4(this.outVecO2U ? this.outVector.length : 0);
        this.meg.marshalO2U(this.outVecRetO2U);
        int n = this.defines.numberOfColumns();
        if (n > 0 && this.sendDefines) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(n);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        int n2 = this.binds.numberOfColumns();
        if (n2 > 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSWORD(n2);
        this.meg.marshalCHR(this.sqlStmt);
        this.meg.marshalCHR(this.dbLink);
        this.meg.marshalUB4Array(this.inVector);
    }

    public void receive() throws SQLException, IOException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.rowsProcessed = 0;
        block9: while (true) {
            try {
                while (true) {
                    byte by = this.meg.unmarshalSB1();
                    switch (by) {
                        case 11: {
                            TTIiov tTIiov = new TTIiov(this.meg);
                            tTIiov.init();
                            tTIiov.unmarshal();
                            if (!tTIiov.isIOVectorEmpty()) {
                                PlsqlTTCDataSet plsqlTTCDataSet = (PlsqlTTCDataSet)this.binds;
                                plsqlTTCDataSet.setIOVector(tTIiov.getIOVector());
                                TTIrxd tTIrxd = tTIiov.processRXD(plsqlTTCDataSet);
                                if (tTIrxd != null) {
                                    this.rxd = tTIrxd;
                                }
                            }
                            bl3 = true;
                            break;
                        }
                        case 6: {
                            this.rxh.init();
                            this.rxh.unmarshal();
                            if (this.rxh.uacBufLength > 0) {
                                DBError.check_error(405);
                            }
                            bl2 = true;
                            break;
                        }
                        case 7: {
                            if (!bl2 && !bl3) {
                                DBError.check_error(401);
                            }
                            if (!this.rxd.unmarshal()) continue block9;
                            this.streamingOn = true;
                            return;
                        }
                        case 8: {
                            if (bl) {
                                DBError.check_error(401);
                            }
                            this.outVecRet = this.meg.unmarshalUB2();
                            int n = 0;
                            while (n < this.outVecRet) {
                                this.outVector[n] = this.meg.unmarshalUB4();
                                ++n;
                            }
                            bl = true;
                            break;
                        }
                        case 4: {
                            this.oer.init();
                            this.oer.unmarshal();
                            this.rowsProcessed = this.oer.getCurRowNumber();
                            if (this.type == 0 && (this.type != 0 || this.oer.retCode == 1403)) break block9;
                            this.oer.processError();
                            break block9;
                        }
                        default: {
                            DBError.check_error(401);
                            break;
                        }
                    }
                }
            }
            catch (BreakNetException breakNetException) {
                continue;
            }
            break;
        }
    }

    private long setOptions(byte by, byte by2, TTCDataSet tTCDataSet, TTCDataSet tTCDataSet2) throws SQLException {
        long l = 0L;
        block0 : switch (by) {
            case 2: {
                l = 32800L;
                if (by2 != 0 && this.autoCommitSet) {
                    l |= 0x100L;
                }
            }
            case 1: {
                l |= 1L;
                break;
            }
            case 4: {
                l = 1L;
            }
            case 3: {
                switch (by2) {
                    case 0: {
                        l |= 0x8060L;
                        break;
                    }
                    case 1: 
                    case 3: {
                        l = tTCDataSet.depth > 0 ? (l |= 0x428L) : (l |= 0x20L);
                        if (!this.autoCommitSet) break block0;
                        l |= 0x100L;
                        break;
                    }
                    case 2: 
                    case 4: {
                        l |= 0x8020L;
                        if (!this.autoCommitSet) break block0;
                        l |= 0x100L;
                        break;
                    }
                    default: {
                        DBError.check_error(432);
                        break;
                    }
                }
                break;
            }
            case 5: {
                l = 32832L;
                break;
            }
            default: {
                DBError.check_error(432);
            }
        }
        if (this.type != 1 && this.type != 3) {
            if (tTCDataSet.depth != 0) {
                l |= 8L;
            }
            if (this.sendDefines && tTCDataSet2.depth != 0) {
                l |= 0x10L;
            }
        }
        return l &= 0xFFFFFFFFFFFFFFFFL;
    }
}

