/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.TTCConversion;
import oracle.jdbc.ttc7.TTCItem;
import oracle.jdbc.ttc7.TTCTypeRep;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;

public class MAREngine {
    public static final int TTCC_MXL = 252;
    public static final int TTCC_ESC = 253;
    public static final int TTCC_LNG = 254;
    public static final int TTCC_ERR = 255;
    public static final int TTCC_MXIN = 64;
    public static final byte TTCLXMULTI = 1;
    public static final byte TTCLXMCONV = 2;
    public TTCTypeRep types;
    public Communication net;
    public TTCConversion conv;
    public byte proSvrVer;
    protected InputStream inStream;
    protected OutputStream outStream;
    final byte[] ignored = new byte[255];
    final byte[] tmpBuffer1 = new byte[1];
    final byte[] tmpBuffer2 = new byte[2];
    final byte[] tmpBuffer3 = new byte[3];
    final byte[] tmpBuffer4 = new byte[4];
    final int[] retLen = new int[1];

    public MAREngine(Communication communication) throws SQLException, IOException {
        if (communication == null) {
            DBError.check_error(433);
        }
        this.net = communication;
        try {
            this.inStream = communication.getInputStream();
            this.outStream = communication.getOutputStream();
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        this.types = new TTCTypeRep();
        this.types.setRep((byte)1, (byte)2);
    }

    protected void addPtr(byte by) throws IOException {
        if ((this.types.rep[3] & 1) > 0) {
            this.outStream.write(by);
        } else {
            byte by2 = this.value2Buffer(by, this.tmpBuffer4, (byte)3);
            if (by2 != 0) {
                this.outStream.write(this.tmpBuffer4, 0, by2);
            }
        }
    }

    private long buffer2Value(byte by) throws SQLException, IOException {
        byte[] byArray;
        int n = 0;
        long l = 0L;
        boolean bl = false;
        if ((this.types.rep[by] & 1) > 0) {
            try {
                n = this.inStream.read();
            }
            catch (BreakNetException breakNetException) {
                this.net.sendReset();
                throw breakNetException;
            }
            catch (NetException netException) {
                throw new IOException(netException.getMessage());
            }
            if ((n & 0x80) > 0) {
                n &= 0x7F;
                bl = true;
            }
            if (n < 0) {
                DBError.check_error(410);
            }
            if (n == 0) {
                return 0L;
            }
            if (by == 1 && n > 2 || by == 2 && n > 4) {
                DBError.check_error(412);
            }
        } else if (by == 1) {
            n = 2;
        } else if (by == 2) {
            n = 4;
        }
        switch (n) {
            case 1: {
                byArray = this.tmpBuffer1;
                break;
            }
            case 2: {
                byArray = this.tmpBuffer2;
                break;
            }
            case 3: {
                byArray = this.tmpBuffer3;
                break;
            }
            case 4: {
                byArray = this.tmpBuffer4;
                break;
            }
            default: {
                byArray = new byte[n];
                break;
            }
        }
        try {
            if (this.inStream.read(byArray) < 0) {
                DBError.check_error(410);
            }
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            long l2 = (this.types.rep[by] & 2) > 0 ? (long)(byArray[byArray.length - 1 - n2] & 0xFF) & 0xFFL : (long)(byArray[n2] & 0xFF) & 0xFFL;
            l |= l2 << 8 * (byArray.length - 1 - n2);
            ++n2;
        }
        l &= 0xFFFFFFFFFFFFFFFFL;
        if (bl) {
            l *= -1L;
        }
        return l;
    }

    private long buffer2Value(byte by, ByteArrayInputStream byteArrayInputStream) throws SQLException, IOException {
        byte[] byArray;
        int n = 0;
        long l = 0L;
        boolean bl = false;
        if ((this.types.rep[by] & 1) > 0) {
            n = byteArrayInputStream.read();
            if ((n & 0x80) > 0) {
                n &= 0x7F;
                bl = true;
            }
            if (n < 0) {
                DBError.check_error(410);
            }
            if (n == 0) {
                return 0L;
            }
            if (by == 1 && n > 2 || by == 2 && n > 4) {
                DBError.check_error(412);
            }
        } else if (by == 1) {
            n = 2;
        } else if (by == 2) {
            n = 4;
        }
        if (byteArrayInputStream.read(byArray = new byte[n]) < 0) {
            DBError.check_error(410);
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            short s = (this.types.rep[by] & 2) > 0 ? (short)(byArray[byArray.length - 1 - n2] & 0xFF) : (short)(byArray[n2] & 0xFF);
            l |= (long)(s << 8 * (byArray.length - 1 - n2));
            ++n2;
        }
        l &= 0xFFFFFFFFFFFFFFFFL;
        if (bl) {
            l *= -1L;
        }
        return l;
    }

    public boolean escapeSequenceNull(int n) throws SQLException {
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = true;
                break;
            }
            case 253: {
                DBError.check_error(401);
            }
            case 255: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public byte[] getNBytes(int n) throws SQLException, IOException {
        byte[] byArray = new byte[n];
        try {
            if (this.inStream.read(byArray) < 0) {
                DBError.check_error(410);
            }
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        return byArray;
    }

    public int getNBytes(byte[] byArray, int n, int n2) throws SQLException, IOException {
        int n3 = 0;
        try {
            n3 = this.inStream.read(byArray, n, n2);
            if (n3 < 0) {
                DBError.check_error(410);
            }
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        return n3;
    }

    public void initBuffers() {
    }

    protected void marshalB1Array(byte[] byArray) throws IOException {
        if (byArray.length > 0) {
            this.outStream.write(byArray);
        }
    }

    protected void marshalB1Array(byte[] byArray, int n, int n2) throws IOException {
        if (byArray.length > 0) {
            this.outStream.write(byArray, n, n2);
        }
    }

    protected void marshalCHR(byte[] byArray) throws IOException {
        if (byArray.length > 0) {
            if (this.types.isConvNeeded()) {
                this.marshalCLR(byArray, byArray.length);
            } else {
                this.outStream.write(byArray);
            }
        }
    }

    protected void marshalCLR(byte[] byArray, int n) throws IOException {
        if (n > 64) {
            int n2;
            int n3 = 0;
            this.outStream.write(-2);
            do {
                int n4;
                n2 = (n4 = n - n3) > 64 ? 64 : n4;
                this.outStream.write((byte)(n2 & 0xFF));
                this.outStream.write(byArray, n3, n2);
            } while ((n3 += n2) < n);
            this.outStream.write(0);
        } else {
            this.outStream.write((byte)(n & 0xFF));
            if (byArray.length != 0) {
                this.outStream.write(byArray);
            }
        }
    }

    public void marshalDALC(byte[] byArray) throws SQLException, IOException {
        if (byArray == null || byArray.length < 1) {
            this.outStream.write(0);
        } else {
            this.marshalSB4(0xFFFFFFFF & byArray.length);
            this.marshalCLR(byArray, byArray.length);
        }
    }

    public void marshalNULLPTR() throws IOException {
        this.addPtr((byte)0);
    }

    public void marshalO2U(boolean bl) throws IOException {
        if (bl) {
            this.addPtr((byte)1);
        } else {
            this.addPtr((byte)0);
        }
    }

    public void marshalPTR() throws IOException {
        this.addPtr((byte)1);
    }

    protected void marshalSB1(byte by) throws IOException {
        this.outStream.write(by);
    }

    protected void marshalSB2(short s) throws IOException {
        byte by = this.value2Buffer(s, this.tmpBuffer2, (byte)1);
        if (by != 0) {
            this.outStream.write(this.tmpBuffer2, 0, by);
        }
    }

    protected void marshalSB4(int n) throws IOException {
        byte by = this.value2Buffer(n, this.tmpBuffer4, (byte)2);
        if (by != 0) {
            this.outStream.write(this.tmpBuffer4, 0, by);
        }
    }

    protected void marshalSWORD(int n) throws IOException {
        this.marshalSB4(n);
    }

    protected void marshalUB1(short s) throws IOException {
        this.outStream.write((byte)(s & 0xFF));
    }

    protected void marshalUB2(int n) throws IOException {
        this.marshalSB2((short)(n & 0xFFFF));
    }

    protected void marshalUB4(long l) throws IOException {
        this.marshalSB4((int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    protected void marshalUB4Array(long[] lArray) throws IOException {
        int n = 0;
        while (n < lArray.length) {
            this.marshalSB4((int)(lArray[n] & 0xFFFFFFFFFFFFFFFFL));
            ++n;
        }
    }

    protected void marshalUWORD(long l) throws IOException {
        this.marshalSB4((int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    public int processIndicator(boolean bl, int n) throws SQLException, IOException {
        short s = this.unmarshalSB2();
        int n2 = 0;
        if (!bl) {
            n2 = s == 0 ? n : (s == -2 || s > 0 ? (int)s : 65536 + s);
        }
        return n2;
    }

    protected void reverseArray(byte[] byArray, byte by) {
        int n = 0;
        while (n < by / 2) {
            byte by2 = byArray[n];
            byArray[n] = byArray[by - 1 - n];
            byArray[by - 1 - n] = by2;
            ++n;
        }
    }

    protected static String toHex(byte by) {
        String string = "00" + Integer.toHexString(by & 0xFF);
        return "0x" + string.substring(string.length() - 2);
    }

    protected static String toHex(int n) {
        return MAREngine.toHex(n, 4);
    }

    protected static String toHex(long l, int n) {
        String string;
        switch (n) {
            case 1: {
                string = "00" + Long.toString(l & 0xFFL, 16);
                break;
            }
            case 2: {
                string = "0000" + Long.toString(l & 0xFFFFL, 16);
                break;
            }
            case 3: {
                string = "000000" + Long.toString(l & 0xFFFFFFL, 16);
                break;
            }
            case 4: {
                string = "00000000" + Long.toString(l & 0xFFFFFFFFL, 16);
                break;
            }
            case 5: {
                string = "0000000000" + Long.toString(l & 0xFFFFFFFFFFL, 16);
                break;
            }
            case 6: {
                string = "000000000000" + Long.toString(l & 0xFFFFFFFFFFFFL, 16);
                break;
            }
            case 7: {
                string = "00000000000000" + Long.toString(l & 0xFFFFFFFFFFFFFFL, 16);
                break;
            }
            case 8: {
                return String.valueOf(MAREngine.toHex(l >> 32, 4)) + MAREngine.toHex(l, 4).substring(2);
            }
            default: {
                return "more than 8 bytes";
            }
        }
        return "0x" + string.substring(string.length() - 2 * n);
    }

    protected static String toHex(short s) {
        return MAREngine.toHex(s, 2);
    }

    protected static String toHex(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return MAREngine.toHex(byArray, byArray.length);
    }

    protected static String toHex(byte[] byArray, int n) {
        if (byArray == null) {
            return "null";
        }
        if (n > byArray.length) {
            return "byte array not long enough";
        }
        String string = "[";
        int n2 = Math.min(64, n);
        int n3 = 0;
        while (n3 < n2) {
            string = String.valueOf(string) + MAREngine.toHex(byArray[n3]) + " ";
            ++n3;
        }
        if (n2 < n) {
            string = String.valueOf(string) + "...";
        }
        return String.valueOf(string) + "]";
    }

    private int unmarshalBuffer(byte[] byArray, int n, int n2) throws SQLException, IOException {
        if (byArray.length < n + n2) {
            this.unmarshalNBytes(byArray, n, byArray.length - n);
            this.unmarshalNBytes(this.ignored, 0, n + n2 - byArray.length);
            n = -1;
        } else {
            this.unmarshalNBytes(byArray, n, n2);
            n += n2;
        }
        return n;
    }

    public byte[] unmarshalCHR(int n) throws SQLException, IOException {
        byte[] byArray = null;
        if (this.types.isConvNeeded()) {
            byArray = this.unmarshalCLR(n, this.retLen);
            if (byArray.length != this.retLen[0]) {
                byte[] byArray2 = new byte[this.retLen[0]];
                System.arraycopy(byArray, 0, byArray2, 0, this.retLen[0]);
                byArray = byArray2;
            }
        } else {
            byArray = this.getNBytes(n);
        }
        return byArray;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] unmarshalCLR(int var1_1, int[] var2_2) throws SQLException, IOException {
        block6: {
            block7: {
                block5: {
                    var3_3 = 0;
                    var4_4 = 0;
                    var5_5 = this.unmarshalUB1();
                    if (var5_5 < 0) {
                        DBError.check_error(401);
                    }
                    if (var5_5 == 0) {
                        var2_2[0] = 0;
                        return new byte[0];
                    }
                    var6_6 = new byte[var1_1 * this.conv.getNLSRATIO()];
                    if (!this.escapeSequenceNull(var5_5)) break block5;
                    var2_2[0] = 0;
                    break block6;
                }
                if (var5_5 == 254) ** GOTO lbl23
                var4_4 = this.unmarshalBuffer(var6_6, var4_4, var5_5);
                break block7;
lbl-1000:
                // 1 sources

                {
                    if (var3_3 == 254 && this.types.isServerConversion()) continue;
                    if (var4_4 == -1) {
                        this.unmarshalBuffer(this.ignored, 0, var3_3);
                        continue;
                    }
                    var4_4 = this.unmarshalBuffer(var6_6, var4_4, var3_3);
lbl23:
                    // 4 sources

                    ** while ((var3_3 = this.unmarshalUB1()) > 0)
                }
            }
            if (var2_2 != null) {
                var2_2[0] = var4_4 != -1 ? var4_4 : var6_6.length;
            }
        }
        return var6_6;
    }

    public void unmarshalCLR(TTCItem tTCItem, int[] nArray) throws SQLException, IOException {
        short s = 0;
        int n = 0;
        boolean bl = false;
        int n2 = -1;
        s = this.unmarshalUB1();
        if (s < 0) {
            DBError.check_error(401);
        }
        if (s == 0) {
            return;
        }
        if (this.escapeSequenceNull(s)) {
            nArray[0] = 0;
            return;
        }
        if (s != 254) {
            n = this.unmarshalBuffer(tTCItem.byte_value, n, s);
        } else {
            n2 = -1;
            block5: while (n2 == -1 || (s = this.unmarshalUB1()) > 0) {
                if (s == 254) {
                    switch (n2) {
                        case -1: {
                            n2 = 1;
                            continue block5;
                        }
                        case 1: {
                            n2 = 0;
                            break;
                        }
                        case 0: {
                            if (bl) {
                                n2 = 0;
                                break;
                            }
                            n2 = 0;
                            continue block5;
                        }
                    }
                }
                if (n == -1) {
                    this.unmarshalBuffer(this.ignored, 0, s);
                } else {
                    n = this.unmarshalBuffer(tTCItem.byte_value, n, s);
                }
                n2 = 0;
                if (s <= 252) continue;
                bl = true;
            }
        }
        if (nArray != null) {
            nArray[0] = n != -1 ? n : tTCItem.byte_value.length;
        }
    }

    public byte[] unmarshalCLRforREFS() throws SQLException, IOException {
        short s = 0;
        short s2 = 0;
        byte[] byArray = null;
        Vector<byte[]> vector = new Vector<byte[]>(10, 10);
        short s3 = this.unmarshalUB1();
        if (s3 < 0) {
            DBError.check_error(401);
        }
        if (s3 == 0) {
            return null;
        }
        if (!this.escapeSequenceNull(s3)) {
            byte[] byArray2;
            if (s3 == 254) {
                while ((s = this.unmarshalUB1()) > 0) {
                    if (s == 254 && this.types.isServerConversion()) continue;
                    s2 = (short)(s2 + s);
                    byArray2 = new byte[s];
                    this.unmarshalBuffer(byArray2, 0, s);
                    vector.addElement(byArray2);
                }
            } else {
                s2 = s3;
                byArray2 = new byte[s3];
                this.unmarshalBuffer(byArray2, 0, s3);
                vector.addElement(byArray2);
            }
            byArray = new byte[s2];
            int n = 0;
            while (vector.size() > 0) {
                int n2 = ((byte[])vector.elementAt(0)).length;
                System.arraycopy(vector.elementAt(0), 0, byArray, n, n2);
                n += n2;
                vector.removeElementAt(0);
            }
        } else {
            byArray = null;
        }
        return byArray;
    }

    public byte[] unmarshalDALC() throws SQLException, IOException {
        long l = this.unmarshalUB4();
        byte[] byArray = new byte[(int)(0xFFFFFFFFFFFFFFFFL & l)];
        if (byArray.length > 0) {
            if ((byArray = this.unmarshalCLR(byArray.length, this.retLen)) == null) {
                DBError.check_error(401);
            }
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public byte[] unmarshalDALC(int[] nArray) throws SQLException, IOException {
        long l = this.unmarshalUB4();
        byte[] byArray = new byte[(int)(0xFFFFFFFFFFFFFFFFL & l)];
        if (byArray.length > 0) {
            if ((byArray = this.unmarshalCLR(byArray.length, nArray)) == null) {
                DBError.check_error(401);
            }
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public byte[] unmarshalNBytes(int n) throws SQLException, IOException {
        byte[] byArray = new byte[n];
        try {
            if (this.inStream.read(byArray) < 0) {
                DBError.check_error(410);
            }
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        return byArray;
    }

    public int unmarshalNBytes(byte[] byArray, int n, int n2) throws SQLException, IOException {
        int n3 = 0;
        while (n3 < n2) {
            n3 += this.getNBytes(byArray, n + n3, n2 - n3);
        }
        return n3;
    }

    public int unmarshalRefCursor(byte[] byArray) throws SQLException, IOException {
        int n = this.unmarshalSB4(byArray);
        return n;
    }

    public byte unmarshalSB1() throws SQLException, IOException {
        byte by = (byte)this.unmarshalUB1();
        return by;
    }

    public short unmarshalSB2() throws SQLException, IOException {
        short s = (short)this.unmarshalUB2();
        return s;
    }

    public int unmarshalSB4() throws SQLException, IOException {
        int n = (int)this.unmarshalUB4();
        return n;
    }

    public int unmarshalSB4(byte[] byArray) throws SQLException, IOException {
        long l = this.buffer2Value((byte)2, new ByteArrayInputStream(byArray));
        return (int)l;
    }

    public int unmarshalSWORD() throws SQLException, IOException {
        int n = (int)this.unmarshalUB4();
        return n;
    }

    public byte[] unmarshalTEXT(int n) throws SQLException, IOException {
        byte[] byArray;
        int n2 = 0;
        byte[] byArray2 = new byte[n];
        while (n2 < n) {
            try {
                if (this.inStream.read(byArray2, n2, 1) < 0) {
                    DBError.check_error(410);
                }
            }
            catch (BreakNetException breakNetException) {
                this.net.sendReset();
                throw breakNetException;
            }
            catch (NetException netException) {
                throw new IOException(netException.getMessage());
            }
            if (byArray2[n2++] == 0) break;
        }
        if (byArray2.length == --n2) {
            byArray = byArray2;
        } else {
            byArray = new byte[n2];
            System.arraycopy(byArray2, 0, byArray, 0, n2);
        }
        return byArray;
    }

    public short unmarshalUB1() throws SQLException, IOException {
        short s = 0;
        try {
            s = (short)this.inStream.read();
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        if (s < 0) {
            DBError.check_error(410);
        }
        return s;
    }

    public int unmarshalUB2() throws SQLException, IOException {
        int n = (int)this.buffer2Value((byte)1);
        return n & 0xFFFF;
    }

    public long unmarshalUB4() throws SQLException, IOException {
        long l = this.buffer2Value((byte)2);
        return l;
    }

    int unmarshalUCS2(byte[] byArray, long l) throws SQLException, IOException {
        int n = this.unmarshalUB2();
        this.tmpBuffer2[0] = (byte)((n & 0xFF00) >> 8);
        this.tmpBuffer2[1] = (byte)(n & 0xFF);
        if (l + 1L < (long)byArray.length) {
            byArray[(int)l] = this.tmpBuffer2[0];
            byArray[(int)l + 1] = this.tmpBuffer2[1];
        }
        return this.tmpBuffer2[0] == 0 ? (this.tmpBuffer2[1] == 0 ? 1 : 2) : 3;
    }

    public long unmarshalUWORD() throws SQLException, IOException {
        long l = this.unmarshalUB4();
        return l;
    }

    protected byte value2Buffer(int n, byte[] byArray, byte by) throws IOException {
        boolean bl = true;
        byte by2 = 0;
        int n2 = byArray.length - 1;
        while (n2 >= 0) {
            byArray[by2] = (byte)(n >>> 8 * n2 & 0xFF);
            if ((this.types.rep[by] & 1) > 0) {
                if (!bl || byArray[by2] != 0) {
                    bl = false;
                    by2 = (byte)(by2 + 1);
                }
            } else {
                by2 = (byte)(by2 + 1);
            }
            --n2;
        }
        if ((this.types.rep[by] & 1) > 0) {
            this.outStream.write(by2);
        }
        if ((this.types.rep[by] & 2) > 0) {
            this.reverseArray(byArray, by2);
        }
        return by2;
    }
}

