/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;

public class OraclePooledConnection
implements PooledConnection,
Serializable {
    public static final String url_string = "connection_url";
    public static final String pool_auto_commit_string = "pool_auto_commit";
    public static final String object_type_map = "obj_type_map";
    public static final String transaction_isolation = "trans_isolation";
    public static final String statement_cache_size = "stmt_cache_size";
    public static final String connect_auto_commit_string = "connect_auto_commit";
    public static final String implicit_caching_enabled = "implicit_cache_enabled";
    public static final String explicit_caching_enabled = "explict_cache_enabled";
    public static final String connection_properties_string = "connection_properties";
    public static final String event_listener_string = "event_listener";
    public static final String sql_exception_string = "sql_exception";
    public static final String close_callback_string = "close_callback";
    public static final String private_data = "private_data";
    private Hashtable m_eventListeners = null;
    private SQLException m_sqlException = null;
    protected boolean m_autoCommit = true;
    protected transient Connection m_logicalHandle = null;
    protected transient Connection m_physicalConn = null;
    private Hashtable m_connectionProperty = null;
    private OracleCloseCallback m_occ = null;
    private Object m_privData = null;
    private long m_lastAccessedTime = 0L;
    protected transient OracleDriver m_oracleDriver = new OracleDriver();

    public OraclePooledConnection() {
        this((Connection)null);
    }

    public OraclePooledConnection(String string) throws SQLException {
        Connection connection = this.m_oracleDriver.connect(string, new Properties());
        this.initialize(connection);
    }

    public OraclePooledConnection(String string, String string2, String string3) throws SQLException {
        Properties properties = new Properties();
        ((Hashtable)properties).put("user", string2);
        ((Hashtable)properties).put("password", string3);
        Connection connection = this.m_oracleDriver.connect(string, properties);
        this.initialize(connection);
    }

    public OraclePooledConnection(Connection connection) {
        this.initialize(connection);
    }

    public OraclePooledConnection(Connection connection, boolean bl) {
        this(connection);
        this.m_autoCommit = bl;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.m_eventListeners == null) {
            this.m_sqlException = new SQLException("Listener Hashtable Null");
        } else {
            this.m_eventListeners.put(connectionEventListener, connectionEventListener);
        }
    }

    private void callListener(int n) {
        if (this.m_eventListeners == null) {
            return;
        }
        Enumeration enumeration = this.m_eventListeners.keys();
        ConnectionEvent connectionEvent = new ConnectionEvent(this, this.m_sqlException);
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            ConnectionEventListener connectionEventListener2 = (ConnectionEventListener)this.m_eventListeners.get(connectionEventListener);
            if (n == 1) {
                connectionEventListener2.connectionClosed(connectionEvent);
                continue;
            }
            if (n != 2) continue;
            connectionEventListener2.connectionErrorOccurred(connectionEvent);
        }
    }

    public synchronized void close() throws SQLException {
        if (this.m_occ != null) {
            this.m_occ.beforeClose((OracleConnection)this.m_physicalConn, this.m_privData);
        }
        if (this.m_physicalConn != null) {
            this.m_physicalConn.close();
            this.m_physicalConn = null;
        }
        if (this.m_occ != null) {
            this.m_occ.afterClose(this.m_privData);
        }
        this.m_lastAccessedTime = 0L;
        this.callListener(2);
    }

    public CallableStatement getCallWithKey(String string) throws SQLException {
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getCallWithKey(string);
        }
        return null;
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.m_physicalConn == null) {
            this.m_sqlException = new SQLException("Physical Connection doesn't exis");
            this.callListener(2);
            DBError.throwSqlException(8);
            return null;
        }
        try {
            if (this.m_logicalHandle != null) {
                ((OracleConnection)this.m_logicalHandle).setPhysicalStatus(false);
                this.m_logicalHandle.close();
            }
            this.m_logicalHandle = new OracleConnection(this, (OracleConnection)this.m_physicalConn, this.m_autoCommit);
        }
        catch (SQLException sQLException) {
            this.m_sqlException = sQLException;
            this.callListener(2);
            DBError.throwSqlException(8);
            return null;
        }
        return this.m_logicalHandle;
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getExplicitCachingEnabled();
        }
        return false;
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getImplicitCachingEnabled();
        }
        return false;
    }

    public long getLastAccessedTime() throws SQLException {
        return this.m_lastAccessedTime;
    }

    public synchronized Connection getLogicalHandle() throws SQLException {
        return this.m_logicalHandle;
    }

    public int getStatementCacheSize() throws SQLException {
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getStatementCacheSize();
        }
        return 0;
    }

    public PreparedStatement getStatementWithKey(String string) throws SQLException {
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getStatementWithKey(string);
        }
        return null;
    }

    public synchronized int getStmtCacheSize() {
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getStmtCacheSize();
        }
        return 0;
    }

    private void initialize(Connection connection) {
        this.m_physicalConn = connection;
        this.m_eventListeners = new Hashtable(10);
        this.m_occ = null;
        this.m_privData = null;
        this.m_lastAccessedTime = 0L;
    }

    public boolean isStatementCacheInitialized() {
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).isStatementCacheInitialized();
        }
        return false;
    }

    public synchronized void logicalClose() {
        this.callListener(1);
    }

    public void purgeExplicitCache() throws SQLException {
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).purgeExplicitCache();
        }
    }

    public void purgeImplicitCache() throws SQLException {
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).purgeImplicitCache();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_connectionProperty = (Hashtable)objectInputStream.readObject();
        try {
            Properties properties = (Properties)this.m_connectionProperty.get(connection_properties_string);
            String string = properties.getProperty(url_string);
            this.m_oracleDriver = new OracleDriver();
            Connection connection = this.m_oracleDriver.connect(string, properties);
            this.initialize(connection);
            this.m_eventListeners = (Hashtable)this.m_connectionProperty.get(event_listener_string);
            this.m_sqlException = (SQLException)this.m_connectionProperty.get(sql_exception_string);
            this.m_autoCommit = ((String)this.m_connectionProperty.get(pool_auto_commit_string)).equals("true");
            this.m_occ = (OracleCloseCallback)this.m_connectionProperty.get(close_callback_string);
            this.m_privData = this.m_connectionProperty.get(private_data);
            Map map = (Map)this.m_connectionProperty.get(object_type_map);
            if (map != null) {
                ((OracleConnection)connection).setTypeMap(map);
            }
            String string2 = properties.getProperty(transaction_isolation);
            connection.setTransactionIsolation(Integer.parseInt(string2));
            string2 = properties.getProperty(statement_cache_size);
            int n = Integer.parseInt(string2);
            if (n != -1) {
                this.setStatementCacheSize(n);
                string2 = properties.getProperty(implicit_caching_enabled);
                this.setImplicitCachingEnabled(Boolean.getBoolean(string2));
                string2 = properties.getProperty(explicit_caching_enabled);
                this.setExplicitCachingEnabled(Boolean.getBoolean(string2));
            }
            this.m_physicalConn.setAutoCommit(((String)((Hashtable)properties).get(connect_auto_commit_string)).equals("true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void registerCloseCallback(OracleCloseCallback oracleCloseCallback, Object object) {
        this.m_occ = oracleCloseCallback;
        this.m_privData = object;
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.m_eventListeners == null) {
            this.m_sqlException = new SQLException("Listener Hashtable Null");
        } else {
            this.m_eventListeners.remove(connectionEventListener);
        }
    }

    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).setExplicitCachingEnabled(bl);
        }
    }

    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).setImplicitCachingEnabled(bl);
        }
    }

    public synchronized void setLastAccessedTime(long l) throws SQLException {
        this.m_lastAccessedTime = l;
    }

    public final void setProperties(Hashtable hashtable) {
        this.m_connectionProperty = hashtable;
    }

    public void setStatementCacheSize(int n) throws SQLException {
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).setStatementCacheSize(n);
        }
    }

    public synchronized void setStmtCacheSize(int n) throws SQLException {
        this.setStmtCacheSize(n, false);
    }

    public synchronized void setStmtCacheSize(int n, boolean bl) throws SQLException {
        if (n < 0) {
            DBError.throwSqlException(68);
        }
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).setStmtCacheSize(n, bl);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        try {
            ((OracleConnection)this.m_physicalConn).getPropertyForPooledConnection(this);
            if (this.m_eventListeners != null) {
                this.m_connectionProperty.put(event_listener_string, this.m_eventListeners);
            }
            if (this.m_sqlException != null) {
                this.m_connectionProperty.put(sql_exception_string, this.m_sqlException);
            }
            this.m_connectionProperty.put(pool_auto_commit_string, String.valueOf(this.m_autoCommit));
            if (this.m_occ != null) {
                this.m_connectionProperty.put(close_callback_string, this.m_occ);
            }
            if (this.m_privData != null) {
                this.m_connectionProperty.put(private_data, this.m_privData);
            }
            objectOutputStream.writeObject(this.m_connectionProperty);
            this.m_physicalConn.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

