/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.OracleTimeoutPollingThread;

class OracleTimeoutThreadPerVM
extends OracleTimeout {
    private static final OracleTimeoutPollingThread watchdog = new OracleTimeoutPollingThread();
    private OracleStatement statement;
    private long interruptAfter;
    private String name;

    OracleTimeoutThreadPerVM(String string) {
        this.name = string;
        this.interruptAfter = Long.MAX_VALUE;
        watchdog.addTimeout(this);
    }

    synchronized void cancelTimeout() throws SQLException {
        this.statement = null;
        this.interruptAfter = Long.MAX_VALUE;
    }

    void close() {
        watchdog.removeTimeout(this);
    }

    void interruptIfAppropriate(long l) {
        if (l > this.interruptAfter) {
            OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM = this;
            synchronized (oracleTimeoutThreadPerVM) {
                if (l > this.interruptAfter) {
                    try {
                        this.statement.cancel();
                        this.statement = null;
                        this.interruptAfter = Long.MAX_VALUE;
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
            }
        }
    }

    synchronized void setTimeout(long l, OracleStatement oracleStatement) throws SQLException {
        if (this.interruptAfter != Long.MAX_VALUE) {
            DBError.throwSqlException(131);
        }
        this.statement = oracleStatement;
        this.interruptAfter = System.currentTimeMillis() + l;
    }
}

