/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;

public class DBData {
    private boolean m_dynamic = false;
    private DBItem[] m_items = null;
    private Vector m_vector = null;

    public DBData() {
        this.m_dynamic = true;
        this.m_vector = new Vector();
    }

    public DBData(int n) {
        this.m_dynamic = false;
        this.m_items = new DBItem[n];
    }

    public int addItem(DBItem dBItem) throws SQLException {
        if (!this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        this.m_vector.addElement(dBItem);
        return this.m_vector.size();
    }

    private void checkItemNumber(int n) throws SQLException {
        if (n < 0 || n >= this.getNItems()) {
            DBError.throwSqlException(46);
        }
    }

    public final void cleanup() {
        this.clearItems();
        this.m_vector = null;
        this.m_items = null;
    }

    public void clearItem(int n) {
        if (this.m_dynamic && this.m_vector != null && n < this.m_vector.size()) {
            this.m_vector.removeElementAt(n);
        }
        if (this.m_items == null || n >= this.m_items.length) {
            return;
        }
        this.m_items[n] = null;
    }

    public final void clearItems() {
        if (this.m_dynamic) {
            if (this.m_vector != null) {
                this.m_vector.removeAllElements();
            }
        } else if (this.m_items != null) {
            int n = 0;
            while (n < this.m_items.length) {
                this.m_items[n] = null;
                ++n;
            }
        }
    }

    public DBItem getItem(int n) throws SQLException {
        DBItem dBItem = null;
        if (this.m_dynamic) {
            if (n < 0) {
                DBError.throwSqlException(46);
            } else {
                dBItem = n >= this.getNItems() ? null : (DBItem)this.m_vector.elementAt(n);
            }
        } else {
            this.checkItemNumber(n);
            dBItem = this.m_items[n];
        }
        return dBItem;
    }

    public int getNItems() {
        return this.m_dynamic ? this.m_vector.size() : this.m_items.length;
    }

    public final boolean isDynamic() {
        return this.m_dynamic;
    }

    public void removeFirstItem() throws SQLException {
        if (!this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        this.m_vector.removeElementAt(0);
    }

    public void setItem(int n, DBItem dBItem) throws SQLException {
        if (this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        this.checkItemNumber(n);
        this.m_items[n] = dBItem;
    }
}

