/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.common.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import java.util.ArrayList;

class TemplateMarkerState
extends DevelopmentObjectState {
    private String mRole = null;
    private boolean mHasRole = false;
    private Reference mParticipantRef = null;

    TemplateMarkerState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        TemplateMarkerState lState = (TemplateMarkerState)object;
        return String.valueOf(this.mRole).equals(String.valueOf(lState.mRole));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        TemplateMarkerState lState = (TemplateMarkerState)object;
        if (!String.valueOf(this.mRole).equals(String.valueOf(lState.mRole))) {
            compareContext.addPropertyDelta(sourceObject, "role", (Object)lState.mRole);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        TemplateMarkerState lState = (TemplateMarkerState)((Object)super.clone());
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
    }

    public void refactor(ClipboardService clipboardService) {
        if (this.mProxyRef != null) {
            this.setName(clipboardService.getNewName(this.mProxyRef));
            this.mProxyRef = null;
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        if (this.mParticipantRef != null) {
            if (clipboardService.isExcluded(this.mParticipantRef)) {
                this.mParticipantRef = null;
            } else if (innerObjectKeys.contains(this.mParticipantRef.toReferenceString())) {
                this.mParticipantRef = clipboardService.refactor(this.mParticipantRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return this.mParticipantRef != null && this.mParticipantRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        if (this.mParticipantRef != null) {
            this.mParticipantRef = refactoringService.refactor(this.mParticipantRef);
        }
    }

    void setRole(String value) {
        if (value == null) {
            this.unsetRole();
            return;
        }
        this.mRole = value;
        this.mHasRole = true;
    }

    String getRole() {
        return this.mRole;
    }

    boolean hasRole() {
        return this.mHasRole;
    }

    void unsetRole() {
        this.mRole = null;
        this.mHasRole = false;
    }

    Reference getParticipant() {
        return this.mParticipantRef;
    }

    void setParticipant(Reference reference) {
        this.mParticipantRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("name")) {
            this.setName((String)value);
        } else if (propertyName.equals("role")) {
            this.setRole((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Participant")) {
            this.setParticipant((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

