/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bi.ext.pack;

import com.sap.bi.ext.AbstractAntTask;
import com.sap.bi.ext.ExceptionUtil;
import com.sap.bi.ext.PathUtils;
import com.sap.cms.tcs.anttask.Component;
import com.sap.cms.tcs.anttask.TcsPra;
import com.sap.tc.cbs.util.ArchivePacker;
import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.ComponentReference;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.complib.provider.DCInputProvider;
import com.sap.tc.complib.provider.FileInputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.xml.XMLException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.ZipException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class CreateDCArchivesTask
extends AbstractAntTask {
    private String buildVariant;
    private File componentRootDir;
    private File targetDir;
    private int exceptionCounter = 0;
    private static final String DCIA_FILE = "dcia.zip";
    private static final String DCA_FILE = "dca.zip";

    public void setTargetdir(File dir) {
        if (dir == null) {
            throw new BuildException("attribute targetdir is undefined");
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.targetDir = dir;
        this.log("targetdir : " + this.targetDir);
    }

    public void setComponentRootDir(File dir) {
        if (dir == null) {
            throw new BuildException("attribute componentRootDir is undefined");
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.componentRootDir = dir;
        this.log("componentRootDir : " + this.componentRootDir);
    }

    public void setBuildvariant(String variant) {
        if (variant == null || variant.trim().equals("")) {
            throw new BuildException("attribute buildvariant is undefined");
        }
        this.buildVariant = variant;
        this.log("buildvariant : " + this.buildVariant);
    }

    public void execute() throws BuildException {
        try {
            this.log("create dcia and dca archives ...");
            DirectoryScanner fs = new DirectoryScanner();
            fs.setBasedir(this.componentRootDir.getCanonicalPath());
            fs.setIncludes(new String[]{"DCs/**/_comp"});
            fs.scan();
            String[] dcPaths = fs.getIncludedDirectories();
            this.incrIndent();
            int i = 0;
            while (i < dcPaths.length) {
                this.log("DC path :" + dcPaths[i], 4);
                File compDir = new File(this.targetDir + File.separator + dcPaths[i]);
                if (!compDir.exists()) {
                    compDir.mkdirs();
                }
                String[] dc = PathUtils.getDCName(compDir);
                String vendor = dc[0];
                String name = dc[1];
                this.log("package DC " + vendor + " " + name);
                this.incrIndent();
                File dciaFile = new File(compDir.getAbsolutePath() + File.separator + DCIA_FILE);
                this.log("dcia file : " + dciaFile.getCanonicalPath());
                FileOutputStream dciaStream = new FileOutputStream(dciaFile);
                try {
                    this.packComponentInterfaceArchive(this.buildVariant, vendor, name, dciaStream);
                }
                catch (Exception e) {
                    this.log("An Exception occured : " + e.getMessage());
                    ++this.exceptionCounter;
                }
                dciaStream.close();
                File dcaFile = new File(compDir.getAbsolutePath() + File.separator + DCA_FILE);
                FileOutputStream dcaStream = new FileOutputStream(dcaFile);
                boolean success = this.packRuntimeArchive(this.buildVariant, vendor, name, dcaStream);
                dcaStream.close();
                if (success) {
                    this.log("dca file : " + dcaFile.getCanonicalPath());
                } else {
                    this.log("skipped empty dca file : " + dcaFile.getCanonicalPath());
                    dcaFile.delete();
                }
                this.decrIndent();
                ++i;
            }
            this.log("create pra archives ...");
            fs = new DirectoryScanner();
            fs.setBasedir(this.componentRootDir.getCanonicalPath());
            fs.setIncludes(new String[]{"SCs/**/_comp"});
            fs.scan();
            String[] scPaths = fs.getIncludedDirectories();
            this.incrIndent();
            int i2 = 0;
            while (i2 < scPaths.length) {
                this.log("SC path :" + scPaths[i2], 4);
                File compDir = new File(this.componentRootDir + File.separator + scPaths[i2]);
                File tragetCompDir = new File(this.targetDir + File.separator + scPaths[i2]);
                if (!tragetCompDir.exists()) {
                    tragetCompDir.mkdirs();
                }
                String[] sc = PathUtils.getSCName(compDir);
                String vendor = sc[0];
                String name = sc[1];
                this.log("package SC " + vendor + " " + name);
                this.incrIndent();
                dcPaths = PathUtils.getDCPaths(this.componentRootDir, compDir);
                TcsPra pra = new TcsPra();
                pra.setProject(this.getProject());
                pra.setTaskName(this.getTaskName() + ".createPRA");
                String praPath = tragetCompDir.getCanonicalPath() + File.separator + vendor + "#" + name + ".sca";
                pra.setPrafile(praPath);
                Component comp = pra.createComponent();
                comp.setName(name);
                comp.setScname(name);
                comp.setScvendor(vendor);
                FileSet dciaFileset = new FileSet();
                FileSet dcaFileset = new FileSet();
                File root = new File(this.targetDir.getCanonicalFile() + File.separator + "DCs");
                this.log("root : " + root);
                dciaFileset.setDir(root);
                dcaFileset.setDir(root);
                this.log("adding dcia and dca archives for SC " + vendor + " " + name + " to " + praPath);
                int j = 0;
                while (j < dcPaths.length) {
                    String prefix = dcPaths[j].substring(5);
                    PatternSet.NameEntry dciaEntry = dciaFileset.createInclude();
                    String pattern = prefix + DCIA_FILE;
                    this.log("buildArchivesFileset: adding include : " + pattern);
                    dciaEntry.setName(pattern);
                    PatternSet.NameEntry dcaEntry = dcaFileset.createInclude();
                    pattern = prefix + DCA_FILE;
                    this.log("deployArchivesFileset: adding include : " + pattern);
                    dcaEntry.setName(pattern);
                    ++j;
                }
                pra.addBuildArchivesFileset(dciaFileset);
                pra.addDeployArchivesFileset(dcaFileset);
                pra.execute();
                if (this.exceptionCounter > 0) {
                    this.log("Number of Exceptions:" + this.exceptionCounter);
                }
                this.decrIndent();
                ++i2;
            }
            this.decrIndent();
        }
        catch (Exception x) {
            throw new BuildException(ExceptionUtil.printStackTrace(x));
        }
    }

    private boolean packRuntimeArchive(String buildVariant, String vendor, String name, OutputStream destination) throws IOException, ZipException, FileNotFoundException {
        File file = new File(PathUtils.getPathForDeploy(this.componentRootDir, name, vendor, buildVariant));
        this.log("packing runtime archive from " + file.getCanonicalPath());
        if (file.exists()) {
            File[] files = file.listFiles();
            File deployFile = null;
            if (files != null && files.length != 0) {
                int i = files.length - 1;
                while (i >= 0) {
                    if (files[i].getName().endsWith(".sda") || files[i].getName().endsWith(".ear")) {
                        deployFile = files[i];
                    }
                    --i;
                }
                if (deployFile != null) {
                    Util.writeFileToStream(deployFile, (OutputStream)destination);
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private void packComponentInterfaceArchive(String buildVariant, String vendor, String name, OutputStream destination) throws IOException, XMLException, ProviderException {
        ArchivePacker packer = new ArchivePacker();
        boolean index = false;
        String dcPath = PathUtils.getPathForDC(this.componentRootDir, name, vendor);
        File dcda = new File(dcPath, ".dcda");
        packer.openArchive(destination, dcPath);
        packer.setCompressionLevel(-1);
        packer.setCompressionMethod(8);
        packer.add(new String[]{".dcdef"}, false);
        this.packComponentDefinitionArchive(new FileOutputStream(dcda), name, vendor);
        packer.add(new String[]{".dcda"}, false);
        dcda.delete();
        FileInputProvider prov = new FileInputProvider(this.componentRootDir.getCanonicalPath(), (ComponentReference)new DCReference(name, vendor));
        DevelopmentComponent dc = ComponentFactory.initialize((DCInputProvider)prov, (boolean)true);
        if (dc.getPublicParts() != null) {
            Iterator iter = dc.getPublicParts().values().iterator();
            while (iter.hasNext()) {
                PublicPart pp = (PublicPart)iter.next();
                File ppa = new File(dcPath, pp.getName() + ".ppa");
                this.packPublicPartArchive(pp.getName(), buildVariant, name, vendor, new FileOutputStream(ppa));
                packer.add(new String[]{ppa.getName()}, false);
                ppa.delete();
            }
        }
        packer.closeArchive();
    }

    private void packComponentDefinitionArchive(OutputStream destination, String dcName, String dcVendor) throws IOException, ZipException, FileNotFoundException {
        ArchivePacker packer = new ArchivePacker();
        String dcPath = PathUtils.getPathForDC(this.componentRootDir, dcName, dcVendor);
        packer.openArchive(destination, dcPath);
        packer.setCompressionLevel(-1);
        packer.setCompressionMethod(8);
        packer.add(new String[]{".dcdef"}, false);
        File defFolder = PathUtils.getDefFolder(this.componentRootDir, dcName, dcVendor);
        if (defFolder.exists()) {
            packer.add(new String[]{"def"}, true);
        }
        packer.closeArchive();
    }

    public void packPublicPartArchive(String ppName, String buildVariant, String dcName, String dcVendor, OutputStream destination) throws IOException, ZipException, FileNotFoundException {
        ArchivePacker packer = new ArchivePacker();
        packer.openArchive(destination, PathUtils.getPublicPartRootPath(this.componentRootDir, dcName, dcVendor, buildVariant, ppName));
        packer.setCompressionLevel(-1);
        packer.setCompressionMethod(8);
        packer.addAll(true);
        if (packer.getPackedFiles() == 0) {
            packer.addDummyEntry(".cbs");
        }
        packer.closeArchive();
    }
}

