/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bi.ext.lib;

import com.sap.bi.ext.AbstractAntTask;
import com.sap.bi.ext.ExceptionUtil;
import com.sap.bi.ext.PathUtils;
import com.sap.bi.ext.XMLAttribute;
import com.sap.bi.ext.XMLException;
import com.sap.bi.ext.XMLReader;
import com.sap.bi.ext.XMLWriter;
import com.sap.bi.ext.lib.ExternalPublicPart;
import com.sap.tc.complib.Component;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.complib.SoftwareComponent;
import com.sap.tc.complib.provider.DCOutputProvider;
import com.sap.tc.complib.provider.FileOutputProvider;
import com.sap.tc.complib.provider.ProviderException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;
import org.w3c.dom.Element;

public class CreateExtLibWrapperDCTask
extends AbstractAntTask {
    private XMLReader reader = new XMLReader();
    private File targetDir;
    private String defaultDCVendor;
    private File componentsFile;
    private String defaultSCVendor;
    private String buildVariant;
    private String defaultPublicPartPurpose = "compilation";
    private static final String EMPTY_NAMESPACE = "";

    public void setComponentsfile(File file) {
        try {
            if (file == null) {
                throw new BuildException("attribute componentsfile is undefined");
            }
            if (!file.exists()) {
                throw new BuildException("Components file " + file.getCanonicalPath() + " doesn't exist", this.getLocation());
            }
            this.log("componentsfile : " + file.getCanonicalPath());
            this.componentsFile = file;
            this.reader.open(this.componentsFile);
        }
        catch (XMLException e) {
            throw new BuildException(ExceptionUtil.printStackTrace(e), this.getLocation());
        }
        catch (IOException e) {
            throw new BuildException(ExceptionUtil.printStackTrace(e), this.getLocation());
        }
    }

    public void setTargetdir(File dir) {
        if (dir == null) {
            throw new BuildException("attribute targetdir is undefined");
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.targetDir = dir;
        this.log("targetdir : " + this.targetDir);
    }

    public void setBuildvariant(String variant) {
        if (variant == null || variant.trim().equals(EMPTY_NAMESPACE)) {
            throw new BuildException("attribute buildvariant is undefined");
        }
        this.buildVariant = variant;
        this.log("buildvariant : " + this.buildVariant);
    }

    public void setDefaultPublicPartPurpose(String purpose) {
        if (purpose == null || purpose.trim().equals(EMPTY_NAMESPACE)) {
            throw new BuildException("attribute defaultPublicPartPurpose is undefined");
        }
        this.defaultPublicPartPurpose = purpose;
        this.log("defaultPublicPartPurpose : " + this.defaultPublicPartPurpose);
    }

    public void execute() throws BuildException {
        try {
            Element root = this.reader.getElement("/SCs");
            Element scElem = this.reader.getFirstChildElement(root);
            while (scElem != null) {
                this.log("found SC");
                this.packageSC(scElem);
                scElem = this.reader.getNextSiblingElement(scElem);
            }
        }
        catch (XMLException e) {
            throw new BuildException(ExceptionUtil.printStackTrace(e), this.getLocation());
        }
    }

    private void packageSC(Element scElement) throws XMLException {
        this.incrIndent();
        String vendor = EMPTY_NAMESPACE;
        String name = EMPTY_NAMESPACE;
        SoftwareComponent sc = ComponentFactory.createSoftwareComponent();
        Element elem = this.reader.getFirstChildElement(scElement);
        while (elem != null) {
            String elemName = elem.getNodeName();
            this.log("element under SC : " + elemName, 4);
            if (elemName.equals("vendor")) {
                vendor = this.reader.getStringValue(elem);
                sc.setVendor(vendor);
                this.log("SC vendor : " + vendor);
            } else if (elemName.equals("name")) {
                name = this.reader.getStringValue(elem);
                sc.setName(name);
                this.log("SC name : " + name);
            } else if (elemName.equals("DC")) {
                this.log("found DC");
                this.packageDC(sc, elem);
            }
            elem = this.reader.getNextSiblingElement(elem);
        }
        this.decrIndent();
    }

    private void packageDC(SoftwareComponent sc, Element dcElem) throws XMLException {
        this.incrIndent();
        String vendor = EMPTY_NAMESPACE;
        String name = EMPTY_NAMESPACE;
        DevelopmentComponent dc = ComponentFactory.createDevelopmentComponent();
        dc.emptyPublicParts();
        dc.emptyGrants();
        Map pps = dc.getPublicParts();
        List grants = dc.getGrants();
        dc.setExternal(true);
        Element elem = this.reader.getFirstChildElement(dcElem);
        while (elem != null) {
            String elemName = elem.getNodeName();
            this.log("element under DC : " + elemName, 4);
            if (elemName.equals("vendor")) {
                vendor = this.reader.getStringValue(elem);
                dc.setVendor(vendor);
                this.log("DC vendor : " + vendor);
            } else if (elemName.equals("name")) {
                name = this.reader.getStringValue(elem);
                dc.setName(name);
                this.log("DC name : " + name);
            } else if (elemName.equals("caption")) {
                String caption = this.reader.getStringValue(elem);
                dc.setCaption(caption);
                this.log("DC caption : " + caption);
            } else if (elemName.equals("dc-type")) {
                this.log("dc-type");
                ComponentType dcType = this.parseDCType(elem);
                dc.setComponentType(dcType);
            } else if (elemName.equals("public-part")) {
                this.log("public-part");
                PublicPart pp = this.parsePublicPart(elem);
                pps.put(pp.getName(), pp);
            } else if (elemName.equals("grant")) {
                this.log("grant");
                DCReference dcr = this.parseDCReference(elem);
                grants.add(dcr);
            }
            elem = this.reader.getNextSiblingElement(elem);
        }
        try {
            try {
                FileOutputProvider prov = new FileOutputProvider(this.targetDir.getCanonicalPath(), (Component)dc);
                this.log("serializing DC (" + vendor + ") " + name);
                dc.serialize((DCOutputProvider)prov);
                this.log("serializing public parts of DC (" + vendor + ") " + name);
                dc.serializePublicParts((DCOutputProvider)prov);
                this.injectPublicPartJars(dc);
                PathUtils.createDCRef(this.targetDir, sc.getName(), sc.getVendor(), name, vendor);
            }
            catch (IOException e) {
                throw new BuildException(ExceptionUtil.printStackTrace(e), this.getLocation());
            }
            catch (ProviderException e) {
                throw new BuildException(ExceptionUtil.printStackTrace(e), this.getLocation());
            }
            Object var12_13 = null;
            this.decrIndent();
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.decrIndent();
            throw throwable;
        }
    }

    private void injectPublicPartJars(DevelopmentComponent dc) {
        FileUtils u = FileUtils.newFileUtils();
        Map ppMap = dc.getPublicParts();
        Collection pps = ppMap.values();
        Iterator it = pps.iterator();
        while (it.hasNext()) {
            try {
                String sourcePath;
                ExternalPublicPart pp = (ExternalPublicPart)((Object)it.next());
                String[] sourcePathList = pp.getSourcePathList();
                if (sourcePathList != null && sourcePathList.length > 0) {
                    int i = sourcePathList.length - 1;
                    while (i >= 0) {
                        sourcePath = sourcePathList[i];
                        if (sourcePath != null && !sourcePath.trim().equals(EMPTY_NAMESPACE)) {
                            File source = u.normalize(this.replaceProperties(sourcePath));
                            String targetPath = PathUtils.getDirForPublicPartJar(this.targetDir, dc.getName(), dc.getVendor(), this.buildVariant, pp.getName());
                            targetPath = targetPath + source.getName();
                            File target = u.normalize(this.replaceProperties(targetPath));
                            this.log("copy file " + source.getCanonicalPath() + " to " + target.getCanonicalPath());
                            u.copyFile(source, target);
                        } else {
                            this.log("this public part has defined an invalid source path!");
                        }
                        --i;
                    }
                } else {
                    sourcePath = pp.getSourcePath();
                    if (sourcePath != null && !sourcePath.trim().equals(EMPTY_NAMESPACE)) {
                        File source = u.normalize(this.replaceProperties(sourcePath));
                        String targetPath = PathUtils.getDirForPublicPartJar(this.targetDir, dc.getName(), dc.getVendor(), this.buildVariant, pp.getName());
                        targetPath = targetPath + source.getName();
                        File target = u.normalize(this.replaceProperties(targetPath));
                        this.log("copy file " + source.getCanonicalPath() + " to " + target.getCanonicalPath());
                        u.copyFile(source, target);
                    } else {
                        this.log("this public part has no java archives, no source path or directory defined!");
                    }
                }
                ExternalPublicPart.NativePart[] nativeParts = pp.getNativeParts();
                XMLWriter searchRulesWriter = null;
                File searchRules = null;
                if (nativeParts.length <= 0) continue;
                searchRulesWriter = new XMLWriter();
                String searchRulesPath = PathUtils.getDirForPublicPartNativeLibs(this.targetDir, dc.getName(), dc.getVendor(), this.buildVariant, pp.getName());
                searchRulesPath = searchRulesPath + "SearchRules.xml";
                searchRules = u.normalize(this.replaceProperties(searchRulesPath));
                searchRules.getParentFile().mkdirs();
                searchRules.createNewFile();
                searchRulesWriter.open(new FileOutputStream(searchRules), "UTF-8");
                searchRulesWriter.beginDocument(null, "native-parts");
                int i = 0;
                while (i < nativeParts.length) {
                    ExternalPublicPart.NativePart np = nativeParts[i];
                    searchRulesWriter.beginTag(null, "native-part");
                    Integer jvmBitlength = np.getJvmBitlength();
                    if (jvmBitlength != null) {
                        searchRulesWriter.beginTag(null, "path", new XMLAttribute[]{new XMLAttribute("platform", np.getPlatform()), new XMLAttribute("jvm-bitlength", np.getJvmBitlength().toString()), new XMLAttribute("supported", new Boolean(np.isSupported()).toString())});
                    } else {
                        searchRulesWriter.beginTag(null, "path", new XMLAttribute[]{new XMLAttribute("platform", np.getPlatform()), new XMLAttribute("supported", new Boolean(np.isSupported()).toString())});
                    }
                    searchRulesWriter.printStringValue(np.getTargetPath());
                    searchRulesWriter.endTag(null, "path");
                    searchRulesWriter.endTag(null, "native-part");
                    if (np.isSupported()) {
                        File source = u.normalize(this.replaceProperties(np.getSourcePath()));
                        String targetPath = PathUtils.getDirForPublicPartNativeLibs(this.targetDir, dc.getName(), dc.getVendor(), this.buildVariant, pp.getName());
                        targetPath = targetPath + np.getTargetPath();
                        File target = u.normalize(this.replaceProperties(targetPath));
                        this.log("copy file " + source.getCanonicalPath() + " to " + target.getCanonicalPath());
                        u.copyFile(source, target);
                    }
                    ++i;
                }
                searchRulesWriter.endTag(null, "native-parts");
                searchRulesWriter.close();
            }
            catch (FileNotFoundException e) {
                throw new BuildException(ExceptionUtil.printStackTrace(e), this.getLocation());
            }
            catch (IOException e) {
                throw new BuildException(ExceptionUtil.printStackTrace(e), this.getLocation());
            }
        }
    }

    private ComponentType parseDCType(Element dcTypeElem) throws XMLException {
        this.incrIndent();
        ComponentType dcType = new ComponentType();
        Element elem = this.reader.getFirstChildElement(dcTypeElem);
        while (elem != null) {
            String elemName = elem.getNodeName();
            this.log("element under dc-type : " + elemName, 4);
            if (elemName.equals("vendor")) {
                String vendor = this.reader.getStringValue(elem);
                dcType.setVendor(vendor);
                this.log("DC type vendor : " + vendor);
            } else if (elemName.equals("type")) {
                String name = this.reader.getStringValue(elem);
                dcType.setType(name);
                this.log("DC type name : " + name);
            }
            elem = this.reader.getNextSiblingElement(elem);
        }
        this.decrIndent();
        return dcType;
    }

    private DCReference parseDCReference(Element dcrElem) throws XMLException {
        this.incrIndent();
        DCReference dcr = new DCReference();
        Element elem = this.reader.getFirstChildElement(dcrElem);
        while (elem != null) {
            String elemName = elem.getNodeName();
            this.log("element under grant : " + elemName, 4);
            if (elemName.equals("name")) {
                String name = this.reader.getStringValue(elem);
                dcr.setName(name);
                this.log("grant name : " + name);
            } else if (elemName.equals("vendor")) {
                String vendor = this.reader.getStringValue(elem);
                dcr.setVendor(vendor);
                this.log("grant vendor : " + vendor);
            } else if (elemName.equals("sc-alias")) {
                String scAlias = this.reader.getStringValue(elem);
                dcr.setSCAlias(scAlias);
                this.log("grant SC alias : " + scAlias);
            }
            elem = this.reader.getNextSiblingElement(elem);
        }
        this.decrIndent();
        return dcr;
    }

    private PublicPart parsePublicPart(Element ppElem) throws XMLException {
        this.incrIndent();
        ExternalPublicPart pp = new ExternalPublicPart();
        pp.setCaption("generated public part for external library");
        Element elem = this.reader.getFirstChildElement(ppElem);
        while (elem != null) {
            String elemName = elem.getNodeName();
            this.log("element under public-part : " + elemName, 4);
            if (elemName.equals("name")) {
                String name = this.reader.getStringValue(elem);
                pp.setName(name);
                this.log("public part name : " + name);
            } else if (elemName.equals("purpose")) {
                String purpose = this.reader.getStringValue(elem);
                pp.setPurpose(PublicPart.Purpose.valueOf((String)purpose));
                this.log("public part purpose : " + purpose);
            } else if (elemName.equals("source-path")) {
                String path = this.reader.getStringValue(elem);
                pp.setSourcePath(path);
                this.log("public part path : " + path);
            } else if (elemName.equals("source-dir")) {
                String directory = this.replaceProperties(this.reader.getStringValue(elem));
                String[] pathList = this.obtainArchives(directory);
                pp.setSourcePathList(pathList);
                this.log("public part directory : " + directory);
            } else if (elemName.equals("native-part")) {
                ExternalPublicPart.NativePart nativePart = this.parseNativePart(elem);
                pp.addNativePart(nativePart);
            }
            elem = this.reader.getNextSiblingElement(elem);
        }
        if (pp.getPurpose() == null) {
            pp.setPurpose(PublicPart.Purpose.valueOf((String)this.defaultPublicPartPurpose));
            this.log("public part purpose (use default) : " + this.defaultPublicPartPurpose);
        }
        this.decrIndent();
        return pp;
    }

    private String[] obtainArchives(String directory) {
        String[] list = null;
        File directoryAsFile = new File(directory);
        if (directoryAsFile.exists() && directoryAsFile.isDirectory()) {
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            };
            File[] fileList = directoryAsFile.listFiles(filter);
            list = new String[fileList.length];
            int i = fileList.length - 1;
            while (i >= 0) {
                list[i] = fileList[i].getAbsolutePath();
                --i;
            }
        } else {
            this.log(directory + " does not exist or is not a directory");
        }
        return list;
    }

    private ExternalPublicPart.NativePart parseNativePart(Element npElem) throws XMLException {
        this.incrIndent();
        String platform = npElem.getAttribute("platform");
        String attr = npElem.getAttribute("jvm-bitlength");
        Integer jvmBitlength = attr == null || attr.trim().equals(EMPTY_NAMESPACE) ? null : Integer.valueOf(attr);
        boolean supported = Boolean.valueOf(npElem.getAttribute("supported"));
        StringBuffer msg = new StringBuffer("found native part, platform : ");
        msg.append(platform);
        if (jvmBitlength != null) {
            msg.append(", jvm-bitlength : ").append(jvmBitlength.toString());
        }
        msg.append(", supported : ").append(supported);
        this.log(msg.toString());
        ExternalPublicPart.NativePart np = new ExternalPublicPart.NativePart(platform, jvmBitlength, supported);
        Element elem = this.reader.getFirstChildElement(npElem);
        while (elem != null) {
            String path;
            String elemName = elem.getNodeName();
            this.log("element under native-part : " + elemName, 4);
            if (elemName.equals("source-path")) {
                path = this.reader.getStringValue(elem);
                np.setSourcePath(path);
                this.log("native-part source path : " + path);
            } else if (elemName.equals("target-path")) {
                path = this.reader.getStringValue(elem);
                np.setTargetPath(path);
                this.log("native-part target path : " + path);
            }
            elem = this.reader.getNextSiblingElement(elem);
        }
        this.decrIndent();
        return np;
    }
}

