/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bi.ext.eclipse;

import com.sap.bi.ext.eclipse.PluginNamingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ExtensionFunctions {
    private static ResourceBundle thePluginIDTODCNameMap = ResourceBundle.getBundle("com.sap.bi.ext.eclipse.PluginIDToDCName");

    public static void main(String[] args) {
        TestReplace aTest = new TestReplace();
        aTest.run();
    }

    public static String extractFragmentName(String parEclipseDir, String varRefPlugInId, String varRefVersion, String varRefMatch, String pluginRelativePathToJar) {
        String result = null;
        if (pluginRelativePathToJar.indexOf("$ws$") == -1) {
            return result;
        }
        String resolvedPath = ExtensionFunctions.replace(pluginRelativePathToJar, "$ws$", "ws/win32");
        ArrayList aListOfFragementDirs = ExtensionFunctions.getFragmentDirs(parEclipseDir, varRefPlugInId);
        int size = aListOfFragementDirs.size();
        int i = 0;
        while (i < size) {
            File aFragmentJar = new File(parEclipseDir + aListOfFragementDirs.get(i) + resolvedPath);
            if (aFragmentJar.exists()) {
                File aFragmentXML = new File(parEclipseDir + aListOfFragementDirs.get(i) + "fragment.xml");
                try {
                    InputSource in = new InputSource(new FileInputStream(aFragmentXML));
                    DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
                    dfactory.setNamespaceAware(true);
                    Document doc = dfactory.newDocumentBuilder().parse(in);
                    String fragementId = doc.getDocumentElement().getAttribute("id");
                    result = ExtensionFunctions.getDCNameFromPluginID(fragementId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return result;
    }

    public static final String replace(String source, String toBeReplaced, String replacement) {
        if (source.indexOf(toBeReplaced) == -1) {
            return source;
        }
        String result = "";
        int currentStart = 0;
        int currentEnd = source.indexOf(toBeReplaced);
        while (currentEnd != -1) {
            result = result + source.substring(currentStart, currentEnd);
            result = result + replacement;
            currentStart = currentEnd + toBeReplaced.length();
            currentEnd = source.indexOf(toBeReplaced, currentStart);
        }
        if (currentStart < source.length()) {
            result = result + source.substring(currentStart);
        }
        return result;
    }

    private static ArrayList getFragmentDirs(String aPathToEclispe, String pluginID) {
        ArrayList<String> theListOfFragementDirs = new ArrayList<String>();
        System.out.println("Scanning for fragments for plugin with id : " + pluginID + "...");
        File aPluginsDir = new File(aPathToEclispe + "plugins");
        String[] aListOfPluginDirs = aPluginsDir.list();
        int numberOfPluginDirs = aListOfPluginDirs.length;
        int i = 0;
        while (i < numberOfPluginDirs) {
            String aPlugInDir = "plugins/" + aListOfPluginDirs[i] + "/";
            File aFragmentXML = new File(aPathToEclispe + aPlugInDir + "fragment.xml");
            if (aFragmentXML.exists()) {
                String aPluginId = "";
                try {
                    InputSource in = new InputSource(new FileInputStream(aFragmentXML));
                    DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
                    dfactory.setNamespaceAware(true);
                    Document doc = dfactory.newDocumentBuilder().parse(in);
                    aPluginId = doc.getDocumentElement().getAttribute("plugin-id");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (aPluginId.equals(pluginID)) {
                    System.out.println("Found fragment for plugin: " + pluginID + "in dir:" + aPathToEclispe + aPlugInDir);
                    theListOfFragementDirs.add(aPlugInDir);
                }
            }
            ++i;
        }
        System.out.println("Found: " + theListOfFragementDirs.size() + " fragments for plugin : " + pluginID + " !");
        return theListOfFragementDirs;
    }

    public static String extractFragmentPPName(String parEclipseDir, String varRefPlugInId, String varRefVersion, String varRefMatch, String pluginRelativePathToJar) {
        if (pluginRelativePathToJar.indexOf("$ws$") == -1) {
            return null;
        }
        return ExtensionFunctions.extractJarName(pluginRelativePathToJar);
    }

    public static String getMatchingFragmentDirs(String anAbsolutePathToAPlugin) {
        if (anAbsolutePathToAPlugin == null) {
            System.err.println("Cann not scan for transparent fragments of  pluginDir: null");
            return null;
        }
        System.out.println("Scanning for transparent fragments of  pluginDir:" + anAbsolutePathToAPlugin);
        String thePluginId = "";
        String thePluginVersion = "";
        if (anAbsolutePathToAPlugin.endsWith("/")) {
            anAbsolutePathToAPlugin = anAbsolutePathToAPlugin.substring(0, anAbsolutePathToAPlugin.length() - 1);
        }
        String theEclipseDir = anAbsolutePathToAPlugin.substring(0, anAbsolutePathToAPlugin.lastIndexOf("plugins"));
        thePluginId = anAbsolutePathToAPlugin.substring(anAbsolutePathToAPlugin.lastIndexOf("/") + 1);
        int versionSeparatorIndex = thePluginId.indexOf("_");
        if (versionSeparatorIndex != -1) {
            thePluginVersion = thePluginId.substring(versionSeparatorIndex + 1);
            thePluginId = thePluginId.substring(0, versionSeparatorIndex);
        } else {
            thePluginVersion = "";
        }
        ArrayList theListOfFragments = ExtensionFunctions.getFragmentDirs(theEclipseDir, thePluginId);
        int numberOfFragements = theListOfFragments.size();
        Iterator anIter = ((AbstractList)theListOfFragments).iterator();
        StringBuffer aBuffer = new StringBuffer();
        while (anIter.hasNext()) {
            aBuffer.append(theEclipseDir).append(anIter.next());
            if (!anIter.hasNext()) continue;
            aBuffer.append(" ");
        }
        String result = aBuffer.toString();
        if (!result.trim().equals("")) {
            System.out.println("Found transparent fragments of  pluginDir:" + anAbsolutePathToAPlugin);
            System.out.println("--->:" + result);
            return result;
        }
        return null;
    }

    public static String getMatchingPluginDir(String anAbsolutePathToEclipse, String pluginId, String pluginVersion, String match) {
        String result = null;
        if (match.equals("") || match.equals("compatible")) {
            File aPluginsDir = new File(anAbsolutePathToEclipse + "plugins/");
            String[] thePluginDirs = aPluginsDir.list();
            int size = thePluginDirs.length;
            int i = 0;
            while (i < size) {
                File aPluginXML = new File(aPluginsDir, thePluginDirs[i] + "/plugin.xml");
                int startIndexOfVersionNumber = thePluginDirs[i].lastIndexOf("_") + 1;
                boolean matchDir = false;
                matchDir = startIndexOfVersionNumber != 0 ? thePluginDirs[i].substring(0, startIndexOfVersionNumber - 1).equals(pluginId) : thePluginDirs[i].equals(pluginId);
                if (matchDir && aPluginXML.exists()) {
                    if (pluginVersion != null && !pluginVersion.trim().equals("") && startIndexOfVersionNumber != 0) {
                        PluginVersionIdentifier theVersionToMatch;
                        String aVersion = thePluginDirs[i].substring(startIndexOfVersionNumber);
                        PluginVersionIdentifier theVersion = new PluginVersionIdentifier(aVersion);
                        if (theVersion.isCompatibleWith(theVersionToMatch = new PluginVersionIdentifier(pluginVersion))) {
                            result = anAbsolutePathToEclipse + "plugins/" + thePluginDirs[i] + "/";
                            break;
                        }
                    } else {
                        result = anAbsolutePathToEclipse + "plugins/" + thePluginDirs[i] + "/";
                        break;
                    }
                }
                ++i;
            }
        } else if (match.equals("equivalent")) {
            File aPluginsDir = new File(anAbsolutePathToEclipse + "plugins/");
            String[] thePluginDirs = aPluginsDir.list();
            int size = thePluginDirs.length;
            int i = 0;
            while (i < size) {
                File aPluginXML = new File(aPluginsDir, thePluginDirs[i] + "/plugin.xml");
                int startIndexOfVersionNumber = thePluginDirs[i].lastIndexOf("_") + 1;
                boolean matchDir = false;
                matchDir = startIndexOfVersionNumber != 0 ? thePluginDirs[i].substring(0, startIndexOfVersionNumber - 1).equals(pluginId) : thePluginDirs[i].equals(pluginId);
                if (matchDir && aPluginXML.exists()) {
                    if (pluginVersion != null && !pluginVersion.trim().equals("") && startIndexOfVersionNumber != 0) {
                        PluginVersionIdentifier thePluginVersionToMatch;
                        String aPluginVersion = thePluginDirs[i].substring(startIndexOfVersionNumber);
                        PluginVersionIdentifier thePluginVersion = new PluginVersionIdentifier(aPluginVersion);
                        if (thePluginVersion.isEquivalentTo(thePluginVersionToMatch = new PluginVersionIdentifier(pluginVersion))) {
                            result = anAbsolutePathToEclipse + "plugins/" + thePluginDirs[i] + "/";
                            break;
                        }
                    } else {
                        result = anAbsolutePathToEclipse + "plugins/" + thePluginDirs[i] + "/";
                        break;
                    }
                }
                ++i;
            }
        } else if (match.equals("perfect")) {
            File aPluginsDir = new File(anAbsolutePathToEclipse + "plugins/");
            String[] thePluginDirs = aPluginsDir.list();
            int size = thePluginDirs.length;
            int i = 0;
            while (i < size) {
                File aPluginXML = new File(aPluginsDir, thePluginDirs[i] + "/plugin.xml");
                if (thePluginDirs[i].equals(pluginId + "_" + pluginVersion) && aPluginXML.exists()) {
                    result = anAbsolutePathToEclipse + "plugins/" + thePluginDirs[i] + "/";
                    break;
                }
                ++i;
            }
        }
        if (result == null) {
            System.err.println("Did not find dir for plugin with id: " + pluginId + " and version: " + pluginVersion + " using the match strategy:->" + match + "<-!");
        } else {
            System.out.println("Found plugin with id: " + pluginId + " and version: " + pluginVersion + " using the match strategy:->" + match + "<-, in directory: " + result);
        }
        return result;
    }

    public static String expand(String plugInDir, String anArgument) {
        if (!anArgument.startsWith("%")) {
            return anArgument;
        }
        String result = ExtensionFunctions.expandFromPropertiesFile(plugInDir, "plugin.properties", anArgument);
        if (result == null) {
            result = anArgument;
        }
        return result;
    }

    private static String expandFromPropertiesFile(String plugInDir, String propertiesFile, String anArgument) {
        PropertyResourceBundle theResourceBundle;
        if (!anArgument.startsWith("%")) {
            return anArgument;
        }
        String result = null;
        try {
            FileInputStream aInStream = new FileInputStream(plugInDir + propertiesFile);
            theResourceBundle = new PropertyResourceBundle(aInStream);
        }
        catch (FileNotFoundException fne) {
            return result;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return result;
        }
        try {
            result = theResourceBundle.getString(anArgument.substring(1));
        }
        catch (MissingResourceException mse) {
            System.out.println("Error: MissingResourceException during lookup of key: ->" + anArgument + "<-  in file " + plugInDir + propertiesFile);
        }
        return result;
    }

    public static String expand(String fragmentDir, String pluginDir, String anArgument) {
        if (!anArgument.startsWith("%")) {
            return anArgument;
        }
        String result = ExtensionFunctions.expandFromPropertiesFile(fragmentDir, "fragment.properties", anArgument);
        if (result == null) {
            result = ExtensionFunctions.expandFromPropertiesFile(pluginDir, "plugin.properties", anArgument);
        }
        if (result == null) {
            result = anArgument;
        }
        return result;
    }

    public static String extractJarName(String aPluginRelativePathToAJar) {
        int index = aPluginRelativePathToAJar.lastIndexOf("/");
        String result = aPluginRelativePathToAJar.substring(index + 1, aPluginRelativePathToAJar.length() - 4);
        return result;
    }

    public static String debug(Object aVarToDebug) {
        Object anObject = aVarToDebug;
        return "debugging";
    }

    public static String getJarNameFromRelativePath(String aPlugInRelativePathToAJar) {
        String aNameWithOutJarExtension = aPlugInRelativePathToAJar;
        if (aPlugInRelativePathToAJar.endsWith(".jar")) {
            aNameWithOutJarExtension = aPlugInRelativePathToAJar.substring(0, aPlugInRelativePathToAJar.length() - 4);
        }
        return aNameWithOutJarExtension.substring(aNameWithOutJarExtension.lastIndexOf("/") + 1);
    }

    public static String copyLibraries(String aPathToTheDCDir, String aPathToThePlugInDir) {
        StringBuffer aListOfCopiedPPs = null;
        File aDir = new File(aPathToThePlugInDir);
        String[] aListOfFiles = aDir.list();
        int size = aListOfFiles.length;
        int i = 0;
        while (i < size) {
            if (aListOfFiles[i].endsWith(".jar") && ExtensionFunctions.copyLibrary(aPathToTheDCDir, aPathToThePlugInDir, aListOfFiles[i])) {
                if (aListOfCopiedPPs == null) {
                    aListOfCopiedPPs = new StringBuffer();
                    aListOfCopiedPPs.append(aListOfFiles[i].substring(0, aListOfFiles[i].length() - 4));
                } else {
                    aListOfCopiedPPs.append(' ').append(aListOfFiles[i].substring(0, aListOfFiles[i].length() - 4));
                }
            }
            ++i;
        }
        File[] anArrayOfFiles = aDir.listFiles();
        int aSize = anArrayOfFiles.length;
        int j = 0;
        while (j < aSize) {
            if (anArrayOfFiles[j].isDirectory()) {
                try {
                    String aNewDirToCopyFrom = anArrayOfFiles[j].getCanonicalPath();
                    aNewDirToCopyFrom.replace('\\', '/');
                    aNewDirToCopyFrom = aNewDirToCopyFrom + "/";
                    String aResult = ExtensionFunctions.copyLibraries(aPathToTheDCDir, aNewDirToCopyFrom);
                    if (aResult != null && !aResult.trim().equals("")) {
                        if (aListOfCopiedPPs == null) {
                            aListOfCopiedPPs = new StringBuffer();
                            aListOfCopiedPPs.append(aResult);
                        } else {
                            aListOfCopiedPPs.append(' ').append(aResult);
                        }
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            ++j;
        }
        return aListOfCopiedPPs != null ? aListOfCopiedPPs.toString() : null;
    }

    public static boolean copyLibrary(String aPathToTheDCDir, String aPathToThePlugInDir, String aPathToTheJar) {
        boolean result = true;
        String aPPName = ExtensionFunctions.getJarNameFromRelativePath(aPathToTheJar);
        String aPathToThePluginJar = aPathToThePlugInDir + aPathToTheJar;
        String aPathToTheFolderOfTheCopiedJar = aPathToTheDCDir + "/gen/default/public/" + aPPName + "/lib/java/";
        String aPathToTheCopiedJar = aPathToTheDCDir + "/gen/default/public/" + aPPName + "/lib/java/" + aPPName + ".jar";
        String aPathToTheFolderOfTheCopiedImplJar = aPathToTheDCDir + "/gen/default/public/" + aPPName + "Impl/lib/java/";
        String aPathToTheCopiedImplJar = aPathToTheDCDir + "/gen/default/public/" + aPPName + "Impl/lib/java/" + aPPName + "Impl.jar";
        result = ExtensionFunctions.copyInternal(aPathToTheJar, result, aPathToThePluginJar, aPathToTheFolderOfTheCopiedJar, aPathToTheCopiedJar);
        result = ExtensionFunctions.copyInternal(aPathToTheJar, result, aPathToThePluginJar, aPathToTheFolderOfTheCopiedImplJar, aPathToTheCopiedImplJar);
        return result;
    }

    /*
     * Loose catch block
     */
    private static boolean copyInternal(String aPathToTheJar, boolean result, String aPathToThePluginJar, String aPathToTheFolderOfTheCopiedJar, String aPathToTheCopiedJar) {
        block26: {
            IOException ioe2222;
            FileOutputStream aFileOutput;
            FileInputStream aFileInput;
            block24: {
                aFileInput = null;
                aFileOutput = null;
                File theTargetFolder = new File(aPathToTheFolderOfTheCopiedJar);
                if (!theTargetFolder.exists()) {
                    boolean aBool = theTargetFolder.mkdirs();
                }
                aFileInput = new FileInputStream(new File(aPathToThePluginJar));
                aFileOutput = new FileOutputStream(new File(aPathToTheCopiedJar));
                int count = -1;
                byte[] aByteArray = new byte[1024];
                while ((count = aFileInput.read(aByteArray)) != -1) {
                    aFileOutput.write(aByteArray, 0, count);
                }
                Object var11_12 = null;
                if (aFileInput == null) break block24;
                try {
                    aFileInput.close();
                }
                catch (IOException ioe2222) {
                    ioe2222.printStackTrace();
                }
            }
            if (aFileOutput != null) {
                try {
                    aFileOutput.close();
                }
                catch (IOException ioe2222) {
                    ioe2222.printStackTrace();
                }
            }
            break block26;
            {
                catch (FileNotFoundException fne) {
                    IOException ioe2222;
                    System.out.println("Did not find the the jar: " + aPathToTheJar);
                    result = false;
                    Object var11_13 = null;
                    if (aFileInput != null) {
                        try {
                            aFileInput.close();
                        }
                        catch (IOException ioe2222) {
                            ioe2222.printStackTrace();
                        }
                    }
                    if (aFileOutput != null) {
                        try {
                            aFileOutput.close();
                        }
                        catch (IOException ioe2222) {
                            ioe2222.printStackTrace();
                        }
                    }
                    break block26;
                }
                catch (IOException ioe3) {
                    IOException ioe2222;
                    ioe3.printStackTrace();
                    result = false;
                    Object var11_14 = null;
                    if (aFileInput != null) {
                        try {
                            aFileInput.close();
                        }
                        catch (IOException ioe2222) {
                            ioe2222.printStackTrace();
                        }
                    }
                    if (aFileOutput != null) {
                        try {
                            aFileOutput.close();
                        }
                        catch (IOException ioe2222) {
                            ioe2222.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                IOException ioe2222;
                Object var11_15 = null;
                if (aFileInput != null) {
                    try {
                        aFileInput.close();
                    }
                    catch (IOException ioe2222) {
                        ioe2222.printStackTrace();
                    }
                }
                if (aFileOutput != null) {
                    try {
                        aFileOutput.close();
                    }
                    catch (IOException ioe2222) {
                        ioe2222.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
        return result;
    }

    public static String getDCNameFromPluginID(String aPlugInId) throws PluginNamingException {
        String result = null;
        try {
            result = thePluginIDTODCNameMap.getString(aPlugInId);
            if (result != null) {
                return result;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        result = aPlugInId;
        if (aPlugInId.startsWith("org.")) {
            result = result.substring(4);
            result = "ec/epi/" + result.replace('.', '/');
        } else {
            result = aPlugInId.replace('.', '/');
        }
        if (result.length() >= 41) {
            throw new PluginNamingException("DC name is to long:->" + result + "<-");
        }
        return result;
    }

    static class TestReplace {
        TestReplace() {
        }

        public void run() {
            String testString = "asfkjhsd$ws$ksjdlksafjskd";
            String result = ExtensionFunctions.replace(testString, "$ws$", "ws/win32");
            if (result.equals("asfkjhsdws/win32ksjdlksafjskd")) {
                System.out.println("Okay 1");
            } else {
                System.out.println("failed 1:" + result);
            }
            testString = "$ws$asfkjhsdksjdlksafjskd";
            result = ExtensionFunctions.replace(testString, "$ws$", "ws/win32");
            if (result.equals("ws/win32asfkjhsdksjdlksafjskd")) {
                System.out.println("Okay 2");
            } else {
                System.out.println("failed 2:" + result);
            }
            testString = "asfkjhsdksjdlksafjskd$ws$";
            result = ExtensionFunctions.replace(testString, "$ws$", "ws/win32");
            if (result.equals("asfkjhsdksjdlksafjskdws/win32")) {
                System.out.println("Okay 3");
            } else {
                System.out.println("failed 3:" + result);
            }
            testString = "asfkjhsd$ws$ksjdlksafjskd$ws$";
            result = ExtensionFunctions.replace(testString, "$ws$", "ws/win32");
            if (result.equals("asfkjhsdws/win32ksjdlksafjskdws/win32")) {
                System.out.println("Okay 4");
            } else {
                System.out.println("failed 4:" + result);
            }
        }
    }
}

